<?php
require_once("../include/syno_conf.php");

if(isset($_POST['node'])) {
	echo SYNOPHOTO_ADMIN_GetTreeData();
	exit;
}

if (preg_match('/^(get_setting|set_setting|set_album_order|get_virtual_album_setting|set_virtual_album_setting|delete_fb_token|do_reindex|do_face_recog)$/', $_POST['action'])) {
	csSYNOPhotoMisc::CheckAdminTimeOut();
}
if(isset($_GET['action']) && 'set_fb_token' == $_GET['action']) {
	echo SYNOPHOTO_ADMIN_SetFBToken();
	exit;
}

switch ($_POST['action']) {
case "get_setting":
	echo SYNOPHOTO_ADMIN_GetPhotoSettings();
	break;
case "set_setting":
	echo SYNOPHOTO_ADMIN_SetPhotoSettings();
	break;
case "set_album_order":
	echo SYNOPHOTO_ADMIN_SetAlbumOrder($_POST['list']);
	break;
case "get_virtual_album_setting":
	echo SYNOPHOTO_ADMIN_GetVirtualAlbumSetting();
	break;
case "set_virtual_album_setting":
	echo SYNOPHOTO_ADMIN_SetVirtualAlbumSetting();
	break;
case "get_index_and_recog_status":
	echo SYNOPHOTO_ADMIN_GetIndexAndRecogStatus();
	break;
case "do_reindex":
	echo SYNOPHOTO_ADMIN_DoReindex();
	break;
case "do_face_recog":
	echo SYNOPHOTO_ADMIN_DoFaceRecog();
	break;
case "stop_face_recog":
	echo SYNOPHOTO_ADMIN_StopFaceRecog();
	break;
}

function SYNOPHOTO_ADMIN_SetFBToken()
{
	$token = $_GET['token'];
	$callback = $_GET['callback'];
	$uid = $_GET['uid'];

	if (empty($callback)) {
		$token = csSYNOPhotoMisc::GetConfigDB("photo", "fb_token", "photo_config");
		if (isset($_GET['token']) && strcmp($token, $_GET['token'])) {
			csSYNOPhotoMisc::UpdateConfigDB("photo", "fb_token", $_GET['token'], "photo_config");
		}
	}

	if (empty($callback)) {
		$callback = "_onFacebookLogin";
	}

	$closeWindow = "
		<html>
		<head>
			<script>
			function loadHandler(){
				var callback = '$callback';
				var token = '$token';
				var uid = '$uid';
				if (callback) {
					eval('callback = window.opener.' + callback);
					callback(token, uid);
				}
				window.close();
			}
			</script>
		</head>
		<body onload='loadHandler()'></body>
		</html>";
	return $closeWindow;
}

function SYNOPHOTO_ADMIN_GetPhotoSettings()
{
	$result['data']['folder_sort_type'] = csSYNOPhotoMisc::GetConfigDB("album", "album_order_type_is_desc", "photo_config");
	if($result['data']['folder_sort_type'] == null || $result['data']['folder_sort_type'] == "") {
		$result['data']['folder_sort_type'] = "0";
	}

	$result['data']['thumb_sort_type'] = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_type", "photo_config");
	if($result['data']['thumb_sort_type'] == null || $result['data']['thumb_sort_type'] == "") {
		$result['data']['thumb_sort_type'] = "0";
	}

	$result['data']['thumb_sort_order'] = csSYNOPhotoMisc::GetConfigDB("album", "thumb_sort_order", "photo_config");
	if($result['data']['thumb_sort_order'] == null || $result['data']['thumb_sort_order'] == "") {
		$result['data']['thumb_sort_order'] = "0";
	}

	$result['data']['paging_use_bar'] = csSYNOPhotoMisc::GetConfigDB("album", "paging_use_bar", "photo_config");
	if($result['data']['paging_use_bar'] == null || $result['data']['paging_use_bar'] == "") {
		$result['data']['paging_use_bar'] = "on";
	}

	$result['data']['paging_item_count'] = csSYNOPhotoMisc::GetConfigDB("album", "paging_item_count", "photo_config");
	if($result['data']['paging_item_count'] == null || $result['data']['thumb_sort_order'] == "") {
		$result['data']['paging_item_count'] = 50;
	}

	$result['data']['photo_style_type'] = csSYNOPhotoMisc::GetConfigDB("photo", "photo_style_type", "photo_config");
	if($result['data']['photo_style_type'] == null || $result['data']['photo_style_type'] == "") {
		$result['data']['photo_style_type'] = "default";
	}

	$result['data']['allow_orig'] = csSYNOPhotoMisc::GetConfigDB("photo", "allow_orig", "photo_config");
	if($result['data']['allow_orig'] == null || $result['data']['allow_orig'] == "") {
		$result['data']['allow_orig'] = "off";
	}

    /*
	$result['data']['piclens_use_orig'] = csSYNOPhotoMisc::GetConfigDB("photo", "piclens_use_orig", "photo_config");
	if($result['data']['piclens_use_orig'] == null || $result['data']['piclens_use_orig'] == "") {
		$result['data']['piclens_use_orig'] = "off";
	}
    */

	$result['data']['allow_album_download'] = csSYNOPhotoMisc::GetConfigDB("photo", "allow_album_download", "photo_config");
	if($result['data']['allow_album_download'] == null || $result['data']['allow_album_download'] == "") {
		$result['data']['allow_album_download'] = "off";
	}

	$result['data']['allow_video_download'] = csSYNOPhotoMisc::GetConfigDB("photo", "allow_video_download", "photo_config");
	if($result['data']['allow_video_download'] == null || $result['data']['allow_video_download'] == "") {
		$result['data']['allow_video_download'] = "off";
	}

    $result['data']['allow_user_comment'] = csSYNOPhotoMisc::GetConfigDB("photo", "allow_user_comment", "photo_config");
	if($result['data']['allow_user_comment'] == null || $result['data']['allow_user_comment'] == "") {
		$result['data']['allow_user_comment'] = "off";
	}

    $result['data']['allow_guest_comment'] = csSYNOPhotoMisc::GetConfigDB("photo", "allow_guest_comment", "photo_config");
	if($result['data']['allow_guest_comment'] == null || $result['data']['allow_guest_comment'] == "") {
		$result['data']['allow_guest_comment'] = "off";
	}

	$result['data']['hide_search'] = csSYNOPhotoMisc::GetConfigDB("photo", "hide_search", "photo_config");
	if($result['data']['hide_search'] == null || $result['data']['hide_search'] == "") {
		$result['data']['hide_search'] = "off";
	}

    /*
	$result['data']['hide_rss_feed'] = csSYNOPhotoMisc::GetConfigDB("photo", "hide_rss_feed", "photo_config");
	if($result['data']['hide_rss_feed'] == null || $result['data']['hide_rss_feed'] == "") {
		$result['data']['hide_rss_feed'] = "off";
	}
    */

	$result['data']['photo_page_title'] = csSYNOPhotoMisc::GetConfigDB("photo", "photo_page_title", "photo_config");
	if($result['data']['photo_page_title'] == null || $result['data']['photo_page_title'] == "") {
		$result['data']['photo_page_title'] = __(photo_str_ap_name_6);
	}

	$result['data']['photo_dispaly_size'] = csSYNOPhotoMisc::GetConfigDB("photo", "photo_dispaly_size", "photo_config");
	if($result['data']['photo_dispaly_size'] == null || $result['data']['photo_dispaly_size'] == "") {
		$result['data']['photo_dispaly_size'] = 0;
	}

	$result['data']['disable_right_button'] = csSYNOPhotoMisc::GetConfigDB("photo", "disable_right_button", "photo_config");
	if ($result['data']['disable_right_button'] == null || $result['data']['disable_right_button'] == "") {
		$result['data']['disable_right_button'] = "off";
	}

	/*$result['data']['show_album_hit'] = csSYNOPhotoMisc::GetConfigDB("photo", "show_album_hit", "photo_config");
	if ($result['data']['show_album_hit'] == null || $result['data']['show_album_hit'] == "") {
		$result['data']['show_album_hit'] = "off";
	}*/

	$result['data']['enable_auto_face_recognition'] = csSYNOPhotoMisc::GetConfigDB("photo", "enable_face_recognition", "photo_config");
	if ($result['data']['enable_auto_face_recognition'] == null || $result['data']['enable_auto_face_recognition'] == "") {
		$result['data']['enable_auto_face_recognition'] = "off";
	}

	$result['data']['allow_face_recognition'] = 'off';
	if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runfacerecognition']) &&
		'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runfacerecognition']) {
		$result['data']['allow_face_recognition'] = 'on';
	} else {
		$result['data']['enable_auto_face_recognition'] = "off";
	}

	$result['supportFaceRecognition'] = false;
	$pkg_default_conf = csSYNOPhotoMisc::GetConfigFile(SYNO_PKG_DEFAULT_CONF, 'support_face_recognition');
	if ('yes' == $pkg_default_conf['support_face_recognition']) {
		$result['supportFaceRecognition'] = true;
	}

	$result['support_timeline'] = false;
	$pkg_default_conf = csSYNOPhotoMisc::GetConfigFile(SYNO_PKG_DEFAULT_CONF, 'support_timeline');
	if ('yes' == $pkg_default_conf['support_timeline']) {
		$result['support_timeline'] = true;
	}


	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetVirtualAlbumSetting()
{
	$result['data']['recent_photo'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_photo", "photo_config");
	if($result['data']['recent_photo'] == null || $result['data']['recent_photo'] == "") {
		$result['data']['recent_photo'] = "off";
	}

	$result['data']['recent_video'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_video", "photo_config");
	if($result['data']['recent_video'] == null || $result['data']['recent_video'] == "") {
		$result['data']['recent_video'] = "off";
	}

	$result['data']['recent_photo_num'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_photo_num", "photo_config");
	if($result['data']['recent_photo_num'] == null || $result['data']['recent_photo_num'] == "") {
		$result['data']['recent_photo_num'] = "20";
	}

	$result['data']['recent_video_num'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_video_num", "photo_config");
	if($result['data']['recent_video_num'] == null || $result['data']['recent_video_num'] == "") {
		$result['data']['recent_video_num'] = "20";
	}

	$result['data']['recent_commented_photo'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_commented_photo", "photo_config");
	if($result['data']['recent_commented_photo'] == null || $result['data']['recent_commented_photo'] == "") {
		$result['data']['recent_commented_photo'] = "off";
	}

	$result['data']['recent_commented_video'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_commented_video", "photo_config");
	if($result['data']['recent_commented_video'] == null || $result['data']['recent_commented_video'] == "") {
		$result['data']['recent_commented_video'] = "off";
	}

	$result['data']['recent_commented_photo_num'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_commented_photo_num", "photo_config");
	if($result['data']['recent_commented_photo_num'] == null || $result['data']['recent_commented_photo_num'] == "") {
		$result['data']['recent_commented_photo_num'] = "20";
	}

	$result['data']['recent_commented_video_num'] = csSYNOPhotoMisc::GetConfigDB("photo", "recent_commented_video_num", "photo_config");
	if($result['data']['recent_commented_video_num'] == null || $result['data']['recent_commented_video_num'] == "") {
		$result['data']['recent_commented_video_num'] = "20";
	}

	$result['data']['general_label_album'] = csSYNOPhotoMisc::GetConfigDB("photo", "general_label_album", "photo_config");
	if($result['data']['general_label_album'] == null || $result['data']['general_label_album'] == "") {
		$result['data']['general_label_album'] = "off";
	}

	$result['data']['place_label_album'] = csSYNOPhotoMisc::GetConfigDB("photo", "place_label_album", "photo_config");
	if($result['data']['place_label_album'] == null || $result['data']['place_label_album'] == "") {
		$result['data']['place_label_album'] = "off";
	}

	$result['data']['person_label_album'] = csSYNOPhotoMisc::GetConfigDB("photo", "person_label_album", "photo_config");
	if($result['data']['person_label_album'] == null || $result['data']['person_label_album'] == "") {
		$result['data']['person_label_album'] = "off";
	}

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_SetPhotoSettings()
{
	csSYNOPhotoMisc::UpdateConfigDB("album", "album_order_type_is_desc", $_POST['folder_sort_type'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("album", "thumb_sort_type", $_POST['thumb_sort_type'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("album", "thumb_sort_order", $_POST['thumb_sort_order'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("album", "paging_use_bar", $_POST['paging_use_bar'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("album", "paging_item_count", $_POST['paging_item_count'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "photo_style_type", $_POST['photo_style_type'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "allow_orig", $_POST['allow_orig'], "photo_config");
	//csSYNOPhotoMisc::UpdateConfigDB("photo", "piclens_use_orig", $_POST['piclens_use_orig'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "allow_album_download", $_POST['allow_album_download'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "allow_video_download", $_POST['allow_video_download'], "photo_config");
    csSYNOPhotoMisc::UpdateConfigDB("photo", "allow_user_comment", $_POST['allow_user_comment'], "photo_config");
    csSYNOPhotoMisc::UpdateConfigDB("photo", "allow_guest_comment", $_POST['allow_guest_comment'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "hide_search", $_POST['hide_search'], "photo_config");
    //csSYNOPhotoMisc::UpdateConfigDB("photo", "hide_rss_feed", $_POST['hide_rss_feed'], "photo_config");

	csSYNOPhotoMisc::UpdateConfigDB("photo", "photo_dispaly_size", $_POST['photo_dispaly_size'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "disable_right_button", $_POST['disable_right_button'], "photo_config");
	//csSYNOPhotoMisc::UpdateConfigDB("photo", "show_album_hit", $_POST['show_album_hit'], "photo_config");

	csSYNOPhotoMisc::UpdateConfigDB("photo", "enable_face_recognition", $_POST['enable_auto_face_recognition'] == 'on'? 'on':'off', "photo_config");
	csSYNOPhotoMisc::SetConfigFile(SYNO_PKG_CNF_FILE, 'runfacerecognition', $_POST['allow_face_recognition']==='on'? 'yes':'no');

	$photo_page_title = $_POST['photo_page_title'];
	if (__(photo_str_ap_name_6) == $photo_page_title) {
		$photo_page_title = "";
	}
	csSYNOPhotoMisc::UpdateConfigDB("photo", "photo_page_title", $photo_page_title, "photo_config");

	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
	return SYNOPHOTO_ADMIN_GetPhotoSettings();
}

function SYNOPHOTO_ADMIN_SetVirtualAlbumSetting()
{
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_photo", $_POST['recent_photo'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_video", $_POST['recent_video'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_photo_num", $_POST['recent_photo_num'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_video_num", $_POST['recent_video_num'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_commented_photo", $_POST['recent_commented_photo'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_commented_video", $_POST['recent_commented_video'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_commented_photo_num", $_POST['recent_commented_photo_num'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "recent_commented_video_num", $_POST['recent_commented_video_num'], "photo_config");

	csSYNOPhotoMisc::UpdateConfigDB("photo", "general_label_album", $_POST['general_label_album'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "place_label_album", $_POST['place_label_album'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "person_label_album", $_POST['person_label_album'], "photo_config");

	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_SetAlbumOrder($list)
{
	$list = stripcslashes($list);
	$album_arr = Array();
	$arr = explode(",", $list);
	foreach ($arr as $tok) {
		$album_arr[] = $tok;
	}
	csSYNOPhotoMisc::UpdateConfigDB("album", "order_list", json_encode($album_arr), "photo_config");

	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetTreeData()
{
	$list = json_decode(csSYNOPhotoMisc::GetConfigDB('album', 'order_list', 'photo_config'), true);

	if($list == null) {
		$list = array();
	}

	$all = Array();
	$get = Array();

	$query = "Select sharename from photo_share where is_subdir = 'f' order by sharename asc";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	while($row = PHOTO_DB_FetchRow($db_result)) {
		array_push($all, $row[0]);
	}

	$i = 0;
	foreach($list as $tok) {
		if(in_array($tok, $all, TRUE)) {
			$result[$i]['text'] = htmlspecialchars($tok);
			$result[$i]['id'] = $tok;
			$result[$i]['cls'] = 'file';
			$result[$i]['leaf'] = TRUE;
			array_push($get, $tok);
			$i++;
		}
	}

	foreach($all as $tok) {
		if(!in_array($tok, $get, TRUE)) {
			$result[$i]['text'] = htmlspecialchars($tok);
			$result[$i]['id'] = $tok;
			$result[$i]['cls'] = 'file';
			$result[$i]['leaf'] = TRUE;
			$i++;
		}
	}
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetIndexAndRecogStatus()
{
	$result['indexing'] = '';
	$result['recognizing'] = '';
	$result['can_stop_recog'] = '';
	$result['find'] = 'F:'.SYNOPHOTO_SERVICE_REAL_DIR;

	if (file_exists(SYNOPHOTO_INDEX_QUEUE) || file_exists(SYNOPHOTO_INDEX_QUEUE_TMP)) {
		$result['indexing'] = 'indexing';
	}
	if (file_exists(SYNOPHOTO_DAEMON_QUEUE_TMP) || file_exists(SYNOPHOTO_DAEMON_QUEUE)) {
		$result['recognizing'] = 'recognizing';

		// Only root photo station admin can stop all recognition jobs.
		if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && 'root' == SYNOPHOTO_ADMIN_USER) {
			$result['can_stop_recog'] = 'can_stop_recog';
		}
	}
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_DoReindex()
{
	$result['success'] = false;
	$cmd = '/usr/syno/bin/synoindex -R photo';
	@exec($cmd, $output, $retVal);
	if (0 == $retVal) {
		$result['success'] = true;
	}
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_StopFaceRecog()
{
	// Stop deamon -> Remove queue -> Re-start deamon
	@exec("/usr/syno/bin/photostationd -k");
	@exec("/usr/syno/bin/photostationd -r");
	@exec("/usr/syno/bin/photostationd");
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_DoFaceRecog()
{
	$result['success'] = false;
	$query = "delete from photo_image_label where status = ?";
	$sqlParam = array('f');
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$cmd = SYNOPHOTO_DAEMON.' -a F:'.SYNOPHOTO_SERVICE_REAL_DIR;
	@exec($cmd, $output, $retVal);

	if (0 == $retVal) {
		$result['success'] = true;
	}
	return json_encode($result);
}
?>
