<?php
require_once("../admin/user.php");

if (preg_match('/^(get_access_right|set_access_right|get_all_albums_public|set_access_right_for_albums)$/', $_POST['action'])) {
	csSYNOPhotoMisc::CheckAdminTimeOut();
}

if($_REQUEST['action'] == 'get_access_right' && isset($_REQUEST['uid'])) {
	echo SYNOPHOTO_ADMIN_GetUserAlbumData($_REQUEST['uid']);
} else if ($_POST['action'] == 'get_access_right' && isset($_POST['gid'])) {
	echo SYNOPHOTO_ADMIN_GetGroupAlbumData($_REQUEST['gid']);
} else if($_POST['action'] == 'get_access_right' && isset($_POST['sharename']) && isset($_POST['start'])) {
	echo SYNOPHOTO_ADMIN_GetAlbumUserData($_POST['sharename'], $_POST['start']);
} else if($_POST['action'] == 'set_access_right' && isset($_POST['shareid'])) {
	SYNOPHOTO_ADMIN_AddAccessRightByShareid($_POST['shareid'], $_POST['add_user']);
	SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($_POST['shareid'], $_POST['delete_user']);
	$result['success'] = true;
	echo json_encode($result);
} else if($_POST['action'] == 'set_access_right' && isset($_POST['uid'])) {
	SYNOPHOTO_ADMIN_AddAccessRightByUid($_POST['uid'], $_POST['add_album']);
	SYNOPHOTO_ADMIN_DeleteAccessRightByUid($_POST['uid'], $_POST['delete_album']);
	$result['success'] = true;
	echo json_encode($result);
} else if($_POST['action'] == 'get_all_albums_privilege') {
	echo SYNOPHOTO_ADMIN_GetAllAlbumsPrivilege();
} else if($_POST['action'] == 'set_access_right_for_albums') {
	echo SYNOPHOTO_ADMIN_SetAllAlbumsPrivilege($_POST['public_list'], $_POST['private_list'], $_POST['password_list']);
}

function SYNOPHOTO_ADMIN_DeleteAccessRightByUid($uid, $delete_albums)
{
	if ($uid == null || $uid == "" ||
		$delete_albums == null || $delete_albums == "") {
		return;
	}

	$query = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where userid = ? and shareid in (".$delete_albums.")";
	$sqlParam = array($uid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$query = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where userid = ? and shareid in (".$delete_albums.")";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
}

function SYNOPHOTO_ADMIN_DeleteAccessRightByUidAll($uid)
{
	$query = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where userid = ?";
	$sqlParam = array($uid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$query = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where userid = ?";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
}

function SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $delete_users)
{
	if ($shareid == null || $shareid == "" ||
		$delete_users == null || $delete_users == "") {
		return;
	}

	$query = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where userid in (".$delete_users.") and shareid =".$shareid;
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
}

function SYNOPHOTO_ADMIN_AddAccessRightByUid($uid, $accessible_albums)
{
	if($uid == null || $uid == "" ||
		$accessible_albums == null || $accessible_albums == "") {
		return;
	}

	$arr = explode(",", $accessible_albums);

	foreach ($arr as $tok) {
		if($tok == "") {
			continue;
		}
		$date = date('Y-m-d H:i:s');
		$query = "Insert into " . PHOTO_ACCESS_RIGHT_TABLE . " (userid, shareid, create_time) ";
		$query = $query."Values (".$uid.", ".$tok.", '".$date."')";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}
}

function SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $accessible_users)
{
	if($shareid == null || $shareid == "" ||
		$accessible_users == null || $accessible_users == "") {
		return;
	}

	$arr = explode(",", $accessible_users);
	foreach ($arr as $tok) {
		if($tok == "") {
			continue;
		}
		$date = date('Y-m-d H:i:s');
		$query = "Insert into " . PHOTO_ACCESS_RIGHT_TABLE . " (userid, shareid, create_time) ";
		$query = $query."Values (".$tok.", ".$shareid.", '".$date."')";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}
}

function SYNOPHOTO_ADMIN_GetUserAlbumData($uid)
{
	/* get root album id */
	$query = "SELECT shareid FROM photo_share WHERE sharename='/'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row = PHOTO_DB_FetchRow($db_result);
	$rootid = $row['shareid'];
	$query = "SELECT * FROM photo_share WHERE is_subdir = 'f' ORDER BY sharename ASC";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	$list = array();
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		if ($row['shareid'] === $rootid) {
			$item = SYNOPHOTO_ADMIN_GetUserAlbumDataOneItem($row, $uid, null, 1, $rootid);
		} else {
			$item = SYNOPHOTO_ADMIN_GetUserAlbumDataOneItem($row, $uid, $rootid, 1, $rootid);
		}

		$escape = PHOTO_DB_GetEscape();
		if ($row['shareid'] === $rootid) {
			$query = "Select * from photo_share where sharename <> '/' and sharename not like '%/%' order by sharename asc";
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		} else {
			$query = "Select * from photo_share where sharename like ? $escape and sharename not like ? $escape order by sharename asc";
			$sqlParam = array(PHOTO_DB_EscapForLike($row[1]) . '/%', PHOTO_DB_EscapForLike($row[1]) . '/%/%');
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}

		$children = array();
		$children_id = array();
		while(($row_2 = PHOTO_DB_FetchRow($db_result_2))) {
			if ($row['password']) {
				$item['browse'] = '1';
			}
			$children[] = SYNOPHOTO_ADMIN_GetUserAlbumDataOneItem($row_2, $uid, $row[0], $item['browse'], $rootid);
			$children_id[] = $row_2[0];
		}

		$item['child_id'] = json_encode($children_id);

		if(0 == count($children)) {
			$item['_is_leaf'] = true;
		}

		$list[] = $item;

		if ($row['shareid'] !== $rootid) {
			foreach ($children as $child) {
				$list[] = $child;
			}
		}
	}

	$result['all'] = $list;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetGroupAlbumData($gid)
{
	/* get root album id */
	$query = "SELECT shareid FROM photo_share WHERE sharename='/'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row = PHOTO_DB_FetchRow($db_result);
	$rootid = $row['shareid'];
	$query = "SELECT * FROM photo_share WHERE is_subdir = 'f' ORDER BY sharename ASC";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	$list = array();
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		if ($row['shareid'] === $rootid) {
			$item = SYNOPHOTO_ADMIN_GetGroupAlbumDataOneItem($row, $gid, null, 1, $rootid);
		} else {
			$item = SYNOPHOTO_ADMIN_GetGroupAlbumDataOneItem($row, $gid, $rootid, 1, $rootid);
		}

		$escape = PHOTO_DB_GetEscape();
		if ($row['shareid'] === $rootid) {
			$query = "Select * from photo_share where sharename <> '/' and sharename not like '%/%' order by sharename asc";
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		} else {
			$query = "Select * from photo_share where sharename like ? $escape and sharename not like ? $escape order by sharename asc";
			$sqlParam = array(PHOTO_DB_EscapForLike($row[1]) . '/%', PHOTO_DB_EscapForLike($row[1]) . '/%/%');
			$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}

		$children = array();
		$children_id = array();
		while(($row_2 = PHOTO_DB_FetchRow($db_result_2))) {
			if ($row['password']) {
				$item['browse'] = '1';
			}
			$children[] = SYNOPHOTO_ADMIN_GetGroupAlbumDataOneItem($row_2, $gid, $row[0], $item['browse'], $rootid);
			$children_id[] = $row_2[0];
		}

		$item['child_id'] = json_encode($children_id);

		if(0 == count($children)) {
			$item['_is_leaf'] = true;
		}

		$list[] = $item;

		if ($row['shareid'] !== $rootid) {
			foreach ($children as $child) {
				$list[] = $child;
			}
		}
	}

	$result['all'] = $list;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetUserAlbumDataOneItem($row, $uid, $parent_id, $parent_status, $root_id)
{
	$result['_id'] = $row[0];
	$result['_parent'] = $parent_id;
	$result['browse'] = 0;
	$result['browse_orig'] = 0;
	$result['upload'] = 0;
	$result['upload_orig'] = 0;
	$result['manage'] = 0;
	$result['manage_orig'] = 0;

	if ($parent_id != null && $parent_id != $root_id) { // is_subdir
		$result['name'] = htmlspecialchars(substr($row[1], strpos($row[1], "/") + 1), ENT_QUOTES);
		$result['_level'] = 2;
		$result['_lft'] = 2;
		$result['_is_leaf'] = true;
		$result['child_id'] = null;
	} else {
		$result['name'] = htmlspecialchars($row[1], ENT_QUOTES);
		$result['_level'] = 1;
		$result['_lft'] = 1;
		$result['_is_leaf'] = false;
	}
	$result['title'] = empty($row['title']) ? $result['name'] : $row['title'];

	if (PHOTO_DB_ConvertBool($row[4]) == 't') { // is_public

		$result['name'] = "(".__(photo_str_photoalbum_public2).") ".$result['name'];

		$result['public'] = 1;
		$result['browse'] = 1;
		$result['browse_orig'] = 1;

		if(0 == $parent_status) {
			$result['browse'] = 0;
			$result['browse_orig'] = 0;
			return $result;
		}
		$query = "Select * from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = ".$row[0]." and userid = ".$uid;
		$db_result_3 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		if(PHOTO_DB_FetchRow($db_result_3)) {
			$result['upload'] = 1;
			$result['upload_orig'] = 1;
		}

		$query = "Select * from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = ".$row[0]." and userid = ".$uid;
		$db_result_4 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		if(PHOTO_DB_FetchRow($db_result_4)) {
			$result['manage'] = 1;
			$result['manage_orig'] = 1;
		}
		return $result;
	}

	if ($row['password']) {
		$result['public'] = 2;
	}

	$query = "Select * from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = ".$row[0]." and userid = ".$uid;
	$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	if (PHOTO_DB_FetchRow($db_result_2)) {
		$result['browse'] = 1;
		$result['browse_orig'] = 1;

		$query = "Select * from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = ".$row[0]." and userid = ".$uid;
		$db_result_3 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		if (PHOTO_DB_FetchRow($db_result_3)) {
			$result['upload'] = 1;
			$result['upload_orig'] = 1;

			$query = "Select * from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = ".$row[0]." and userid = ".$uid;
			$db_result_4 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

			if (PHOTO_DB_FetchRow($db_result_4)) {
				$result['manage'] = 1;
				$result['manage_orig'] = 1;
			}
		}

	}
	return $result;
}

function SYNOPHOTO_ADMIN_GetGroupAlbumDataOneItem($row, $gid, $parent_id, $parent_status, $root_id)
{
	$result['_id'] = $row[0];
	$result['_parent'] = $parent_id;
	$result['browse'] = 0;
	$result['browse_orig'] = 0;
	$result['upload'] = 0;
	$result['upload_orig'] = 0;
	$result['manage'] = 0;
	$result['manage_orig'] = 0;

	if ($parent_id != null && $parent_id != $root_id) { // is_subdir
		$result['name'] = htmlspecialchars(substr($row[1], strpos($row[1], "/") + 1), ENT_QUOTES);
		$result['_level'] = 2;
		$result['_lft'] = 2;
		$result['_is_leaf'] = true;
		$result['child_id'] = null;
	} else {
		$result['name'] = htmlspecialchars($row[1], ENT_QUOTES);
		$result['_level'] = 1;
		$result['_lft'] = 1;
		$result['_is_leaf'] = false;
	}
	$result['title'] = empty($row['title']) ? $result['name'] : $row['title'];

	$query = "Select * from " . PHOTO_GROUP_PERMISSION_TABLE . " where shareid = ".$row[0]." and groupid = ".$gid;
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$res = PHOTO_DB_FetchRow($db_result);

	$browse = $res['permission'] & 1;
	$upload = $res['permission'] & 2;
	$manage = $res['permission'] & 4;

	if (PHOTO_DB_ConvertBool($row[4]) == 't') { // is_public
		$result['name'] = "(".__(photo_str_photoalbum_public2).") ".$result['name'];

		$result['public'] = 1;
		$result['browse'] = 1;
		$result['browse_orig'] = 1;

		if(0 == $parent_status) {
			$result['browse'] = 0;
			$result['browse_orig'] = 0;
			return $result;
		}

		$result['upload'] = $upload;
		$result['upload_orig'] = $upload;
		$result['manage'] = $manage;
		$result['manage_orig'] = $manage;

		return $result;
	}

	if ($row['password']) {
		$result['public'] = 2;
	}

	if ($browse) {
		$result['browse'] = 1;
		$result['browse_orig'] = 1;

		if ($upload) {
			$result['upload'] = 1;
			$result['upload_orig'] = 1;

			if ($manage) {
				$result['manage'] = 1;
				$result['manage_orig'] = 1;
			}
		}

	}
	return $result;
}

function SYNOPHOTO_ADMIN_GetAlbumUserData($sharename, $start = 0, $limit = 15)
{
	/* edit sharename for root album */
	if ('' === $sharename) {
		$sharename = '/';
	}
	$query = "Select * from photo_share where sharename = '" . PHOTO_DB_EscapeParam($sharename) . "'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
    	$shareid = $row['shareid'];
    	$isPublic = ('t' == $row['public']);
	} else {
    	return;
	}

	$parentid = null;
	/* find the nearest private parent */
	if (false !== strstr($sharename, '/')) {
		$parent = substr($sharename, 0, strpos($sharename, "/"));
		$query = "Select * from photo_share where sharename = '".PHOTO_DB_EscapeParam($parent)."'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$row = PHOTO_DB_FetchRow($db_result);
		if ('' == $row['password'] && PHOTO_DB_ConvertBool($row['public']) == 'f') {
			// For parent albunm be privated
			// Only users who have the permission of the parent album can be candidates of the second album.
			// So we must filter them out
			$parentid = $row['shareid'];
		}
	}

	$users = json_decode(SYNOPHOTO_ADMIN_GetAllUsersForAlbum(), true);
	$result['totalCount'] = $users['totalCount'];
	$result['all'] = array();

	for ($i = $start ; $i < $users['totalCount'] && $i < $start + $limit; $i++) {
		$idx = $i - $start;
		$result['all'][$idx]['disabled'] = 0;
		if (null != $parentid) {
			$query = "Select * from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = " . $parentid;
			$query .= " and userid = " . $users['all_users'][$idx]['userid'];
			$db_result_parent = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

			// Only users who have the permission of the parent album can be candidates of the second album.
			if(false == ($row_parent = PHOTO_DB_FetchRow($db_result_parent))) {
				$result['all'][$idx]['disabled'] = 1;
			}
		}

		$result['all'][$idx]['userid'] = $users['all_users'][$idx]['userid'];
		$result['all'][$idx]['username'] = $users['all_users'][$idx]['username'];
		$result['all'][$idx]['description'] = $users['all_users'][$idx]['description'];

		/* check album access right */
		$query = "Select * from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = " . $shareid;
		$query .= " and userid = " . $users['all_users'][$idx]['userid'];
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$row = PHOTO_DB_FetchRow($db_result);
		if (($row != null || $isPublic) && (0 == $result['all'][$idx]['disabled'])) {
			$result['all'][$idx]['browse'] = 1;
			$result['all'][$idx]['browse_orig'] = 1;
		} else {
			$result['all'][$idx]['browse'] = 0;
			$result['all'][$idx]['browse_orig'] = 0;
		}
		/* check album upload right */
		$query_2 = "Select * from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = " . $shareid;
		$query_2 .= " and userid = " . $users['all_users'][$idx]['userid'];
		$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_2);

		$row_2 = PHOTO_DB_FetchRow($db_result_2);
		if($row_2 != null) {
			$result['all'][$idx]['upload'] = 1;
			$result['all'][$idx]['upload_orig'] = 1;
		} else {
			$result['all'][$idx]['upload'] = 0;
			$result['all'][$idx]['upload_orig'] = 0;
		}
		/* check album manage right */
		$query_3 = "Select * from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = " . $shareid;
		$query_3 .= " and userid = " . $users['all_users'][$idx]['userid'];
		$db_result_3 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_3);

		$row_3 = PHOTO_DB_FetchRow($db_result_3);
		if($row_3 != null) {
			$result['all'][$idx]['manage'] = 1;
			$result['all'][$idx]['manage_orig'] = 1;
		} else {
			$result['all'][$idx]['manage'] = 0;
			$result['all'][$idx]['manage_orig'] = 0;
		}
	}
	return json_encode($result);
}


function SYNOPHOTO_ADMIN_GetUserAlbumPrivilegeOneItem($row, $parent_id)
{
	$item = array();
	$item['_parent'] = $parent_id;
	$item['_id'] = $row['shareid'];
	if ($parent_id) {
		$item['name'] = htmlspecialchars(substr($row['sharename'], strpos($row['sharename'], "/") + 1), ENT_QUOTES);
		$item['_level'] = 2;
		$item['_is_leaf'] = true;
	} else {
		$item['name'] = htmlspecialchars($row['sharename'], ENT_QUOTES);
		$item['_level'] = 1;
		$item['_is_leaf'] = false;
	}
	$item['title'] = empty($row['title']) ? $item['name'] : $row['title'];

	if (PHOTO_DB_ConvertBool($row['public']) == 't' && !$row['password']) {
       	$item['public'] = 1;
		$item['original'] = 'public';
	       $item['public_orig'] = 1;
    } else {
       	$item['public'] = 0;
		$item['public_orig'] = 0;
    }

	if ($row['password'] && '' != $row['password']) {
		$item['password_content'] = '＃＃＃＃＃＃＃＃';
		$item['password_content_orig'] = '＃＃＃＃＃＃＃＃';
		$item['password'] = 1;
		$item['original'] = 'password';
		$item['password_orig'] = 1;
	} else {
		$item['password_content'] = $row['password'];
		$item['password'] = 0;
		$item['password_orig'] = 0;
	}

	if (0 == $item['public'] && 0 == $item['password']) {
		$item['private'] = 1;
		$item['private_orig'] = 1;
		$item['original'] = 'private';
	} else {
		$item['private'] = 0;
		$item['private_orig'] = 0;
	}
	return $item;
}

function SYNOPHOTO_ADMIN_GetAllAlbumsPrivilege()
{
	$query = "Select * from photo_share where is_subdir = 'f' and sharename <> '/' order by sharename asc";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	$list = array();
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		$item = SYNOPHOTO_ADMIN_GetUserAlbumPrivilegeOneItem($row, null);

		$escape = PHOTO_DB_GetEscape();
		$query = "Select * from photo_share where sharename like ? $escape and sharename not like ? $escape order by sharename asc";
		$sqlParam = array(PHOTO_DB_EscapForLike($row['sharename']) . '/%', PHOTO_DB_EscapForLike($row['sharename']) . '/%/%');
		$db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		$children = array();
		$children_id = array();
		while(($row_2 = PHOTO_DB_FetchRow($db_result_2))) {
			$children[] = SYNOPHOTO_ADMIN_GetUserAlbumPrivilegeOneItem($row_2, $row['shareid']);
		}


		if(0 == count($children)) {
			$item['_is_leaf'] = true;
		}

		$list[] = $item;

		foreach ($children as $child) {
			$list[] = $child;
		}
	}

	$result['totalCount'] = count($list);
	$result['all'] = $list;
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_SetAllAlbumsPrivilege($public_list, $private_list, $password_json)
{

	if($public_list != null && $public_list != "") {
		$query = "Update photo_share set public='t', password = '' where shareid in (".$public_list.")";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$query = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid in (".$public_list.")";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$query = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid in (".$public_list.")";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}

	if($private_list != null && $private_list != "") {
		$query = "Update photo_share set public='f', password = '' where shareid in (".$private_list.")";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$query = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid in (".$private_list.")";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}

	if($password_json != null && $password_json != "") {
		$passArray = json_decode($password_json, 1);
		$password_list = '';
		$tmpArray = Array();

		foreach ($passArray as $item) {
			$query = "Update photo_share set public='f', password = '" . md5($item['password']) . "' where shareid = " . $item['id'];
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$tmpArray[] = $item['id'];
		}
		$password_list = join("," , $tmpArray);

		$query = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid in (".$password_list.")";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$query = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid in (".$password_list.")";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_DeleteUploadPermissionByUid($uid, $delete_albums)
{
	if ($uid == null || $uid == "" ||
		$delete_albums == null || $delete_albums == "") {
		return;
	}

	$query = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where userid = ? and shareid in (".$delete_albums.")";
	$sqlParam = array($uid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
}

function SYNOPHOTO_ADMIN_AddUploadPermissionByUid($uid, $accessible_albums)
{
	if($uid == null || $uid == "" ||
		$accessible_albums == null || $accessible_albums == "") {
		return;
	}

	$arr = explode(",", $accessible_albums);

	foreach ($arr as $tok) {
		if($tok == "") {
			continue;
		}
		$date = date('Y-m-d H:i:s');
		$query = "Insert into " . PHOTO_UPLOAD_RIGHT_TABLE . " (userid, shareid, create_time) ";
		$query = $query."Values (?, ?, ?)";
		$sqlParam = array($uid, $tok, $date);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	}
}

function SYNOPHOTO_ADMIN_DeleteManagePermissionByUid($uid, $delete_albums)
{
	if ($uid == null || $uid == "" ||
		$delete_albums == null || $delete_albums == "") {
		return;
	}

	$query = "Delete from " . PHOTO_MANAGE_RIGHT_TABLE . " where userid = ? and shareid in (".$delete_albums.")";
	$sqlParam = array($uid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
}

function SYNOPHOTO_ADMIN_AddManagePermissionByUid($uid, $accessible_albums)
{
	if($uid == null || $uid == "" ||
		$accessible_albums == null || $accessible_albums == "") {
		return;
	}

	$arr = explode(",", $accessible_albums);

	foreach ($arr as $tok) {
		if($tok == "") {
			continue;
		}
		$date = date('Y-m-d H:i:s');
		$query = "Insert into " . PHOTO_MANAGE_RIGHT_TABLE . " (userid, shareid, create_time) ";
		$query = $query."Values (?, ?, ?)";
		$sqlParam = array($uid, $tok, $date);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	}
}
