#!/bin/sh
# Copyright (c) 2003-2012 Synology Inc. All rights reserved.

PGSQL="/usr/syno/pgsql/bin/psql -U admin"

SQL_TEST="select * from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where table_name='photo_label'"
SCRIPT="/var/packages/PhotoStation/target/photo_scripts/sql/upgrade/020_modify_label_constraint.pgsql"

echo "Update photo_label table to test constraint correct"
$PGSQL photo -c "$SQL_TEST" | grep "photo_label_id_pkey" > /dev/null 2>&1
Ret=$?
if [ $Ret = 1 ]; then
	echo "Change primary key constraint to photo_label table"
	$PGSQL photo < $SCRIPT
	if [ $? != 0 ]; then
		echo "Failed to upgrade photo database"
		exit
	fi
fi
