BEGIN;

create table category
(
	id serial NOT NULL,
	name text NOT NULL,
	hidden boolean NOT NULL DEFAULT false,
	order_number int NOT NULL,
	create_date timestamp DEFAULT current_timestamp,
	modify_date timestamp DEFAULT current_timestamp,
	CONSTRAINT category_pkey PRIMARY KEY (id),
	CONSTRAINT category_ukey UNIQUE (name)
);

CREATE TYPE item_type AS ENUM ('album', 'smart', 'tag');
create table category_items
(
	id serial NOT NULL,
	category_id serial NOT NULL,
	type item_type NOT NULL,
	order_number int not NULL,
	album_id int
		REFERENCES photo_share (shareid)
		ON UPDATE CASCADE ON DELETE CASCADE,
	tag_id int
		REFERENCES photo_label (id)
		ON UPDATE CASCADE ON DELETE CASCADE,
	smart_id text,
	CONSTRAINT category_items_pkey PRIMARY KEY (id),
	CONSTRAINT category_item_album_ukey UNIQUE (category_id, album_id),
	CONSTRAINT category_items_tag_ukey UNIQUE (category_id, tag_id),
	CONSTRAINT category_items_smart_ukey UNIQUE (category_id, smart_id),
	CONSTRAINT category_items_fkey FOREIGN KEY (category_id)
		REFERENCES category (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

COMMIT;
