BEGIN;

CREATE TABLE photo_group
(
	groupid int8 NOT NULL,
	groupname varchar(128) NOT NULL,
	description varchar(128),
	CONSTRAINT photo_group_pkey PRIMARY KEY (groupid),
	CONSTRAINT photo_group_username_key UNIQUE (groupname)
);

CREATE TABLE photo_user_group (
	id serial NOT NULL,
	userid int8 NOT NULL,
	groupid int8 NOT NULL,
	PRIMARY KEY (id),
	CONSTRAINT photo_user_group_userID_fkey FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
	CONSTRAINT photo_user_group_groupID_fkey FOREIGN KEY (groupid)
		REFERENCES photo_group (groupid) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
	CONSTRAINT photo_user_group_key UNIQUE (userid, groupid)
);

CREATE TABLE photo_group_permission
(
	groupid int8 NOT NULL,
	shareid int4 NOT NULL,
	permission int2 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_group_permission_pkey PRIMARY KEY (groupid, shareid),
	CONSTRAINT photo_group_permission_shareID_fkey FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT photo_group_permission_groupID_fkey FOREIGN KEY (groupid)
		REFERENCES photo_group (groupid) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE
);

COMMIT;
