<?php
    require_once('webapi.conf.php');

    define('SZ_WEBAPI_SDK_DIR',     CONF_WEBAPI_SERVICE_PATH.'/sdk');
    define('SZ_WEBAPI_CLASS_PATH',  SZ_WEBAPI_SDK_DIR.'/WebAPI.php');
    define('SZ_WEBAPI_API_DESCRIPTION_DIR', CONF_WEBAPI_SERVICE_PATH);
    define('SZ_API_DESCRIPTION', 'PhotoStation.api');
    define('SZ_WEBAPI_API_DESCRIPTION_PATH', SZ_WEBAPI_API_DESCRIPTION_DIR.'/'.SZ_API_DESCRIPTION);

    // SYNO.PhotoStation.Info (401-405)

    // SYNO.PhotoStation.Auth (406-415)
    define('PHOTOSTATION_AUTH_LOGIN_NOPRIVILEGE', 406);
    define('PHOTOSTATION_AUTH_LOGIN_ERROR', 407);
    define('PHOTOSTATION_AUTH_LOGIN_DISABLE_ACCOUNT', 408);

    // SYNO.PhotoStaion.Album (416-425)
    define('PHOTOSTATION_ALBUM_PASSWORD_ERROR', 416);
    define('PHOTOSTATION_ALBUM_NO_ACCESS_RIGHT', 417);
    define('PHOTOSTATION_ALBUM_NO_UPLOAD_RIGHT', 418);
    define('PHOTOSTATION_ALBUM_NO_MANAGE_RIGHT', 419);
    define('PHOTOSTATION_ALBUM_NOT_ADMIN', 420);
    define('PHOTOSTATION_ALBUM_HAS_EXIST', 421);
    define('PHOTOSTATION_ALBUM_CREATE_FAIL', 422);
    define('PHOTOSTATION_ALBUM_EDIT_FAIL', 423);
    define('PHOTOSTATION_ALBUM_DELETE_FAIL', 424);

    // SYNO.PhotoStation.Permission (426-435)
    define('PHOTOSTATION_PERMISSION_BAD_PARAMS', 426);
    define('PHOTOSTATION_PERMISSION_ACCESS_DENY', 427);

    // SYNO.PhotoStation.Tag (436-445)
    define('PHOTOSTATION_TAG_LIST_FAIL', 436);
    define('PHOTOSTATION_TAG_GETINFO_FAIL', 437);
    define('PHOTOSTATION_TAG_CREATE_FAIL', 438);
    define('PHOTOSTATION_TAG_EDIT_FAIL', 439);
    define('PHOTOSTATION_TAG_ACCESS_DENY', 440);
    define('PHOTOSTATION_TAG_HAS_EXIST', 441);
    define('PHOTOSTATION_TAG_SEARCH_FAIL', 442);

    // SYNO.PhotoStation.SmartAlbum (446-455)
    define('PHOTOSTATION_SMARTALBUM_CREATE_FAIL', 446);
    define('PHOTOSTATION_SMARTALBUM_EDIT_FAIL', 447);
    define('PHOTOSTATION_SMARTALBUM_ACCESS_DENY', 448);
    define('PHOTOSTATION_SMARTALBUM_NOT_EXIST', 449);
    define('PHOTOSTATION_SMARTALBUM_TAG_NOT_EXIST', 450);
    define('PHOTOSTATION_SMARTALBUM_CREATE_FAIL_EXIST', 451);

    // SYNO.PhotoStation.Photo (456-465)
    define('PHOTOSTATION_PHOTO_BAD_PARAMS', 456);
    define('PHOTOSTATION_PHOTO_ACCESS_DENY', 457);

    // SYNO.PhotoStation.PhotoTag (466-475)
    define('PHOTOSTATION_PHOTO_TAG_ACCESS_DENY', 466);
    define('PHOTOSTATION_PHOTO_TAG_NOT_EXIST', 467);
    define('PHOTOSTATION_PHOTO_TAG_DUPLICATE', 468);
    define('PHOTOSTATION_PHOTO_TAG_VIDEO_NOT_EXIST', 469);
    define('PHOTOSTATION_PHOTO_TAG_ADD_GEO_DESC_FAIL', 470);
    define('PHOTOSTATION_PHOTO_TAG_ADD_PEOPLE_FAIL', 471);
    define('PHOTOSTATION_PHOTO_TAG_DELETE_FAIL', 472);
    define('PHOTOSTATION_PHOTO_TAG_PEOPLE_TAG_CONFIRM_FAIL', 473);

    // SYNO.PhotoStation.Category (476-490)
    define('PHOTOSTATION_CATEGORY_ACCESS_DENY', 476);
    define('PHOTOSTATION_CATEGORY_WRONG_ID_FORMAT', 477);
    define('PHOTOSTATION_CATEGORY_GETINFO_FAIL', 478);
    define('PHOTOSTATION_CATEGORY_CREATE_FAIL', 479);
    define('PHOTOSTATION_CATEGORY_DELETE_FAIL', 480);
    define('PHOTOSTATION_CATEGORY_EDIT_FAIL', 481);
    define('PHOTOSTATION_CATEGORY_ARRANGE_FAIL', 482);
    define('PHOTOSTATION_CATEGORY_ADD_ITEM_FAIL', 483);
    define('PHOTOSTATION_CATEGORY_LIST_ITEM_FAIL', 484);
    define('PHOTOSTATION_CATEGORY_REMOVE_ITEM_FAIL', 485);
    define('PHOTOSTATION_CATEGORY_ARRANGE_ITEM_FAIL', 486);

    // SYNO.PhotoStation.Comment (491-495)
    define('PHOTOSTATION_COMMENT_VALIDATE_FAIL', 491);
    define('PHOTOSTATION_COMMENT_ACCESS_DENY', 492);
    define('PHOTOSTATION_COMMENT_CREATE_FAIL', 493);

    // SYNO.PhotoStation.Thumb (496-505)
    define('PHOTOSTATION_THUMB_BAD_PARAMS', 501);
    define('PHOTOSTATION_THUMB_ACCESS_DENY', 502);
    define('PHOTOSTATION_THUMB_NO_COVER', 503);
    define('PHOTOSTATION_THUMB_FILE_NOT_EXISTS', 504);

    // SYNO.PhotoStation.Download (506-515)
    define('PHOTOSTATION_DOWNLOAD_BAD_PARAMS', 506);
    define('PHOTOSTATION_DOWNLOAD_ACCESS_DENY', 507);
    define('PHOTOSTATION_DOWNLOAD_CHDIR_ERROR', 508);

    // SYNO.PhotoStation.File (516-525)
    define('PHOTOSTATION_FILE_BAD_PARAMS', 516);
    define('PHOTOSTATION_FILE_ACCESS_DENY', 517);
    define('PHOTOSTATION_FILE_FILE_EXT_ERR', 518);
    define('PHOTOSTATION_FILE_DIR_NOT_EXISTS', 519);

    // SYNO.PhotoStation.Cover (526-530)
    define('PHOTOSTATION_COVER_ACCESS_DENY', 526);
    define('PHOTOSTATION_COVER_ALBUM_NOT_EXIST', 527);
    define('PHOTOSTATION_COVER_PHOTO_VIDEO_NOT_EXIST', 528);
    define('PHOTOSTATION_COVER_PHOTO_VIDEO_NOT_IN_ALBUM', 529);
    define('PHOTOSTATION_COVER_SET_FAIL', 530);

    // SYNO.PhotoStation.Rotate (531-535)
    define('PHOTOSTATION_ROTATE_ACCESS_DENY', 531);
    define('PHOTOSTATION_ROTATE_SET_FAIL', 532);

?>
