<?php

require_once('rotate.inc.php');

class RotateAPI extends WebAPI {
    function __construct()
    {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process()
    {
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

        csSYNOPhotoMisc::CheckSessionTimeOut(true);

        if (!strcasecmp($this->method, "set")) {
            $this->Set();
        }
    }

    private function GetParams_Set()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['rotate'])) {
            return false;
        }
        if (!is_numeric($_REQUEST['rotate'])) {
            return false;
        }
        if (!in_array($_REQUEST['rotate'], array('90', '180', '270'))) {
            return false;
        }
        $params['rotate'] = (int)$_REQUEST['rotate'];

        $arr = explode(',', $_REQUEST['id']);
        $params['ids'] = array();
        foreach ($arr as $item) {
            unset($id);
            $split = explode('_', $item);
            if (3 !== count($split)) {
                return false;
            }
            if (!in_array($split[0], array('photo'))) {
                return false;
            }
            $dirName = @pack('H*', $split[1]);
            $fileName = @pack('H*', $split[2]);
            $filePath = realpath(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$dirName.'/'.$fileName);
            if (0 !== strncmp($filePath, SYNOPHOTO_SERVICE_REAL_DIR."/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
                return false;
            }
            $id['fullPath'] = $filePath;
            $id['albumName'] = $dirName;
            array_push($params['ids'], $id);
        }
        return $params;
    }

    private function Set()
    {
        if (false === ($params = $this->GetParams_Set())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        // check album maganeable
        foreach ($params['ids'] as $item) {
            if (false === csSynoPhotoMisc::CheckAlbumManageable($item['albumName'])) {
                $this->SetError(PHOTOSTATION_ROTATE_ACCESS_DENY);
                goto End;
            }
        }
        // rotate
        foreach ($params['ids'] as $item) {
            $retJson = SYNOPHOTO_ROTATE_PIC_DoRotation($params['rotate'], $item['fullPath']);
            $ret = json_decode($retJson, true);
            if (false === $ret['success']) {
                $this->SetError(PHOTOSTATION_ROTATE_SET_FAIL);
                goto End;
            }
        }
    End:
        return;
    }
}

$api = new RotateAPI();
$api->Run();
?>
