<?PHP
require_once 'about.inc.php';

class AboutAPI extends WebAPI
{
	public function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		switch ($this->method) {
			case 'get':
				$this->Get();
				break;
			case 'set':
				$this->Set();
				break;
			case 'set_visibility':
				$this->SetVisibility();
				break;
			default:
				break;
		}
	}

	private function Get()
	{
		$html = '';
		$hasContent = false;

		if (file_exists(ABOUT_HTML_PATH)) {
			$html = @file_get_contents(ABOUT_HTML_PATH);
			$hasContent = true;
		} else {
			$html = @file_get_contents(TEMPLATE_ABOUT_HTML_PATH);
		}

		if ($html === false) {
			$this->SetError(WEBAPI_ERR_UNKNOWN);
			return;
		}

		$resp = array(
			'html' => $html,
			'has_content' => $hasContent
		);

		$this->SetResponse($resp);
	}

	private function Set()
	{
		csSYNOPhotoMisc::CheckSessionTimeOut();

		$isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

		if (!$isAdmin) {
			$this->SetError(WEBAPI_ERR_NO_PERMISSION);
			return;
		}

		if (!isset($_REQUEST['html'])) {
			$this->SetError(WEBAPI_ERR_BAD_REQUEST);
			return;
		}
		$html = $_REQUEST['html'];

		if (!is_dir(SYNOTHEME_DIR) && !mkdir(SYNOTHEME_DIR)) {
			$this->SetError(WEBAPI_ERR_UNKNOWN);
			return;
		}

		$ret = @file_put_contents(ABOUT_HTML_PATH, $html);
		if ($ret === false) {
			$this->SetError(WEBAPI_ERR_UNKNOWN);
			return;
		}
	}

	private function SetVisibility()
	{
		csSYNOPhotoMisc::CheckSessionTimeOut();

		$isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

		if (!$isAdmin) {
			$this->SetError(WEBAPI_ERR_NO_PERMISSION);
			return;
		}

		$hidden = ('true' === $_REQUEST['hidden'] ? 'on' : 'off');
		csSYNOPhotoMisc::UpdateConfigDB('photo', 'disable_aboutme', $hidden, 'photo_config');
	}
}

$api = new AboutAPI();
$api->Run();
