<?php
require_once("include/syno_conf.php");
require 'twitter/tmhOAuth.php';
require 'twitter/tmhUtilities.php';

if(isset($_GET['action']) && 'start_twitter_oauth' == $_GET['action']) {
	echo SYNOPHOTO_TWITTER_StartOAuth();
	exit;
}

if(isset($_GET['action']) && 'set_twitter_token' == $_GET['action']) {
	echo SYNOPHOTO_TWITTER_SetToken();
	exit;
}

switch ($_POST['action']) {
case 'get_user':
	echo SYNOPHOTO_TWITTER_GetUser();
	break;
case 'upload':
	echo SYNOPHOTO_TWITTER_Upload();
	break;
case 'upload_new':
	echo SYNOPHOTO_TWITTER_Upload_new();
	break;
}

function SYNOPHOTO_TWITTER_StartOAuth()
{
	$callback = tmhUtilities::php_self()."?action=set_twitter_token";

	$cmd = "/usr/bin/php -n -d safe_mode_exec_dir=/usr/syno/bin -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so /var/packages/PhotoStation/target/photo/twitter/twitter.php -a get_token -c $callback";
	$res = exec($cmd, $output, $val);
	if ($val == 0) {
		$resArray = json_decode($res, true);
		$_SESSION['twitter_oauth'] = $resArray['twitter_oauth'];
		$authurl = $resArray['auth_url'];
		header("Location: {$authurl}");
	} else {
		echo $res;
	}
}

//twitter callback
function SYNOPHOTO_TWITTER_SetToken()
{
	$cmd = "/usr/bin/php -n -d safe_mode_exec_dir=/usr/syno/bin -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so /var/packages/PhotoStation/target/photo/twitter/twitter.php -a set_token -t  ".$_SESSION['twitter_oauth']['oauth_token']
	." -s ".$_SESSION['twitter_oauth']['oauth_token_secret']." -v ".escapeshellarg($_GET['oauth_verifier']);
	$res = exec($cmd, $output, $val);

	if ($val == 0) {
		$resArray = json_decode($res, true);
		$callback = '_onTwitterLogin';
		$token = $resArray['oauth_token'];
		$secret = $resArray['oauth_token_secret'];
		$uid = $resArray['user_id'];
		$screen_name = $resArray['screen_name'];
		$closeWindow = "
			<html>
			<head>
				<script>
				function loadHandler(){
					var callback = '$callback';
					var token = '$token';
					var secret = '$secret';
					var uid = '$uid';
					var screen_name = '$screen_name';
					if (callback) {
						eval('callback = window.opener.' + callback);
						callback(token, secret, uid, screen_name);
					}
					window.close();
				}
				</script>
			</head>
			<body onload='loadHandler()'></body>
			</html>";
		return $closeWindow;
	} else {
		echo $resArray['error'];;
	}
	unset($_SESSION['twitter_oauth']);
}

function SYNOPHOTO_TWITTER_GetUser()
{
	$result['success'] = false;
	if (!isSet($_POST['token']) || !isSet($_POST['secret'])) {
		return json_encode($result);
	}

	$cmd = "/usr/bin/php -n -d safe_mode_exec_dir=/usr/syno/bin -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so /var/packages/PhotoStation/target/photo/twitter/twitter.php -a get_user -t  "
		.escapeshellarg($_POST['token'])." -s ".escapeshellarg($_POST['secret']);
	$res = exec($cmd, $output, $val);

	if ($val == 0) {
		$resp = json_decode($res, true);
		$result['user'] = array();
		$result['user']['name'] = $resp['screen_name'];
		$result['user']['profile_image_url'] = $resp['profile_image_url'];
		$result['success'] = true;
	} else {
		$result['user'] = null;
	}
	return json_encode($result);
}

function SYNOPHOTO_TWITTER_Upload()
{
	$result['success'] = false;
	if (!isSet($_POST['path']) || !isSet($_POST['token']) || !isSet($_POST['secret'])) {
		return json_encode($result);
	}

	$path = $_POST['path'];

	$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($path);
	$image = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBXLARGE, false);
	if (!file_exists($image)) {
		$image = $path;// upload original file
	}

	$cmd = "/usr/bin/php -n -d safe_mode_exec_dir=/usr/syno/bin -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so /var/packages/PhotoStation/target/photo/twitter/twitter.php -a upload_photo -t  "
		.escapeshellarg($_POST['token'])." -s ".escapeshellarg($_POST['secret'])." -f ". escapeshellarg($image)." -m ".escapeshellarg($_POST['message']);
	$res = exec($cmd, $output, $val);

	if ($val == 0) {
		$result['success'] = true;
	}
	return json_encode($result);
}

function SYNOPHOTO_TWITTER_Upload_new()
{
	$result['success'] = false;
	if (!isSet($_POST['id']) || !isSet($_POST['token']) || !isSet($_POST['secret'])) {
		return json_encode($result);
	}

	$idarr = split('_', $_POST['id']);
	$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . @pack('H*', $idarr[1]) . "/" . @pack('H*', $idarr[2]));

	$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($path);
	$image = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBXLARGE, false);
	if (!file_exists($image)) {
		$image = $path;// upload original file
	}

	$cmd = "/usr/bin/php -n -d safe_mode_exec_dir=/usr/syno/bin -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so /var/packages/PhotoStation/target/photo/twitter/twitter.php -a upload_photo -t  "
		.escapeshellarg($_POST['token'])." -s ".escapeshellarg($_POST['secret'])." -f ". escapeshellarg($image)." -m ".escapeshellarg($_POST['message']);
	$res = exec($cmd, $output, $val);

	if ($val == 0) {
		$result['success'] = true;
	}
	return json_encode($result);
}
?>
