<!DOCTYPE html>
<html itemscope itemtype="http://schema.org/">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<!-- Facebook sharing meta tags -->
	{$CURRENT_IMAGES_LINK}
	<meta property="og:type" content="blog" />
	<meta property="og:title" content="{$CURRENT_TITLE}" />
	<meta property="og:description" content="{$CURRENT_DESC}" />
	<meta id= "fb_share_url" name="blogBaseUrl" content="{$CURRENT_URL}" />
	<!-- Google+ sharing meta tags -->
	<meta itemprop="name" content="{$CURRENT_TITLE}">
	<meta itemprop="description" content="{$CURRENT_DESC}">
	<meta itemprop="image" content="{$CURRENT_IMAGE_URL}">

	<meta name="description" content="{$PHOTO_META_DESC}" />
	<meta name="keywords" content="{$PHOTO_META_KEYWORD}" />
	<meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0" />

	<link rel="shortcut icon" href="../photo/images/ps_icon.png">
	<!-- GC -->
	<link rel="stylesheet" type="text/css" href="../photo/scripts/ext-3/resources/css/ext-all.css{$DSM_VERSION}" />
	<link rel="stylesheet" type="text/css" href="../photo/scripts/ext-3/resources/css/xtheme-gray-syno.css{$DSM_VERSION}" />
	<link rel="stylesheet" type="text/css" href="../photo/css/dsm_resources/css/desktop.css{$PACKAGE_VERSION}" />
	<link rel="stylesheet" type="text/css" href="../photo/css/common.css{$PACKAGE_VERSION}" />
	<!-- LIBS -->
	<script type="text/javascript" src="../photo/scripts/uistrings.php{$DSM_VERSION}&{$LAN_PARAM}"></script>
	<script type="text/javascript" src="../photo/scripts/ext-3/adapter/ext/ext-base.js{$DSM_VERSION}"></script>
	<script type="text/javascript" src="../photo/scripts/ext-3/ext-all.js{$DSM_VERSION}"></script>
	<script type="text/javascript" src="../photo/scripts/ext-3/ux/ux-all.js{$DSM_VERSION}"></script>

	<!-- String Script -->
	<script type="text/javascript" src="../photo/include/client_string.php{$PACKAGE_VERSION}&{$LAN_PARAM}"></script>
	<!-- SYNOBLO_INDEX -->
	<script type="text/javascript" src="../photo/javascripts/synoblog_index.js{$PACKAGE_VERSION}"></script>
	<!-- Common Styles -->
	<link rel="stylesheet" href="../photo/css/blog_style.css{$PACKAGE_VERSION}">
	<link type="text/css" rel="stylesheet" href="../photo/include/synotheme_css.php?type=blog&cv=1" id="theme-tmp">
	<link rel="stylesheet" href="../photo/css/article_content.css{$PACKAGE_VERSION}">

	<!-- Module Scripts -->
	{foreach $moduleList as $module}
          <script type="text/javascript" src="../photo/blog/modules/{$module.name}.js{$PACKAGE_VERSION}"></script>
    {/foreach}

	{$JS_NEEDED_BY_ADMIN}
	<script type="text/javascript" src="../photo/javascripts/synoblog_index_admin.js{$PACKAGE_VERSION}"></script>
	<script type="text/javascript" src="../photo/tinymce/jscripts/tiny_mce/tiny_mce.js{$PACKAGE_VERSION}"></script>
	<script type="text/javascript">{$JS_GLOBAL_VARS}</script>
	<script type="text/javascript">{$SCRIPT_NEED_BY_THEME}</script>
	<!-- Title -->
	<title>{$PAGE_TITLE}</title>
</head>
<body onclick="if(parent.prevent)parent.prevent(event)" onload="if('true'!==(Ext.urlDecode(window.location.hash.substr(1)) || {}).sc)window.scrollTo(0,0)" style="background-image:url({$SYNOTHEME_REQUEST_FILE}?type=blog&cv=1{$BKG_CHANGE}&action=bkg)">
	<div class="syno-blog-wrapper">
		<div class="syno-blog-header">
			<div class="header-main">
				<a href="index.php">
				<div class="syno-header-logo"><img src="{$SYNOTHEME_REQUEST_FILE}?type=blog&action=logo&cv=1" id="theme-logo"></div>
				</a>
				<div class="syno-header-link">
					{$WELCOME_TITLE}&nbsp;|
					{foreach $header_link_array as $link}
					<a href="{$link.href}">{$link.name}</a>&nbsp;|
					{/foreach}
				</div>
			</div>
		</div>
		<div class="syno-blog-contain-out">
			<div class="syno-blog-out-tl">
				<div class="syno-blog-out-tr">
					<div class="syno-blog-out-tc">
					</div>
				</div>
			</div>
			<div class="syno-blog-out-ml">
				<div class="syno-blog-out-mr">
					<div class="syno-blog-contain" id="blog_contain">
						<div class= "syno-blog-banner" id="syno_blog_banner" style="{$CUS_BANNER}">
							<div class="syno-blog-banner-l" id="syno_blog_banner_l" style="{$CUS_BANNER_L}">
								<div class="syno-blog-banner-r" id="syno_blog_banner_r" style="{$CUS_BANNER_L}">
									<div class="syno-blog-banner-m" id="syno_blog_banner_m" style="{$CUS_BANNER_M}">
										<a href="{$header_link_array['blog'].href}">{$BLOG_HEADER}</a></div>
								</div>
							</div>
						</div>
						<div class="syno-blog-central">
							<div class="syno-blog-central-left">
								{if $BLOG_LAYOUT == '1'}
									{include file='blog/module.tpl'}
								{/if}
							</div>
							<div id = "syno_blog_article" class="syno-blog-central-center">
								{include file='blog/article.tpl'}
							</div>
							<div class="syno-blog-central-right">
								{if $BLOG_LAYOUT == '2'}
									{include file='blog/module.tpl'}
								{/if}
							</div>
							<div class="clear"></div>
						</div>
						<div class="syno-footer syno-footer-stick">
							<div class="syno-footer-info">
							<a href="http://www.synology.com">Synology</a>
							Photo Station 6
							<a class="icon-rss" href="{$RSS_URL}"></a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="syno-blog-out-bl">
				<div class="syno-blog-out-br">
					<div class="syno-blog-out-bc">
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Fields required for history management -->
	<form id="history-form" class="x-hidden">
		<input type="hidden" id="x-history-field" />
		<iframe id="x-history-frame"></iframe>
	</form>
	{include file='login_form.tpl'}
</body>
</html>
