<?php
require_once("include/syno_conf.php");

$is_for_search = 0;

if (isSet($_REQUEST['dir']) && $_REQUEST['dir'] != "") {
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
}

if (isset($_GET['search'])) {
	$is_for_search = 1;
}

if ("on" != csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_album_download', 'photo_config')) {
	exit;
}

$dir = @pack('H*', $_REQUEST['dir']);

if (!$is_for_search) {
	$basename = basename($dir);
	$path = SYNOPHOTO_SERVICE_DIR."/".$dir;

	if (!file_exists($path) ||
		0 !== strncmp (realpath($path), SYNOPHOTO_SERVICE_REAL_DIR, strlen(SYNOPHOTO_SERVICE_REAL_DIR))) {
		exit;
	}

	$parent_dir = dirname($path);
	chdir($parent_dir);
} else {
	chdir(SYNOPHOTO_SERVICE_DIR);
}

if (isSet($_REQUEST['action'])) {
	if (!$is_for_search) {
		echo SYNOPHOTO_DOWNLOAD_GetDownloadItems($dir);
	}
	exit;
}

if (isSet($_REQUEST['download_list']) && $_REQUEST['download_list'] != "") {
	if (!$is_for_search) {
		$source = SYNOPHOTO_DOWNLOAD_GetDownloadListFromPostList($dir);
	} else {
		$source = SYNOPHOTO_DOWNLOAD_GetDownloadListFromPostListForSearch();
	}
} else {
	if (!$is_for_search) {
		if (strstr($dir, "/")) {
			$source = escapeshellarg($basename);
		} else {
			$source = SYNOPHOTO_DOWNLOAD_GetDownloadList($dir);
		}
	}
}

SYNOPHOTO_DOWNLOAD_PrintHeaders($basename.'.zip', $is_for_search);
passthru("/usr/syno/bin/zip -q -G -r -0 - ".$source." -x@".SYNOPHOTO_INCLUDE_DIR."/exclude.txt");

function SYNOPHOTO_DOWNLOAD_PrintHeaders($filename, $force_filename)
{
	header('Content-Type: application/force-download');
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Pragma: public");
	if ($force_filename) {
		header('Content-Disposition: attachment; filename="'.addslashes($filename).'"');
	} else {
		header('Content-Disposition: attachment');
	}
	header("X-Download-Options: noopen");
}


function SYNOPHOTO_DOWNLOAD_GetDownloadListFromPostList($album_name)
{
	$arr = explode(',', $_REQUEST['download_list']);

	foreach ($arr as $file) {
		$file = @pack('H*', $file);
		if ($file == "") {
			continue;
		}
		if (!strstr($album_name, "/") && is_dir($album_name."/".$file) &&
			!csSYNOPhotoMisc::CheckAlbumAccessible($album_name."/".$file)) {
			continue;
		}
		$result = $result.escapeshellarg(basename($album_name)."/".$file)." ";
	}
	return $result;
}

function SYNOPHOTO_DOWNLOAD_GetDownloadListFromPostListForSearch()
{
	$arr = explode(',', $_REQUEST['download_list']);

	foreach ($arr as $file) {
		$file = @pack('H*', $file);
		if ($file == "") {
			continue;
		}
		if (is_dir(SYNOPHOTO_SERVICE_REAL_DIR."/".$file)) {
			if (!csSYNOPhotoMisc::CheckAlbumAccessible($file)) {
				continue;
			}
			if (!strstr($file)) {
				$result = $result.SYNOPHOTO_DOWNLOAD_GetDownloadList($file);
			} else {
				$result = $result.escapeshellarg($file)." ";
			}
			continue;
		}

		if (csSYNOPhotoMisc::CheckPathAccessible(SYNOPHOTO_SERVICE_REAL_DIR."/".$file)) {
			$result = $result.escapeshellarg($file)." ";
		}
	}
	return $result;
}

function SYNOPHOTO_DOWNLOAD_GetDownloadList($album_name)
{
	$currPath = getcwd();
	@chdir(SYNOPHOTO_SERVICE_REAL_DIR."/".$album_name);
	foreach (glob('{,.}*', GLOB_BRACE) as $file) {
		if (is_dir($file)) {
			if ($file == SYNOPHOTO_EADIR) {
				continue;
			}
			if (!csSYNOPhotoMisc::CheckAlbumAccessible($album_name."/".$file)) {
				continue;
			}
			$result = $result.escapeshellarg($album_name."/".$file)." ";
		} else {
			if ($file == '.' || $file == '..') {
				continue;
			}
			$result = $result.escapeshellarg($album_name."/".$file)." ";
		}
	}
	@chdir($currPath);
	return $result;
}

function SYNOPHOTO_DOWNLOAD_GetDownloadItems($album_name)
{
	$escape = PHOTO_DB_GetEscape();
	$list = csSYNOPhotoMisc::GetSubDir($album_name, 0);
	$dir_list = array_keys($list);

	$result_list = array();

	for ($i = 0; $i < count($dir_list); $i++) {
		if (!csSYNOPhotoMisc::CheckAlbumAccessible($dir_list[$i])) {
			continue;
		}
		$album_info = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($dir_list[$i]);

		$item = array();
		$item['icon'] = 'folder.png';
		$item['name'] = htmlspecialchars(basename($dir_list[$i]));
		$item['src_name'] = bin2hex(basename($dir_list[$i]));
		$item['src'] = $album_info['bigCover']['src'];
		$result_list[] = $item;
	}

	$albumRealPath = PHOTO_DB_EscapForLike(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$album_name}");
	$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
	$escape = PHOTO_DB_GetEscape();

	$query = "Select * from photo_image where path like ? $escape and path not like ? $escape order by ".$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']." ".$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'].", path ".$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'];

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	while (($row = PHOTO_DB_FetchRow($db_result))) {
		$fPath = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[1];
		$info = csSYNOPhotoMisc::GetThumbInfoFromFullPath($fPath, 0, $row[7], $row[8], $row[16]);
		$item = array();
		$item['icon'] = 'image.png';
		$item['name'] = htmlspecialchars(basename($fPath));
		$item['src_name'] = bin2hex(basename($fPath));
		$item['src'] = $info['src'];
		$result_list[] = $item;
	}

	if ("on" == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_video_download', 'photo_config')) {
		$query = "Select * from video where path like ? $escape and path not like ? $escape
			order by ".$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type_video']." ".$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'].", path ".$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'];
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		while (($row = PHOTO_DB_FetchRow($db_result))) {
			$fPath = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[1];
			$info = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($fPath, 0, $row[7], $row[8], -1);
			$item = array();
			$item['icon'] = 'film.png';
			$item['name'] = htmlspecialchars(basename($fPath));
			$item['src_name'] = bin2hex(basename($fPath));
			$item['src'] = $info['src'];
			$result_list[] = $item;
		}
	}

	$result['images'] = $result_list;
	$result['success'] = TRUE;
	return json_encode($result);
}

?>
