<?php
require_once('../include/synophoto_mobile_conf.php');

function IsServiceEnabled()
{
	$result =true;
	if (!preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
		/* check whether photo service enabled */
		if (!file_exists(SYNO_PKG_DIR.'/enabled')) {
			$result = false;
		}
	} else{
		if (!file_exists(SYNO_PKG_DIR.'/enabled') ||
			!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation']) ||
			'yes' != $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation'] ||
			!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation']) ||
			'yes' != $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation']) {
			$result = false;
		}
	}

	return $result;
}

//client supported video formats
if (isSet($_REQUEST['video_formats']) &&
	is_array($video_formats = json_decode($_REQUEST['video_formats']))) {

	$_SESSION[SYNOPHOTO_ADMIN_USER]['video_formats'] = array();
	foreach ($video_formats as $item) {
		if (7 !== count($item)) {
			continue;
		}

		list($codec, $profile, $level, $width, $height, $bitrate, $formats) = $item;
		/* check paramemter type */
		if (!is_string($codec) || !is_array($formats) ||
			!is_numeric($profile) || !is_numeric($level) ||
			!is_numeric($width) || !is_numeric($height) ||
			!is_numeric($bitrate)) {
			continue;
		}

		/* check codec value */
		if (!in_array($codec, array('h264', 'mpeg4', 'flv1', '*'), true)) {
			continue;
		}

		/* check container value */
		if (0 < count($formats)) {
			$containers = array();
			foreach ($formats as $type) {
				if (in_array($type, array('mp4', '3gp', 'flv'), true)) {
					$containers[] = $type;
				}
			}
			if (0 >= count($containers)) {
				continue;
			}
		}
		$_SESSION[SYNOPHOTO_ADMIN_USER]['video_formats'][] = $item;
	}
}

if (isSet($_POST['action']) && $_POST['action'] == "login" && isSet($_POST['username'])) {
	$IsServiceEnabled = IsServiceEnabled();

	$username = $_POST['username'];
	$password = isSet($_POST['passwd']) ? $_POST['passwd'] : '';
	$isValid = false;
	$errText = 'login_error_account';

	unset($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'], $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'], $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'], $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'], $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid']);

    $commend = "/usr/syno/bin/synoautoblock --deny \"".$_SERVER['REMOTE_ADDR']."\"";
    @system($commend, $retval);
    $commend = "";
	if (!file_exists(SYNOPHOTO_SERVICE_DIR)) {
		$errText = 'error_photo_share_not_found';
	} else if (!$IsServiceEnabled) {
    	$errText = 'error_service_disabled';
    } else if ($retval == 1) {
        $errText = 'error_noprivilege';
    //if username is ADMIN
	} else if ('admin' == strtolower($username) || strtolower(SYNOPHOTO_ADMIN_NAME) == strtolower($username)) {
		if (csSYNOPhotoDB::GetDBInstance()->ValidateAdminPassword($password, SYNOPHOTO_ADMIN_NAME)) {
			$isValid = true;
			$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
            $commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
		} else {
            $commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
        }

	} else if (empty($username)) {
		//login as guest
		$isValid = true;

	}else {
		$accountSystem = csSYNOPhotoDB::GetDBInstance()->GetConfig('global', 'account_system');
		if (SYNOPHOTO_INDEPENDENT_ACCOUNT == $accountSystem || 'root' != SYNOPHOTO_ADMIN_USER) {
			$userInfo = csSYNOPhotoDB::GetDBInstance()->GetValidateUserInfo($username, $password);
			if (false !== $userInfo) {
				if ('t' == $userInfo['disabled'] || true === $userInfo['disabled']) {
					$errText = 'error_noprivilege';
				} else {
					$isValid = true;
					$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = $userInfo['userid'];
					$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $userInfo['username'];
					if ('t' == $userInfo['admin'] || true === $userInfo['admin']) {
						$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
					}
					$commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
				}
			} else {
				$commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
			}
		} else {
			//use DSM account
			if (csSYNOPhotoDB::GetDBInstance()->ValidateAdminPassword($password, $username)) {
				$isValid = true;
				$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = csSYNOPhotoDB::GetDBInstance()->GetDSMUserID($username);
				$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $username;
				$_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'] = true;
				if (csSYNOPhotoDB::GetDBInstance()->IsDSMAdmin($username)) {
					$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
				}
				$commend = "/usr/syno/bin/synoautoblock --reset \"".$_SERVER['REMOTE_ADDR']."\"";
			} else {
				$commend = "/usr/syno/bin/synoautoblock --attempt \"".$_SERVER['REMOTE_ADDR']."\"";
			}
		}
	}

    if ($commend != "") {
		putenv('SYNOAUTOBLOCK_SERVICE=Photo Station');
		@system($commend, $retval);
		putenv('SYNOAUTOBLOCK_SERVICE');
    }

	if ($IsServiceEnabled && !empty($username)) {
		// log the user login record
		$status = $isValid ? 'logged in' : 'failed to login';
		if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
			$logMsg = "{$username} {$status} from [xxx.xxx.xxx.xxx]";
		} else {
			$logMsg = "{$username} {$status} from [{$_SERVER['REMOTE_ADDR']}]";
		}
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($logMsg, $isValid, $username);
	}

	//check if server enable search
	$searchEnabled = true;
	if ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'hide_search')) {
		$searchEnabled = false;
	}

	$downloadOrig = false;
	if ('on'== csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_orig')){
		$downloadOrig = true;
	}

	$version = csSYNOPhotoMisc::GetConfigFile(SYNO_DEF_VERSION_FILE, 'buildnumber');

	// detect package major, minor number and build version
	$command = '/usr/syno/bin/synogetkeyvalue '.escapeshellarg(SYNOPHOTO_PACKAGE_INFO).' version';
	$ret = @exec($command);
	list($majorNum, $minorNum, $buildVer) = preg_split("/[\.-]+/", $ret);

	$result = array('success' => $isValid ? true : $errText, 'isAdmin' => isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']),
					'isSearchEnabled' => $searchEnabled, 'allow_orig' => $downloadOrig, 'version' => $version['buildnumber'],
					'packageVersion' => array('major' => $majorNum, 'minor' => $minorNum, 'build' => $buildVer));

	echo json_encode($result);

} else if (isSet($_GET['action']) && $_GET['action'] == "logout") {
	session_unset();
	session_destroy();
}
?>
