<?php
require_once('include/synophoto_mobile_conf.php');

$isIPhone = ('iPhone' == $_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser']);

$albumName = @pack('H*', $_GET['dir']);
$password = $_POST['password'];
$checkResult = csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($albumName, $password);
if (empty($_GET['name']) || "error_no_permission" === $checkResult) {
	header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/m/");
	exit;
}

$photoName = @pack('H*', $_GET['name']);
$searchParam = '';

if (isSet($_GET['searchToken']) && !empty($_GET['searchToken'])
	&& isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$_GET['searchToken']])
	&& isSet($_GET['search']) && !empty($_GET['search'])
	&& (isSet($_GET['option_name']) || isSet($_GET['option_title']) || isSet($_GET['option_desc'])) ) {
	$searchToken = $_GET['searchToken'];
	$searchParam = "searchToken={$searchToken}&search=".rawurlencode($_GET['search']);
	$condition = array();
	$matchPattern = array('option_name', 'option_title', 'option_desc');
	foreach($matchPattern as $field) {
		if (isSet($_GET[$field])) {
			$searchParam .= "&{$field}=on";
			$condition[$field] = $_GET['search'];
		}
	}
	$seqList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSearchList($condition);
	$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$photoName}";
	$photoSeq = 1 + array_search($photoPath, array_keys($seqList));
	$photoView = csSYNOPhotoThumb::GetThumbInstance()->GetSearchPhotoView($searchToken, $albumName, $photoName);
	$navPrevText = __('photo_str_search_result');
	$navPrevLink = "search_result.php?{$searchParam}&showSeq={$photoSeq}";
} else {
	$seqList = csSYNOPhotoBrowse::GetBrowseInstance()->GetList($albumName);
	$photoSeq = 1 + array_search($photoName, array_keys($seqList));
	$photoView = csSYNOPhotoThumb::GetThumbInstance()->GetAlbumPhotoView($albumName, $photoName);
	$albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
	$navPrevText = $albumInfo['showTitle'];
	$navPrevLink = "photo_album.php?dir={$_GET['dir']}&showSeq={$photoSeq}";
}


$smarty->assign('toolbarTitle', '');
$smarty->assign('hasZoom', true);
$smarty->assign('navPrevText', $navPrevText);
$smarty->assign('navPrevLink', $navPrevLink);

if (!$isIPhone && true !== $checkResult) {
	switch ($checkResult) {
		case "error_invalid_album_password":
			$smarty->assign('alertMsg', __('photo_str_password_error'));
		case "error_need_album_password":
			Header("Cache-Control: no-cache, must-revalidate");
			Header("Pragma: no-cache");
			$smarty->display('photo_album_password.tpl');
			break;
		default:
			header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/m/");
	}
	exit;
}

if (!$isIPhone) {
	$page = 1;
	if (isSet($_GET['page']) && is_numeric($_GET['page'])) {
		$page = $_GET['page'];
	}
	$commentList = csSYNOPhotoBrowse::GetBrowseInstance()->GetCommentList($albumName, $photoName, ($page - 1) * COMMENTS_PER_LOAD, COMMENTS_PER_LOAD);
	$smarty->assign('page', $page);
	$smarty->assign('isMorePage', $commentList['commentsMore']);
	$smarty->assign('photoComments', $commentList);
	$smarty->assign('searchParam', $searchParam);
	$smarty->assign('photoView', $photoView);
}

$smarty->display('photo_one.tpl');
?>
