<?php
require_once(dirname(__FILE__).'/../syno_conf.php');

if (preg_match('/^(save_label|delete_label|confirm_label|get_label|update_label|batch_add_label|batch_delete_label|get_labels_by_selected_ids)$/', $_POST['action'])) {
	if (!csSYNOPhotoMisc::CheckAlbumManageable($_POST['albumName'])) {
		csSYNOPhotoMisc::CheckAdminTimeOut();
	}
}

switch ($_POST['action']) {
case 'save_label':
	echo SYNOPHOTO_LABEL_UTIL_SaveItemLabel();
	break;
case 'delete_label':
	if (isset($_POST['label_ids'])) {
		$delete_ids = json_decode($_POST['label_ids']);
		foreach ($delete_ids as $item) {
			SYNOPHOTO_LABEL_UTIL_DeleteLabel($item);
		}
		$result['success'] = true;
		echo json_encode($result);
		exit;
	}
	if (isset($_POST['item_label_ids'])) {
		$delete_ids = json_decode($_POST['item_label_ids']);
		foreach ($delete_ids as $item) {
			$result = SYNOPHOTO_LABEL_UTIL_DeleteItemLabel($item);
		}
		echo $result;
		exit;
	}
	echo SYNOPHOTO_LABEL_UTIL_DeleteItemLabel($_POST['item_label_id']);
	break;
case 'get_available_label':
	echo SYNOPHOTO_LABEL_UTIL_GetAvailableLabel();
	break;
case 'confirm_label':
	echo SYNOPHOTO_LABEL_UTIL_ConfirmLable();
	break;
case 'get_label':
	echo SYNOPHOTO_LABEL_UTIL_GetLable();
	break;
case 'update_label':
	echo SYNOPHOTO_LABEL_UTIL_UpdateLable();
	break;
case 'batch_add_label':
	echo SYNOPHOTO_LABEL_UTIL_BatchAddLabel();
	break;
case 'batch_delete_label':
	echo SYNOPHOTO_LABEL_UTIL_BatchDeleteLabel();
	break;
case 'get_labels_by_selected_ids':
	echo SYNOPHOTO_LABEL_UTIL_GetLabelsBySelectedIds();
	break;
}

function SYNOPHOTO_LABEL_UTIL_SaveItemLabel()
{
	$successCount = 0;
	$result['success'] = false;
	$result['data'] = array();

	if (!isSet($_POST['category']) || !isSet($_POST['name']) || !isSet($_POST['item_label_id']) || (!isSet($_POST['id']) && !isSet($_POST['path']))
		|| ('0' == $_POST['category'] && (!isSet($_POST['x']) || !isSet($_POST['y']) || !isSet($_POST['width']) || !isSet($_POST['height'])))) {
		$result['info'] = 'Some required POST fields is missing';
		return json_encode($result);
	}

	if ('2' === $_POST['category']) {//descriptive tag would be separated by comma
		$inputLabels = explode(',', $_POST['name']);
	} else {
		$inputLabels[] = $_POST['name'];
	}

	foreach ($inputLabels as $inputLabel) {
		$inputLabel = trim($inputLabel);

		if (0 < strlen($inputLabel)) {
			$targetLabels[] = $inputLabel;
		}
	}

	if (empty($targetLabels)) {
		$result['info'] = 'No valid label';
		return json_encode($result);
	}

	foreach($targetLabels as $targetLabel) {
		//get label id
		if ($row = SYNOPHOTO_LABEL_UTIL_GetLabel($targetLabel, $_POST['category'])) {//label exists
			$label_id = $row['id'];
		} else {//add a new label
			$label['name'] = $targetLabel;
			$label['category'] = $_POST['category'];
			$label['info'] = '';

			if ('1' === $_POST['category']) {
				$label['info'] = json_encode(
					array(
						'placeId' => $_POST['placeId'],
						'reference' => $_POST['reference'],
						'lat' => $_POST['lat'],
						'lng' => $_POST['lng']
					)
				);
			}

			if (false === SYNOPHOTO_LABEL_UTIL_AddNewLabel($label)) {
				$result['info'] = 'Add new label failed';
				continue;
			}

			$row = SYNOPHOTO_LABEL_UTIL_GetLabel($targetLabel, $_POST['category']);
			$label_id = $row['id'];
			$result['new_label'] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);

			//descriptive tag would be separated by comma
			if ('2' === $_POST['category']) {
				$result['data']['new_labels'][] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
			}
		}

		if (isSet($_POST['id'])) {//photo
			$info= '';
			if ('0' === $_POST['category']) {
				$info = json_encode(
					array(
						'x' => intval($_POST['x']),
						'y' => intval($_POST['y']),
						'width' => intval($_POST['width']),
						'height' => intval($_POST['height'])
					)
				);
			}

			$tempLabel = SYNOPHOTO_LABEL_UTIL_GetOneImageLabel($_POST['id'], $label_id);

			if (-1 == $_POST['item_label_id']) {//add
				if ($tempLabel) {
					$result['info'] = 'Label exists';
					continue;
				}

				if (SYNOPHOTO_LABEL_UTIL_AddPhotoLabel($_POST['id'], $label_id, $info)) {
					$newLabelRecord = SYNOPHOTO_LABEL_UTIL_GetOneImageLabel($_POST['id'], $label_id);
					$result['item_label_id'] = $newLabelRecord['id'];
					$result['label_id'] = $newLabelRecord['label_id'];

					//descriptive tag would be separated by comma
					if ('2' === $_POST['category']) {
						$result['data']['tagged_labels'][] = array(
							'item_label_id' => $newLabelRecord['id'],
							'label_id' => $newLabelRecord['label_id'],
							'name' => $targetLabel
						);
					}
					$successCount++;

					if ('0' == $_POST['category']) {
						$cmd = sprintf("%s -T %s %s", SYNOPHOTO_FACE_RECOG_TOOL, $result['item_label_id'], escapeshellarg($_POST['path']));
						@exec($cmd);
					}
				}
			} else {
				//update info, only person tag may be updated
				if ($tempLabel && ($tempLabel['id'] != $_POST['item_label_id'])) {
					$result['info'] = 'Label exists';
					continue;
				}

				if (SYNOPHOTO_LABEL_UTIL_UpdatePhotoLabel($_POST['id'], $label_id, $_POST['item_label_id'])) {
					SYNOPHOTO_LABEL_UTIL_RemoveFaceTrainingData();
					$successCount++;
				}
			}
		} else { //video
			$tempLabel = SYNOPHOTO_LABEL_UTIL_GetOneVideoLabel($_POST['path'], $label_id);

			if ($tempLabel) {
				$result['info'] = 'Label exists';
				continue;
			}

			if (SYNOPHOTO_LABEL_UTIL_AddVideoLabel($_POST['path'], $label_id, $info='')) {
				$newLabelRecord = SYNOPHOTO_LABEL_UTIL_GetOneVideoLabel($_POST['path'], $label_id);
				$result['item_label_id'] = $newLabelRecord['id'];
				$result['label_id'] = $newLabelRecord['label_id'];

				//descriptive tag would be separated by comma
				if ('2' === $_POST['category']) {
					$result['data']['tagged_labels'][] = array(
						'item_label_id' => $newLabelRecord['id'],
						'label_id' => $newLabelRecord['label_id'],
					);
				}
				$successCount++;
			}
		}
	}

	$result['success'] = ($successCount > 0);
	return json_encode($result);
}

function SYNOPHOTO_LABEL_UTIL_DeleteItemLabel($item_label_id, $isPhoto = null)
{
	$isNeedUpdatePhotoMetadata = false;
	$isNeedRemoveFaceTrainingData = false;

	$result['success'] = false;
	if (!isSet($item_label_id)) {
		return json_encode($result);
	}

	$itemType = 1;
	if (isSet($_POST['path']) || (false === $isPhoto)) {
		$itemType = 2;
	} else {
		$query = 'SELECT A.image_id, A.status, A.info, B.category FROM photo_image_label A, photo_label B WHERE A.id=? and A.label_id = B.id';
		$sqlParam = array($item_label_id);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if (false === $db_result) {
			return false;
		}
		$row = PHOTO_DB_FetchRow($db_result);
		$image_id = $row['image_id'];

		if (0 == $row['category'] || 2 == $row['category']) {
			$isNeedUpdatePhotoMetadata = true;
		}
		if (0 == $row['category'] && PHOTO_DB_IsTrue($row['status']) && strstr($row['info'], "face")) {
			$isNeedRemoveFaceTrainingData = true;
		}
	}

	$label = SYNOPHOTO_LABEL_UTIL_CheckLabelToDelete($item_label_id, $itemType);
	$result['success'] = SYNOPHOTO_LABEL_UTIL_DeleteOneItemLabel($item_label_id, $itemType);
	if ($label) {
		SYNOPHOTO_LABEL_UTIL_DeleteLabel($label['id']);
		$result['delete_label_id'] = $label['id'];
	}
	if ($isNeedUpdatePhotoMetadata) {
		SYNOPHOTO_LABEL_UTIL_UpdatePhotoMetadata($image_id, $row['category']);
	}
	if ($isNeedRemoveFaceTrainingData) {
		SYNOPHOTO_LABEL_UTIL_RemoveFaceTrainingData();
	}
	return json_encode($result);
}

function SYNOPHOTO_LABEL_UTIL_RemoveFaceTrainingData()
{
	$cmd = sprintf("%s -R %s", SYNOPHOTO_FACE_RECOG_TOOL, escapeshellarg(SYNOPHOTO_ADMIN_NAME));
	@exec($cmd);
}

function SYNOPHOTO_LABEL_UTIL_GetAvailableLabel()
{
	$result['success'] = false;
	if (!isSet($_POST['category'])) {
		return json_encode($result);
	}
	$labels = SYNOPHOTO_LABEL_UTIL_GetAllLabel();

	$data['labels'] = $labels[$_POST['category']];
	return json_encode($data);
}

//database related function
function SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($photo_id) {
	$tag = array();
	$tag['person'] = array();
	$tag['place'] = array();
	$tag['general'] = array();
	$query = 'select B.id, B.label_id, B.image_id, B.info, B.status, B.info_new, A.name, A.category, A.info as label_info from photo_label A, photo_image_label B '.
			'where A.id=B.label_id AND B.image_id=?';
	$sqlParam = array($photo_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	$isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

	while (false !== ($row = $db_result->fetch())) {
		if (0 == $row['category']) {
			$item = SYNOPHOTO_LABEL_UTIL_GetImageLabelItem($row, $photo_id);
			if (!$isAdmin && false == $item['status']) {
				continue;
			}
			$tag['person'][] = $item;
		} else if (1 == $row['category']) {
			$tag['place'][] = SYNOPHOTO_LABEL_UTIL_GetImageLabelItem($row, false);
		} else {
			$tag['general'][] = SYNOPHOTO_LABEL_UTIL_GetImageLabelItem($row, false);
		}
	}
	return $tag;
}

function SYNOPHOTO_LABEL_UTIL_GetPhotoResolution_800px($photoID)
{
    // get path and version
    $query = 'select path, version, resolutionx, resolutiony from photo_image where id=?';
    $sqlParam = array($photoID);
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
        return false;
	}
    $path = $row['path'];
    $version = (int)$row['version'];
    $orig_x = (int)$row['resolutionx'];
    $orig_y = (int)$row['resolutiony'];

    // calculate thumb(800px) resolution
    $thumb_L_x = $thumb_L_y = 800;
    $photoRadio = $orig_x / $orig_y;
    if ($orig_x > $orig_y) { //wider photo
        $thumb_L_y = intval(800 / $photoRadio);
    } else { // higher photo
        $thumb_L_x = intval(800 * $photoRadio);
    }

    // check rotate
    if (1 == ($version % 2)) {
        $tmp = $thumb_L_x;
        $thumb_L_x = $thumb_L_y;
        $thumb_L_y = $tmp;
    }

    $data['x'] = $thumb_L_x;
    $data['y'] = $thumb_L_y;
    return $data;
}

function SYNOPHOTO_LABEL_UTIL_GetImageLabelItem($row, $photoID)
{
	$item = array();
	$item['id'] = $row['id'];
	$item['label_id'] = $row['label_id'];
	if (isSet($row['image_id'])) {
		$item['image_id'] = $row['image_id'];
	} else {
		$item['video_path'] = $row['video_path'];
	}
    $item['info'] = $row['info'];
    // adjust info
    if (!empty($row['info_new'])) {
        $item['info'] = $row['info_new'];
    } elseif (!empty($row['info']) && false !== $photoID) {
        $item['info'] = '';
        $resolution = SYNOPHOTO_LABEL_UTIL_GetPhotoResolution_800px($photoID);
        if (!empty($resolution['x']) && !empty($resolution['y'])) {
            $info = json_decode($row['info'], true);
            if (!empty($info['face'])) {
                $adjustInfo['face']['x'] = $info['face']['x'] / $resolution['x'];
                $adjustInfo['face']['y'] = $info['face']['y'] / $resolution['y'];
                $adjustInfo['face']['width'] = $info['face']['width'] / $resolution['x'];
                $adjustInfo['face']['height'] = $info['face']['height'] / $resolution['y'];
            }
            $adjustInfo['x'] = $info['x'] / $resolution['x'];
            $adjustInfo['y'] = $info['y'] / $resolution['y'];
            $adjustInfo['width'] = $info['width'] / $resolution['x'];
            $adjustInfo['height'] = $info['height'] / $resolution['y'];
            $item['info'] = json_encode($adjustInfo);
        }
    }

	$item['name'] = $row['name'];
	$item['status'] = PHOTO_DB_IsTrue($row['status']);
	$item['category'] = $row['category'];
	$item['label_info'] = $row['label_info'];
	return $item;
}

/*
 * @params - $filterCategory = array()
 */

function SYNOPHOTO_LABEL_UTIL_GetAllLabel($forceStatusConfirm = false, $filterCategory = false)
{
	$tag = array();
	$tag[0] = array();//person
	$tag[1] = array();//place
	$tag[2] = array();//general

	$needFilterNonConfirm = ('on' == csSYNOPhotoMisc::GetConfigDB("timeline", "timeline_filter_nonConfirm", 'photo_config'));
	$needFilterNonConfirm = $needFilterNonConfirm || $forceStatusConfirm;
	$filterCondi = ($needFilterNonConfirm) ? " WHERE status='t' " : '';

	$sqlParam = array();
	if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && !$needFilterNonConfirm) {
		$query = 'SELECT * FROM photo_label;';
	} else {
		$query = 'select distinct photo_label.id as id, photo_label.name as name, photo_label.info as info, category from photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id LEFT JOIN photo_label ON photo_image_label.label_id=photo_label.id '.$filterCondi;
		$videoQuery = 'select distinct photo_label.id as id, photo_label.name as name, photo_label.info as info, category from photo_video_label LEFT JOIN video ON photo_video_label.video_path=video.path LEFT JOIN photo_label ON photo_video_label.label_id=photo_label.id ';
        if (false !== $filterCategory) {
            $cateogryArr = array();
            foreach ($filterCategory as $categoryID) {
                $str = 'category='.$categoryID;
                array_push($cateogryArr, $str);
            }
            $categoryString = '('.implode(' or ', $cateogryArr).')';
            $operator = ($needFilterNonConfirm) ? ' AND ' : 'WHERE';
            $query .=" $operator $categoryString ";
            $videoQuery .=" WHERE $categoryString";
        }

		if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$operator = (false !== $filterCategory || $forceStatusConfirm) ? ' AND ' : 'WHERE';
            $operatorVideo = (false !== $filterCategory) ? ' AND ' :  'WHERE';
			$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
			if(count($albumCondition['albumCond']) > 0) {
				$query .= " $operator (".implode(' OR ', $albumCondition['albumCond']).' )';
				$videoQuery .= " $operatorVideo (".implode(' OR ', $albumCondition['albumCond']).' )';
				$sqlParam = $albumCondition['sqlParam'];
			} else {
				return $tag;
			}
		}
	}

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	while (false !== ($row = $db_result->fetch())) {
		if (empty($row['name'])) {
			continue;
		}
		$tag[$row['category']][] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
	}
	if (isSet($videoQuery)) {
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $videoQuery, $sqlParam);
		while (false !== ($row = $db_result->fetch())) {
			$find = false;
			foreach($tag[$row['category']] as $item){
				if ($item['id'] == $row['id']){
					$find = true;
				}
			}
			if (!$find) {
				$tag[$row['category']][] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
			}
		}
	}

	usort($tag[0], 'SYNOPHOTO_LABEL_UTIL_SortLabel');
	usort($tag[1], 'SYNOPHOTO_LABEL_UTIL_SortLabel');
	usort($tag[2], 'SYNOPHOTO_LABEL_UTIL_SortLabel');
	return $tag;
}

function SYNOPHOTO_LABEL_UTIL_SortLabel($a, $b)
{
	return strnatcasecmp($a['name'], $b['name']);
}

function SYNOPHOTO_LABEL_UTIL_GetLabelItem($row)
{
	$item = array();
	$item['id'] = $row['id'];
	$item['name'] = $row['name'];
	$item['display_name'] = htmlspecialchars($row['name'],ENT_QUOTES);
	$item['info'] = $row['info'];
	return $item;
}

function SYNOPHOTO_LABEL_UTIL_AddNewLabel($label)
{
	$sqlParam = array();
	$label_id = 'null';
	if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
		//personal
		$query = "SELECT MAX(id) FROM photo_label;";
		$count = PHOTO_DB_QueryCount($GLOBALS['dbconn_photo'], $query);
		if ($count === NULL) {//for there is no record in photo_label, max(id) will be null
			$count = 1;
		}
		$query = "INSERT INTO photo_label (id, name, category, info) VALUES (?, ?, ?, ?);";
		$sqlParam[] = $count+1;
	} else {
		$query = "INSERT INTO photo_label (name, category, info) VALUES (?, ?, ?);";
	}
	$sqlParam[] = $label['name'];
	$sqlParam[] = $label['category'];
	$sqlParam[] = $label['info'];
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	return true;
}

function SYNOPHOTO_LABEL_UTIL_GetLabel($name, $category)
{
	$query = 'SELECT * FROM photo_label WHERE name = ? and category = ?';
	$sqlParam = array($name, $category);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		return $row;
	}
	return false;
}

function SYNOPHOTO_LABEL_UTIL_GetGeoLabel($name, $info)
{
	$query = 'SELECT * FROM photo_label WHERE name = ? and category=1  and info = ?';
	$sqlParam = array($name, $info);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		return $row;
	}
	return false;
}

function SYNOPHOTO_LABEL_UTIL_GetLabelById($id)
{
	$query = 'SELECT * FROM photo_label WHERE id=?';
	$sqlParam = array($id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		return SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
	}
	return false;
}

function SYNOPHOTO_LABEL_UTIL_AddPhotoLabel($image_id, $label_id, $info='')
{
	$query = 'INSERT INTO photo_image_label (image_id, label_id, info) VALUES (?, ?, ?);';
	$sqlParam = array($image_id, $label_id, $info);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	$query = 'SELECT category FROM photo_label WHERE id=?';
	$sqlParam = array($label_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	$row = PHOTO_DB_FetchRow($db_result);

	if (0 == $row['category'] || 2 == $row['category']) {
		SYNOPHOTO_LABEL_UTIL_UpdatePhotoMetadata($image_id, $row['category']);
	}
	return true;
}

function SYNOPHOTO_LABEL_UTIL_AddVideoLabel($path, $label_id, $info='')
{
	$query = 'INSERT INTO photo_video_label (video_path, label_id, info) VALUES (?, ?, ?);';
	$dPath = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
	$sqlParam = array($dPath, $label_id, $info);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	return true;
}

function SYNOPHOTO_LABEL_UTIL_UpdatePhotoLabel($image_id, $label_id, $item_label_id)
{
	$query = 'UPDATE photo_image_label SET label_id=?, status=? WHERE id=?';
	$sqlParam = array($label_id, 't', $item_label_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	$query = 'SELECT category FROM photo_label WHERE id=?';
	$sqlParam = array($label_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	$row = PHOTO_DB_FetchRow($db_result);
	if (0 == $row['category'] || 2 == $row['category']) {
		SYNOPHOTO_LABEL_UTIL_UpdatePhotoMetadata($image_id, $row['category']);
	}
	return true;
}

function SYNOPHOTO_LABEL_UTIL_DeleteOneItemLabel($item_label_id, $itemType)
{
	$table = 'photo_image_label';
	if ($itemType == 2) {
		$table = 'photo_video_label';
	}
	$query = 'DELETE from '.$table.' WHERE id=?';
	$sqlParam = array($item_label_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	return true;
}

function SYNOPHOTO_LABEL_UTIL_CheckLabelToDelete($id, $itemType=1)
{
	$table = 'photo_image_label';
	if ($itemType == 2) {
		$table = 'photo_video_label';
	}
	$query = 'SELECT label_id FROM '.$table.' WHERE id=?';
	$sqlParam = array($id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		$query = 'SELECT COUNT(*) from photo_image_label where label_id=?';
		$sqlParam = array($row['label_id']);
		$photoCount = PHOTO_DB_QueryCount($GLOBALS['dbconn_photo'], $query, $sqlParam);
		$query = 'SELECT COUNT(*) from photo_video_label where label_id=?';
		$videoCount = PHOTO_DB_QueryCount($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if (($photoCount + $videoCount) <= 1) {
			$query = 'SELECT * from photo_label WHERE id=?';
			$sqlParam = array($row['label_id']);
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			if ($label = PHOTO_DB_FetchRow($db_result)) {
				return $label;
			}
		}
	}
	return false;
}

function SYNOPHOTO_LABEL_UTIL_GetVideoLabels($path)
{
	$tag = array();
	$tag['person'] = array();
	$tag['place'] = array();
	$tag['general'] = array();
	$query = 'select B.id, B.label_id, B.video_path, B.info, B.status, A.name, A.category, A.info as label_info from photo_label A, photo_video_label B '.
			'where A.id=B.label_id AND B.video_path=?';
	$dPath = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
	$sqlParam = array($dPath);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	while (false !== ($row = $db_result->fetch())) {
		if (0 == $row['category']) {
			$tag['person'][] = SYNOPHOTO_LABEL_UTIL_GetImageLabelItem($row, false);
		} else if (1 == $row['category']) {
			$tag['place'][] = SYNOPHOTO_LABEL_UTIL_GetImageLabelItem($row, false);
		} else {
			$tag['general'][] = SYNOPHOTO_LABEL_UTIL_GetImageLabelItem($row, false);
		}
	}
	return $tag;
}

function SYNOPHOTO_LABEL_UTIL_FlattenLabels($labels) {
	$categorys = array('person', 'place', 'general');

	$result = array();
	foreach ($categorys as $category) {
		foreach ($labels[$category] as $label) {
			$result[] = $label;
		}
	}

	return $result;
}
function SYNOPHOTO_LABEL_UTIL_GetOneImageLabel($photo_id, $label_id)
{
	$query = 'SELECT * FROM photo_image_label WHERE image_id=? AND label_id=?';
	$sqlParam = array($photo_id, $label_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		return $row;
	}
	return false;
}

function SYNOPHOTO_LABEL_UTIL_GetOneVideoLabel($path, $label_id)
{
	$query = 'SELECT * FROM photo_video_label WHERE video_path=? AND label_id=?';
	$sqlParam = array($path, $label_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		return $row;
	}
	return false;
}

function SYNOPHOTO_LABEL_UTIL_DeleteLabel($id)
{
	$query = 'DELETE FROM photo_label where id=?';
	$sqlParam = array($id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	return true;
}

function SYNOPHOTO_LABEL_UTIL_UpdatePhotoMetadata($image_id, $category)
{
	//1. query file path from DB
	$query = 'SELECT path, resolutionx, resolutiony FROM photo_image WHERE id = ?';
	$sqlParam = array($image_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}
	$row = PHOTO_DB_FetchRow($db_result);
	$path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
	$resolutionx = floatval($row['resolutionx']);
	$resolutiony = floatval($row['resolutiony']);

	//2. remove existed metadata
	if (0 == $category) {
		//people tag
		$peopleTagPrefix = 'Xmp.MP.RegionInfo';
		$metadataList = array();
		$removedMetadataList = array();

		$cmd = sprintf('%s -Pkt %s | grep '.$peopleTagPrefix, SYNO_EXIFTOOL_FILE, escapeshellarg($path));
		@exec($cmd, &$metadataList);

		foreach($metadataList as $metadata) {
			if (0 === strncmp($peopleTagPrefix, $metadata, strlen($peopleTagPrefix))) {
				$tmp = explode(' ', $metadata);
				$removedMetadataList[] = $tmp[0];
			}
		}
		$removedMetadataList = array_reverse($removedMetadataList);

		$cmd = '';
		foreach($removedMetadataList as $removedMetadata) {
			$cmd .= '-M"del '.$removedMetadata.'" ';
		}

		if (!empty($cmd)) {
			$cmd = sprintf('%s %s %s %s %s %s', SYNO_EXIFTOOL_FILE,
						   '-M"reg MP http://ns.microsoft.com/photo/1.2/"',
						   '-M"reg MPRI http://ns.microsoft.com/photo/1.2/t/RegionInfo#"',
						   '-M"reg MPReg http://ns.microsoft.com/photo/1.2/t/Region#"',
						   $cmd, escapeshellarg($path));

			@exec($cmd);
		}
	} else {
		//descriptive tag
		$cmd = sprintf('%s -M "del %s" %s', SYNO_EXIFTOOL_FILE, "Iptc.Application2.Keywords", escapeshellarg($path));
		@exec($cmd);
		$cmd = sprintf('%s -M "del %s" %s', SYNO_EXIFTOOL_FILE, "Xmp.dc.subject", escapeshellarg($path));
		@exec($cmd);
	}

	//3. query new metadata value from DB
	$query = 'SELECT A.id, A.info, A.info_new, B.name FROM photo_image_label A, photo_label B '.
		'WHERE A.image_id = ? AND B.id = A.label_id AND B.category = ? AND A.status = ?';
	$sqlParam = array($image_id, $category, 't');
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if (false === $db_result) {
		return false;
	}

	//4. write metadata to file
	if (0 == $category) {
		//people tag
		$precision = 6;
		$thumbSize = 800;
		$peopleTaggingCount = 1;
		$cmd = '';

		while ($row = PHOTO_DB_FetchRow($db_result)) {
            $info = json_decode($row['info'], true);
            $info_new = json_decode($row['info_new'], true);
            if (!$info && !$info_new) {
                continue;
            }

            if ($info_new) {
                $x = round(floatval($info_new['x']), $precision);
                $y = round(floatval($info_new['y']), $precision);
                $width = round(floatval($info_new['width']), $precision);
                $height = round(floatval($info_new['height']), $precision);
            } elseif ($info) {
                $ratio = $resolutiony / $resolutionx;
                if ($ratio > 1) {//higher image
                    $x = round(floatval($info['x']) / ((float)$thumbSize / $ratio), $precision);
                    $y = round(floatval($info['y']) / (float)$thumbSize, $precision);
                    $width = round(floatval($info['width']) / ((float)$thumbSize / $ratio), $precision);
                    $height = round(floatval($info['height']) / (float)$thumbSize, $precision);
                } else {//wider image
                    $x = round(floatval($info['x']) / (float)$thumbSize, $precision);
                    $y = round(floatval($info['y']) / ((float)$thumbSize * $ratio), $precision);
                    $width = round(floatval($info['width']) / (float)$thumbSize, $precision);
                    $height = round(floatval($info['height']) / ((float)$thumbSize * $ratio), $precision);
                }
            }

			$cmd .= '-M"set Xmp.MP.RegionInfo/MPRI:Regions['.$peopleTaggingCount.']/MPReg:Rectangle '."$x, $y, $width, $height".'" ';
			if ('' !== $row['name']) {
				$cmd .= '-M"set Xmp.MP.RegionInfo/MPRI:Regions['.$peopleTaggingCount.']/MPReg:PersonDisplayName '.str_replace('"', '\"', $row['name']).'" ';
			}
			$peopleTaggingCount++;
		}

		if (!empty($cmd)) {
			$cmd = sprintf('%s %s %s %s %s %s %s',
						   SYNO_EXIFTOOL_FILE,
						   '-M"reg MP http://ns.microsoft.com/photo/1.2/"',
						   '-M"reg MPRI http://ns.microsoft.com/photo/1.2/t/RegionInfo#"',
						   '-M"reg MPReg http://ns.microsoft.com/photo/1.2/t/Region#"',
						   '-M"set Xmp.MP.RegionInfo/MPRI:Regions XmpText type=Bag"',
						   $cmd, escapeshellarg($path));
			@exec($cmd);
		}
	} else {
		//descriptive tag
		$keyword = array();
		$count = 1;
		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$cmd = sprintf('%s -M "add %s %s" %s', SYNO_EXIFTOOL_FILE,
						   "Iptc.Application2.Keywords String", str_replace('"', '\"', $row['name']), escapeshellarg($path));
			@exec($cmd);
			if (1 === $count) {
				$cmd = sprintf('%s -M "set %s %s" %s', SYNO_EXIFTOOL_FILE, "Xmp.dc.subject", "''", escapeshellarg($path));
				@exec($cmd);
			}
			$cmd = sprintf('%s -M "set %s[%d] %s" %s', SYNO_EXIFTOOL_FILE,
						   "Xmp.dc.subject", $count++, str_replace('"', '\"', $row['name']), escapeshellarg($path));
			@exec($cmd);
		}
	}

	//update mtime of all thumbnails for prevent from re-making thumbnail
	$cmd = sprintf('/usr/syno/bin/synophoto_dsm_user --updatethumbnailmtime %s', escapeshellarg($path));
	@exec($cmd);
}

function SYNOPHOTO_LABEL_UTIL_ConfirmLable()
{
	$result['success'] = false;
	if (!isset($_POST['item_label_ids']) || !isset($_POST['image_id'])) {
		return json_encode($result);
	}

	$confirm_ids = json_decode($_POST['item_label_ids']);
	$id_list = "";
	foreach ($confirm_ids as $item) {
		if (!is_numeric($item)) {
			return json_encode($result);
		}
		$id_list = $id_list.",".$item;
	}
	$id_list = substr($id_list, 1);

	$query = "UPDATE photo_image_label SET status=? WHERE id in (".$id_list.")";
	$sqlParam = array('t');
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	SYNOPHOTO_LABEL_UTIL_RemoveFaceTrainingData();

	SYNOPHOTO_LABEL_UTIL_UpdatePhotoMetadata($_POST['image_id'], 0);

	$result['data'] = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($_POST['image_id']);

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_LABEL_UTIL_GetLable()
{
	$result['labels'] = array();

	$query = "Select count(*) from photo_label where name <> ''";
	$result['totalCount'] = PHOTO_DB_QueryCount($GLOBALS['dbconn_photo'], $query);

	$query = "select * from photo_label where name <> '' order by category asc, name asc limit ? offset ?";
	$sqlParam = array($_POST['limit'], $_POST['start']);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	while (false !== ($row = PHOTO_DB_FetchRow($db_result))) {
		$item = array();
		$item['id'] = $row['id'];
		$item['name'] = $row['name'];
		$item['category'] = $row['category'];
        $item['info'] = $row['info'];
		$result['labels'][] = $item;
	}

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_LABEL_UTIL_UpdateLable()
{
	$result['success'] = false;
	if (!isset($_POST['id']) || !isset($_POST['name']) || !isset($_POST['category'])) {
		return json_encode($result);
	}

	$query = "select * from photo_label where name = ? and category = ?";
	$sqlParam = array($_POST['name'], $_POST['category']);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	if (false !== ($row = PHOTO_DB_FetchRow($db_result))) {
		$result['msg'] = __(photo_str_label_duplicate);
		return json_encode($result);
	}

	$query = "update photo_label set name = ? where id = ?";
	$sqlParam = array($_POST['name'], $_POST['id']);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_LABEL_UTIL_Check_Photo_Label()
{
	$deprecated_id_query =
		'WHERE id NOT IN ( ' .
			'SELECT DISTINCT label_id FROM photo_image_label ' .
				'LEFT OUTER JOIN photo_label ' .
				'ON label_id = photo_label.id ' .
		') ' .
		'AND id NOT IN ( ' .
			'SELECT DISTINCT label_id FROM photo_video_label ' .
				'LEFT OUTER JOIN photo_label ' .
				'ON label_id = photo_label.id ' .
		');';

	$select_query = 'SELECT id FROM photo_label ' . $deprecated_id_query;
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $select_query);

	$idList = array();
	while (false !== ($row = PHOTO_DB_FetchRow($db_result))) {
		$idList[] = $row['id'];
	}

	if (count($idList) > 0) {
		$delete_query = 'DELETE FROM photo_label ' . $deprecated_id_query;
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $delete_query);
	}
	return $idList;
}

function SYNOPHOTO_LABEL_UTIL_CheckPostIsSet($keyArray)
{
	foreach ($keyArray as $key) {
		if (!isSet($_POST[$key])) {
			return false;
		}
	}

	return true;
}

function SYNOPHOTO_LABEL_UTIL_GetVideoPathById($id)
{
	$query = 'SELECT path FROM video WHERE id=?';
	$sqlParam = array($id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	$row = PHOTO_DB_FetchRow($db_result);
	if ($row) {
		return $row['path'];
	}
	return false;
}

function SYNOPHOTO_LABEL_UTIL_BatchAddLabel()
{
	$successCount = 0;
	$result['success'] = false;
	$result['data'] = array();
	$checkArray = array('category', 'name', 'info', 'photo_list', 'video_list');

	if (!SYNOPHOTO_LABEL_UTIL_CheckPostIsSet($checkArray)) {
		$result['info'] = 'Some required POST fields is missing';
		return json_encode($result);
	}

	if ('2' === $_POST['category']) {//descriptive tag would be separated by comma
		$inputLabels = explode(',', $_POST['name']);
	} else {
		$inputLabels[] = $_POST['name'];
	}

	foreach ($inputLabels as $inputLabel) {
		$inputLabel = trim($inputLabel);

		if (0 < strlen($inputLabel)) {
			$targetLabels[] = $inputLabel;
		}
	}

	if (empty($targetLabels)) {
		$result['info'] = 'No valid label';
		return json_encode($result);
	}

	$labelCategory = $_POST['category'];
	$labelInfo = $_POST['info'];

	foreach($targetLabels as $targetLabel) {
		//get label id
		if ($row = SYNOPHOTO_LABEL_UTIL_GetLabel($targetLabel, $labelCategory)) {//label exists
			$label_id = $row['id'];
		} else {
			$label['name'] = $targetLabel;
			$label['category'] = $labelCategory;
			$label['info'] = $labelInfo;

			if (false === SYNOPHOTO_LABEL_UTIL_AddNewLabel($label)){
				$result['info'] = 'Add new label failed';
				continue;
			}

			// get label again
			$row = SYNOPHOTO_LABEL_UTIL_GetLabel($targetLabel, $labelCategory);
			$label_id = $row['id'];
		}

		$result['new_label'] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
		$result['category'] = $labelCategory;

		//descriptive tag would be separated by comma
		if ('2' === $_POST['category']) {
			$result['data']['new_labels'][] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
		}

		// for each photo list
		$photoIdArray = explode(',', $_POST['photo_list']);
		foreach ($photoIdArray as $photoId) {
			$info = '';
			$tempLabel = SYNOPHOTO_LABEL_UTIL_GetOneImageLabel($photoId, $label_id);
			if ($tempLabel) {
				// label already on this photo, skip
				continue;
			}

			SYNOPHOTO_LABEL_UTIL_AddPhotoLabel($photoId, $label_id, $info);
			$successCount++;
		}

		// for each video list
		$videoIdArray = explode(',', $_POST['video_list']);
		foreach ($videoIdArray as $videoId) {
			$path = SYNOPHOTO_LABEL_UTIL_GetVideoPathById($videoId);
			if (false === $path) {
				continue;
			}

			$tempLabel = SYNOPHOTO_LABEL_UTIL_GetOneVideoLabel($path, $label_id);
			if ($tempLabel) {
				continue;
			}

			SYNOPHOTO_LABEL_UTIL_AddVideoLabel($path, $label_id);
			$successCount++;
		}
	}

	$result['success'] = ($successCount > 0);
	return json_encode($result);
}

function SYNOPHOTO_LABEL_UTIL_BatchDeleteLabel()
{
	$result['success'] = false;
	$checkArray = array('category', 'id', 'photo_list', 'video_list');

	if (!SYNOPHOTO_LABEL_UTIL_CheckPostIsSet($checkArray)) {
		return json_encode($result);
	}

	$labelCategory = $_POST['category'];
	$labelId = $_POST['id'];
	$photoList = $_POST['photo_list'];
	$videoList = $_POST['video_list'];

	$labelItem  = SYNOPHOTO_LABEL_UTIL_GetLabelById($labelId);
	if ($labelItem === false) {
		return json_encode($result);
	}
	$result['deleted_label'] = $labelItem;

	if (!empty($photoList)) {
		$query = 'DELETE FROM photo_image_label WHERE label_id=? AND image_id IN ('.$photoList.')';
		$sqlParam = array($labelId);

		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		if ($labelCategory == 0 || $labelCategory == 2) {
			$photoIdArray = explode(',', $photoList);
			foreach ($photoIdArray as $photoId) {
				SYNOPHOTO_LABEL_UTIL_UpdatePhotoMetadata($photoId, $labelCategory);
			}
		}
	}

	$videoIdArray = explode(',', $videoList);
	if (count($videoIdArray) > 0) {
		foreach ($videoIdArray as $videoId) {
			if (empty($videoId)) {
				continue;
			}

			$query = 'DELETE FROM photo_video_label'.
					' WHERE id in ('.
					'   SELECT photo_video_label.id FROM photo_video_label, video'.
					'   WHERE photo_video_label.video_path=video.path'.
					'     AND video.id='.$videoId.' AND photo_video_label.label_id='.$labelId.
					' )';
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}
	}

	SYNOPHOTO_LABEL_UTIL_Check_Photo_Label();

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_LABEL_UTIL_GetLabelsBySelectedIds()
{
	$result['success'] = false;
	$tag = array();
	$checkArray = array('category', 'photo_list', 'video_list');

	if (!SYNOPHOTO_LABEL_UTIL_CheckPostIsSet($checkArray)) {
		return json_encode($result);
	}

	$labelCategory = $_POST['category'];
	$photoList = $_POST['photo_list'];
	$videoList = $_POST['video_list'];

	if (!empty($photoList)) {
		$query = 'SELECT DISTINCT L.id, L.name, IL.info'.
				' FROM photo_image_label IL'.
				' INNER JOIN photo_label L'.
				' ON L.category=? AND IL.label_id=L.id AND IL.image_id IN ('.$photoList.')'.
				' ORDER BY L.name ASC';
		$sqlParam = array($labelCategory);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		while (false !== ($row = $db_result->fetch())) {
			if (empty($row['name'])) {
				continue;
			}

			$tag[] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
		}
	}

	if (!empty($videoList)) {
		$query = 'SELECT DISTINCT L.id, L.name, VL.info'.
				' FROM photo_video_label VL'.
				' INNER JOIN photo_label L'.
				'   ON L.category=? AND VL.label_id=L.id'.
				' INNER JOIN video V'.
				'   ON V.path=VL.video_path AND V.id IN ('.$videoList.')';
		$sqlParam = array($labelCategory);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		while (false !== ($row = $db_result->fetch())) {
			if (empty($row['name'])) {
				continue;
			}

			$find = false;
			foreach($tag as $item){
				if ($item['id'] === $row['id']){
					$find = true;
					break;
				}
			}
			if (!$find) {
				$tag[] = SYNOPHOTO_LABEL_UTIL_GetLabelItem($row);
			}
		}

	}

	$result['labels'] = $tag;
	$result['success'] = true;
	return json_encode($result);
}
?>
