<?php
require_once("../include/syno_conf.php");

switch ($_POST['action']) {
	case "get_blog_other_settings":
		echo SYNOPHOTO_ADMIN_GetBlogOtherSettings();
		break;
	case "set_blog_other_settings":
		echo SYNOPHOTO_ADMIN_SetBlogOtherSettings();
		break;
	case "enable_blog":
		echo SYNOPHOTO_ADMIN_EnableBlog($_POST['enable_blog']);
		break;
	case "is_blog_enabled":
		echo SYNOPHOTO_ADMIN_IsBlogEnabled();
		break;
	case "get_articles":
		echo SYNOPHOTO_ADMIN_GetArticles($_POST['start'], $_POST['limit']);
		break;
	case "get_config":
		echo csSYNOPhotoMisc::GetConfigDB($_POST['module_name'], $_POST['config_key'], $_POST['table']);
		break;
	case "update_config":
		echo csSYNOPhotoMisc::UpdateConfigDB($_POST['module_name'], $_POST['config_key'],  $_POST['config_value'], $_POST['table']);
		break;
    case "get_blog_settings":
        echo SYNOPHOTO_ADMIN_GetBlogSettings();
        break;
    case "save_blog_settings":
        echo SYNOPHOTO_ADMIN_SaveBlogSettings();
        break;
}

function SYNOPHOTO_ADMIN_IsBlogEnabled()
{
	$result['data']['enable_blog'] = csSYNOPhotoMisc::IsBlogEnabled();
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetArticles($start, $limit)
{
	$query = "Select count(article_id) from blog_article where draft = 0";
	$count = BLOG_DB_PHOTO_QueryCount($GLOBALS['dbconn_photo'], $query);
	$result['totalCount'] = $count + 1;

	$i = 0;
	if($start == 0) {
		$result['articles'][0]['id'] = "";
		$result['articles'][0]['info'] = htmlspecialchars(__(blog_str_article_label_none));
		$result['articles'][0]['title'] = '';
		$result['articles'][0]['desc'] = htmlspecialchars(__(blog_str_article_label_none));
		$limit--;
		$i = 1;
	} else {
		$start--;
	}

	$query = "Select * from blog_article where draft = 0 order by date desc limit ".$limit." offset ".$start;
	$db_result = BLOG_DB_PHOTO_Query($GLOBALS['dbconn_photo'], $query);

	while(($row = BLOG_DB_PHOTO_FetchRow($db_result))) {
		$result['articles'][$i]['id'] = $row[0];
		$result['articles'][$i]['info'] = $row[2]." By ".$row[1];
		$result['articles'][$i]['title'] = htmlspecialchars($row[3]);
		$result['articles'][$i]['desc'] = $result['articles'][$i]['info']." ".$result['articles'][$i]['title'];
		$i++;
	}

	return json_encode($result);
}

function SYNOPHOTO_ADMIN_EnableBlog($enable)
{
	csSYNOPhotoMisc::CheckAdminTimeOut();
	csSYNOPhotoMisc::UpdateConfigDB("main", "enable_blog", $enable == 'on' ? "1" : "0");
	return SYNOPHOTO_ADMIN_IsBlogEnabled();
}

function SYNOPHOTO_ADMIN_GetBlogOtherSettings()
{
	$result['data']['page_title'] = csSYNOPhotoMisc::GetConfigDB("main", "page_title");
	if($result['data']['page_title'] == null || $result['data']['page_title'] == "") {
		$result['data']['page_title'] = 'Synology Blog';
	}
	$result['data']['article_num'] = csSYNOPhotoMisc::GetConfigDB("main", "article_num");
	$result['data']['autosave_interval'] = csSYNOPhotoMisc::GetConfigDB("main", "autosave_interval");
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_SetBlogOtherSettings()
{
	$page_title = $_POST['page_title'];
	if ('Synology Blog' == $page_title) {
		$page_title = "";
	}
	csSYNOPhotoMisc::UpdateConfigDB("main", "page_title", $page_title);
	csSYNOPhotoMisc::UpdateConfigDB("main", "article_num", $_POST['article_num']);
	csSYNOPhotoMisc::UpdateConfigDB("main", "autosave_interval", $_POST['autosave_interval']);
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_SaveBlogSettings()
{
    csSYNOPhotoMisc::CheckAdminTimeOut();
    csSYNOPhotoMisc::UpdateConfigDB("main", "enable_blog", ('on' === $_POST['enable_blog']) ? "1" : "0");
    $page_title = $_POST['page_title'];
    if ('Synology Blog' == $page_title) {
        $page_title = "";
    }
    csSYNOPhotoMisc::UpdateConfigDB("main", "page_title", $page_title);
    csSYNOPhotoMisc::UpdateConfigDB("main", "article_num", (null === $_POST['article_num'] || '' === $_POST['article_num']) ? '10' : $_POST['article_num']);
    csSYNOPhotoMisc::UpdateConfigDB("main", "autosave_interval", $_POST['autosave_interval']);
    $result['success'] = true;
    return json_encode($result);
}

function SYNOPHOTO_ADMIN_GetBlogSettings()
{
    $result['data']['enable_blog'] = csSYNOPhotoMisc::IsBlogEnabled();
    $result['data']['page_title'] = csSYNOPhotoMisc::GetConfigDB("main", "page_title");
    if($result['data']['page_title'] == null || $result['data']['page_title'] == "") {
        $result['data']['page_title'] = 'Synology Blog';
    }
    $result['data']['article_num'] = csSYNOPhotoMisc::GetConfigDB("main", "article_num");
    $result['data']['autosave_interval'] = csSYNOPhotoMisc::GetConfigDB("main", "autosave_interval");
    $result['success'] = true;
    return json_encode($result);
}

?>
