<?php

require_once("../include/syno_conf.php");
require_once("util.php");

$error = array(
	'error' => 'Unknown error.',
	'error_code' => '0000',
	'error_source' => 'local'
);

//get access token from qq
if (isset($_GET['access_token'])) {
	SYNOPHOTO_QQ_GetAccessToken();
} else {
	if (!isset($_POST['token'])) {
		FillErrorMessage('No POST access_token', '0002', 'local');
		ResponseErrorJson();
	}

	switch ($_POST['action']) {
	case 'get_user':
		echo SYNOPHOTO_QQ_GetUser();
		break;
	case "get_album":
		echo SYNOPHOTO_QQ_GetAlbum();
		break;
	case 'upload':
		echo SYNOPHOTO_QQ_Upload();
		break;
	/*case 'multi_upload':
		echo SYNOPHOTO_QQ_MultiUpload();
		break;*/
	default:
		FillErrorMessage('Invalid POST action', '0003', 'local');
		ResponseErrorJson();
	}
}

function SYNOPHOTO_QQ_GetAccessToken()
{
	if (!isset($_GET['access_token'])) {
		FillErrorMessage('No GET access_token', '0001', 'local');
		SYNOPHOTO_UTIL_ResponseErrorHtml();
	}

	$accessToken = $_GET['access_token'];

	if (false === ($openIdJson = GetUserOpenId($accessToken))) {
		SYNOPHOTO_UTIL_ResponseErrorHtml();
	}

	if (false === ($userInfoJson = GetUserInfo($accessToken, $openIdJson['client_id'], $openIdJson['openid']))) {
		SYNOPHOTO_UTIL_ResponseErrorHtml();
	}

	echo GetCallbackHtmlTemplate('_onQQLogin', $accessToken, $userInfoJson['nickname'], $userInfoJson['figureurl_1']);
	exit;
}

function SYNOPHOTO_QQ_GetUser()
{
	if (false === ($openIdJson = GetUserOpenId($_POST['token']))) {
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	if (false === ($userInfoJson = GetUserInfo($_POST['token'], $openIdJson['client_id'], $openIdJson['openid']))) {
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	if (!isset($userInfoJson['nickname']) || !is_array($userInfoJson['figureurl_1'])) {
		FillErrorMessage('No required fields nickname or figureurl_1 in user info json.', '4000', 'local');
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$returnJson = array(
		'user' => array(
			'name' => $userInfoJson['nickname'],
			'image' => $userInfoJson['figureurl_1']
		),
		'success' => true
	);

	echo json_encode($returnJson);
}

function SYNOPHOTO_QQ_GetAlbum()
{
	if (false === ($openIdJson = GetUserOpenId($_POST['token']))) {
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$getAlbumListAPI = 'https://graph.qq.com/photo/list_album';

	$params = array(
		'access_token' => $_POST['token'],
		'oauth_consumer_key' => $openIdJson['client_id'],
		'openid' => $openIdJson['openid']
	);

	$url = $getAlbumListAPI.'?'.http_build_query($params);

	if (false === ($albumListJson = SendQQRequest($url))) {
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	if (!isset($albumListJson['album']) || !is_array($albumListJson['album'])) {
		FillErrorMessage('No required fields album in album list json or album is not an array.', '5000', 'local');
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$albums = array();

	foreach ($albumListJson['album'] as $album) {
		$albums[] = array(
			'id' => $album['albumid'],
			'name' => $album['name'],
			'count' => $album['picnum']
		);
	}

	$returnJson = array(
		'albums' => $albums,
		'success' => true
	);

	echo json_encode($returnJson);
}

function SYNOPHOTO_QQ_Upload()
{
	if (!isset($_POST['path']) || !isset($_POST['message']) || !isset($_POST['type']) || !isset($_POST['albumId'])) {
		FillErrorMessage('no path, message, type, or albumId.', '0004', 'local');
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	if (false === ($openIdJson = GetUserOpenId($_POST['token']))) {
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	if ('1' !== $_POST['type']) {
		//create new album
		$addAlbumAPI = 'https://graph.qq.com/photo/add_album';

		$params = array(
			'access_token' => $_POST['token'],
			'oauth_consumer_key' => $openIdJson['client_id'],
			'openid' => $openIdJson['openid'],
			'albumname' => $_POST['albumId']
		);

		if (false === ($addAlbumJson = SendQQRequest($addAlbumAPI, $params))) {
			SYNOPHOTO_UTIL_ResponseErrorJson();
		}

		if (!isset($addAlbumJson['albumid'])) {
			FillErrorMessage('No required fields albumid in add album json.', '6000', 'local');
			SYNOPHOTO_UTIL_ResponseErrorJson();
		}

		$albumId = $addAlbumJson['albumid'];
	} else {
		//upload to existed album
		$albumId = $_POST['albumId'];
	}

	$uploadAPI = 'https://graph.qq.com/photo/upload_pic';

	$image = csSYNOPhotoMisc::GetThumbPathFromFullPath($_POST['path'], SYNOPHOTO_THUMBXLARGE, false);
	if (!file_exists($image)) {
		$image = $_POST['path'];// upload original file
	}

	$params = array(
		'access_token' => $_POST['token'],
		'oauth_consumer_key' => $openIdJson['client_id'],
		'openid' => $openIdJson['openid'],
		'albumid' => $albumId,
		'photodesc' => $_POST['message'],
		'title' => basename($_POST['path']),
		'picture' => '@'.$image
	);

	if (false === ($uploadJson = SendQQRequest($uploadAPI, $params))) {
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$returnJson = array(
		'success' => true
	);

	echo json_encode($returnJson);
}

function GetUserOpenId($token)
{
	$getUserOpenIdAPI = 'https://graph.qq.com/oauth2.0/me';

	$data = array(
		'access_token' => $token
	);

	$url = $getUserOpenIdAPI.'?'.http_build_query($data);

	if (false === ($userOpenIdResult = CurlRequest($url))) {
		return false;
	}

	//The result of GetUserOpenId is like ' callback( {"client_id":"xxxxxxxxx","openid":"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"} );'

	if (false === ($start = strpos($userOpenIdResult, '{')) || false === ($end = strrpos($userOpenIdResult, '}')) || $end < $start) {
		FillErrorMessage('Invalid open id', '1000', 'local');
		return false;
	}

	if (false === ($userOpenIdJson = json_decode(substr($userOpenIdResult, $start, $end - $start + 1), true))) {
		FillErrorMessage('Decode open id json failed', '1001', 'local');
		return false;
	}

	if (!isset($userOpenIdJson['client_id']) || !isset($userOpenIdJson['openid'])) {
		FillErrorMessage('No required fields in user info json.', '1002', 'local');
		return false;
	}

	return $userOpenIdJson;
}

function GetUserInfo($token, $appid, $openid)
{
	$getUserInfoAPI = 'https://graph.qq.com/user/get_user_info';

	$data = array(
		'access_token' => $token,
		'oauth_consumer_key' => $appid,
		'openid' => $openid
	);

	$url = $getUserInfoAPI.'?'.http_build_query($data);

	if (false === ($userInfoJson = SendQQRequest($url))) {
		return false;
	}

	if (!isset($userInfoJson['nickname']) || !isset($userInfoJson['figureurl_1'])) {
		FillErrorMessage('No required fields in user info json.', '2000', 'local');
		return false;
	}

	return $userInfoJson;
}

function SendQQRequest($url, $postParams = false)
{
	if (false === ($result = CurlRequest($url, $postParams))) {
		return false;
	}

	if (false === ($json = json_decode($result, true))) {
		FillErrorMessage('Decode json failed', '3000', 'local');
		return false;
	}

	if (0 !== $json['ret']) {
		FillErrorMessage($json['msg'], $json['ret'], 'QQ');
		return false;
	}

	return $json;
}

?>
