#!/bin/sh
# Copyright (c) 2000-2007 Synology Inc. All rights reserved.

echo "Update photo_upload_right table in photo db to test photo_upload_right table existence."
su -l admin -c "/usr/syno/pgsql/bin/psql photo -c \"update photo_upload_right set userid = 0 where userid = 0\"" > /dev/null 2>&1
Ret=$?
if [ $Ret = 1 ]; then
   Ret=1
   Script="/var/packages/PhotoStation/target/photo_scripts/sql/upgrade/006_photo_upload_right.pgsql"
   su -l admin -c "/usr/syno/pgsql/bin/psql photo < $Script"
   if [ $? != 0 ]; then
      echo "Failed to create photo_upload_right table."
      exit
   fi

   # We need to generate 320px and 800px thumbnail in this upgade.
   PHOTO_PATH=`ls -l /var/services/photo | awk -F "-> " '{print $2}'`
   SZF_THUMB_CREATE_QUEUE="/var/spool/thumb_create.queue"
   SZF_FLV_CREATE_QUEUE="/var/spool/flv_create.queue"
   SZF_THUMB_CREATE_QUEUE_TMP="/var/spool/thumb_create.queue_tmp"
   SZF_FLV_CREATE_QUEUE_TMP="/var/spool/flv_create.queue_tmp"

   if [ "$PHOTO_PATH" != "" ]; then
      if [ -d $PHOTO_PATH ]; then
         echo "Start recreating thumbnails ..."
         echo "R:$PHOTO_PATH" > $SZF_THUMB_CREATE_QUEUE_TMP
         mv $SZF_THUMB_CREATE_QUEUE_TMP $SZF_THUMB_CREATE_QUEUE
         kill -s SIGUSR1 `cat /var/run/synomkthumbd.pid`

         echo "R:$PHOTO_PATH" > $SZF_FLV_CREATE_QUEUE_TMP
         mv $SZF_FLV_CREATE_QUEUE_TMP $SZF_FLV_CREATE_QUEUE
         kill -s SIGUSR1 `cat /var/run/synomkflvd.pid`
      fi
   fi   
fi
