BEGIN;

create table photo_user
(
	userid int4 NOT NULL,
	username varchar(128) NOT NULL,
	description varchar(128),
	password varchar(128),
	disabled text DEFAULT 'f',
	lock_pass text DEFAULT 'f',
	admin text DEFAULT 'f',
	email varchar(128),
	CONSTRAINT photo_user_pkey PRIMARY KEY (userid),
	CONSTRAINT photo_user_username_key UNIQUE (username)
);

create table photo_share
(
	shareid int4 NOT NULL,
	sharename varchar(1024),
	title text,
	description text,
	public text,
	hits int8 DEFAULT 0,
	cover text,
	comment text DEFAULT 't',
	is_subdir text DEFAULT 'f',
	updated character DEFAULT '1',
	password varchar(128) DEFAULT '',
	CONSTRAINT photo_share_pkey PRIMARY KEY (shareid),
	CONSTRAINT photo_share_sharename_key UNIQUE (sharename)
);

create table photo_log
(
	logid int4 NOT NULL,
	create_time timestamp,
	log text,
	success text,
	user varchar(128),
	CONSTRAINT photo_log_pkey PRIMARY KEY (logid)
);

create table photo_access_right
(
	userid int4 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_access_right_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_access_right_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT "photo_access_right_userID_fkey" FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);


create table photo_upload_right
(
	userid int4 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_upload_right_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_upload_right_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT "photo_upload_right_userID_fkey" FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

create table photo_image
(
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	name text NOT NULL,
	title text,
	description text,
	album text,
	size int4,
	resolutionx int4,
	resolutiony int4,
	camera_make varchar(100),
	camera_model varchar(100),
	exposure varchar(20),
	aperture varchar(20),
	iso int4,
	timetaken timestamp,
	updated char(1),
	version int4 DEFAULT 0,
	create_time timestamp,
	gps text DEFAULT '',
	CONSTRAINT photo_image_path_key UNIQUE (path)
);

CREATE INDEX photo_image_create_time_idx ON photo_image (create_time);
CREATE UNIQUE INDEX photo_image_path_idx ON photo_image (path);

create table photo_comment
(
	id INTEGER PRIMARY KEY,
	photo_id int8 NOT NULL,
	name varchar(100),
	email varchar(128),
	comment text,
	date timestamp,
	CONSTRAINT photo_comment_photo_id_fkey1 FOREIGN KEY (photo_id)
		REFERENCES photo_image (id) MATCH SIMPLE
		ON UPDATE RESTRICT ON DELETE CASCADE
);

CREATE TABLE video_comment
(
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	name varchar(100),
	email varchar(128),
	comment text,
	date timestamp,
	updated char(1)
);

CREATE TABLE video_desc
(
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	title text,
	description text,
	updated char(1),
	CONSTRAINT video_path_key UNIQUE (path)
);

CREATE TABLE photo_config
(
	config_id INTEGER PRIMARY KEY,
	module_name varchar(128) NOT NULL,
	config_key varchar(512) NOT NULL,
	config_value text
);

CREATE TABLE common_config
(
	config_id INTEGER PRIMARY KEY,
	module_name varchar(128) NOT NULL,
	config_key varchar(512) NOT NULL,
	config_value text
);

create INDEX photo_comment_photoid_index
	ON photo_comment (photo_id);

create table blog_config
(
  config_id INTEGER PRIMARY KEY,
  module_name varchar(128) NOT NULL,
  config_key varchar(512) NOT NULL,
  config_value text
);

INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'header_picture', 'Temple_of_Guangong_for_Official_Ritual,Tainan,Taiwan.jpg');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'blog_title', 'WELCOME TO BLOG');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'page_title', 'Synology Blog');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'article_num', '5');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'date_format', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'layout_type', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'layout_right', 'photo_slide,recent_article,recent_comment,article_collection');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'layout_left', 'search,personal_information,friend_link,label_cloud,statistical_data');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'view_today', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'view_total', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'view_last', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'show_top_header_logo', '1');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'autosave_interval', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('recent_article', 'number', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('recent_comment', 'number', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('photo_slide', 'album_name', '');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('photo_slide', 'slide_interval', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('google_ad', 'code', '');

create table blog_module
(
  module_name varchar(128) NOT NULL,
  provide_setting text DEFAULT 'f',
  CONSTRAINT blog_module_pkey PRIMARY KEY (module_name)
);

INSERT INTO blog_module VALUES('personal_information', 't');
INSERT INTO blog_module VALUES('friend_link', 't');
INSERT INTO blog_module VALUES('label_cloud', 'f');
INSERT INTO blog_module VALUES('statistical_data', 'f');
INSERT INTO blog_module VALUES('photo_slide', 't');
INSERT INTO blog_module VALUES('recent_article', 't');
INSERT INTO blog_module VALUES('recent_comment', 't');
INSERT INTO blog_module VALUES('article_collection', 'f');
INSERT INTO blog_module VALUES('search', 'f');
INSERT INTO blog_module VALUES('google_ad', 't');


create table blog_label
(
  label_id INTEGER PRIMARY KEY,
  label_name text NOT NULL,
  article_count int4 DEFAULT 0,
  CONSTRAINT blog_label_label_name_key UNIQUE (label_name)
);

INSERT INTO blog_label (label_name, article_count) VALUES('no_label', 1);

create table blog_article
(
  article_id INTEGER PRIMARY KEY,
  author varchar(128) NOT NULL,
  date timestamp,
  title text NOT NULL,
  abstract text,
  content text NOT NULL,
  viewing_privilege int4 DEFAULT 0,
  access_key varchar(512),
  access_key_hint varchar(512),
  allow_comment text DEFAULT 't',
  hits int4 DEFAULT 0,
  draft int4 DEFAULT 0,
  show_abstract text DEFAULT 'f',
  CHECK (draft IN (-1, 0, 1))
);

INSERT INTO blog_article (author, date, title, content) VALUES('Synology Blog', '2008-01-01 00:00:00', 'Synology Blog', '<font size="2" face="Arial"><p>Welcome! This is your first blog post on <a target="_blank" href="http://www.synology.com">Synology</a> <font color="#996600">Photo Station</font>. You can freely share wonderful living experiences here with all your friends.</p><p>Please sign in to add a new post or customize your Photo Station Blog.</p></font>');

create table blog_article_label
(
  article_label_id INTEGER PRIMARY KEY,
  label_id int4 NOT NULL,
  label_name text NOT NULL,
  article_id int4 NOT NULL
);

INSERT INTO blog_article_label (label_id, label_name, article_id) VALUES(1, 'no_label', 1);

create table blog_article_autosave
(
  article_autosave_id INTEGER PRIMARY KEY,
  autosave_id int4 NOT NULL,
  article_id int4 NOT NULL
);

create table blog_comment
(
  comment_id INTEGER PRIMARY KEY,
  article_id int4 NOT NULL,
  username varchar(128) NOT NULL,
  email varchar(128),
  ip varchar(64) NOT NULL,
  date timestamp,
  comment text NOT NULL
);


CREATE TABLE directory (
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	title text,
	date timestamp without time zone,
	mdate timestamp without time zone,
	fs_uuid text,
	fs_online TEXT DEFAULT 't'
);

CREATE TABLE music (
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	title text NOT NULL,
	filesize bigint DEFAULT 0 NOT NULL,
	album text,
	artist text,
	composer text,
	comment text,
	year integer,
	genre character varying(128),
	frequency integer,
	bitrate integer,
	duration integer,
	channel integer,
	track integer,
	disc integer,
	covercount integer,
	date timestamp without time zone,
	mdate timestamp without time zone,
	fs_uuid text,
	fs_online TEXT DEFAULT 't'
);

CREATE TABLE photo (
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	title text NOT NULL,
	filesize bigint DEFAULT 0 NOT NULL,
	album text,
	resolutionx integer,
	resolutiony integer,
	camera_make character varying(100),
	camera_model character varying(100),
	exposure character varying(20),
	aperture character varying(20),
	iso integer,
	date timestamp without time zone,
	timetaken timestamp without time zone,
	mdate timestamp without time zone,
	fs_uuid text,
	fs_online TEXT DEFAULT 't'
);

CREATE TABLE playlist (
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	title text NOT NULL,
	filesize bigint DEFAULT 0 NOT NULL,
	album text,
	song_count integer DEFAULT 0 NOT NULL,
	date timestamp without time zone,
	mdate timestamp without time zone,
	fs_uuid text,
	fs_online TEXT DEFAULT 't'
);

CREATE TABLE video (
	id INTEGER PRIMARY KEY,
	path text NOT NULL,
	title text NOT NULL,
	filesize bigint DEFAULT 0 NOT NULL,
	album text,
	container_type text,
	video_codec text,
	frame_bitrate integer,
	frame_rate_num integer,
	frame_rate_den integer,
	video_bitrate integer,
	video_profile integer,
	video_level integer,
	duration integer,
	resolutionx integer,
	resolutiony integer,
	audio_codec text,
	audio_bitrate integer,
	frequency integer,
	channel integer,
	date timestamp without time zone,
	mdate timestamp without time zone,
	gps text DEFAULT '',
	fs_uuid text,
	fs_online TEXT DEFAULT 't'
);

CREATE UNIQUE INDEX video_path_index ON video(path);

CREATE TABLE video_convert (
	video_path text NOT NULL,
	convert_file_path text NOT NULL,
	resolutionx integer,
	resolutiony integer,
	container_type text NOT NULL,
	video_bitrate integer,
	vcodec text,
	video_profile integer,
	video_level integer,
	acodec text,
	audio_bitrate integer,
	audio_frequency integer,
	audio_channel integer,
	convert_type text NOT NULL,
	fs_online TEXT DEFAULT 't'
);

CREATE TABLE photo_label (
  id INTEGER PRIMARY KEY,
  name text,
  category int4 NOT NULL,
  info text DEFAULT ''
);

CREATE TABLE photo_image_label (
  id INTEGER PRIMARY KEY,
  image_id int4 NOT NULL,
  label_id int4 NOT NULL,
  info text DEFAULT '',
  info_new TEXT DEFAULT '',
  status text DEFAULT 't',
  CONSTRAINT photo_image_label_photo_id_fkey1 FOREIGN KEY (image_id) REFERENCES photo_image (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
  CONSTRAINT photo_image_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);

CREATE TABLE photo_video_label (
  id INTEGER PRIMARY KEY,
  video_path text NOT NULL,
  label_id int4 NOT NULL,
  info text DEFAULT '',
  status text DEFAULT 't',
  updated char(1),
  CONSTRAINT photo_image_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);

create table photo_manage_right
(
	userid int4 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_manage_right_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_manage_right_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT "photo_manage_right_userID_fkey" FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

create table category
(
	id INTEGER NOT NULL,
	name TEXT NOT NULL,
	hidden TEXT DEFAULT 'f',
	order_number INTEGER NOT NULL,
	create_date timestamp DEFAULT current_timestamp,
	modify_date timestamp DEFAULT current_timestamp,
	CONSTRAINT category_pkey PRIMARY KEY (id),
	CONSTRAINT category_ukey UNIQUE (name)
);

create table category_items
(
	id INTEGER NOT NULL,
	category_id INTEGER NOT NULL,
	type TEXT NOT NULL,
	order_number INTEGER not NULL,
	album_id INTEGER
		REFERENCES photo_share (shareid)
		ON UPDATE CASCADE ON DELETE CASCADE,
	tag_id INTEGER
		REFERENCES photo_label (id)
		ON UPDATE CASCADE ON DELETE CASCADE,
	smart_id TEXT,
	CONSTRAINT category_items_pkey PRIMARY KEY (id),
	CONSTRAINT category_item_album_ukey UNIQUE (category_id, album_id),
	CONSTRAINT category_items_tag_ukey UNIQUE (category_id, tag_id),
	CONSTRAINT category_items_smart_ukey UNIQUE (category_id, smart_id),
	CONSTRAINT category_items_fkey FOREIGN KEY (category_id)
		REFERENCES category (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE TABLE photo_group
(
	groupid int8 NOT NULL,
	groupname varchar(128) NOT NULL,
	description varchar(128),
	CONSTRAINT photo_group_pkey PRIMARY KEY (groupid),
	CONSTRAINT photo_group_username_key UNIQUE (groupname)
);

CREATE TABLE photo_user_group (
	id serial NOT NULL,
	userid int8 NOT NULL,
	groupid int8 NOT NULL,
	PRIMARY KEY (id),
	CONSTRAINT photo_user_group_userID_fkey FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
	CONSTRAINT photo_user_group_groupID_fkey FOREIGN KEY (groupid)
		REFERENCES photo_group (groupid) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
	CONSTRAINT photo_user_group_key UNIQUE (userid, groupid)
);

CREATE TABLE photo_group_permission
(
	groupid int8 NOT NULL,
	shareid int4 NOT NULL,
	permission int2 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_group_permission_pkey PRIMARY KEY (groupid, shareid),
	CONSTRAINT photo_group_permission_shareID_fkey FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT photo_group_permission_groupID_fkey FOREIGN KEY (groupid)
		REFERENCES photo_group (groupid) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE
);


COMMIT;

