BEGIN;

create table photo_user
(
	userid int4 NOT NULL,
	username varchar(128) NOT NULL,
	description varchar(128),
	"password" varchar(128),
	disabled bool DEFAULT false,
	lock_pass bool DEFAULT false,
	admin bool DEFAULT false,
	email varchar(128),
	CONSTRAINT photo_user_pkey PRIMARY KEY (userid),
	CONSTRAINT photo_user_username_key UNIQUE (username)
);

create table photo_share
(
	shareid int4 NOT NULL,
	sharename varchar(1024),
	title text,
	description text,
	public bool,
	hits int8 DEFAULT 0,
	cover text,
	comment bool DEFAULT true,
	is_subdir bool DEFAULT false,
	updated character DEFAULT '1',
	password varchar(128) DEFAULT '',
	CONSTRAINT photo_share_pkey PRIMARY KEY (shareid),
	CONSTRAINT photo_share_sharename_key UNIQUE (sharename)
);

create table photo_log
(
	logid int4 NOT NULL,
	create_time timestamp,
	log text,
	success bool,
	"user" varchar(128),
	CONSTRAINT photo_log_pkey PRIMARY KEY (logid)
);

create table photo_access_right
(
	userid int4 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_access_right_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_access_right_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT "photo_access_right_userID_fkey" FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);


create table photo_upload_right
(
	userid int4 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_upload_right_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_upload_right_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT "photo_upload_right_userID_fkey" FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

create table photo_access_right_for_dsm_account
(
	userid int4 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_access_right_for_dsm_account_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_access_right_for_dsm_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

create table photo_upload_right_for_dsm_account
(
	userid int4 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_upload_right_for_dsm_account_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_upload_right_for_dsm_account_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

create table photo_image
(
	id serial NOT NULL,
	path text NOT NULL,
	name text NOT NULL,
	title text,
	description text,
	album text,
	size int4,
	resolutionx int4,
	resolutiony int4,
	camera_make varchar(100),
	camera_model varchar(100),
	exposure varchar(20),
	aperture varchar(20),
	iso int4,
	timetaken timestamp,
	updated char(1),
	version int4 DEFAULT 0,
	create_time timestamp,
	gps text DEFAULT '',
	CONSTRAINT photo_pkey PRIMARY KEY (id),
	CONSTRAINT photo_image_path_key UNIQUE (path)
);

CREATE INDEX photo_image_create_time_idx ON photo_image USING btree (create_time);
CREATE UNIQUE INDEX photo_image_path_idx ON photo_image USING btree (path);

create table photo_comment
(
	id serial NOT NULL,
	photo_id int8 NOT NULL,
	name varchar(100),
	email varchar(128),
	comment text,
	date timestamp,
	CONSTRAINT photo_comment_pkey PRIMARY KEY (id),
	CONSTRAINT photo_comment_photo_id_fkey1 FOREIGN KEY (photo_id)
		REFERENCES photo_image (id) MATCH SIMPLE
		ON UPDATE RESTRICT ON DELETE CASCADE
);

CREATE TABLE video_comment
(
	id serial NOT NULL,
	path text NOT NULL,
	name varchar(100),
	email varchar(128),
	"comment" text,
	date timestamp,
	updated char(1),
	CONSTRAINT video_comment_pkey PRIMARY KEY (id)
);

CREATE TABLE video_desc
(
	id serial NOT NULL,
	path text NOT NULL,
	title text,
	description text,
	updated char(1),
	CONSTRAINT video_pkey PRIMARY KEY (id),
	CONSTRAINT video_path_key UNIQUE (path)
);


CREATE TABLE photo_config
(
	config_id serial NOT NULL,
	module_name varchar(128) NOT NULL,
	config_key varchar(512) NOT NULL,
	config_value text,
	CONSTRAINT photo_config_pkey PRIMARY KEY (config_id)
);

CREATE TABLE common_config
(
	config_id serial NOT NULL,
	module_name varchar(128) NOT NULL,
	config_key varchar(512) NOT NULL,
	config_value text,
	CONSTRAINT common_config_pkey PRIMARY KEY (config_id)
);

create INDEX photo_comment_photoid_index
	ON photo_comment
	USING hash
	(photo_id);


CREATE TABLE video
(
	id serial NOT NULL,
	path text NOT NULL,
	title text NOT NULL,
	filesize int8 NOT NULL DEFAULT 0,
	album text,
	container_type text NOT NULL,
	video_codec text,
	frame_bitrate int4,
	frame_rate_num int4,
	frame_rate_den int4,
	video_bitrate int4,
	video_profile int4,
	video_level int4,
	resolutionX int4,
	resolutionY int4,
	audio_codec text,
	audio_bitrate int4,
	frequency int4,
	channel int4,
	duration int4,
	date timestamp,
	mdate timestamp,
	gps text DEFAULT '',
	CONSTRAINT video_primary_key PRIMARY KEY (id)
)
WITHOUT OIDS;
CREATE INDEX video_title_idx ON video USING btree (title);
CREATE INDEX video_date_idx ON video USING btree (date);
CREATE INDEX video_mdate_idx ON video USING btree (mdate);
CREATE UNIQUE INDEX video_path_idx ON video USING btree (path);

CREATE TABLE video_convert (
	video_path text NOT NULL,
	convert_file_path text NOT NULL,
	resolutionx int4 DEFAULT NULL,
	resolutiony int4 DEFAULT NULL,
	container_type text NOT NULL,
	video_bitrate int4 DEFAULT NULL,
	vcodec text DEFAULT NULL,
	video_profile int4 DEFAULT NULL,
	video_level int4 DEFAULT NULL,
	acodec text DEFAULT NULL,
	audio_bitrate int4 DEFAULT NULL,
	audio_frequency int4 DEFAULT NULL,
	audio_channel int4 DEFAULT NULL,
	convert_type text NOT NULL,
	CONSTRAINT video_convert_pkey PRIMARY KEY (convert_file_path),
	CONSTRAINT video_convert_fk1 FOREIGN KEY (video_path) REFERENCES video (path) ON DELETE CASCADE ON UPDATE CASCADE
)
WITHOUT OIDS;
CREATE INDEX video_convert_convert_type_idx ON video_convert USING btree (convert_type);
CREATE INDEX video_convert_video_path_idx ON video_convert USING btree (video_path);

CREATE TABLE photo_label (
	id serial NOT NULL unique,
	name text,
	category int4 NOT NULL,
	info text DEFAULT '',
        CONSTRAINT photo_label_id_primary_key PRIMARY KEY (id)
);

CREATE TABLE photo_image_label (
	id serial NOT NULL,
	image_id int4 NOT NULL,
	label_id int4 NOT NULL,
	info text DEFAULT '',
	info_new text DEFAULT '',
	status bool default true,
	PRIMARY KEY (id),
	CONSTRAINT photo_image_label_photo_id_fkey1 FOREIGN KEY (image_id) REFERENCES photo_image (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
	CONSTRAINT photo_image_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);

CREATE TABLE photo_video_label (
	id serial NOT NULL,
	video_path text NOT NULL,
	label_id int4 NOT NULL,
	info text DEFAULT '',
	status bool default true,
	updated char(1),
	PRIMARY KEY (id),
	CONSTRAINT photo_video_label_label_id_fkey1 FOREIGN KEY (label_id) REFERENCES photo_label (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE
);

create table photo_manage_right
(
	userid int8 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_manage_right_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_manage_right_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT "photo_manage_right_userID_fkey" FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

create table photo_manage_right_for_dsm_account
(
	userid int8 NOT NULL,
	shareid int4 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_manage_right_for_dsm_account_pkey PRIMARY KEY (userid, shareid),
	CONSTRAINT "photo_manage_right_for_dsm_shareID_fkey" FOREIGN KEY (shareid)
	REFERENCES photo_share (shareid) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

create table category
(
	id serial NOT NULL,
	name text NOT NULL,
	hidden boolean NOT NULL DEFAULT false,
	order_number int NOT NULL,
	create_date timestamp DEFAULT current_timestamp,
	modify_date timestamp DEFAULT current_timestamp,
	CONSTRAINT category_pkey PRIMARY KEY (id),
	CONSTRAINT category_ukey UNIQUE (name)
);

CREATE TYPE item_type AS ENUM ('album', 'smart', 'tag');
create table category_items
(
	id serial NOT NULL,
	category_id serial NOT NULL,
	type item_type NOT NULL,
	order_number int not NULL,
	album_id int
		REFERENCES photo_share (shareid)
		ON UPDATE CASCADE ON DELETE CASCADE,
	tag_id int
		REFERENCES photo_label (id)
		ON UPDATE CASCADE ON DELETE CASCADE,
	smart_id text,
	CONSTRAINT category_items_pkey PRIMARY KEY (id),
	CONSTRAINT category_item_album_ukey UNIQUE (category_id, album_id),
	CONSTRAINT category_items_tag_ukey UNIQUE (category_id, tag_id),
	CONSTRAINT category_items_smart_ukey UNIQUE (category_id, smart_id),
	CONSTRAINT category_items_fkey FOREIGN KEY (category_id)
		REFERENCES category (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE TABLE photo_group
(
	groupid int8 NOT NULL,
	groupname varchar(128) NOT NULL,
	description varchar(128),
	CONSTRAINT photo_group_pkey PRIMARY KEY (groupid),
	CONSTRAINT photo_group_username_key UNIQUE (groupname)
);

CREATE TABLE photo_user_group (
	id serial NOT NULL,
	userid int8 NOT NULL,
	groupid int8 NOT NULL,
	PRIMARY KEY (id),
	CONSTRAINT photo_user_group_userID_fkey FOREIGN KEY (userid)
		REFERENCES photo_user (userid) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
	CONSTRAINT photo_user_group_groupID_fkey FOREIGN KEY (groupid)
		REFERENCES photo_group (groupid) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE CASCADE,
	CONSTRAINT photo_user_group_key UNIQUE (userid, groupid)
);

CREATE TABLE photo_group_permission
(
	groupid int8 NOT NULL,
	shareid int4 NOT NULL,
	permission int2 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_group_permission_pkey PRIMARY KEY (groupid, shareid),
	CONSTRAINT photo_group_permission_shareID_fkey FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT photo_group_permission_groupID_fkey FOREIGN KEY (groupid)
		REFERENCES photo_group (groupid) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE TABLE photo_group_permission_for_dsm_account
(
	groupid int8 NOT NULL,
	shareid int4 NOT NULL,
	permission int2 NOT NULL,
	create_time timestamp,
	CONSTRAINT photo_group_permission_for_dsm_account_pkey PRIMARY KEY (groupid, shareid),
	CONSTRAINT "photo_group_permission_for_dsm_shareID_fkey" FOREIGN KEY (shareid)
		REFERENCES photo_share (shareid) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE
);



COMMIT;
