#!/bin/sh
# Copyright (c) 2000-2007 Synology Inc. All rights reserved.

echo "Update blog_config table in blog db where config_id = 0 to test blog db existence"
su -l admin -c "/usr/syno/pgsql/bin/psql blog -c \"update blog_config set config_value = '' where config_id = 0\"" > /dev/null 2>&1
Ret=$?
if [ $Ret != 2 ]; then

   TmpDir="/volume1/@tmp/php/"
	SupportRAID=`/bin/get_key_value /etc.defaults/synoinfo.conf supportraid`
	case "${SupportRAID}" in
	[Yy][Ee][Ss])
		TmpDir="/var/spool/php/"
		;;
	esac

   mkdir -p ${TmpDir}
	chmod 1777 ${TmpDir}
   
   su -l admin -c "/usr/syno/pgsql/bin/pg_dump blog -d > ${TmpDir}blog.pgdump"
   if [ $? != 0 ]; then
      echo "Failed to dump blog database"
      exit
   fi
   
   if [ -f "${TmpDir}blog.pgdump" ]; then
      su -l admin -c "/usr/syno/pgsql/bin/psql photo <  ${TmpDir}blog.pgdump"
      if [ $? != 0 ]; then
         echo "Failed to restore blog tables into photo database"
         exit
      else
         su -l admin -c "/usr/syno/pgsql/bin/dropdb blog"
      fi
   
      rm ${TmpDir}blog.pgdump
      if [ $? != 0 ]; then
         echo "Failed to remove blog database backup"
         exit
      fi
   fi
fi
