<?php

define('SYNOPHOTO_EADIR', '@eaDir');
define('SYNOPHOTO_SORT_FILE', 'SYNOPHOTO_ALBUM.sort');
define('SYNO_PHOTO_DSM_USER_PROG', '/usr/syno/bin/synophoto_dsm_user');

/* list dsm users */
$dsmUserList = getDSMUserList();
$usernameList = array_merge(array(''), $dsmUserList);

foreach ($usernameList as $username) {
	$user = $username;
	$dbh = getDatabaseHandler();
	$sortFile = getRootSortFile();

	//no database, skip
	if (!$dbh) {
		continue;
	}

	if (checkRootOrderExists()) {
		continue;
	}

	$rootOrderInDB = getRootAlbumOrderFromDB();
	if (!$rootOrderInDB) {
		continue;
	}

	setRootOrderToEA($rootOrderInDB);
}

function checkRootOrderExists() {
	global $sortFile;

	if (false === ($result = @file_get_contents($sortFile))) {
		return false;
	}

	$result = json_decode($result, true);
	if (empty($result['list'])) {
		return false;
	}

	return true;
}

function setRootOrderToEA($order) {
	global $sortFile;

	$result = array();
	$albumArr = json_decode($order);
	foreach($albumArr as $album) {
		$result['list'][] = $album . '/';
	}
	@file_put_contents($sortFile, json_encode($result));
}

function getDSMUserList()
{
	@exec(SYNO_PHOTO_DSM_USER_PROG." --enum", $dsmUserCount);
	@exec(SYNO_PHOTO_DSM_USER_PROG." --enum 0 ".intval($dsmUserCount[0]), $dsmUserList);
	$list = array();

	foreach($dsmUserList as &$dsmUser) {
		$dsmUser = explode(',', $dsmUser);
		if (count($dsmUser) != 6) {
			continue;
		}
		$list[] = $dsmUser[1];
	}
	return $list;
}

function getDatabaseHandler()
{
	global $user;

	$dbh = null;

	if (strlen($user)){
		$user_photo_db = "/var/services/homes/$user/photo/.SYNOPPSDB";

		if(!file_exists($user_photo_db)){
			return $dbh;
		}

		try {
			$dbh = new PDO("sqlite:{$user_photo_db}");
			$dbh->exec('PRAGMA case_sensitive_like=1');
			$dbh->exec('PRAGMA foreign_keys=ON');
		} catch (PDOException $e) {
			die($e->getMessage());
		}
	} else {
		try {
			$dbh = new PDO('pgsql:dbname=photo', 'admin', '', array(PDO::ATTR_PERSISTENT => false, PDO::ATTR_EMULATE_PREPARES => true));
		} catch (PDOException $e) {
			die($e->getMessage());
		}
	}

	return $dbh;
}

function getRootSortFile()
{
	global $user;

	if (strlen($user)){
		$service_dir = '/var/services/homes/' . $user . '/photo';
	} else {
		$service_dir = '/var/services/photo';
	}

	$ea_dir = $service_dir . '/' . SYNOPHOTO_EADIR;
	$file = $ea_dir . '/' . SYNOPHOTO_SORT_FILE;

	return $file;
}

function getRootAlbumOrderFromDB()
{
	global $dbh;

	$sqlCond = "SELECT config_value FROM photo_config WHERE module_name = 'album' AND config_key = 'order_list'";
	$sqlParam = array();

	$dbResult = $dbh->prepare($sqlCond);
	$dbResult->execute($sqlParam);

	if (false !== ($row = $dbResult->fetch())) {
		return $row[0];
	}

	return false;
}
?>
