#!/bin/sh
# Copyright (c) 2000-2011 Synology Inc. All rights reserved.

PHOTO_FB_REGULAR_SYNC_CONF='/var/services/blog/fb_allow_regular_sync.conf'
PHOTO_SCRIPT_DIR='/var/packages/PhotoStation/target/photo_scripts'
OLDIFS=$IFS
IFS=","

if [ ! -f "$PHOTO_FB_REGULAR_SYNC_CONF" ]; then
    exit
fi

confContent=$(cat "$PHOTO_FB_REGULAR_SYNC_CONF")

for name in $confContent;
do
    name=$(echo $name | sed "s/\[//" | sed "s/\"//" | sed "s/\".*$//g")

    if [ $name = "root" ]; then
        $PHOTO_SCRIPT_DIR/root_fbsync.sh
    else
        $PHOTO_SCRIPT_DIR/pps_fbsync.sh "$name"
    fi
done
