<?PHP

set_time_limit(0);
session_cache_limiter("must-revalidate");

require_once('thumb.inc.php');
require_once '../include/SYNOPhotoEA.php';
require_once('../include/photo/synophoto_csPhotoDB.php');
require_once('../include/photo/synophoto_csPhotoMisc.php');

class ThumbAPI extends WebAPI
{
	function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		session_start();
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
		session_write_close();
		if (!strcasecmp($this->method, "get")) {
			$this->Get();
		}
	}

	private function Get()
	{
		global $SYNOPHOTO_ALLOW_ID_TYPE;
		global $SYNOPHOTO_ID_TYPE_LEN;
		$ret = false;

		/* return when lack of params */
		if (!isset($_REQUEST['id']) || !isset($_REQUEST['size'])) {
			$this->SetError(PHOTOSTATION_THUMB_BAD_PARAMS);
			goto End;
		}

		/* check params */
		$id = $_REQUEST['id'];
		$id_arr = explode('_', $id);

		if ($id_arr[0] !== 'photo' && $id_arr[0] !== 'video') {
			// require albumutil.php before variable $type is assigned
			// due to "include/photo/album_util.php" will read variable $type and lead to check timeout
			require_once('albumutil.php');

			session_write_close();
		}

		$type = $id_arr[0];
		if (!in_array($type, $SYNOPHOTO_ALLOW_ID_TYPE)) {
			$this->SetError(PHOTOSTATION_THUMB_BAD_PARAMS);
			goto End;
		}
		if (count($id_arr) !== $SYNOPHOTO_ID_TYPE_LEN[$type]) {
			$this->SetError(PHOTOSTATION_THUMB_BAD_PARAMS);
			goto End;
		}
		$size = $_REQUEST['size'];
		if ('small' !== $size && 'large' !== $size && 'preview' !== $size) {
			$this->SetError(PHOTOSTATION_THUMB_BAD_PARAMS);
			goto End;
		}

		/* start to construct thumbnail path from the given id */
		$dir = '';
		$fileName = '';
		$albumName = '';
		$url = '';
		$path = '';
		$isPublic = false;
		if (SYNOPHOTO_UNCONFIRM_TAG_ID === $id) {
			$list = AlbumAPIUtil::GetUnConfirmItemList(1, 0);
			$keys = array_keys($list);
			$fullPath = $keys[0];
			$dir = dirname($fullPath);
			$albumName = substr($dir, strlen(SYNOPHOTO_SERVICE_REAL_DIR.'/'));
			$fileName = basename($fullPath);
		} else if ('photo' === $type || 'video' === $type) {
			$albumName = @pack('H*', $id_arr[1]);
			$dir = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName;
			$fileName = @pack('H*', $id_arr[2]);
		} elseif ('smart' === $type) {
			$albumName = @pack('H*', $id_arr[1]);
			$album = SmartAlbum::GetCoverOfSmartAlbumByName($albumName);
			if (!$album['success']) {
				$this->SetError(PHOTOSTATION_THUMB_ACCESS_DENY);
				goto End;
			}
			$cover_path = $album['cover']['path'];
			if ('' !== $cover_path) {
				$dir = substr($cover_path, 0, strrpos($cover_path, '/'));
				$fileName = basename($cover_path);
			} else {
				$path = SYNO_PKG_DIR . "/target" . SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			}
			$isPublic = true;
		} else {
			if ('album' === $type) {
				$albumName = @pack('H*', $id_arr[1]);
				$album = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($albumName);
			} elseif ('virtual' === $type) {
				$isPublic = true;
				$album = csSYNOPhotoBrowse::GetBrowseInstance()->GetVirtualAlbumThumb($id_arr[1]);
			} elseif ('tag' === $type) {
				$isPublic = true;
				$album = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumCover($id_arr[1]);
            } elseif ('defaultsmart' === $type) {
                $index = 0;
                if ('people' === $id_arr[1]) {
                    $index = 0;
                } elseif ('geo' === $id_arr[1]) {
                    $index = 1;
                } elseif ('desc' === $id_arr[1]) {
                    $index = 2;
                }
                $isPublic = true;
                $categoryArr = array();
                array_push($categoryArr, $index);
                $result = SYNOPHOTO_LABEL_UTIL_GetAllLabel(false, $categoryArr);
                $album = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumCover($result[$index][0]['id']);
            }
			$url = $album['bigCover']['src'];

			if (!empty($album['coverPath'])) {
				// extract cover info from coverPath
				$path_parts = pathinfo($album['coverPath']);
				$fileName = $path_parts['basename'];
				$dir = $path_parts['dirname'];
				if ($dir === SYNOPHOTO_SERVICE_REAL_DIR) {
					$albumName = '/';
				} else {
					$albumName = substr($dir, strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1);
				}
			} else {
				$albumName = @pack('H*', substr($url, strpos($url, 'dir=') + 4, strpos($url, '&name') - strpos($url, 'dir=') - 4));
				$fileName = @pack('H*', substr($url, strpos($url, 'name=') + 5, strpos($url, '&type') - strpos($url, 'name=') - 5));
				$dir = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName;
			}

			if (empty($albumName) || empty($fileName)) {
				$this->SetError(PHOTOSTATION_THUMB_NO_COVER);
				goto End;
			}
		}

		/* check access right */
		if (!$isPublic && !csSYNOPhotoMisc::CheckAlbumAccessible($albumName)) {
			$this->SetError(PHOTOSTATION_THUMB_ACCESS_DENY);
			goto End;
		}

		/* construct corresonding thumbnail path */
		$useDefImage = true;
		if ('' === $path) {
			$useDefImage = false;
			if ('small' === $size) {
				SYNOPhotoEA::checkFilePathByDirFile($dir, $fileName, SYNOPhotoEA::FILE_THUMB_M, $path);
			} elseif ('large' === $size) {
				SYNOPhotoEA::checkFilePathByDirFile($dir, $fileName, SYNOPhotoEA::FILE_THUMB_XL, $path);
			} elseif ('preview' === $size) {
				SYNOPhotoEA::checkFilePathByDirFile($dir, $fileName, SYNOPhotoEA::FILE_THUMB_PREVIEW, $path);
			}
		}

		/* set mime type, default is jpeg */
		$mime = 'image/jpeg';
		preg_match('/\.([^\.]*?)$/', $fileName, $matches);
		$extension = strtolower($matches[1]);
		/* special case for gif, return original file */
		if ('gif' === $extension) {
			$path = $dir . "/" . $fileName;
			$mime = 'image/gif';
		}

		/* if "user_small_orig" is true, trying to check size of original file and thumbnail file, and then use the smaller one */
		if ('true' === $_REQUEST['use_small_orig'] && !$useDefImage) {
			if (in_array($extension, array('jpeg', 'jpg', 'jpe', 'bmp', 'png'/*, 'image/tiff'*/))) {
				$oriPath = $dir . "/" . $fileName;
				$imgInfo = @getImageSize($oriPath);
				$thumbInfo = @getImageSize($path);

				/* find larger length of original file and thumbnail file */
				$thumbLarger = max(array_slice($thumbInfo, 0, 2));
				$origLarger = max(array_slice($imgInfo, 0, 2));

				if ($thumbLarger > $origLarger) {
					$path = $dir . "/" . $fileName;
					$mime = $imgInfo['mime'];
				}
			}
		}

		if (!file_exists($path)) {
			$this->SetError(PHOTOSTATION_THUMB_FILE_NOT_EXISTS);
			goto End;
		}

		@header("Cache-Control: max-age=".(3600*24*7));

		// check last-modified value
		$lastModified = $this->GetLastModified($path);
		if ($lastModified) {
			if ($this->CheckLastModified($lastModified)) {
				@header("HTTP/1.1 304 Not Modified");
				return;
			} else {
				@header("Last-Modified: " . $lastModified);
			}
		}

		/* output binary */
		@header("Content-Type: $mime");
		@header("Content-Disposition: inline; filename=\"".addslashes($fileName).'"');

		$this->SYNOPHOTO_CONVERT_Rrange_Download($path);
		exit;

		End:
			return $ret;
	}

	private function GetLastModified($thumbPath)
	{
		$filest = @stat($thumbPath);

		if ($filest !== false) {
			$lastModified = gmdate('D, d M Y H:i:s', $filest[9]) . ' GMT';
			return $lastModified;
		} else {
			return false;
		}
	}

	private function CheckLastModified($lastModified)
	{
		if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
			$ims = preg_replace('/;.*$/', '', $_SERVER['HTTP_IF_MODIFIED_SINCE'] );
			if ($ims === $lastModified) {
				return true;
			}
		}

		return false;
	}

	private function SYNOPHOTO_CONVERT_Rrange_Download($file)
	{
		$fp = @fopen($file, 'rb');
		if (FALSE == $fp) {
			return FALSE;
		}

		$size   = filesize($file); // File size
		$length = $size;		   // Content length
		$start  = 0;			   // Start byte
		$end	= $size - 1;	   // End byte
		// Now that we've gotten so far without errors we send the accept range header
		/* At the moment we only support single ranges.
		 * Multiple ranges requires some more work to ensure it works correctly
		 * and comply with the spesifications: http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.2
		 *
		 * Multirange support annouces itself with:
		 * header('Accept-Ranges: bytes');
		 *
		 * Multirange content must be sent with multipart/byteranges mediatype,
		 * (mediatype = mimetype)
		 * as well as a boundry header to indicate the various chunks of data.
		 */
		//header("Accept-Ranges: 0-$length");
		header('Accept-Ranges: bytes');
		// multipart/byteranges
		// http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.2
		if (isset($_SERVER['HTTP_RANGE'])) {
			$c_start = $start;
			$c_end   = $end;
			// Extract the range string
			list(, $range) = explode('=', $_SERVER['HTTP_RANGE'], 2);
			// Make sure the client hasn't sent us a multibyte range
			if (strpos($range, ',') !== false) {

				// (?) Shoud this be issued here, or should the first
				// range be used? Or should the header be ignored and
				// we output the whole content?
				header('HTTP/1.1 416 Requested Range Not Satisfiable');
				header("Content-Range: bytes $start-$end/$size");
				// (?) Echo some info to the client?
				exit;
			}
			// If the range starts with an '-' we start from the beginning
			// If not, we forward the file pointer
			// And make sure to get the end byte if spesified
			if ($range{0} == '-') {

				// The n-number of the last bytes is requested
				$c_start = $size - substr($range, 1);
			}
			else {

				$range  = explode('-', $range);
				$c_start = $range[0];
				$c_end   = (isset($range[1]) && is_numeric($range[1])) ? $range[1] : $size;
			}
			/* Check the range and make sure it's treated according to the specs.
			 * http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html
			 */
			// End bytes can not be larger than $end.
			$c_end = ($c_end > $end) ? $end : $c_end;
			// Validate the requested range and return an error if it's not correct.
			if ($c_start > $c_end || $c_start > $size - 1 || $c_end >= $size) {

				header('HTTP/1.1 416 Requested Range Not Satisfiable');
				header("Content-Range: bytes $start-$end/$size");
				// (?) Echo some info to the client?
				exit;
			}
			$start  = $c_start;
			$end	= $c_end;
			$length = $end - $start + 1; // Calculate new content length
			fseek($fp, $start);
			header('HTTP/1.1 206 Partial Content');
		}
		// Notify the client the byte range we'll be outputting
		header("Content-Range: bytes $start-$end/$size");
		header("Content-Length: $length");

		// Start buffered download
		$buffer = 1024 * 8;
		while(!feof($fp) && ($p = ftell($fp)) <= $end) {

			if ($p + $buffer > $end) {

				// In case we're only outputtin a chunk, make sure we don't
				// read past the length
				$buffer = $end - $p + 1;
			}

			echo fread($fp, $buffer);
			flush(); // Free up memory. Otherwise large files will trigger PHP's memory limit.
		}
		fclose($fp);
	}
}

$api = new ThumbAPI();
$api->Run();
