<?php

require_once('smart_album.inc.php');
require_once('albumutil.php');

class SmartAlbumAPI extends WebAPI {

    function __construct() {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process() {
        if (!strcasecmp($this->method, "list")) {
			session_write_close();
            $this->SmartAlbumList();
        } elseif (!strcasecmp($this->method, "getinfo")) {
			session_write_close();
            $this->GetInfo();
        } else {
            csSYNOPhotoMisc::CheckSessionTimeOut();

            if (!strcasecmp($this->method, "create")) {
                $this->Create();
            } elseif (!strcasecmp($this->method, "edit")) {
                $this->Edit();
            } elseif (!strcasecmp($this->method, "delete")) {
                $this->Delete();
            }
        }
    }

    private function ExtractTagStringToArray($tagString)
    {
        $tagArr = array();
        $arr = explode(',', $tagString);
        foreach ($arr as $tag) {
            $split = explode('tag_', $tag);
            if (2 !== count($split)) {
                return false;
            }
            array_push($tagArr, $split[1]);
        }
        return $tagArr;
    }

    private function GetParams_List() {
        $params = array();
        if (!isset($_REQUEST['offset']) || !isset($_REQUEST['limit'])) {
            return false;
        }
        $params['offset'] = $_REQUEST['offset'];
        $params['limit'] = $_REQUEST['limit'];

        $params['sort_by'] = (isset($_REQUEST['sort_by'])) ? $_REQUEST['sort_by'] : 'title';
        if (!in_array($params['sort_by'], array('title'))) {
            return false;
        }
        $params['sort_direction'] = (isset($_REQUEST['sort_direction'])) ? $_REQUEST['sort_direction'] : 'asc';
        if (!in_array($params['sort_direction'], array('asc', 'desc'))) {
            return false;
        }

        // additional operator
        $params['additional'] = array();
        $params['additional'] = explode(',', $_REQUEST['additional']);

        return $params;
    }

    /**
     * 
     *  @return
     *   params object - success
     *   -1 - bad parameter
     *   -2 - smart album not exist
     */
    private function GetParams_Info() {
        $params = array();
        if (!isset($_REQUEST['id'])) {
            return -1;
        }
        $arr = explode(',', $_REQUEST['id']);
        $params['id'] = array();
        foreach ($arr as $smartID) {
            if (!$this->CheckSmartAlbumExist($smartID)) {
                return -2;
            }
            $split = explode('smart_', $smartID);
            array_push($params['id'], $split[1]);
        }
        // additional operator
        $params['additional'] = array();
        $params['additional'] = explode(',', $_REQUEST['additional']);

        return $params;
    }

    /**
     * 
     * @return 
     *   -1 - bad parameter
     *   -2 - smart album not exist
     */
    private function GetPrams_Edit() {
        $params = array();

        if (!isset($_REQUEST['id'])) {
            return -1;
        }
        // check smart album exist
        if (!$this->CheckSmartAlbumExist($_REQUEST['id'])) {
            return -2;
        }
        $arr = explode('smart_', $_REQUEST['id']);
        if (2 !== count($arr)) {
            return -1;
        }
        $params['id'] = $arr[1];
        $smartName =  @pack('H*', $arr[1]);
        $params['name'] = (isset($_REQUEST['name']) && '' !== $_REQUEST['name']) ? $_REQUEST['name'] : $smartName;
        $params['orig_name'] = $smartName;

        // get original smart album setting
        $smartAlbumCond = SmartAlbum::GetSmartCondition($smartName);
        // type
        if (isset($_REQUEST['type'])) {
            $params['type'] = $_REQUEST['type'];
            $arr = explode(',', $params['type']);
            $count = 0;
            foreach ($arr as $type) {
                if (!in_array($type, array('photo', 'video'))) {
                    return -1;
                }
                $count++;
            }
            if (1 > $count) {
                return -1;
            }
        } else {
            $params['type'] = $smartAlbumCond['type'];
        }
        // keyword
        if (isset($_REQUEST['keyword'])) {
            if ('' === $_REQUEST['keyword']) {
                $params['keyword'] = null;
                $params['keyword_op'] = null;
            } else {
                $params['keyword'] = $_REQUEST['keyword'];
                $default = isset($smartAlbumCond['keyword_op']) ? $smartAlbumCond['keyword_op'] : 'any';
                $params['keyword_op'] = (isset($_REQUEST['keyword_op'])) ? $_REQUEST['keyword_op'] : $default;
                if (isset($params['keyword_op']) && !in_array($params['keyword_op'], array('any', 'all', 'exact'))) {
                    return -1;
                }
            }
        } else {
            $params['keyword'] = $smartAlbumCond['keyword'];
            $params['keyword_op'] = $smartAlbumCond['keyword_op'];
        }
        // date
        if (isset($_REQUEST['date'])) {
            if (empty($_REQUEST['date'])) {
                $params['date'] = null;
                $params['date_op'] = null;
            } else {
                $params['date'] = $_REQUEST['date'];
                $default = isset($smartAlbumCond['date_op']) ? $smartAlbumCond['date_op'] : 'taken';
                $params['date_op'] = (isset($_REQUEST['date_op'])) ? $_REQUEST['date_op'] : $default;
                if (isset($params['date_op']) && !in_array($params['date_op'], array('taken', 'upload', 'recently_add', 'recently_comment'))) {
                    return -1;
                }
            }
        } else {
            $params['date'] = $smartAlbumCond['date'];
            $params['date_op'] = $smartAlbumCond['date_op'];
        }
        // peopel_tag
        if (isset($_REQUEST['people_tag'])) {
            if (empty($_REQUEST['people_tag'])) {
                $params['people_tag'] = null;
                $params['people_tag_op'] = null;
            } else {
                // get people_tag
                $params['people_tag'] = array();
                $params['people_tag'] = $this->ExtractTagStringToArray($_REQUEST['people_tag']);
                // get people_tag_op
                $default = isset($smartAlbumCond['people_tag_op']) ? $smartAlbumCond['people_tag_op'] : 'all';
                $params['people_tag_op'] = (isset($_REQUEST['people_tag_op'])) ? $_REQUEST['people_tag_op'] : $default;
                if (isset($params['people_tag_op']) && !in_array($params['people_tag_op'], array('all', 'any'))) {
                    return -1;
                }
            }
        } else {
            $arr = $this->ExtractTagStringToArray($smartAlbumCond['people_tag']);
            $params['people_tag'] = empty($arr) ? null : $arr;
            $params['people_tag_op'] = $smartAlbumCond['people_tag_op'];
        }
        // geo_tag
        if (isset($_REQUEST['geo_tag'])) {
            if (empty($_REQUEST['geo_tag'])) {
                $params['geo_tag'] = null;
                $params['geo_tag_op'] = null;
            } else {
                // get geo_tag
                $params['geo_tag'] = array();
                $params['geo_tag'] = $this->ExtractTagStringToArray($_REQUEST['geo_tag']);
                // get geo_tag_op
                $default = isset($smartAlbumCond['geo_tag_op']) ? $smartAlbumCond['geo_tag_op'] : 'all';
                $params['geo_tag_op'] = (isset($_REQUEST['geo_tag_op'])) ? $_REQUEST['geo_tag_op'] : $default;
                if (isset($params['geo_tag_op']) && !in_array($params['geo_tag_op'], array('all', 'any'))) {
                    return -1;
                }
            }
        } else {
            $arr = $this->ExtractTagStringToArray($smartAlbumCond['geo_tag']);
            $params['geo_tag'] = empty($arr) ? null : $arr;
            $params['geo_tag_op'] = $smartAlbumCond['geo_tag_op'];
        }
        // desc_tag
        if (isset($_REQUEST['desc_tag'])) {
            if (empty($_REQUEST['desc_tag'])) {
                $params['desc_tag'] = null;
                $params['desc_tag_op'] = null;
            } else {
                // get desc_tag
                $params['desc_tag'] = array();
                $params['desc_tag'] = $this->ExtractTagStringToArray($_REQUEST['desc_tag']);
                // get desc_tag_op
                $default = isset($smartAlbumCond['desc_tag_op']) ? $smartAlbumCond['desc_tag_op'] : 'all';
                $params['desc_tag_op'] = (isset($_REQUEST['desc_tag_op'])) ? $_REQUEST['desc_tag_op'] : $default;
                if (isset($params['desc_tag_op']) && !in_array($params['desc_tag_op'], array('all', 'any'))) {
                    return -1;
                }
            }
        } else {
            $arr = $this->ExtractTagStringToArray($smartAlbumCond['desc_tag']);
            $params['desc_tag'] = empty($arr) ? null : $arr;
            $params['desc_tag_op'] = $smartAlbumCond['desc_tag_op'];
        }

        if ((null === $params['keyword'] || '' === $params['keyword']) && empty($params['date']) && empty($params['people_tag']) && empty($params['geo_tag']) && empty($params['desc_tag'])) {
            return -1;
        }
        return $params;
    }

    private function GetParams_Create() {
        $params = array();

        if (!isset($_REQUEST['name']) || !isset($_REQUEST['type'])) {
            return false;
        }
        $params['name'] = $_REQUEST['name'];
        // type
        $params['type'] = $_REQUEST['type'];
        $arr = explode(',', $params['type']);
        $count = 0;
        foreach ($arr as $type) {
            if (!in_array($type, array('photo', 'video'))) {
                return false;
            }
            $count++;
        }
        if (1 > $count) {
            return false;
        }

        $params['keyword'] = (isset($_REQUEST['keyword'])) ? $_REQUEST['keyword'] : null;
        if (!empty($_REQUEST['keyword']) || '0' === $_REQUEST['keyword']) {
            $default = 'all';
            $params['keyword_op'] = (isset($_REQUEST['keyword_op'])) ? $_REQUEST['keyword_op'] : $default;
            if (isset($params['keyword_op']) && !in_array($params['keyword_op'], array('any', 'all', 'exact'))) {
                return false;
            }
        }
        $params['date'] = (isset($_REQUEST['date'])) ? $_REQUEST['date'] : null;
        if (!empty($_REQUEST['date'])) {
            $default = 'taken';
            $params['date_op'] = (isset($_REQUEST['date_op'])) ? $_REQUEST['date_op'] : $default;
            if (isset($params['date_op']) && !in_array($params['date_op'], array('taken', 'upload', 'recently_add', 'recently_comment'))) {
                return false;
            }
        }
        $people_tags = (isset($_REQUEST['people_tag'])) ? $_REQUEST['people_tag'] : null;
        if (!empty($_REQUEST['people_tag'])) {
            // get people_tag
            $params['people_tag'] = array();
            $params['people_tag'] = $this->ExtractTagStringToArray($people_tags);
            // get people_tag_op
            $default = 'all';
            $params['people_tag_op'] = (isset($_REQUEST['people_tag_op'])) ? $_REQUEST['people_tag_op'] : $default;
            if (isset($params['people_tag_op']) && !in_array($params['people_tag_op'], array('all', 'any'))) {
                return false;
            }
        }
        $geo_tags = (isset($_REQUEST['geo_tag'])) ? $_REQUEST['geo_tag'] : null;
        if (!empty($_REQUEST['geo_tag'])) {
            // get geo_tag
            $params['geo_tag'] = array();
            $params['geo_tag'] = $this->ExtractTagStringToArray($geo_tags);
            // get geo_tag_op
            $default = 'all';
            $params['geo_tag_op'] = (isset($_REQUEST['geo_tag_op'])) ? $_REQUEST['geo_tag_op'] : $default;
            if (isset($params['geo_tag_op']) && !in_array($params['geo_tag_op'], array('all', 'any'))) {
                return false;
            }
        }
        $desc_tags = (isset($_REQUEST['desc_tag'])) ? $_REQUEST['desc_tag'] : null;
        if (!empty($_REQUEST['desc_tag'])) {
            // get desc_tag
            $params['desc_tag'] = array();
            $params['desc_tag'] = $this->ExtractTagStringToArray($desc_tags);
            // get desc_tag_op
            $default = 'all';
            $params['desc_tag_op'] = (isset($_REQUEST['desc_tag_op'])) ? $_REQUEST['desc_tag_op'] : $default;
            if (isset($params['desc_tag_op']) && !in_array($params['desc_tag_op'], array('all', 'any'))) {
                return false;
            }
        }

        if ((null === $params['keyword'] || '' === $params['keyword']) && empty($params['date']) && empty($params['people_tag']) && empty($params['geo_tag']) && empty($params['desc_tag'])) {
            return false;
        }

        return $params;
    }

    /**
     * 
     * @param 
     *  $tagIDs - array
     *  $type - 0 means people tag
     *          1 means geo tag
     *          2 means desc tag
     */
    private function CheckTagExist($tagIDs, $type) {
        if (!is_array($tagIDs)) {
            return false;
        }
        foreach ($tagIDs as $id) {
            $query = "SELECT count(id) FROM photo_label WHERE id={$id} AND category={$type}";
            $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
            $row = PHOTO_DB_FetchRow($db_result);
            if (1 !== (int)$row[0]) {
                return false;
            }
        }

        return true;
    }

    /**
     * 
     * @param 
     *  $smartID - ex: smart_id 
     */
    private function CheckSmartAlbumExist($smartID) {
        $arr = explode('smart_', $smartID);
        if (2 !== count($arr)) {
            return false;
        }
        $smartName = @pack('H*', $arr[1]);
        $result = SmartAlbum::ReadSmartAlbumFile();
        if (!isset($result['smart_albums'][$smartName])) {
            return false;
        }
        return true;
    }

    private function ConvertToSmartCondition($data) {
        $rule_sets = array();
        $rule_sets[0] = array();

        $ret['orig_name'] = $data['orig_name'];
        $ret['name'] = $data['name'];
        $ret['desc'] = '';
        $ret['show_photo'] = strstr($data['type'], 'photo') ? true : false;
        $ret['show_video'] = strstr($data['type'], 'video') ? true : false;

        if (isset($data['keyword']) && isset($data['keyword_op'])) {
            $rule_set['field'] = 'keyword';
            $rule_set['operator'] = $data['keyword_op'];
            $rule_set['value'] = $data['keyword'];
            array_push($rule_sets[0], $rule_set);
        }
        if (isset($data['date']) && isset($data['date_op'])) {
            $rule_set['field'] = 'date';
            $rule_set['operator'] = $data['date_op'];
            $rule_set['value'] = $data['date'];
            array_push($rule_sets[0], $rule_set);
        }
        if (isset($data['people_tag']) && isset($data['people_tag_op'])) {
            $rule_set['field'] = 'people';
            $rule_set['operator'] = $data['people_tag_op'];
            $peopleString = implode(',', $data['people_tag']);
            $rule_set['value'] = $peopleString;
            array_push($rule_sets[0], $rule_set);
        }
        if (isset($data['geo_tag']) && isset($data['geo_tag_op'])) {
            $rule_set['field'] = 'geo';
            $rule_set['operator'] = $data['geo_tag_op'];
            $geoString = implode(',', $data['geo_tag']);
            $rule_set['value'] = $geoString;
            array_push($rule_sets[0], $rule_set);
        }
        if (isset($data['desc_tag']) && isset($data['desc_tag_op'])) {
            $rule_set['field'] = 'desc';
            $rule_set['operator'] = $data['desc_tag_op'];
            $descString = implode(',', $data['desc_tag']);
            $rule_set['value'] = $descString;
            array_push($rule_sets[0], $rule_set);
        }

        $ret['rule_sets'] = $rule_sets;
        return json_encode($ret);
    }

    private function FormAdditional($smartAlbumName) {
        $additional = explode(',', $_REQUEST['additional']);
        if (in_array('smart_condition', $additional)) {
            $smartAlbumCond = SmartAlbum::GetSmartCondition($smartAlbumName);
            return $smartAlbumCond;
        }
        return false;
    }

    private function FormSmarAlbumItem($item) {
        $needThumbSize = in_array('thumb_size', explode(',', $_REQUEST['additional']));
        $smartAlbum['id'] = 'smart_'.bin2hex($item['name']);
        $smartAlbum['type'] = 'smart';
        $album = SmartAlbum::GetCoverOfSmartAlbumByName($item['name']);
        $smartAlbum['thumbnail_status'] = 'default';

		$coverPath = '';
        if ($album['success']) {
			$coverPath = $album['cover']['path'];
        }

        $smartAlbum['name'] = $item['name'];
        $ret = $this->FormAdditional($item['name']);
        if ($ret) {
            $smartAlbum['additional']['smart_condition'] = $ret;
        }
		AlbumAPIUtil::FillThumbStatus($smartAlbum, $coverPath, $needThumbSize, false);

        return $smartAlbum;
    }

    private function FormSmartAlbums($smartNames = false) {
        $smartAlbumList = SmartAlbum::ReadSmartAlbumFile();
        $smartAlbumArr = array();

        if (empty($smartAlbumList) || !is_array($smartAlbumList['smart_albums'])) {
            return $smartAlbumArr;
        }

        foreach ($smartAlbumList['smart_albums'] as $key => $item) {
            $item['name'] = (string)$key;
            $smartAlbum = $this->FormSmarAlbumItem($item);
            if (false === $smartNames) {
                array_push($smartAlbumArr, $smartAlbum);
                continue;
            }
            if ((false !== $smartNames) && (in_array($smartAlbum['name'], $smartNames))) {
                array_push($smartAlbumArr, $smartAlbum);
                continue;
            }
        }
        return $smartAlbumArr;
    }

    private function SortTitle_ASC($a, $b) {
        if ($a['name'] == $b['name']) {
            return 0;
        }
        return ($a['name'] < $b['name']) ? -1 : 1;
    }

    private function SortTitle_DESC($a, $b) {
        if ($a['name'] == $b['name']) {
            return 0;
        }
        return ($a['name'] > $b['name']) ? -1 : 1;
    }

    private function SortItem($smartAlbums, $sortBy, $sortDirection, $offset, $limit) {
        if ('title' ===$sortBy) {
            if ('asc' === $sortDirection) {
                usort($smartAlbums, 'self::SortTitle_ASC');
            } else {
                usort($smartAlbums, 'self::SortTitle_DESC');
            }
        }
        $cutItemSort = array();
        if (0 > (int)$limit) {
            $cutItemsSort = array_slice($smartAlbums, $offset);
        } else {
            $cutItemsSort = array_slice($smartAlbums, $offset, $limit);
        }
        return $cutItemsSort;
    }

    private function SmartAlbumList() {
        // Get and check params
        $params = array();
        $params = $this->GetParams_List();
        if (!$params) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // Get and form to webapi format
        $smart_albums = array();
        $smart_albums = $this->FormSmartAlbums();
        $total = count($smart_albums);

        // sort and set offset, limit
        $smartSort = array();
        $smartSort = $this->SortItem($smart_albums, $params['sort_by'], $params['sort_direction'], $params['offset'], $params['limit']);

        $resp['total'] = $total;
        $offset = (0 > $params['limit']) ? $resp['total'] : $params['offset'] + $params['limit'];
        $resp['offset'] = ($offset > $total) ?  $total : $offset;
        $resp['smart_albums'] = $smartSort;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function GetInfo() {
        // Get and check params
        $params = array();
        $params = $this->GetParams_Info();
        if (-1 === $params) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        } elseif (-2 === $params) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_NOT_EXIST);
            goto End;
        }

        // Get and form to webapi format
        $smartNames = array();
        foreach ($params['id'] as $id) {
            $smartName = @pack('H*', $id);
            array_push($smartNames, $smartName);
        }
        $smart_albums = $this->FormSmartAlbums($smartNames);

        $resp['smart_albums'] = $smart_albums;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Create() {
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (false === $isAdmin) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_ACCESS_DENY);
            goto End;
        }
        
        // check parameter
        if (false === ($params = $this->GetParams_Create())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // check tag_id exist
        if (is_array($params['people_tag']) && !$this->CheckTagExist($params['people_tag'], 0)) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_TAG_NOT_EXIST);
            goto End;
        }
        if (is_array($params['geo_tag']) && !$this->CheckTagExist($params['geo_tag'], 1)) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_TAG_NOT_EXIST);
            goto End;
        }
        if (is_array($params['desc_tag']) && !$this->CheckTagExist($params['desc_tag'], 2)) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_TAG_NOT_EXIST);
            goto End;
        }

        // add smart album
        $jsonRuleData = $this->ConvertToSmartCondition($params);
        $jsonRet = SmartAlbum::AddSmartAlbum($jsonRuleData);
        $ret = json_decode($jsonRet, true);
        if (false === $ret['success']) {
	    if ($ret["error"]["code"] == 103) {
		$this->SetError(PHOTOSTATION_SMARTALBUM_CREATE_FAIL_EXIST);
	    } else {
                $this->SetError(PHOTOSTATION_SMARTALBUM_CREATE_FAIL);
	    }
            goto End;
        }

        $resp['id'] = 'smart_'.bin2hex($params['name']);
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Edit() {
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (false === $isAdmin) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_ACCESS_DENY);
            goto End;
        }
        // get parameter
        $params = $this->GetPrams_Edit();
        if (-1 === $params) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        } elseif (-2 === $params) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_NOT_EXIST);
            goto End;
        }

        // check tag_id exist
        if (is_array($params['people_tag']) && !$this->CheckTagExist($params['people_tag'], 0)) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_TAG_NOT_EXIST);
            goto End;
        }
        if (is_array($params['geo_tag']) && !$this->CheckTagExist($params['geo_tag'], 1)) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_TAG_NOT_EXIST);
            goto End;
        }
        if (is_array($params['desc_tag']) && !$this->CheckTagExist($params['desc_tag'], 2)) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_TAG_NOT_EXIST);
            goto End;
        }

        // edit smart album
        $jsonRuleData = $this->ConvertToSmartCondition($params);
        $jsonRet = SmartAlbum::EditSmartAlbum($jsonRuleData);
        $ret = json_decode($jsonRet, true);
        if (empty($ret) || false === $ret['success']) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_EDIT_FAIL);
            goto End;
        }

        // category hook
        if ($params['name'] !== $params['orig_name']) {
            $newID = bin2hex($params['name']);
            $query = "UPDATE category_items SET smart_id='{$newID}' WHERE smart_id='{$params['id']}'";
            if (false === PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query)) {
                $this->SetError(PHOTOSTATION_SMARTALBUM_EDIT_FAIL);
                goto End;
            }
        }

        $resp['id'] = 'smart_'.bin2hex($params['name']);
        $this->SetResponse($resp);
    End:
        return;
    }
    
    private function Delete() {
        $isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
        if (false === $isAdmin) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_ACCESS_DENY);
            goto End;
        }
        // Get and check params
        $params = $this->GetParams_Info();
        if (-1 === $params) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        } elseif (-2 === $params) {
            $this->SetError(PHOTOSTATION_SMARTALBUM_NOT_EXIST);
            goto End;
        }

        // get smart album names
        $smartNames = array();
        foreach ($params['id'] as $id) {
            $smartName = @pack('H*', $id);
            array_push($smartNames, $smartName);
        }

        // delete
        foreach ($smartNames as $smartName) {
            $data['name'] = $smartName;
            $jsonData = json_encode($data);
            SmartAlbum::DeleteSmartAlbum($jsonData);

            // category hook
            $id = bin2hex($smartName);
            $query = "DELETE FROM category_items WHERE smart_id='{$id}'";
            PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        }



    End:
        return;
    }
}

$api = new SmartAlbumAPI();
$api->Run();

?>
