<?php
class WebAPIUtil {	
	static function Log($text = "", $file_name = "", $line = "0") {
		if ("" === $text) {
			return;
		}
		$file_name = basename($file_name);
		syslog(LOG_ERR, "$file_name:$line $text");
	}
	
	static function ParseToArray($string, $separator) {
		$result = array();	
		foreach (explode($separator, $string) as $element) {
			$trimmed = trim($element);
			if (!empty($trimmed)) {
				$result[] = $trimmed;
			}
		}
		
		return $result;
	}
	
	static function ParseAuthKey($authkey) {
		$auth_arr = json_decode(WebAPIUtil::Decrypt($authkey), true);
		$ret = false;

		if (null === $auth_arr) {
			goto End;
		}
		
		if (!isset($auth_arr['myds_id']) || !isset($auth_arr['app_id']) || !isset($auth_arr['time'])) {
			goto End;
		}
		
		$ret = $auth_arr;
		
	End:
		return $ret;
	}
	
	static function Encrypt($str) {
		// Charlie temp - wait to implement
		
		return base64_encode($str);
	}
	
	static function Decrypt($str) {
		// Charlie temp - wait to implement
		
		return base64_decode($str);
	}
}
?>
