<?php

class PhotoAPIUtil {
	static function getLabelIDConstraint($idList)
	{
		$ret = '';
		$ids = explode(',', $idList);
		$isFirst = true;
		foreach ($ids as $id) {
			$arr = explode('_', $id);
			if ('tag' !== $arr[0] || !is_numeric($arr[1])) {
				continue;
			}
			if (!$isFirst) {
				$ret .= " OR ";
			}
			$ret .= "label_id = $arr[1]";
			$isFirst = false;
		}
		return $ret;
	}

	static function getItemByPath($path, $additional, $type, $getRealPath)
	{
		if ($getRealPath) {
			if (false === ($path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $path))) {
				return false;
			}
		}

		$needExif = strstr($additional, 'photo_exif') ? true : false;
		$needCodec = strstr($additional, 'video_codec') ? true : false;
		$needQuality = strstr($additional, 'video_quality') ? true : false;
		$needThumbSize = strstr($additional, 'thumb_size') ? true : false;

		$item = null;
		if ('photo' === $type) {
			$row = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($path);
			if (false === $row) {
				return false;
			}
			$obj = null;
			$obj['name'] = $row['name'];
			$obj['title'] = $row['title'];
			$obj['createdate'] = $row['create_time'];
			$obj['size'] = $row['size'];
			$obj['takendate'] = $row['timetaken'];
			$obj['resolutionx'] = $row['resolutionx'];
			$obj['resolutiony'] = $row['resolutiony'];
			$obj['description'] = $row['description'];
			$obj['rotated'] = (0 === (int)$row['version'] %2) ? false : true;
			$obj['rotate_version'] = (int)$row['version'];

			/* set photo exif if required */
			if ($needExif) {
				$addObj = null;
				$addObj['takendate'] = $row['timetaken'];
				$addObj['camera'] = $row['camera_make'];
				$addObj['camera_model'] = $row['camera_model'];
				$addObj['exposure'] = $row['exposure'];
				$addObj['aperture'] = $row['aperture'];
				$addObj['iso'] = $row['iso'];
				$addObj['gps'] = json_decode($row['gps'], true);
				$addObj['version'] = $row['version'];
				$item['additional']['photo_exif'] = $addObj;
			}

			$orig_resolutionx = $row['resolutionx'];
			$orig_resolutiony = $row['resolutiony'];
			$blThumbRotated = (0 === (int)$row['version'] %2) ? false : true;
			$blCalculateThumbByOrig = true;

		} elseif ('video' === $type) {
			$row = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($path);
			if (false === $row) {
				return false;
			}
			$title_desc = csSYNOPhotoDB::GetDBInstance()->GetVideoCustomizedTitleDescription($path);

			$obj = null;
			$obj['name'] = basename($path);
			$obj['createdate'] = $row['date'];
			$obj['takendate'] = $row['mdate'];
			$obj['size'] = $row['filesize'];
			$obj['title'] = empty($title_desc['title']) ? $row['title'] : $title_desc['title'];
			$obj['description'] = $title_desc['description'];
			$obj['duration'] = $row['duration'];
            $obj['gps'] = json_decode($row['gps']);

			/* set video codec if required */
			if ($needCodec) {
				$addObj = null;
				$addObj['container'] = $row['container_type'];
				$addObj['vcodec'] = $row['video_codec'];
				$addObj['acodec'] = $row['audio_codec'];
				$addObj['resolutionx'] = $row['resolutionx'];
				$addObj['resolutiony'] = $row['resolutiony'];
				$addObj['frame_bitrate'] = $row['frame_bitrate'];
				$addObj['video_bitrate'] = $row['video_bitrate'];
				$addObj['audio_bitrate'] = $row['audio_bitrate'];
				$item['additional']['video_codec'] = $addObj;
			}
			/* set video quality if required */
			if ($needQuality) {
				$item['additional']['video_quality'] = AlbumAPIUtil::GetConvertedVideoInfo($path);
			}

			$orig_resolutionx = $row['resolutionx'];
			$orig_resolutiony = $row['resolutiony'];
			$blThumbRotated = false;
			$blCalculateThumbByOrig = true;
		}

		$thumbnail = AlbumAPIUtil::GetThumbStatus($path, $needThumbSize, $blCalculateThumbByOrig, $orig_resolutionx, $orig_resolutiony, $blThumbRotated);
		$item['thumbnail_status'] = $thumbnail['status'];
		if ($needThumbSize) {
			$item['additional']['thumb_size'] = $thumbnail['size'];
		}

        if (SYNOPHOTO_SERVICE_REAL_DIR === dirname($path)) {
            $item['id'] = $type . '_' . bin2hex('/') . '_' . bin2hex(basename($path));
        } else {
            $dir = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1, strrpos($path, '/') - strlen(SYNOPHOTO_SERVICE_REAL_DIR) - 1);
            $item['id'] = $type . '_' . bin2hex($dir) . '_' . bin2hex(basename($path));
        }
		$item['type'] = $type;
		$item['info'] = $obj;
		return $item;
	}
}

?>
