<?php

require_once('auth.inc.php');

class AuthAPIUtil {

    static function SYNOPHOTO_LOGIN_USERDATA_PARSER($pUser)
    {
        global $SYNOPHOTO_DSM_USER_INFO;
        $result = array();
        if (!is_array($pUser)) {
            return null;
        }
        $i = 0;
		$groups = array();
        foreach ($pUser as $item) {
			if (preg_match('/\((\d+)\)/', $item, $match)) {
				$groups[] = $match[1];
			}

            if (!preg_match('/(^\w+\s?\w+)\s*\:/', $item, $match) || !preg_match('/\[(.*)\]/', $item, $match_val)) {
                continue;
            }

            if (false !== $index = array_search($match[1], $SYNOPHOTO_DSM_USER_INFO)) { // $key = 2;
                $result[$index] = $match_val[1];
            }
        }
		$result['groups'] = implode(',', $groups);
        return $result;
    }

    static function SYNOPHOTO_LOGIN_AddLog($username, $success)
    {
        $ip = $_SERVER['REMOTE_ADDR'];
        $conf = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, 'enable_demomode');
        if ('yes' == $conf['enable_demomode']) {
            $ip = 'xxx.xxx.xxx.xxx';
        }

        if ($success) {
            csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($username." logged in from "."[".$ip."]", "t", strtolower($username));
            return;
        }
        csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($username." failed to login from "."[".$ip."]", "f", strtolower($username));
    }

    /*
     *  return
     *    1 - success
     *    0 - fail
     */
    static function SYNOPHOTO_LOGIN_ValidateAdmin()
    {
        $user = ('root' == SYNOPHOTO_ADMIN_USER)? 'admin':SYNOPHOTO_ADMIN_NAME;
        $command = "/usr/syno/bin/synoauth ".escapeshellarg($user)." ".escapeshellarg($_REQUEST['password']);
        @exec($command, $pAuth, $retval);

        if (0 == $retval) {
            unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
            session_start();

            csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
            $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
            self::SYNOPHOTO_LOGIN_AddLog($_REQUEST['username'], true);
            return 1;
        }
        self::SYNOPHOTO_LOGIN_AddLog($_REQUEST['username'], false);
        return 0;
    }

    /*
     *  return
     *    1 - success
     *    0 - fail
     */
    static function SYNOPHOTO_LOGIN_ValidateDsmUser()
    {
        $command = "/usr/syno/bin/synophoto_dsm_user --auth ".escapeshellarg($_REQUEST['username'])." ".escapeshellarg($_REQUEST['password']);
        @exec($command, $pAuth, $auth_retval);

        $user_info = array();
        if (0 == $auth_retval) {
            $command = "/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($_REQUEST['username']);
            @exec($command, $pUser, $retval);
            $user_info = self::SYNOPHOTO_LOGIN_USERDATA_PARSER($pUser);
        } else {
            self::SYNOPHOTO_LOGIN_AddLog($_REQUEST['username'], false);
            return 0;
        }

        if ($user_info) {
            unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
            session_start();

            csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
            $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = $user_info[2];
            $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $user_info[0];
            $_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] = true;
			$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = $user_info['groups'];

            if ($user_info[10]) {
                $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
            }
            self::SYNOPHOTO_LOGIN_AddLog($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'], true);
            return 1;
        }
        self::SYNOPHOTO_LOGIN_AddLog($_REQUEST['username'], false);
        return 0;
    }

    /*
     * return 
     *   1 - success
     *   0 - fail
     *  -1 - disable user
     *  -2 - not photo station user
     */
    static function SYNOPHOTO_LOGIN_ValidateUser()
    {
        $escape = PHOTO_DB_GetEscape();
        $query_usr = "Select count(*) from photo_user where lower(username) like ? $escape";
        $sqlParam = array(PHOTO_DB_EscapForLike(strtolower($_REQUEST['username'])));
        $count = PHOTO_DB_QueryCount($GLOBALS['dbconn_photo'], $query_usr, $sqlParam);

        if ($count == 0) {
            // user is not photo station user
            return -2;
        }

        $query = "Select * from photo_user where lower(username) like ? $escape and password = '".md5($_REQUEST['password'])."'";
        $sqlParam = array(PHOTO_DB_EscapForLike(strtolower($_REQUEST['username'])));
        $result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

        $user_info = PHOTO_DB_FetchRow($result);
        if ($user_info) {
            if(PHOTO_DB_ConvertBool($user_info[4]) == 't') {
                //disabled
                return -1;
            }

            unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
            session_start();

            csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
            $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = $user_info[0];
            $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $user_info[1];
            $_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] = false;

			/* set user's belonging groups */
			$query = "SELECT groupid FROM " . PHOTO_USER_GROUP_TABLE . " WHERE userid = $user_info[0]";
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = '';
			$groups = array();
			while ($row = PHOTO_DB_FetchRow($db_result)) {
				$groups[] = $row['groupid'];
			}
			$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = implode(',', $groups);

            if (PHOTO_DB_ConvertBool($user_info[6]) == 't') {
                $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
            }
            self::SYNOPHOTO_LOGIN_AddLog($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'], true);
            return 1;
        }
        self::SYNOPHOTO_LOGIN_AddLog($_REQUEST['username'], false);
        return 0;
    }

	static function SYNOPHOTO_LOGIN_UpdateUserGroupSession($username) {
		if (null == $username) {
			return;
		}
		if ("0" == $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['global']['account_system'] || 'root' != SYNOPHOTO_ADMIN_USER){
			$query = "SELECT groupid FROM photo_user_group WHERE userid = (SELECT userid FROM photo_user WHERE username = '$username')";
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = '';
			$groups = array();
			while ($row = PHOTO_DB_FetchRow($db_result)) {
				$groups[] = $row['groupid'];
			}
			$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = implode(',', $groups);
		} else {
			$command = "/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($username);
			@exec($command, $pUser, $retval);
			$user_info = self::SYNOPHOTO_LOGIN_USERDATA_PARSER($pUser);
			if ($user_info) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_groupid'] = $user_info['groups'];
			}
		}
	}
}

?>

