<?php
require_once('synophoto_mobile_csDBCacher.php');
/*!
 * database operation
 */
class csSYNOPhotoDB {
	/*! cache life time (seconds)*/
	public $CACHE_LIFETIME = 300;
	/*! db connection handler */
	public $_dbh;
	/*! db escape string for like */
	public $escapeStr = '';
	public $db_type = '';
	public static $current_admin = '';
	/*! db cacher handler */
	private $_dbCacher;
	/*! reference to a self instance */
	private static $instance = null;
	/*!
	 * Constructor
	 */
	function __construct()
	{
		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			$user = substr(urldecode($matches[0]), 2);
			$user_photo_db = "/var/services/homes/{$user}/photo/.SYNOPPSDB";
			if(!file_exists($user_photo_db)){
				header('Location: /photo/report.php?msgkey=photo_str_service_disabled');
				exit;
			}
			try{
				$this->_dbh = new PDO("sqlite:{$user_photo_db}");
				$this->_dbh->exec('PRAGMA case_sensitive_like=1');
				$this->escapeStr = " ESCAPE '\'";
				self::$current_admin = $user;
			} catch (PDOException $e) {
				die($e->getMessage());
			}
		} else{
			self::$current_admin = 'root';
			try{
				$this->_dbh = new PDO('pgsql:dbname=photo', 'admin', '', array(PDO::ATTR_PERSISTENT => true, PDO::ATTR_EMULATE_PREPARES => true) );
			} catch (PDOException $e){
				die($e->getMessage());
			}
		}

		$this->db_type = $this->_dbh->getAttribute(constant("PDO::ATTR_DRIVER_NAME"));

		$this->_dbCacher = new DBCacher($this->_dbh, self::$current_admin);
		$this->SetSessionCache(false);
		$this->SetSessionSystemConfigsFromFile();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'] = array();
	}
	/*!
	 * close db connection
	 */
	function __destruct()
	{
		$this->_dbh = null;
	}
	/*!
	 * Get a exist instance
	 */
	static function GetDBInstance()
	{
		$admin_name = preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches) ? substr(urldecode($matches[0]), 2) : 'root';

		if (null === self::$instance || $admin_name != self::$current_admin) {
			self::$instance = null;
			self::$instance = new self;
			self::$current_admin = $admin_name;
		}
		return self::$instance;
	}
	/*!
	 * convert db bool colum to bool value
	 *
	 * \param $param db colum value
	 * \return bool value
	 */
	private function ConvertAsBool($param) {
		return ($param === true || $param === 't');
	}
	/*!
	 * escape string for like/ilike sql op
	 * \param $param string to escape
	 * \return escaped string
	 */
	static function EscapeLikeParam($param)
	{
		$param = str_replace('\\', '\\\\', $param);
		$param = str_replace('_', '\\_', $param);
		$param = str_replace('%', '\\%', $param);
		return $param;
	}
	/*!
	 * dump photo_config scheme from db
	 *
	 * \return array with data from scheme 'photo_config'
	 */
	private function GetConfigsFromDB()
	{
		$query = 'SELECT * FROM photo_config';
		$dbResult = $this->_dbh->query($query);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Get accessible album list from db
	 *
	 * \param $userID logined username
	 * \param $noRightCheck true for get all albums
	 * \return array with data from scheme 'photo_share'
	 */
	private function GetAlbumsFromDB($userID, $noRightCheck)
	{
		$sqlParam = array();
		$sqlParamCount = 0;
		/* prepare permission condition */
		$permConditionClause = '';
		if (!$noRightCheck) {
			$permConditionClause = "public='t' OR password <> ''";
			if (!empty($userID)) {
				$access_right_table = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['use_DSM_account'])?'photo_access_right_for_dsm_account':'photo_access_right';
				$permConditionClause .= ' OR shareid IN (SELECT shareid FROM '.$access_right_table.' WHERE userid=?)';
				$sqlParam[$sqlParamCount++] = $userID;
			}
		}

		/* query first level albums */
		$whereClause = "WHERE is_subdir='f'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$rootAlbums = $dbResult->fetchAll();
		if (false === $rootAlbums) {
			return array();
		}

		/* query second level albums accroding to accessible first level albums */
		$secondLevelAlbums = array();
		$whereClause = "WHERE is_subdir='t' AND sharename NOT LIKE '%/%/%'";
		if (strlen($permConditionClause)) {
			/* sql param already append to $sqlParam */
			$whereClause .= " AND ({$permConditionClause})";
		}
		$whereClause .=  " AND sharename LIKE ? {$this->escapeStr}";
		$query = "SELECT * FROM photo_share {$whereClause} ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		foreach ($rootAlbums as $key => $item) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::IsSkipPhotoPath(SYNOPHOTO_SERVICE_DIR.'/'.$item['sharename'])) {
				unset($rootAlbums[$key]);
				continue;
			}

			$item['sharename'] = self::EscapeLikeParam($item['sharename']);
			$sqlParam[$sqlParamCount] = "{$item['sharename']}/%";
			$dbResult->execute($sqlParam);
			$result = $dbResult->fetchAll();
			if (false !== $result) {
				// skip photo in remote mount (cifs) or read-only mount (iso9660)
				foreach ($result as $key => $item) {
					if (csSYNOPhotoMisc::IsSkipPhotoPath(SYNOPHOTO_SERVICE_DIR.'/'.$item['sharename'])) {
						unset($result[$key]);
					}
				}
				$secondLevelAlbums = array_merge($secondLevelAlbums, $result);
			}
		}

		$result = array_merge($rootAlbums, $secondLevelAlbums);
		$query = "SELECT * FROM photo_share where password <> '' and is_subdir = 't' AND sharename NOT LIKE '%/%/%' ORDER BY sharename ASC";
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$passwordAlbums = $dbResult->fetchAll();
		foreach ($passwordAlbums as $item) {
			if (!in_array($item, $result)) {
				$result[] = $item;
			}
		}
		return $result;
	}
	/*!
	 * Get parsed config from file
	 *
	 * \param $cfgFile config file
	 * \return array with parsed data
	 *	- key = 'value' will parse into $result['key'] = value
	 */
	private function GetConfigFile($cfgFile)
	{
		preg_match_all('/^\s*(runpersonalphotostation|language|supplang|enable_demomode|buildnumber)\s*=\s*("|\')(.+)("|\')/m', file_get_contents($cfgFile), $matches, PREG_SET_ORDER);
		$result = array();
		foreach ($matches as $item) {
			$result[$item[1]] = $item[3];
		}
		return $result;
	}
	/*!
	 * Cache system config files in session data
	 */
	private function SetSessionSystemConfigsFromFile()
	{
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg'] = $this->GetConfigFile(SYNO_CNF_FILE);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg'] = $this->GetConfigFile(SYNO_DEF_CNF_FILE);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg'] = $this->GetConfigFile(SYNO_PKG_CNF_FILE, $requiredConfKeys);
		$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['dsmCfg']['buildnumber'] = $this->GetConfigFile(SYNO_DEF_VERSION_FILE, 'buildnumber');
		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			$command = '/usr/syno/bin/synogetkeyvalue '.escapeshellarg(SYNO_PERSONAL_CNF_FILE).' runpersonalphotostation';
			$ret = @exec($command);
			$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation'] = $ret;
		}
	}
	/*!
	 * Cache album/photo sort type/order in session data
	 * \param $sortType sort type
	 *	- 1: by taken time
	 *	- 2: by create time
	 *	- default: by name
	 * \param $sortOrder sort order
	 *	- 1: descending  sort
	 *	- default: ascending sort
	 */
	private function SetSessionSortMethod($sortType, $sortOrder)
	{
		switch ($sortType) {
			case '1':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'timetaken';
				break;
			case '2':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'create_time';
				break;
			default:
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] = 'name';
		}

		switch ($sortOrder) {
			case '1':
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] = 'desc';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_front'] = '>';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_back'] = '<';
				break;
			default:
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] = 'asc';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_front'] = '<';
				$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_operator_back'] = '>';
		}
	}
	/*!
	 * cache frequent access data
	 *
	 * \param $isForced force to refresh cache or not
	 */
	function SetSessionCache($isForced = false)
	{
		/*
		 * accessible_album, accessible_subdir: accessible level 1,2 albums.
		 * accessed_albums: set by AddHitTimes(), accessed albums
		 * photoNum_cache[albumName]: set by GetNumberOfPhotos(), the number of accessed albums' photos
		 * albumCover_cache[albumName]: set by GetAlbumCoverLatestUpload(), the cover of albums
		 * search_result[searchToken]: the photos' db records for searched result
		 * list_cache[albumName]: the browsed thumb list (including subdir and photos)
		 * **function controlled** photo_config[key]=value: set by GetConfigsFromDB() in GetConfig() on demand, photo_config scheme from DB
		 * **reset each load** system_config[key]=value: set by SetSessionSystemConfigsFromFile(), from /etc[.default]/synoinfo.conf
		 */

		/* ensure every cache container is exist */
		$sessionInitField = array('accessible_album', 'accessible_subdir', 'photo_config', 'list_cache',
								  'search_result', 'system_config', 'accessed_albums', 'photoNum_cache',
								  'albumCover_cache');
		foreach ($sessionInitField as $field) {
			if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER][$field])) {
				$_SESSION[SYNOPHOTO_ADMIN_USER][$field] = array();
			}
		}

		/* compatible for desktop edition */
		if (!count($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']) || !is_array($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][array_rand($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'])])) {
			$isForced = true;
		}

		/* cache still fresh */
		if (!$isForced && isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp'] > (time() - $this->CACHE_LIFETIME)) {
			return;
		}

		/* flush non-function controlled cache */
		$sessionStaleField = array('accessible_album', 'accessible_subdir', 'photoNum_cache', 'albumCover_cache', 'list_cache');
		foreach ($sessionStaleField as $field) {
			$_SESSION[SYNOPHOTO_ADMIN_USER][$field] = array();
		}

		/* cache accessible albums/sub-albums */
		$userID = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) ? $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] : '';
		$isAdmin = isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
		$albums = $this->GetAlbumsFromDB($userID, $isAdmin);

		foreach ($albums as $item) {
			if ('t' == $item['is_subdir'] || true === $item['is_subdir']) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$item['sharename']] = $item;
			} else {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$item['sharename']] = $item;
			}
			if ($item['password'] && $isAdmin) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$item['sharename']] = $item['password'];
			}
		}

		/* set sort property */
		$this->SetSessionSortMethod($this->GetConfig('album', 'thumb_sort_type'),
									$this->GetConfig('album', 'thumb_sort_order'));
		$_SESSION[SYNOPHOTO_ADMIN_USER]['timestamp'] = time();
	}
	/*!
	 * Check user exist in db or not
	 *
	 * \param $userId username
	 * \return true for exist
	 */
	function CheckUserExist($userId)
	{
		$accountSystem = $this->GetConfig('global', 'account_system');
		if (SYNOPHOTO_DSM_ACCOUNT == $accountSystem ) {
			//use DSM account
			exec("/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($userId), $results, $retval);
			$exist = !$retval;
		} else {
			$query = 'SELECT count(*) FROM photo_user WHERE username=?';
			$sqlParam = array($userId);
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
			$row = $dbResult->fetch();
			$exist = (0 < $row[0]);
		}
		return $exist;
	}
	/*!
	 * check album accessible or not
	 *
	 * \param $albumName album name
	 * \param $password  album password
	 * \return true or error result
	 */
	function CheckAlbumAccessible($albumName, $password)
	{
		$albumToken = explode('/', $albumName);
		if (2 < count($albumToken)) {
			$albumName = "{$albumToken[0]}/{$albumToken[1]}";
		}

		$albumItem = null;
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
			$albumItem = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName];
		} else if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
			$albumItem = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName];
		}

		if (!$albumItem) {
			return "error_no_permission";
		}

		/* public album under password protected album */
		$albumParentItem = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumToken[0]];
		if ($albumParentItem['password'] && $this->ConvertAsBool($albumItem['public'])) {
			$albumItem = $albumParentItem;
		}

		/* non password protected album or previous successed */
		if (!$albumItem['password'] ||
			$albumItem['password'] == $_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumItem['sharename']]) {
			return true;
		}

		/* check password */
		if ($albumItem['password']) {
			if ('' == $password) {
				return 'error_need_album_password';
			}
			$password = md5($password);
			if ($password == $albumItem['password']) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumItem['sharename']] = $password;
				return true;
			}
			return 'error_invalid_album_password';
		}

		return true;
	}
	/*!
	 * check image path is accessible (in private or password protected album)
	 *
	 * \param $path image path
	 * \return true or error result
	 */
	function CheckPathAccessible($path)
	{
		$file_name = basename($path);
		$dir = substr($path, 0, strlen($path) - strlen($file_name) - 1);
		$dir = substr($dir, strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1);
		return $this->CheckAlbumAccessible($dir, '');
	}
	/*!
	 * validate username and password, and then return user info
	 *
	 * \param $username username
	 * \param $password password
	 * \return false when validate failed, otherwise data from scheme 'photo_user'
	 */
	function GetValidateUserInfo($username, $password)
	{
		$query = 'SELECT * FROM photo_user WHERE lower(username)=? AND password=?';
		$sqlParam = array(strtolower($username), md5(addslashes($password)));
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$userInfo = $dbResult->fetch();
		return $userInfo; // false when no matched
	}
	/*!
	 * Validate admin password
	 *
	 * \param $password password
	 * \return the password passed or not
	 */
	function ValidateAdminPassword($password, $user)
	{
		$admin_user = ('root' == $user)? 'admin':$user;
		@system("/usr/syno/bin/synoauth ".escapeshellarg($admin_user)." ".escapeshellarg($_POST['passwd']), $retval);
		return !$retval;
	}
	/*!
	 * Get config value from scheme 'photo_config'
	 *
	 * \param $moduleName module/section name
	 * \param $configKey key name
	 * \return config value
	 */
	function GetConfig($moduleName, $configKey)
	{
        /* cache db scheme on demand */
		if (0 == count($_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'])) {
			$configs = $this->GetConfigsFromDB();
			foreach ($configs as $item) {
				$_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'][$item['module_name']][$item['config_key']] = $item['config_value'];
			}
		}
		$item = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config'];
		if (isSet($item[$moduleName]) && ($item = $item[$moduleName]) && isSet($item[$configKey])) {
			return $item[$configKey];
		}
		return NULL;
	}
	/*!
	 * Get # of comments for specified photo
	 *
	 * \param $photoId photo id in db
	 * \return # of comments
	 */
	function GetNumberOfComments($photoId)
	{
		$query = 'SELECT count(*) FROM photo_comment WHERE photo_id=?';
		$sqlParam = array($photoId);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$row = $dbResult->fetch();
		return $row[0];
	}
	/*!
	 * Get comments for specified photo
	 *
	 * \param $photoId photo id in db
	 * \param $offset # of comments to skip
	 * \param $limit # of comments to get
	 * \return array with data from scheme 'photo_comment'
	 */
	function GetPhotoComments($photoId, $offset = 0, $limit = 'ALL')
	{
		if ('ALL' == $limit && 'sqlite' == $this->db_type) {
			$limit = -1;//for sqlite, limit < 0 is equal to no limit
		}

		$query = "SELECT * FROM photo_comment WHERE photo_id=? ORDER BY date desc LIMIT {$limit} OFFSET {$offset}";
		$sqlParam = array($photoId);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		$result = $dbResult->fetchAll();
		if (false === $result) {
			return array();
		}
		return $result;
	}
	/*!
	 * Get photo info for specified path
	 *
	 * \param $photoPath photo full path
	 * \return array with data from scheme 'photo_image'
	 */
	function GetPhotoInfo($photoPath)
	{
		$dPath = substr($photoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
		/* search db cacher */
		foreach($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID] as $cacheTuple) {
			if (!is_array($cacheTuple[DBCACHER_TUPLE_DATA])) {
				continue;
			}
			foreach ($cacheTuple[DBCACHER_TUPLE_DATA] as $dbTuple) {
				if ($dPath == $dbTuple['path']) {
					$dbTuple['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$dbTuple['path'];
					return $dbTuple;
				}
			}
		}

		/* not found in cache */
		$query = "SELECT * FROM photo_image WHERE path=?";
		$sqlParam = array($dPath);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
		if ($row = $dbResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		}
		return $row;
	}
	/*!
	 * Prepare album photos DB Cache for future use
	 *
	 * \param $albumName alubm name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareAlbumPhotos($albumName, $offset, $limit)
	{
		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT * FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		return $this->_dbCacher->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Prepare searched photos DB Cache for future use
	 *
	 * \param $cacheToken search token
	 * \param $offset # of photos to skip
	 * \param $length # of photos to prepare
	 * \return prepared db data from scheme 'photo_image'
	 */
	function PrepareSearchPhotos($cacheToken, $offset, $limit)
	{
        if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken])) {
			return;
		}
		$query = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken]['statement'];
		$sqlParam = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken]['param'];
		return $this->_dbCacher->CacheQuery($query, $sqlParam, $offset, $limit);
	}
	/*!
	 * Get photo name list for specified album
	 *
	 * \param $albumName alubm name
	 * \return array with name list
	 */
	function GetAlbumPhotoList($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName];
		}

		$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$query = "SELECT name FROM photo_image WHERE path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr} ORDER BY {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type']} {$_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order']}";
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$list = array();
		while (false !== ($row = $dbResult->fetch())) {
			$list[] = $row[0];
		}

		$_SESSION[SYNOPHOTO_ADMIN_USER]['list_cache'][$albumName] = $list;
		return $list;
	}
	/*!
	 * Search photos by conditions, and store result in cache
	 *
	 * \param $moreCond array with search conditions, key as the field name
	 * \return the token of cache store search result
	 */
	function GetSearchToken($moreCond = array())
	{
		$cacheToken = md5(implode('_',$moreCond));
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken])) {
			return $cacheToken;
		}

		$sqlParam = array();

		/* prepare album condition */
		$albumCond = array();
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'] as $item) {
			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "(path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
			$sqlParam[] = "{$albumRealPath}/%";
			$sqlParam[] = "{$albumRealPath}/%/%";
		}
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
			$albumRealPath = self::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "path LIKE ? {$this->escapeStr} ";
			$sqlParam[] = "{$albumRealPath}/%";
		}

		/* prepare photo condition */
		$photoCond = array();
		foreach ($moreCond as $key => $value) {
			$value = self::EscapeLikeParam(strtolower($value));
			$photoCond[] = "lower({$key}) LIKE ? {$this->escapeStr} ";
			$sqlParam[] = "%{$value}%";
		}

		$result = array();
		/* make sure condition exist */
		if (count($albumCond) && count($photoCond)) {
			$albumCond = implode(' OR ', $albumCond);
			$photoCond = implode(' OR ', $photoCond);
			$cacheQuery = "SELECT * FROM photo_image WHERE ({$albumCond}) AND ({$photoCond})";
			$query = "SELECT path FROM photo_image WHERE ({$albumCond}) AND ({$photoCond})";
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);

			while (false !== ($row = $dbResult->fetch())) {
				$result[] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
			}
		} else {
			$cacheQuery = '';
			$sqlParam = array();
		}

		/* keep only the latest search result */
		$_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'] = array();
		$_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$cacheToken] = array('statement' => $cacheQuery,
														'param' => $sqlParam,
														'result' => $result);
		return $cacheToken;
	}
	/*!
	 * Get album info by name
	 *
	 * \param $albumName album name
	 * \return array with data from scheme 'photo_share'
	 */
	function GetAlbum($albumName)
	{
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName];
		}
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName];
		}
		return false;
	}
	/*!
	 * Get albums by conditions
	 *
	 * \param $moreCond array with search conditions, key as the field name
	 * \param $isORCond conditions in $moreCond is concatenate by 'OR' or not
	 * \return array with data from scheme 'photo_share'
	 */
	function GetAlbums($moreCond = array(), $isORCond = false)
	{
		$searchPool = $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'];
		if (!isSet($moreCond['is-subdir']) || 'f' == $moreCond['is-subdir'] || false === $moreCond['is-subdir']) {
			$searchPool = array_merge($searchPool, $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir']);
		}
		if (isSet($moreCond['is-subdir'])) {
			unset($moreCond['is-subdir']);
		}
		$result = array();
		foreach ($searchPool as $albumName => $item) {
			$condMatch = array();
			foreach ($moreCond as $key => $value) {
				if (!is_array($value)) {
					$value = array('op' => '=', 'value' => $value);
				}
				$op = strtoupper($value['op']);
				$value = strtoupper($value['value']);
				switch ($op) {
					case '=':
						$condMatch[] = ($value == strtoupper($item[$key]));
						break;
					case 'PREFIX':
						$condMatch[] = ($value == strtoupper(substr($item[$key], 0, strlen($value))));
						break;
					case 'MIDDLE':
						$condMatch[] = (false !== stristr($item[$key], $value));
						break;
					default: // not supported
						$condMatch[] = false;
				}
			}
			$match = $isORCond ? false !== array_search(true, $condMatch, true) : false === array_search(false, $condMatch, true);
			if ($match) {
				$result[] = $item;
			}
		}
		return $result;
	}
	/*!
	 * purge stale log accroding to #SYNOPHOTO_MAX_LOG_TO_KEEP
	 *
	 * \return the logid can be used to insert new record
	 */
	private function PurgePhotoLog()
	{
		$query = 'SELECT count(logid) FROM photo_log';
		$dbResult = $this->_dbh->query($query);
		$logRec = $dbResult->fetch();
		/* purge stale log record */
		if ($logRec[0] >= SYNOPHOTO_MAX_LOG_TO_KEEP) {
			$query =  'SELECT create_time FROM photo_log ORDER BY create_time DESC  LIMIT 1 OFFSET '.SYNOPHOTO_REC_TO_DEL;
			$dbResult = $this->_dbh->query($query);
			$truncateLog = $dbResult->fetch();
			$query = "DELETE FROM photo_log WHERE create_time < '{$truncateLog[0]}'";
			$this->_dbh->query($query);
		}
		$query = 'SELECT max(logid) FROM photo_log';
		$dbResult = $this->_dbh->query($query);
		$maxLogId = $dbResult->fetch();
		/* rotate to 1 if > PHP_INT_MAX (2147483647) */
		$maxLogId = $maxLogId[0] >= PHP_INT_MAX ? 1 : $maxLogId[0] + 1;
		return $maxLogId;
	}
	/*!
	 * Add a new log record to db
	 *
	 * \param $msg message string to record
	 * \param $isError this log is for error occurred
	 * \param $user logined username
	 */
	function AddPhotoLog($msg, $isError, $user)
	{
		$isError = $isError ? 't' : 'f';
		$logId = $this->PurgePhotoLog();
		$query = 'INSERT INTO photo_log VALUES(?, ?, ?, ?, ?)';
		$sqlParam = array($logId, date('Y-m-d H:i:s'), $msg, $isError, $user);
		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);
	}
	/*!
	 * Get language to use by system config
	 *
	 * \return ### format language region code
	 */
	function GetLanguage()
	{
        /* use user-defined language */
		if ('1' == $this->GetConfig('global', 'lang_setting') &&
			'def' != ($lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['language']) ) {
			return $lang;
		}
		/* use browser default */
		$matches = array();
		if (isSet($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			preg_match_all('/([-a-z]+)(;q=([\.0-9]+))?/', strtolower(trim($_SERVER['HTTP_ACCEPT_LANGUAGE'])), $matches, PREG_SET_ORDER);
		}
		$acceptLang = array();
		foreach ($matches as $item) {
			$qvalue = isSet($item[3]) ? $item[3] : 1;
			$acceptLang[$qvalue] = $item[1];
		}
		unset($matches);
		/* sort by qvalue (ref. RFC 2616) */
		krsort($acceptLang, SORT_NUMERIC);
		foreach ($acceptLang as $lang) {
			if (false !== ($lang = csSYNOPhotoMisc::GetMappedLanguage($lang)) &&
				false !== stripos($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg']['supplang'], $lang)) {
				return $lang;
			}
		}

		return 'enu';
	}

	/*!
	 * Get userid from DSM account
	 *
	 * \param $user DSM user name
	 * \return userid for given DSM user, retuen false if the userid can not be found
	 */
	function GetDSMUserID($dsm_user)
	{
		$dsm_uid = false;
		@exec("/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($dsm_user)."|grep 'User uid'", $results, $retval);
		if (!$retval) {
			$uid_Info = explode(']', $results[0]);
			$uid_Tokens = explode('[', $uid_Info[0]);
			$dsm_uid = (count($uid_Tokens) > 1)?$uid_Tokens[1]:false;
		}
		return $dsm_uid;
	}

	/*!
	 * Check DSM account is admin group
	 *
	 * \param $dsm_user DSM user name
	 * \return true if the user is one of the admin group.
	 */
	function IsDSMAdmin($dsm_user)
	{
		$isAdmin = false;
		@exec("/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($dsm_user)."|grep 'AdminGroup'", $results, $retval);
		if (!$retval) {
			$token = explode(']', $results[0]);
			$token = explode('[', $token[0]);
			$isAdmin = (count($token) > 1 && 1 == $token[1]);
		}
		return $isAdmin;
	}
}
?>
