<?php
require_once('../include/synophoto_mobile_conf.php');

$albumName = @pack('H*', $_GET['dir']);
$password = $_GET['password'];
$checkResult = csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($albumName, $password);

if (true !== $checkResult) {
	switch ($checkResult) {
		case "error_need_album_password":
			echo json_encode(array(
				'error' => $checkResult,
				'confirm' => __('photo_str_password_protected')
			));
			break;
		case "error_invalid_album_password":
			echo json_encode(array(
				'error' => $checkResult,
				'confirm' => __('photo_str_password_error')
			));
			break;
		case "error_no_permission":
		default:
			header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/m/");
	}
	exit;
}

if (empty($_GET['name'])) {
	header("Location: {SYNOPHOTO_URL_PREFIX}/photo/m/");
	exit;
}

$photoName = @pack('H*', $_GET['name']);
if (isSet($_GET['searchToken']) && ($searchToken = $_GET['searchToken']) ) { // from search results
	if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$searchToken])) {
		header("Location: {SYNOPHOTO_URL_PREFIX}/photo/m/");
		exit;
	}
	$albumPhotoNum = count($_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$searchToken]['result']);
	$photoView = csSYNOPhotoThumb::GetThumbInstance()->GetSearchPhotoView($searchToken, $albumName, $photoName);
} else {
	$albumPhotoNum = csSYNOPhotoAlbum::GetAlbumInstance()->GetNumberOfPhotos($albumName, false);
	$photoView = csSYNOPhotoThumb::GetThumbInstance()->GetAlbumPhotoView($albumName, $photoName);
}
$photoView['numberOfPhotos'] = $albumPhotoNum;
echo json_encode($photoView);
?>
