<?php
require_once("include/syno_conf.php");

// force clear cache when user refresh browser
csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

$DSM_VERSION = csSYNOPhotoMisc::GetDsmVersion();
$PACKAGE_VERSION = csSYNOPhotoMisc::GetPackageVersion();
$LANGUEGE = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$DEBUG = isset($_GET['jsDebug']);
$PAGE_TITLE = csSYNOPhotoMisc::GetConfigDB("photo", "photo_page_title", "photo_config");
if (empty($PAGE_TITLE)) {
	$PAGE_TITLE = "Photo Station 6";
}
$PAGE_TITLE = htmlentities($PAGE_TITLE);
$blDemoMode = 'false';
$isDemoMode = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, 'enable_demomode');
if ('yes' === $isDemoMode['enable_demomode']) {
    $blDemoMode = 'true';
}
$photo_config_theme = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['theme'];
$SHARE_DATA = GetShareData();

?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">

	<!-- Facebook sharing meta tags -->
	<meta property="og:type" content="<?php echo $SHARE_DATA['type'] ?>" />
	<meta property="og:title" content="<?php echo $SHARE_DATA['title'] ?>" />
	<meta property="og:description" content="<?php echo $SHARE_DATA['description'] ?>" />
	<meta property="og:image" content="<?php echo $SHARE_DATA['img'] ?>" />
	<meta property="og:url" content="<?php echo $SHARE_DATA['url'] ?>" />
	<!-- Google+ sharing meta tags -->
	<meta itemprop="name" content="<?php echo $SHARE_DATA['title'] ?>" />
	<meta itemprop="description" content="<?php echo $SHARE_DATA['description'] ?>" />
	<meta itemprop="image" content="<?php echo $SHARE_DATA['img'] ?>">
	<!-- SEO -->
	<!--
	<meta name="description" content="{$PHOTO_META_DESC}" />
	<meta name="keywords" content="{$PHOTO_META_KEYWORD}" />
	-->

	<!-- javascript -->
	<script type="text/javascript" src="scripts/uistrings.php?v=<?php echo $DSM_VERSION ?>&ln=<?php echo $LANGUEGE ?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/adapter/ext/ext-base.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/ext-all.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/ux/ux-all.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="../photo/include/client_string.php?v=<?php echo $PACKAGE_VERSION ?>&ln=<?php echo $LANGUEGE ?>"></script>
	<script type="text/javascript" src="photo_new/flexcroll/flexcroll.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="tinymce/tinymce.min.js"></script>
	<script type="text/javascript" src="jwplayer/jwplayer.js"></script>
    <script>
            var gIsDemoMode = false;
            if ("true" === ("<?php echo $blDemoMode;?>")) {
                gIsDemoMode = true;
            }
	    var LANGUAGE = "<?= $LANGUEGE?>";
    </script>
	<?php
	if ($DEBUG === true) {
		$jsFiles = glob("photo_new/js/*.js");
	} else {
		$jsFiles = array('photo_new/syno_photo_main.js');
	}
	printf("\t<script type=\"text/javascript\">debugMode = " . ($DEBUG ? 'true' : 'false') . ";</script>\n");

	foreach ($jsFiles as $item) {
		printf(
			"\t<script type=\"text/javascript\" src=\"%s?v=%s%s\"></script>\n",
			$item, $PACKAGE_VERSION, ($DEBUG === true) ? '&_dc='.time() : ''
		);
	}
	?>

	<!-- style sheet -->
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/resources/css/ext-all.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/resources/css/xtheme-gray-syno.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/ux/ux-all.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="css/flexcrollstyles.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="css/SuperBoxSelect.css?v=<?php echo $PACKAGE_VERSION ?>">
	<link rel="stylesheet" type="text/css" href="photo_new/css/style.css?v=<?php echo $PACKAGE_VERSION ?>">
	<? if ($photo_config_theme['v6_template'] === 'Black') {?>
	<link rel="stylesheet" type="text/css" href="photo_new/css/black.css?v=<?php echo $PACKAGE_VERSION ?>">
	<?}?>
	<link rel="stylesheet" type="text/css" href="include/custom_css.php?v=<?php echo $PACKAGE_VERSION ?>">

	<link rel="stylesheet" type="text/css" href="./photo_new/css/imageChooser.css?v=<?php echo $PACKAGE_VERSION ?>">
	<link rel="stylesheet" type="text/css" href="./photo_new/css/flashUploadDataView.css?v=<?php echo $PACKAGE_VERSION ?>">

	<link rel="shortcut icon" href="favicon.ico">

	<title><?php echo $PAGE_TITLE ?></title>
</head>
<body>
	<iframe id="login_iframe" name="login_iframe" width="0" height="0" frameborder="0"></iframe>
	<form id="login_form" class="login_form" method="POST" action="webapi/auth.php" target="login_iframe" style="filter: Alpha(opacity=0); opacity: 0;">
		<input type="text" id="login_api" name="api" class="sbox-text login-input" />
		<input type="text" id="login_method" name="method" class="sbox-text login-input" />
		<input type="text" id="login_version" name="version" class="sbox-text login-input" />
		<input type="text" id="login_username" name="username" class="sbox-text login-input" />
		<input type="password" id="login_password" name="password" class="sbox-text login-input"/>
		<input type="submit" style="display: none;">
	</form>
	<form id="history-form" class="x-hidden">
		<input type="hidden" id="x-history-field" />
		<iframe id="x-history-frame"></iframe>
	</form>
</body>
</html>
<?php

function GetShareData()
{
	$data = false;

	//parse token
	$token = '';
	if (isset($_REQUEST['t'])) {
		$token = $_REQUEST['t'];
	}
	$tokenParts = explode('/', $token);
	$id = $tokenParts[count($tokenParts) - 1];
	$idParts = explode('_', $id);
	$count = count($idParts);

	if (2 === $count) {
		if ('album' === $idParts[0]) {
			$data = GetAlbumShareData($idParts[1]);
		} else if ('smart' === $idParts[0]) {
			$data = GetSmartShareData($idParts[1]);
		} else if ('tag' === $idParts[0]) {
			$data = GetTagShareData($idParts[1]);
		} else if ('category' === $idParts[0]) {
			$data = GetCategoryShareData($idParts[1]);
		}
	} else if (3 === $count) {
		if ('photo' === $idParts[0] || 'video' === $idParts[0]) {
			$data = GetPhotoVideoShareData($idParts[1], $idParts[2]);
		}
	}

END:
	if (false === $data) {
		$data = GetDefaultShareData();
	}
	return FormData($data, "/photo/" . ($token ? "?t=$token#$token" : ""));
}

function GetAlbumShareData($album)
{
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

	$albumName = @pack('H*', $album);

	if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName)) {
		return false;
	}

	$albumInfo = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
	$result = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($albumName);

	$title = $albumInfo['title'];
	if (empty($title)) {
		$title = $albumInfo['dirName'];
	}

	if (empty($result['coverPath'])) {
		$img = $result['cover']['src'];
	} else {
		$img = GetThumbUrl('album_' . $album);
	}

	return array(
		'type' => 'album',
		'title' => $title,
		'desc' => $albumInfo['desc'],
		'img' => $img
	);
}

function GetSmartShareData($smart)
{
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

	$smartName = @pack('H*', $smart);
	$cover = SmartAlbum::GetSmartAlbumInstance()->GetCoverOfSmartAlbumByName($smartName);

	if (!$cover['success']) {
		return false;
	};

	return array(
		'type' => 'album',
		'title' => $smartName,
		'desc' => '',
		'img' => GetThumbUrl('smart_' . $smart)
	);
}

function GetTagShareData($tag)
{
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

	$found = false;
	$tags = SYNOPHOTO_LABEL_UTIL_GetAllLabel(true);
	foreach($tags[0] as $t) {
		if ((int)$tag === $t['id']) {
			$found = true;
			$title = $t['name'];
			break;
		}
	}

	if (false === $found) {
		return false;
	}

	return array(
		'type' => 'album',
		'title' => $title,
		'desc' => '',
		'img' => GetThumbUrl('tag_' . $tag)
	);
}

function GetCategoryShareData($category)
{
	global $photo_config_theme;

	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

	//admin-check is totally unnecessary, because social network will nerver login as admin
	$isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);
	$hidden = csSYNOPhotoDB::GetDBInstance()->IsCategoryAccessible($category);
	if (false === $isAdmin && true === $hidden) {
		return false;
	}

	$dbCategory = csSYNOPhotoDB::GetDBInstance()->GetCategory($category);
	if (false === $dbCategory) {
		return false;
	}

	return array(
		'type' => 'album',
		'title' => $dbCategory['name'],
		'desc' => '',
		'img' => "/photo/photo_new/images/" . (($photo_config_theme['template'] === 'Black') ? 'Black' : 'White') . '/logo_ps6.png'
	);
}

function GetPhotoVideoShareData($album, $file)
{
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

	$albumName = @pack('H*', $album);
	$fileName = @pack('H*', $file);

	$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . "/" . $fileName);

	if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
		return false;
	}
	if (!@file_exists($path)) {
		return false;
	}
	if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName)) {
		return false;
	}

	$isPhoto = csSYNOPhotoMisc::IsPhotoFile($path);

	if ($isPhoto) {
		$type = 'album';
		$info = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($path);
	} else {
		$type = 'movie';
		$info = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($path);
	}

	return array(
		'type' => $type,
		'title' => $info['title'] ? $info['title'] : $info['name'],
		'desc' => $info['description'],
		'img' => GetThumbUrl(($isPhoto ? 'photo_' : 'video_') . $album . '_' . $file)
	);
}

function GetDefaultShareData()
{
	global $PAGE_TITLE, $photo_config_theme;

	$desc = csSYNOPhotoDB::GetDBInstance()->GetConfig('main', 'main_page_desc');
	if (empty($desc) || $desc === __(photo_str_add_description)) {
		$desc = '';
	}

	return array(
		'type' => 'album',
		'title' => $PAGE_TITLE,
		'desc' => $desc,
		'img' => "/photo/photo_new/images/" . (($photo_config_theme['template'] === 'Black') ? 'Black' : 'White') . '/logo_ps6.png'
	);
}

function GetThumbUrl($id)
{
	return '/photo/webapi/thumb.php?' . http_build_query(
		array(
			'api' => 'SYNO.PhotoStation.Thumb',
			'version' => 1,
			'method' => 'get',
			'id' => $id,
			'size' => 'small'
		),
		'',
		'&'
	);
}

function FormData($data, $url)
{
	$urlPrefix = csSYNOPhotoMisc::GetServerHost().SYNOPHOTO_URL_PREFIX;

	return array(
		'type' => htmlspecialchars($data['type']),
		'title' => htmlspecialchars($data['title']),
		'description' => htmlspecialchars($data['desc']),
		'img' => $urlPrefix . $data['img'],
		'url' => $urlPrefix . $url
	);
}

?>
