<?php

//sqlite should defind escape char for each LIKE
function PHOTO_DB_GetEscape(){
	$db_type = $GLOBALS['dbconn_photo']->getAttribute(constant("PDO::ATTR_DRIVER_NAME"));
	if ('sqlite' == $db_type) {
			return "ESCAPE '\'";
	}
	return '';
}

function PHOTO_DB_EscapeParam($param)
{
	$db_type = $GLOBALS['dbconn_photo']->getAttribute(constant("PDO::ATTR_DRIVER_NAME"));
	if ('sqlite' == $db_type) {
		return sqlite_escape_string($param);
	}
	return pg_escape_string($param);
}

function PHOTO_DB_Query($dbconn, $query, $param=array())
{
	$stmt = $dbconn->prepare($query);
	$rs = $stmt->execute($param);
	if ($rs === false) {
		return false;
	}
	return $stmt;
}

function PHOTO_DB_FetchRow($stmt)
{
	if (false === $stmt) {
		return false;
	}
	$row = $stmt->fetch();
	return $row;
}

function PHOTO_DB_FetchAll($stmt)
{
	if (false === $stmt) {
		return false;
	}
	$rows = $stmt->fetchAll();
	return $rows;
}

//query must use count()
function PHOTO_DB_QueryCount($dbconn, $query, $param=array())
{
	$stmt = $dbconn->prepare($query);
	$rs = $stmt->execute($param);
	$row = $stmt->fetch();
	return $row[0];
}

//just for insert, delete, update
function PHOTO_DB_AffectedRows($stmt)
{
	$count = $stmt->rowCount();
	return $count;
}

//for pgsql, sqlite boolean type is different
function PHOTO_DB_IsTrue($var)
{
	return ($var == 't' || $var === true);
}

//convert boolean True/False to 't'/'f'
function PHOTO_DB_ConvertBool($var)
{
	return ($var === true || $var == 't') ? 't' : 'f';
}

function PHOTO_DB_EscapForLike($val){
	$val = str_replace('\\', '\\\\', $val);
	$val = str_replace('_', '\\_', $val);
	$val = str_replace('%', '\\%', $val);
	return $val;
}

?>
