<?php
define('DBCACHER_CACHE_EXPIRE', 5 * 60);
define('DBCACHER_PAGE_SIZE', 24);
define('DBCACHER_PAGE_FORWARD', 2);
define('DBCACHER_PAGE_BACKWARD', 1);

define('DBCACHER_SESSION_ID', '_dbcacher');
define('DBCACHER_VIDEO_SESSION_ID', '_dbcacherVideo');
define('DBCACHER_TUPLE_EXIPRE_TIME', 'expireTime');
define('DBCACHER_TUPLE_SQL', 'statement');
define('DBCACHER_TUPLE_PARAM', 'param');
define('DBCACHER_TUPLE_PAGE_MIN', 'pageMin');
define('DBCACHER_TUPLE_PAGE_MAX', 'pageMax');
define('DBCACHER_TUPLE_COUNT', 'count');
define('DBCACHER_TUPLE_MAXCOUNT', 'maxCount');
define('DBCACHER_TUPLE_DATA', 'data');

class DBCacher {
	private $_dbh;
	private $_cacherid;
	private $current_admin;

	function __construct($dbh, $isForVideo, $user)
	{
		$this->_dbh = $dbh;
		$this->current_admin = ('root' ==  $user) ? 'root' : '~'.$user;
		if	($isForVideo) {
			$this->_cacherid = DBCACHER_VIDEO_SESSION_ID;
		} else {
			$this->_cacherid = DBCACHER_SESSION_ID;
		}

		if (!isSet($_SESSION[$this->current_admin][$this->_cacherid])) {
			$_SESSION[$this->current_admin][$this->_cacherid] = array();
		}
	}

	function __destruct()
	{
	}

	private function &GetCacheTuple($statement, $param)
	{
		if (!is_array($param)) {
			$param = array();
		}
		$cacheId = md5($statement . implode('', $param));
		if (!isSet($_SESSION[$this->current_admin][$this->_cacherid][$cacheId])) {
			/* Cache Structure:
			 * sql statement
			 * sql parameter
			 * page range (min - max)
			 * cached data length
			 * cached data
			 * //total length (pgsql use count(*) with condition very slow)
			 * total length (false for unknown or a value when query return less then page length)
			 */
			$tuple = array(
						DBCACHER_TUPLE_EXIPRE_TIME	=>	time() + DBCACHER_CACHE_EXPIRE,
						DBCACHER_TUPLE_SQL 			=>	$statement,
						DBCACHER_TUPLE_PARAM		=>	$param,
						DBCACHER_TUPLE_PAGE_MIN		=>	-1,
						DBCACHER_TUPLE_PAGE_MAX		=>	-1,
						DBCACHER_TUPLE_COUNT		=>	0,
						DBCACHER_TUPLE_MAXCOUNT		=>	false,
						DBCACHER_TUPLE_DATA			=>	array()
						);
			/* keep only one cached data */
			$_SESSION[$this->current_admin][$this->_cacherid] = array($cacheId => $tuple);
		}
		return $_SESSION[$this->current_admin][$this->_cacherid][$cacheId];
	}

	private function &RefreshCacheTuple(&$cache, $minPage, $maxPage)
	{
		/* rerange page range */
		$minPage -= DBCACHER_PAGE_BACKWARD;
		$maxPage += DBCACHER_PAGE_FORWARD;

		if ($minPage < 1) {
			$minPage = 1;
		}

		$cache[DBCACHER_TUPLE_PAGE_MIN] = $minPage;
		$cache[DBCACHER_TUPLE_PAGE_MAX] = $maxPage;

		/* translate page to number */
		$offset = ($minPage - 1) * DBCACHER_PAGE_SIZE;
		$limit = ($maxPage - $minPage + 1) * DBCACHER_PAGE_SIZE;
		/* prepare sql statement and param */
		$query = sprintf('%s LIMIT %s OFFSET %s', $cache[DBCACHER_TUPLE_SQL], $limit, $offset);
		$param = $cache[DBCACHER_TUPLE_PARAM];

		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($param);
		$cache[DBCACHER_TUPLE_DATA] = $dbResult->fetchAll();

		if (false !== $cache[DBCACHER_TUPLE_DATA]) {
			$cache[DBCACHER_TUPLE_COUNT] = count($cache[DBCACHER_TUPLE_DATA]);

			/* found end of records */
			if (0 < $cache[DBCACHER_TUPLE_COUNT] && $limit > $cache[DBCACHER_TUPLE_COUNT]) {
				$cache[DBCACHER_TUPLE_MAXCOUNT] = $offset + $cache[DBCACHER_TUPLE_COUNT];
			}
		} else {
			/* false means no record found or error occurred */
			$cache[DBCACHER_TUPLE_DATA] = array();
		}

		return $cache;
	}

	function CacheQuery($statement, $param, $offset, $limit)
	{
		if (empty($statement) || !$limit) {
			return array();
		}

		$cache = &$this->GetCacheTuple($statement, $param);
		$minPage = ceil( ($offset + 1) / DBCACHER_PAGE_SIZE );
		$maxPage = ceil( ($offset + $limit) / DBCACHER_PAGE_SIZE );

		if ($cache[DBCACHER_TUPLE_EXIPRE_TIME] < time()
			|| $cache[DBCACHER_TUPLE_PAGE_MIN] > $minPage
			|| $cache[DBCACHER_TUPLE_PAGE_MAX] < $maxPage) {
			$this->RefreshCacheTuple($cache, $minPage, $maxPage);
		}

		$result = array();
		$offsetInCache = $offset - (($cache[DBCACHER_TUPLE_PAGE_MIN] - 1) * DBCACHER_PAGE_SIZE);
		for ($idx = $offsetInCache; $limit && $idx < $cache[DBCACHER_TUPLE_COUNT]; $idx++) {
			$result[] = $cache[DBCACHER_TUPLE_DATA][$idx];
			$limit--;
		}

		return $result;
	}
}
?>
