<?php
require_once(dirname(__FILE__).'/../syno_conf.php');
require_once SYNOPHOTO_INCLUDE_EA;

function SYNOPHOTO_ROTATE_PIC_DoRotation($angle, $path)
{
	$result['success'] = FALSE;
	if (!isSet($angle) || !isSet($path) || !is_numeric($angle)) {
		return json_encode($result);
	}

	$dPath = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
	$path = PHOTO_DB_EscapeParam($dPath);
	$query = "Select id, path from photo_image where path = '".$path."'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		$image_id = $row['id'];
	} else {
		return json_encode($result);
	}

	$dir_name = substr($path, 0, strlen($path) - strlen(basename($path)) - 1);

	if(SYNOPHOTO_ROTATE_PIC_ThumbLackCheck($path)) {
		$result['msg'] = __(photo_str_thumbing_wait_msg);
		return json_encode($result);
	}

	$rotate_list = array();
	$rotate_list[] = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBSMALL, false);
	$rotate_list[] = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBBIG, false);
	$rotate_list[] = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBMEDIUM, false);
	$rotate_list[] = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBLARGE, false);
	$rotate_list[] = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, SYNOPHOTO_THUMBXLARGE, false);

	SYNOPHOTO_ROTATE_PIC_UpdatePersonLabel($image_id, $path, $angle);
	SYNOPHOTO_ROTATE_PIC_ThumbRotate($angle, $rotate_list);
	SYNOPHOTO_ROTATE_PIC_UpdatePhotoVersion($path, $angle);

	$result['label'] = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($image_id);
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ROTATE_PIC_UpdatePersonLabel($image_id, $path, $angle)
{
	$data = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($image_id);

	for ($i = 0; $i < count($data['person']); $i++) {
		$info = json_decode($data['person'][$i]['info']);
		$new_info = SYNOPHOTO_ROTATE_PIC_GetNewInfo($path, $info, $angle);
		if (null != $info->face) {
			$new_info['face'] = SYNOPHOTO_ROTATE_PIC_GetNewInfo($path, $info->face, $angle);
		}
		$query = 'update photo_image_label set info_new = ? WHERE id = ?';
		$sqlParam = array(json_encode($new_info), $data['person'][$i]['id']);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	}
}

function SYNOPHOTO_ROTATE_PIC_GetNewInfo($path, $info, $angle)
{
	switch ($angle) {
	case 90:
		$result['x'] = floatval(1 - $info->height - $info->y);
		$result['y'] = floatval($info->x);
		$result['width'] = floatval($info->height);
		$result['height'] = floatval($info->width);
		break;
	case 270:
		$result['x'] = floatval($info->y);
		$result['y'] = floatval(1 - $info->width - $info->x);
		$result['width'] = floatval($info->height);
		$result['height'] = floatval($info->width);
		break;
	case 180:
		$result['x'] = floatval(1 - $info->width - $info->x);
		$result['y'] = floatval(1 - $info->height - $info->y);
		$result['width'] = floatval($info->width);
		$result['height'] = floatval($info->height);
		break;
	}
	return $result;
}

function SYNOPHOTO_ROTATE_PIC_UpdatePhotoVersion($path, $angle)
{
	$path = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
	$path = PHOTO_DB_EscapeParam($path);
	$query = "Select version from photo_image where path = '".$path."'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row = PHOTO_DB_FetchRow($db_result);
	$old_version = $row[0];
	$offset = 1;
	if ($angle == 180) {
		$offset = 2;
	}
	$new_version = $old_version + $offset;
	$query = "Update photo_image set version = ".$new_version;
	$query = $query." where path = '".$path."'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	/* search db cacher, update version */
	foreach($_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID] as $key => $cacheTuple) {
		if (!is_array($cacheTuple[DBCACHER_TUPLE_DATA])) {
			continue;
		}
		$key1 = $key;
		foreach ($cacheTuple[DBCACHER_TUPLE_DATA] as $sub_key => $dbTuple) {
			if ($path == $dbTuple['path']) {
				$key2 = $sub_key;
			}
		}
	}
	$_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID][$key1][DBCACHER_TUPLE_DATA][$key2]['version'] = $new_version;
}

function SYNOPHOTO_ROTATE_PIC_ThumbRotate($angle=0, $rotate_list)
{
	for($i = 0; $i < count($rotate_list); $i++) {
		if(!@file_exists($rotate_list[$i])) {
			continue;
		}
		$command = "/usr/syno/bin/convert"
				." ".escapeshellarg($rotate_list[$i])
				." -rotate ". escapeshellarg($angle)
				. " " . escapeshellarg($rotate_list[$i].".tmp");
		@system($command);

		@unlink($rotate_list[$i]);
		@rename($rotate_list[$i].".tmp", $rotate_list[$i]);
	}
}

function SYNOPHOTO_ROTATE_PIC_ThumbLackCheck($path)
{
	$thumbCheckList = array(
		SYNOPhotoEA::FILE_THUMB_XL,
		SYNOPhotoEA::FILE_THUMB_M
	);

	$eaDir = SYNOPhotoEA::getEADirPath($path);
	foreach ($thumbCheckList as $thumbType) {
		$exists = SYNOPhotoEA::checkFilePath($path, $thumbType, $eaPath);
		if (!$exists) {
			return true;
		}
	}
	return false;
}
?>
