<?php
require_once("syno_conf.php");
require_once("photo/album_util.php");

// the string definition needs to be sync with Photo Uploader in Assistant
$SZ_DUPLICATE_OVERWRITE = 'OVERWRITE';
$SZ_DUPLICATE_SKIP = 'SKIP';
$SZ_DUPLICATE_RENAME = 'RENAME';

$SZ_UPD_TYPE_FOLDER = 'FOLDER';
$SZ_UPD_TYPE_ORIG_FILE = 'ORIG_FILE';
$SZ_UPD_TYPE_THUMB_B = 'THUM_B';
$SZ_UPD_TYPE_THUMB_L = 'THUM_L';
$SZ_UPD_TYPE_THUMB_M = 'THUM_M';
$SZ_UPD_TYPE_THUMB_S = 'THUM_S';
$SZ_UPD_TYPE_THUMB_XL = 'THUM_XL';
$SZ_UPD_TYPE_FLV = 'FLV';
$SZ_UPD_TYPE_MP4_HIGH =	"MP4_HIGH";
$SZ_UPD_TYPE_MP4_MEDIUM = "MP4_MEDIUM";
$SZ_UPD_TYPE_MP4_LOW = "MP4_LOW";
$SZ_UPD_TYPE_MP4_MOBILE = "MP4_MOBILE";
$SZ_UPD_TYPE_CUST_TITLE = 'CUST_TITLE'; // file customized title
$SZ_UPD_TYPE_CUST_DESC = 'CUST_DESC'; // file customized description

$SZ_UPD_ERROR_SESSION_LOST = 'session_lost';
$SZ_UPD_ERROR_TARGET_FOLDER_NOT_FOUND_PREFIX = 'target_folder_not_found_';
$SZ_UPD_ERROR_NO_PRIVILEGE = 'no_privilege';
$SZ_UPD_ERROR_DUPLICATE = 'duplicated_file';
$SZ_UPD_ERROR_BAD_DIR_NAME_PREFIX = 'bad_dir_name_';
$SZ_UPD_ERROR_DEMO_SITE = 'demo_site_disable';

$result['success'] = true;
$result['err_msg'] = '';
$result['duplicate_folder'] = false;

$conf = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, "enable_demomode");
if("yes" == $conf['enable_demomode']) {
	$result['success'] = false;
	$result['err_msg'] = $SZ_UPD_ERROR_DEMO_SITE;
}

if ($result['success'] && false == isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && false == isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
	$result['success'] = false;
	$result['err_msg'] = $SZ_UPD_ERROR_SESSION_LOST;
}

if ($result['success']) {
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
}

if ($result['success'] && (!isset($_SERVER['HTTP_X_PATH']) || !isset($_SERVER['HTTP_X_DUPLICATE']) ||
		!isset($_SERVER['HTTP_X_ORIG_FNAME']) || !isset($_SERVER['HTTP_X_UPLOAD_TYPE']))) {

	$result['success'] = false;
	$result['err_msg'] = 'bad_parameter';
}

$_SERVER['HTTP_X_PATH'] = trim(urldecode($_SERVER['HTTP_X_PATH']), '/'); // trim the '/' in the begining & end
$_SERVER['HTTP_X_ORIG_FNAME'] = urldecode($_SERVER['HTTP_X_ORIG_FNAME']);

// unlock session file to avoid blocking other php process that are waiting for the session file
session_write_close();

// make temp dir
if ($result['success']) {
	$photo_dir_real_path =  realpath(SYNOPHOTO_SERVICE_DIR);
	$root_tmp_dir_path = $photo_dir_real_path.'/'.SYNOPHOTO_EADIR.'/ASST_PHOTO_UPLOAD_TMP_DIR';
	if (!file_exists($root_tmp_dir_path)) {
		if(!($mkdir_ret = @mkdir($root_tmp_dir_path, 0777, true))) {
			$result['success'] = false;
			$result['err_msg'] = 'mk_tmp_dir_error:'.$root_tmp_dir_path;
		}
	}
}


$SZ_TMP_EA_FOLDER_PATH = $root_tmp_dir_path.'/ASST_TMP_EA_'.session_id();
$SZ_TMP_ORIG_FILE_PATH = $root_tmp_dir_path.'/ASST_TMP_ORG_'.session_id();
$SZ_TMP_FILE_PATH = $root_tmp_dir_path.'/ASST_TMP_FILE_'.session_id();

if ($result['success'] && $_SERVER['HTTP_X_UPLOAD_TYPE'] != $SZ_UPD_TYPE_FOLDER) {
	// upload is file condition:

	// set php execution timelimit to no limit. prevent from file upload time out.
	set_time_limit(0);

	// 1. check if the server path exists
	if (!file_exists(SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'])) {
		$result['success'] = false;
		$result['err_msg'] = $SZ_UPD_ERROR_TARGET_FOLDER_NOT_FOUND_PREFIX.'/'.$_SERVER['HTTP_X_PATH'];
	}

	// 2. check the upload privilege
	if (false == ASST_PHOTO_UPLOAD_UploadRightCheck($_SERVER['HTTP_X_PATH'])) {
		$result['success'] = false;
		$result['err_msg'] = $SZ_UPD_ERROR_NO_PRIVILEGE;
	}

	// 3. clean up temp files if file is upload batch's first file
	if ($result['success'] && isset($_SERVER['HTTP_X_IS_BATCH_FIRST_FILE'])) {
		if (file_exists($SZ_TMP_EA_FOLDER_PATH)) {
			$files = glob( $SZ_TMP_EA_FOLDER_PATH.'/*', GLOB_MARK );
			foreach( $files as $file ){
				unlink($file);
			}
			rmdir($SZ_TMP_EA_FOLDER_PATH);
		}

		if (file_exists($SZ_TMP_ORIG_FILE_PATH)) {
			unlink($SZ_TMP_ORIG_FILE_PATH);
		}
	}

	// 4. get the upload file and move it to a temp file
	if ($result['success']) {
		if (file_exists($SZ_TMP_FILE_PATH)) {
			unlink($SZ_TMP_FILE_PATH);
		}

		$input = fopen('php://input', 'rb');
		if (!$input) {
			//open file fail
			$result['success'] = false;
			$result['err_msg'] = 'open_file_error';
		}

		$temp = fopen($SZ_TMP_FILE_PATH, 'wb');

		$written_file_size = 0;

		while(($buf = fread( $input, 8192 )) != '' ) {
			$written_file_size += fwrite($temp, $buf);
		}

		if($buf === false) {
			$result['success'] = false;
			$result['err_msg'] = 'write_temp_file_error';
		}

		fclose($input);
		fclose($temp);

		@chmod($SZ_TMP_FILE_PATH, 0777);

		// check file size is equal to content length
		if ($written_file_size != $_SERVER['CONTENT_LENGTH']) {
			$result['success'] = false;
			$result['err_msg'] = 'file_size_not_match'.'writen file size:'.$written_file_size.' Content-Length:'.$_SERVER['CONTENT_LENGTH'];
		}
	}

	// 5. check if the original file already exists
	$is_orig_file_duplicate = file_exists(SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$_SERVER['HTTP_X_ORIG_FNAME']);
	if($result['success'] && $is_orig_file_duplicate && $_SERVER['HTTP_X_DUPLICATE'] == $SZ_DUPLICATE_SKIP) {
		$result['success'] = false;
		$result['err_msg'] = $SZ_UPD_ERROR_DUPLICATE;
	}

	// 6. make temp EA folder if needed
	if ($_SERVER['HTTP_X_UPLOAD_TYPE'] != $SZ_UPD_TYPE_ORIG_FILE && !file_exists($SZ_TMP_EA_FOLDER_PATH)) {
		if(!($mkdir_result= @mkdir($SZ_TMP_EA_FOLDER_PATH, 0777, true))){
			$result['success'] = false;
			$result['err_msg'] = 'create_temp_ea_dir_fail:'.$SZ_TMP_EA_FOLDER_PATH;
		}
	}

	// 7. get destination file name
	$dest_fname = ASST_PHOTO_UPLOAD_GetDestFileName($is_orig_file_duplicate);

	// 8. move the temp file to temp file destination path
	$tmp_dest_path;
	if ($_SERVER['HTTP_X_UPLOAD_TYPE'] != $SZ_UPD_TYPE_ORIG_FILE) {
		$tmp_dest_path = $SZ_TMP_EA_FOLDER_PATH.'/'.$dest_fname;
	} else {
		$tmp_dest_path = $SZ_TMP_ORIG_FILE_PATH;
	}

	if ($result['success'] && !rename($SZ_TMP_FILE_PATH, $tmp_dest_path)) {
		$result['success'] = false;
		$result['err_msg'] = 'rename_tmp_file_fail: '.$tmp_dest_path;
	}

	// copy the whole temp EA folder or temp original file to destination at batch's last file
	// the last file MUST be the original file
	if ($result['success'] && isset($_SERVER['HTTP_X_IS_BATCH_LAST_FILE'])) {
		$rename_tmp_ea_result = true;
		$dest_ea_folder_path = SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.SYNOPHOTO_EADIR.'/'.$dest_fname;
		$is_temp_orig_file_exist = file_exists($SZ_TMP_ORIG_FILE_PATH);

		// remove the dest ea folder if it existed already
		if(file_exists($dest_ea_folder_path)) {
			// remove all the contents in the dir
			$files = glob($dest_ea_folder_path.'/*', GLOB_MARK );
			foreach($files as $file ){
				unlink($file);
			}
			rmdir($dest_ea_folder_path);
		}

		// copy ea files prior to original file to avoid tirggering synoindex to create thumbnails by browsing photo station
		if ($is_temp_orig_file_exist && file_exists($SZ_TMP_EA_FOLDER_PATH)) {
			@mkdir($dest_ea_folder_path, 0777, true);
			if(!rename($SZ_TMP_EA_FOLDER_PATH, $dest_ea_folder_path)) {
				$rename_tmp_ea_result = false;
				$result['err_msg'] = 'warning: rename tmp EA folder fail: '.$dest_ea_folder_path;
			}
		}

		if ($is_temp_orig_file_exist) {
			if(!rename($SZ_TMP_ORIG_FILE_PATH, SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$dest_fname)) {
				$result['success'] = false;
				$result['err_msg'] = 'rename_tmp_original_fail: '.SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$dest_fname;
			}

			if (isset($_SERVER['HTTP_X_LAST_MODIFIED_TIME'])) {
				// set original file's last modified time
				@touch(SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$dest_fname, $_SERVER['HTTP_X_LAST_MODIFIED_TIME']);
			}
		}

		// modify the files's modified time in EA to avoid synoindex regenerate thumbs
		if ($result['success'] && file_exists($dest_ea_folder_path) && $rename_tmp_ea_result) {
			$currentDir = getcwd();
			chdir($dest_ea_folder_path);
			$files = glob('*', GLOB_MARK );
			foreach( $files as $file ){
				@touch($file);
			}
			chdir($currentDir);
		}

		if ($result['success']) {
			// log to database
			$loguser = "admin";
			if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
				$loguser = $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
			}

			$file_folder_path = '';
			if ($_SERVER['HTTP_X_PATH'] != '') {
				$file_folder_path = $_SERVER['HTTP_X_PATH'].'/';
			}

			csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('Upload '.$dest_fname.' to /photo/'.$file_folder_path.' successfully.', 't', $loguser);
		}

		// delete all temp files
		if (file_exists($SZ_TMP_EA_FOLDER_PATH)) {
			$files = glob( $SZ_TMP_EA_FOLDER_PATH.'/*', GLOB_MARK );
			foreach( $files as $file ){
				unlink($file);
			}
			rmdir($SZ_TMP_EA_FOLDER_PATH);
		}

		if (file_exists($SZ_TMP_ORIG_FILE_PATH)) {
			unlink($SZ_TMP_ORIG_FILE_PATH);
		}

		if (file_exists($SZ_TMP_FILE_PATH)) {
			unlink($SZ_TMP_FILE_PATH);
		}

	}

	// 9. index the original file
	if ($result['success'] && $_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_ORIG_FILE) {
		ASST_PHOTO_UPLOAD_Do_SYNO_INDEX(SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$dest_fname);
		ASST_PHOTO_UPLOAD_INDEX_FILE_TO_PHOTO_DB($_SERVER['HTTP_X_PATH'], pathinfo($dest_fname));
	}

	// 10. triger facebook sync
	if ($result['success'] && $_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_ORIG_FILE) {
		ASST_PHOTO_UPLOAD_Triger_FB_SYNC($_SERVER['HTTP_X_PATH']);
	}
} else if ($result['success'] && $_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_FOLDER) {
	// upload is folder condition:

	// set php execution timelimit to no limit. prevent from file upload time out.
	set_time_limit(0);

	$_SERVER['HTTP_X_ORIG_FNAME'] = trim($_SERVER['HTTP_X_ORIG_FNAME']); // trim the white space in folder condition
	$folder_path = SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$_SERVER['HTTP_X_ORIG_FNAME'] . '/';
	$result['duplicate_folder'] = file_exists($folder_path);

	// 1. check if folder name is valid
	$is_folder_name_valid = true;
	$folder_name = $_SERVER['HTTP_X_ORIG_FNAME'];
	if ($folder_name == "") {
		$is_folder_name_valid = false;
	} else if ($folder_name == "." || $folder_name == "..") {
		$is_folder_name_valid = false;
	} else if (preg_match("/([\\\\:\/\\?\|\*<>])|(^@eadir)|(^\._)/i", $folder_name)) {
		$is_folder_name_valid = false;
	}

	if (!$is_folder_name_valid) {
		$result['success'] = false;
		$result['err_msg'] = $SZ_UPD_ERROR_BAD_DIR_NAME_PREFIX.$_SERVER['HTTP_X_ORIG_FNAME'];
	}

	// check if the folder is on the top level, i.e. under "photo" folder directly
	$is_top_folder = false;
	$share_name = '';
	if ($_SERVER['HTTP_X_PATH'] != '') {
		$is_top_folder = false;
		$share_name = $_SERVER['HTTP_X_PATH'].'/'.$_SERVER['HTTP_X_ORIG_FNAME'];
	} else {
		$is_top_folder = true;
		$share_name = '/';
	}

	// 2. check privilege
	if ($result['success']) {
		$privilege_check_result = false;
		if ($is_top_folder || strstr($_SERVER['HTTP_X_PATH'], '/')) {
			// folder is (top level folder) or (level 3 and below) condition:
			$privilege_check_result = ASST_PHOTO_UPLOAD_UploadRightCheck($share_name);
		} else {
			// folder is 2nd level condition:
			if ($result['duplicate_folder']) {
				// folder already existed
				$privilege_check_result = ASST_PHOTO_UPLOAD_UploadRightCheck($share_name);
			} else {
				$privilege_check_result = ASST_PHOTO_UPLOAD_UploadRightCheck($_SERVER['HTTP_X_PATH']);
			}
		}

		if (!$privilege_check_result) {
			$result['success'] = false;
			$result['err_msg'] = $SZ_UPD_ERROR_NO_PRIVILEGE;
		}
	}

        // 3. add album
        if ($result['success'] && !$result['duplicate_folder']) {
                $add_result = ASST_UPLOAD_AddAlbum($_SERVER['HTTP_X_PATH'], $_SERVER['HTTP_X_ORIG_FNAME']);
        }

        // 4. triger facebook sync
	if ($result['success']) {
		ASST_PHOTO_UPLOAD_Triger_FB_SYNC($_SERVER['HTTP_X_PATH']);
	}
}

echo preg_replace("#\\\u([0-9a-f]{4}+)#ie", "iconv('UCS-2', 'UTF-8', pack('H4', '\\1'))", json_encode($result));

function ASST_PHOTO_UPLOAD_GetDestFileName($is_orig_duplicate)
{
	global $SZ_UPD_TYPE_ORIG_FILE;
	global $SZ_UPD_TYPE_THUMB_B;
	global $SZ_UPD_TYPE_THUMB_L;
	global $SZ_UPD_TYPE_THUMB_M;
	global $SZ_UPD_TYPE_THUMB_S;
	global $SZ_UPD_TYPE_THUMB_XL;
	global $SZ_UPD_TYPE_FLV;
	global $SZ_UPD_TYPE_MP4_HIGH;
	global $SZ_UPD_TYPE_MP4_MEDIUM;
	global $SZ_UPD_TYPE_MP4_LOW;
	global $SZ_UPD_TYPE_MP4_MOBILE;
	global $SZ_UPD_TYPE_CUST_TITLE;
	global $SZ_UPD_TYPE_CUST_DESC;
	global $SZ_DUPLICATE_RENAME;

	$IsOldEAFilePrefix = csSYNOPhotoMisc::IsOldEAFilePrefix();

	if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_ORIG_FILE ) {
		if ($is_orig_duplicate === false || $_SERVER['HTTP_X_DUPLICATE'] != $SZ_DUPLICATE_RENAME) {
			return $_SERVER['HTTP_X_ORIG_FNAME'];
		} else {
			// need to rename file
			if (!strstr($_SERVER['HTTP_X_ORIG_FNAME'], '.')) {
				// file name doesn't contains '.' -> append sequence number to the file name directly
				$sequence = 1;
				while (file_exists(SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$_SERVER['HTTP_X_ORIG_FNAME'].'_'.$sequence)) {
					$sequence = $sequence + 1;
				}
				return $_SERVER['HTTP_X_ORIG_FNAME'].'_'.$sequence;

			} else {
				// insert sequence number into the orig file name
				$sequence = 1;
				$path_parts = pathinfo(SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$_SERVER['HTTP_X_ORIG_FNAME']);
				while (file_exists(SYNOPHOTO_SERVICE_DIR.'/'.$_SERVER['HTTP_X_PATH'].'/'.$path_parts['filename'].'_'.$sequence.'.'.$path_parts['extension'])) {
					$sequence = $sequence + 1;
				}
				return $path_parts['filename'].'_'.$sequence.'.'.$path_parts['extension'];
			}
		}
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_THUMB_B) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_THUMB_B, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_THUMB_L) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_THUMB_L, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_THUMB_M) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_THUMB_M, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_THUMB_S) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_THUMB_S, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_THUMB_XL) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_THUMB_XL, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_FLV) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_FLV, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_MP4_HIGH) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_H_MP4, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_MP4_MEDIUM) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_M_MP4, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_MP4_LOW) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_L_MP4, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_MP4_MOBILE) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_MOBILE_MP4, $IsOldEAFilePrefix);
	}else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_CUST_TITLE) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_TITLE, $IsOldEAFilePrefix);
	} else if ($_SERVER['HTTP_X_UPLOAD_TYPE'] == $SZ_UPD_TYPE_CUST_DESC) {
		return SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_DESC, $IsOldEAFilePrefix);
	}
}

function ASST_UPLOAD_AddAlbum($parentAlbumName, $AlbumName)
{
        $album_data = array();
        $album_data['sharename'] = ($parentAlbumName == '') ? $AlbumName : $parentAlbumName.'/'.$AlbumName;
        $album_data['title'] = '';
        $album_data['description'] = '';
        $album_data['public'] = 'f';
        $album_data['is_subdir'] = ($parentAlbumName == '') ? 'f' : 't';
        $album_data['password'] = '';
        $album_data['comment'] = 'f';

        $album_real_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$album_data['sharename'];

        // get default folder public flag
        $conf = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config'][('root' !== SYNOPHOTO_ADMIN_USER)?'percfg':'pkgCfg']['albumdefpublic'];
        if ($conf == 'yes') {
                $album_data['public'] = 't';
        }

        $is_folder_in_top_2_level = (($parentAlbumName == '') || (!strstr($parentAlbumName, '/')));
        if (isset($_SERVER['HTTP_X_FOLDER_TITLE']) && $is_folder_in_top_2_level) {
                $album_data['title'] = PHOTO_DB_EscapeParam($_SERVER['HTTP_X_FOLDER_TITLE']);
        }

        if (isset($_SERVER['HTTP_X_FOLDER_DESC']) && $is_folder_in_top_2_level) {
                $album_data['description'] = PHOTO_DB_EscapeParam($_SERVER['HTTP_X_FOLDER_DESC']);
        }

        $createID = SYNOPHOTO_ADMIN_AddAlbumToDB($album_data, $album_real_path, true);
        if ('album existed' === $createID) {
                return false;
        }

        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

        return true;
}

// this function only checks album_names that are already existed folder
function ASST_PHOTO_UPLOAD_UploadRightCheck($album_name)
{
	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		return true;
	}

	if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
		return false;
	}

	$sharename = $album_name;
	if(strstr($sharename, '/')) {
		$arr = explode('/', $sharename);
		$sharename = $arr[0].'/'.$arr[1];
	}
	return $_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album'][$sharename];
}

function ASST_PHOTO_UPLOAD_Do_SYNO_INDEX($filepath)
{
	@exec("/usr/syno/bin/synoindex -a ".escapeshellarg($filepath)." > /dev/null 2>&1");
	@exec("/usr/syno/bin/synoindex -f -a ".escapeshellarg($filepath)." > /dev/null 2>&1");
}

function ASST_PHOTO_UPLOAD_INDEX_FILE_TO_PHOTO_DB($albumPath, $path_parts)
{
	$name = PHOTO_DB_EscapeParam($path_parts['basename']);
	$title = PHOTO_DB_EscapeParam($path_parts['filename']);
	if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)) {
		$destination_path = $albumPath.'/'.$name;
	} else {
		$destination_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumPath.'/'.$name;
	}

	if (csSYNOPhotoMisc::IsPhotoFile($destination_path)) {
		$real_path = SYNOPHOTO_SERVICE_DIR.'/'.$albumPath.'/'.$name;
		list($width, $height) = @getimagesize($real_path);
		if (!empty($width) && !empty($height)) {
			$version = ASST_PHOTO_UPLOAD_Get_Image_Orientation($real_path);
			$query = "Insert into photo_image (path, name, title, resolutionx, resolutiony, version) values ('".PHOTO_DB_EscapeParam($destination_path)."', '".$name."', '".$title."', ".$width.", ".$height.", ".$version.");";
		} else {
			$query = "Insert into photo_image (path, name, title) values ('".PHOTO_DB_EscapeParam($destination_path)."', '".$name."', '".$title."');";
		}
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	} else {
		// Todo: Insert into mediaserver?
	}
}

function ASST_PHOTO_UPLOAD_Get_Image_Orientation($path) {
	$exif = @exif_read_data($path);
	$ret = 0;
	if(!empty($exif['Orientation'])) {
		switch($exif['Orientation']) {
		case 1: // nothing
			break;
		case 2: // horizontal flip
			break;
		case 3: // 180 rotate left
			break;
		case 4: // vertical flip
			break;
		case 5: // vertical flip + 90 rotate right
			$ret = 1;
			break;
		case 6: // 90 rotate right
			$ret = 1;
			break;
		case 7: // horizontal flip + 90 rotate right
			$ret = 1;
			break;
		case 8: // 90 rotate left
			$ret = 1;
			break;
		}
	}
	return $ret;
}

function ASST_PHOTO_UPLOAD_Triger_FB_SYNC($album_name)
{
	$ret = FALSE;
	if (empty($album_name) || !csSYNOPhotoMisc::isSetToSyncWithFb($album_name)) {
		goto End;
	}

	$token = csSYNOPhotoMisc::GetConfigDB("photo", "fb_token", "photo_config" );
	$confPath = csSYNOPhotoMisc::getFbSyncConfPath($album_name);
	$albumPath = SYNOPHOTO_SERVICE_REAL_DIR."/".$album_name;
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? '-o':'';
	$commend = "/usr/syno/bin/synophoto_sns_utils --pidfile \"".$confPath.".set\" --fbsync \"$useOrig -t '$token' -c ".escapeshellarg($confPath)." ".escapeshellarg($albumPath)."\"";
	@exec($commend." > /dev/null 2>&1");

	$ret = TRUE;
End:
	return $ret;
}
?>
