<?
require_once("include/syno_conf.php");
require_once(SYNOPHOTO_FB_UTILS);
require_once(SYNOPHOTO_FB_SDK);

define("FBSYNCING_LIST_FILE", '/tmp/fbsyncing');
define("FBSYNCING_LIST_FILELOCK", '/tmp/fbsyncing.lck');

if (preg_match('/^(setSyncWithFb|startSyncWithFb)$/', $_POST['action'])) {
	csSYNOPhotoMisc::CheckAdminTimeOut();
}
if (preg_match('/^(get_album|upload|setSyncWithFb|startSyncWithFb|get_user)$/', $_POST['action'])) {
	if ('setSyncWithFb' != $_POST['action'] || 'true' == $_POST['enable']) {
		if (null == ($fb_utils = csSYNOPhotoMisc::CheckFbTokenValid($_POST['token']))) {
			$result['success'] = false;
			$result['msg'] = __(photo_str_fb_token_invalid);
			echo json_encode($result);
			exit;
		}
	}
}

switch ($_POST['action']) {
case "get_album":
	echo SYNOPHOTO_FB_GetAlbum();
	break;
case "upload_new":
	echo SYNOPHOTO_FB_DoUpload_New();
	break;
case "get_upload_status":
	echo SYNOPHOTO_FB_GetUploadStatus();
	break;
case 'setSyncWithFb':
	echo SYNOPHOTO_FB_SetSyncWithFb();
	break;
case 'startSyncWithFb':
	echo SYNOPHOTO_FB_StartSyncWithFb();
	break;
case 'get_syncing_status':
	echo SYNOPHOTO_FB_GetSyncStatus();
	break;
case 'cancel_upload':
	echo SYNOPHOTO_FB_CancelUpload();
	break;
case 'get_user':
	echo SYNOPHOTO_FB_GetUser();
	break;
}

function SYNOPHOTO_FB_GetUser()
{
	global $fb_utils;
	$result['success'] = true;
	$result['user'] = $fb_utils->getUser();
	return json_encode($result);
}

function SYNOPHOTO_FB_GetAlbum()
{
	global $fb_utils;
	$result['albums'] = array();
	$albums = $fb_utils->getAlbums();
	foreach ($albums as $item) {
		if (200 > $item['count']) {
			$result['albums'][] = $item;
		}
	}
	return json_encode($result);
}

function SYNOPHOTO_FB_DoUpload_New()
{
	$list_file = SYNOPHOTO_FB_GetNameList_new($_POST['albumName'], $_POST['photoList'], $_POST['prog_id'], $_POST['message']);
	$progressFile = SYNOPHOTO_FB_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'];
	$token = $_POST['token'];
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? '-o':'';


	if ('0' == $_POST['type']) {
		$commend = "/usr/syno/bin/synophoto_sns_utils --fbsync \"$useOrig -t '$token' -u $progressFile -n ".escapeshellarg($_POST['newAlbumName'])." $list_file\"";
	} else {
		$commend = "/usr/syno/bin/synophoto_sns_utils --fbsync \"$useOrig -t '$token' -u '$progressFile' -a ".escapeshellarg($_POST['albumId'])." '$list_file'\"";
	}

	@exec($commend." > /dev/null 2>&1");
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_FB_CancelUpload()
{
	$list_file = SYNOPHOTO_FB_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'].".list";
	if (@file_exists($list_file)) {
		@unlink($list_file);
	}
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_FB_GetNameList_new ($albumName, $photoList, $prog_id, $message)
{
	$id_litst = explode(",", $photoList);

	$result['files'] = array();
	foreach ($id_litst as $id) {
		$arr = split('_', $id);
		$name = @pack('H*', $arr[2]);
		$title = empty($message) ? $name : $message;
		$real_path = SYNOPHOTO_SERVICE_REAL_DIR . "/" . @pack('H*', $arr[1]) . "/" . $name;
		if (FALSE == @stat($real_path)) {
			continue;
		}
		$item = array();
		$item['file'] = $real_path;
		$item['message'] = $title;
		$result['files'][] = $item;
	}
	$list_file = SYNOPHOTO_FB_UPLOAD_PROGRESS_FILE . "." . $prog_id . ".list";
	$handle = @fopen($list_file, "w");
	@fwrite($handle, json_encode($result));
	fclose($handle);
	return $list_file;
}

function SYNOPHOTO_FB_GetUploadStatus()
{
	$result = array();
	$result['success'] = 'uploading';
	$result['name'] = __(photo_str_init);
	$result['percent'] = 0;

	$listFile = SYNOPHOTO_FB_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'].".list";
	if (!file_exists($listFile)) {
		$result['success'] = 'canceling';
		return json_encode($result);
	}
	$progressFile = SYNOPHOTO_FB_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'];
	$handle = @fopen($progressFile, "r");
	if ($handle) {
		$content = fread($handle, 8192);
		fclose($handle);
		$json = json_decode($content);
		$result['success'] = 'uploading';
		if ($json->{'success'}) {
			$result['success'] = 'finish';
		} else {
			$result['name'] = basename($json->{'file'});
			$result['percent'] = $json->{'progress'} / $json->{'total'};
		}
	}
	return json_encode($result);
}

function SYNOPHOTO_FB_SetSyncWithFb()
{
	$result['success'] = false;
	if (!isSet($_POST['albumName']) || !isSet($_POST['enable']) || !isSet($_POST['fbAlbumName'])) {
		return json_encode($result);
	}

	$token = csSYNOPhotoMisc::GetConfigDB("photo", "fb_token", "photo_config");
	$albumName = $_POST['albumName'];
	$albumPath = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumName;
	$confPath = SYNOPhotoEA::getFilePath($albumPath, SYNOPhotoEA::FILE_ALBUM_FBSYNC);

	if ('true' != $_POST['enable']) {
		if (csSYNOPhotoMisc::isSyncingWithFb($_POST['albumName'])) {
			$commend = "/usr/syno/bin/synophoto_sns_utils --stop_syncing \"".$confPath.".set\"";
			@exec($commend." > /dev/null 2>&1");
			SYNOPHOTO_FB_RemoveFromSyncingList($albumPath);
		}
		@unlink($confPath);
		@unlink($confPath.".set");
		$result['success'] = TRUE;
		return json_encode($result);
	}

	if ('true' == $_POST['isForResync']) {
		@unlink($confPath);
	}

	$eadir = dirname(dirname($confPath));
	if (!@file_exists($eadir)) {
		@mkdir($eadir);
		@chmod($eadir, 0777);
	}

	$albumEadir = dirname($confPath);
	if (!@file_exists($albumEadir)) {
		@mkdir($albumEadir);
		@chmod($albumEadir, 0777);
	}

	touch($confPath.".set");
	@chmod($confPath.".set", 0777);
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? '-o':'';
	$commend = "/usr/syno/bin/synophoto_sns_utils --pidfile \"".$confPath.".set\" --fbsync \"$useOrig -t '$token' -c ".escapeshellarg($confPath)." -n ".escapeshellarg($_POST['fbAlbumName'])." ".escapeshellarg($albumPath)."\"";
	$commend = "/usr/syno/bin/synophoto_sns_utils --pidfile \"".$confPath.".set\" --fbsync \"$useOrig -t '$token' -c ".escapeshellarg($confPath)." -n ".escapeshellarg($_POST['fbAlbumName'])." ".escapeshellarg($albumPath)."\"";
	@exec($commend." > /dev/null 2>&1");

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_FB_StartSyncWithFb()
{
	global $fb_utils;

	$result['success'] = false;
	if (!isSet($_POST['albumName']) ||
		!csSYNOPhotoMisc::isSetToSyncWithFb($_POST['albumName'])) {
		return json_encode($result);
	}
	$albumName = $_POST['albumName'];
	$albumPath = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumName;
	SYNOPhotoEA::checkFilePath($albumPath, SYNOPhotoEA::FILE_ALBUM_FBSYNC, $confPath);

	$conf_arr = json_decode(file_get_contents($confPath));
	if ($conf_arr->uid != $fb_utils->user_id) {
		$result['msg'] = __(photo_str_fb_account_change);
		$result['confirm'] = true;
		return json_encode($result);
	}

	$isAlbumExist = false;
	$albums = $fb_utils->getAlbums();
	foreach ($albums as $item) {
		if ($item['id'] == $conf_arr->albumID) {
			$isAlbumExist = true;
			break;
		}
	}
	if (!$isAlbumExist) {
		$result['msg'] = __(photo_str_fb_album_miss_resync);
		$result['confirm'] = true;
		return json_encode($result);
	}

	$token = csSYNOPhotoMisc::GetConfigDB("photo", "fb_token", "photo_config");
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? '-o':'';
	$commend = "/usr/syno/bin/synophoto_sns_utils --pidfile \"".$confPath.".set\" --fbsync \"$useOrig -t '$token' -c ".escapeshellarg($confPath)." ".escapeshellarg($albumPath)."\"";
	@exec($commend." > /dev/null 2>&1");

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_FB_GetSyncStatus()
{
	$result['success'] = false;
	if (!isSet($_POST['albumName'])) {
		return json_encode($result);
	}
	if (csSYNOPhotoMisc::isSyncingWithFb($_POST['albumName'])) {
		$result['success'] = 'syncing';
	} else {
		$result['success'] = 'finish';
	}
	return json_encode($result);
}

function SYNOPHOTO_FB_RemoveFromSyncingList($path)
{
	$fp = fopen(FBSYNCING_LIST_FILELOCK, 'w');
	if ($fp) {
		flock($fp, LOCK_EX);
	} else {
		goto Error;
	}

	$syncingList = file(FBSYNCING_LIST_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
	if (empty($syncingList)) {
		goto Error;
	}
	if (($key = array_search($path, $syncingList)) === FALSE) {
		goto Error;
	}
	array_splice($syncingList, $key, 1);
	file_put_contents(FBSYNCING_LIST_FILE, implode("\n", $syncingList));
	@chmod(FBSYNCING_LIST_FILE, 0777);
Error:
	if ($fp) {
		fclose($fp);
		@chmod(FBSYNCING_LIST_FILELOCK, 0777);
	}
}
?>
