<?php
$type = 'blog';
require_once('../include/syno_conf.php');
require_once(SYNOBLOG_INCLUDE_ARTICLE);
require_once(SYNOBLOG_INCLUDE_MODULE);

if (!csSYNOPhotoMisc::IsBlogEnabled()) {
	header("Location: ".SYNOPHOTO_URL_PREFIX."/photo");
	exit;
}
$currentUrl = csSYNOPhotoMisc::GetServerHost();
$currentUrl .= SYNOPHOTO_URL_PREFIX.'/blog/index.php';

// Countting "visit today" and "visit total"
SYNOBLOG_MODULE_CountVisit();

$dsmVersion = csSYNOPhotoMisc::GetDsmVersion();
$packageVersion = csSYNOPhotoMisc::GetPackageVersion();
$smarty->assign('DSM_VERSION', '?v='.$dsmVersion);
$smarty->assign('PACKAGE_VERSION', '?v='.$packageVersion);

$ln = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$smarty->assign('LAN_PARAM', 'ln='.$ln);

$pageTitle = htmlspecialchars(csSYNOPhotoMisc::GetConfigDB('main', 'page_title'), ENT_QUOTES);
if (empty($pageTitle)) {
	$pageTitle = 'Synology Blog';
}
$blogTitle = csSYNOPhotoMisc::GetConfigDB('main', 'blog_title');
$smarty->assign('PAGE_TITLE', $pageTitle);
$smarty->assign('WELCOME_TITLE', csSYNOPhotoMisc::GetWelcomeText());
$smarty->assign('header_link_array', csSYNOPhotoMisc::GetTopHeaderLinkArray(true));

$smarty->assign('BLOG_HEADER', $blogTitle);
$layout_type = csSYNOPhotoMisc::GetConfigDB('main', 'layout_type', 'blog_config');
if ($layout_type == 0) {
	$layout_type = 1;
}

if (2 == csSYNOPhotoMisc::GetConfigDB('theme', 'banner', $type.'_config')) {
	$imageInfo = @getImageSize(SYNOTHEME_BANNER_CUSTOM_FILE);
	$style = "background-image: url(../photo/include/synotheme.php?type=blog&action=banner&cv=1);";
	$style .= "height:".$imageInfo[1].'px;';
	$smarty->assign('CUS_BANNER', $style);
	$style = "background-image:none;";
	$smarty->assign('CUS_BANNER_L', $style);
	$style = "background-image:none;";
	$style .= "height:".$imageInfo[1].'px;';
	$smarty->assign('CUS_BANNER_M', $style);
}

$show_bkg_img = csSYNOPhotoMisc::GetConfigDB('theme', 'show_bkg_img', 'blog_config');
if ($show_bkg_img && '1' == $show_bkg_img && file_exists(SYNOTHEME_BKG_SYNO_FILE)) {
	$smarty->assign('BKG_CHANGE',  @filemtime(SYNOTHEME_BKG_SYNO_FILE));
} else if ($show_bkg_img && '2' == $show_bkg_img && file_exists(SYNOTHEME_BKG_CUSTOM_FILE)) {
	$smarty->assign('BKG_CHANGE',  @filemtime(SYNOTHEME_BKG_CUSTOM_FILE));
} else if ($show_bkg_img && '3' == $show_bkg_img) {
	$smarty->assign('BKG_CHANGE', '0');
} else {
	$smarty->assign('BKG_CHANGE',  rand());
}
$matches = array();
if (isSet($_GET['post_id'])) {
	$blogTitle = $blogTitle ? $blogTitle : $_SERVER['SERVER_NAME'];
	$article = SYNOBLOG_ARTICLE_GetStickyArticle($_GET['post_id']);
	$art_content = $article['content'] ? $article['content'] : '';
	$art_images = preg_match_all('/<img[^>]*src=[^"]*"([^"]*)"/', $art_content,$matches);
	$art_content = mb_substr( strip_tags($art_content), 0, 126 );
	$art_content .= ($art_content) ? '...' : '';
	$smarty->assign('CURRENT_TITLE', strip_tags($article['title'] ? $article['title'] : $blogTitle));
} else {
	$smarty->assign('CURRENT_TITLE', strip_tags($blogTitle));
}
$images_link = '';
$currentImg = '';
if (0 < $art_images) {
	foreach ($matches[1] as $image_src) {
		$images_link .= "<link rel=\"image_src\" type=\"image/jpeg\" href=\"".$image_src."\">\n";
		if ('' == $currentImg) {
			$currentImg = $image_src;
		}
	}
}

if ('' == $images_link) {
	$images_link .= "<link rel=\"image_src\" type=\"image/jpeg\" href=\"no images\">\n";
}

$smarty->assign('BLOG_LAYOUT', $layout_type);
$module_list = SYNOBLOG_MODULE_ArrageModules();
$smarty->assign('moduleList', $module_list);

$jsGlobalVars = "var gCurrentPage=1;var gIsAbstractPage=false;var gUserType=0;";

$articles = SYNOBLOG_ARTICLE_GetAbstractList(1);
$jsGlobalVars .= "var gTotalPage=".$articles['total_page'].";";

$userType = csSYNOPhotoMisc::GetUserType();
$jsGlobalVars .= "gUserType=$userType;";

$smarty->assign('PHOTO_META_DESC', __(photo_str_meta_desc));
$smarty->assign('PHOTO_META_KEYWORD', __(photo_str_meta_keyword));
$smarty->assign('STR_READ_ALL', __(blog_article_read_all));
$smarty->assign('STR_POST_COMMENT', $photo_str_comment_add);
$smarty->assign('articleList', $articles['article_list']);
$smarty->assign('pageIndex', $articles['page_list']);
$smarty->assign('TOTALPAGE', $articles['total_page']);
$smarty->assign('RSS_URL', 'rss.php');
$smarty->assign('JS_GLOBAL_VARS', $jsGlobalVars);
$smarty->assign('SYNOTHEME_REQUEST_FILE', SYNOTHEME_REQUEST_FILE);
$smarty->assign('SCRIPT_NEED_BY_THEME', (isset($_GET['preview'])) ? 'var isPreview = 1;' : 'var isPreview = 0;');
$smarty->assign('CURRENT_IMAGES_LINK',$images_link);
$smarty->assign('CURRENT_DESC', $art_content ? $art_content : '');
$smarty->assign('CURRENT_URL', $currentUrl);
$smarty->assign('CURRENT_IMAGE_URL', $currentImg);
$smarty->assign('IS_BLOG', true);
$smarty->assign('IS_DISABLE_SHARE', (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'disable_share') == 'on') ? true : false);


$smarty->display('blog/index.tpl');

?>
