<?php

function GetCallbackHtmlTemplate($callback, $token, $name, $image, $uid = false, $expire = false)
{
	$params = "'$token', '$name', '$image'";
	if (false !== $uid) {
		$params .= ", '$uid'";
	}
	if (false !== $expire) {
		$params .= ", '$expire'";
	}

	return "<html>
			<head>
				<script>
					function loadHandler(){
						window.opener.$callback($params);
						window.close();
					}
				</script>
			</head>
			<body onload='loadHandler()'></body>
		</html>";
}


function CurlRequest($url, $postData = false)
{
	$curl = curl_init();

	if (false !== $postData) {
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $postData);
	}

	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
	curl_setopt($curl, CURLOPT_TIMEOUT, 30);
	curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($curl, CURLOPT_VERBOSE, true);
	curl_setopt($curl, CURLOPT_URL, $url);

	$result = curl_exec($curl);

	if (false === $result) {
		FillErrorMessage(curl_error($curl), curl_errno($curl), 'local');
	}

	curl_close($curl);

	return $result;
}

function FillErrorMessage($err, $err_code, $err_source)
{
	global $error;

	$error['error'] = $err;
	$error['error_code'] = $err_code;
	$error['error_source'] = $err_source;
}

function SYNOPHOTO_UTIL_ResponseErrorHtml()
{
	global $error;

	echo "<html><head></head><body>".
		"error: ".htmlspecialchars($error['error'])."<br>".
		"error_code: ".htmlspecialchars($error['error_code'])."<br>".
		"error_source: ".htmlspecialchars($error['error_source'])."<br>".
		"</body></html>";

	exit;
}

function SYNOPHOTO_UTIL_ResponseErrorJson()
{
	global $error;

	$returnJson = array(
		'success' => false,
		'error' => $error
	);

	echo json_encode($returnJson);

	exit;
}

?>
