<?php
ini_set("session.use_only_cookies", 0); // Allow sessionid followed by url.
require_once("include/syno_conf.php");

/*
 * class: ImageEditorHandler
 * Desc: 1. Create iframe as cross-domain proxy 2. Handle the notify and save action
 */
class ImageEditorHandler
{
	private $in_param = array();
	private $keys = array('action', 'image', 'session', 'path', 'name', 'id', 'file', 'type', 'title', 'mode', 'PHPSESSID', 'topHost', 'version');

	function __construct() {
		$this->ProcessRequest();
		$this->Dispatch($this->in_param['action']);
	}

	function BridgeService() {
		header('Content-Type: text/html',true);
		$currentURI = $this->in_param['topHost'] . $_SERVER['PHP_SELF'];
		$currentURI .= '?action=notify';
		$keys = $this->keys;
		foreach ($keys as $v) {
			if ($v == 'action') {
				continue;
			}
			$param = $this->in_param[$v];
			$currentURI .= "&$v=$param";
		}
		echo "<iframe width='0' height='0' src='$currentURI'> </iframe>";
	}

	function NotifyPS() {
		header('Content-Type: text/html',true);
		$json = array();
		foreach ($this->keys as $v) {
			$json[$v] = $this->in_param[$v];
		}
		$json['imageurl'] = $json['image'];
		$json_str = json_encode($json);
		$script = "<script> window.top._redirectMessage('$json_str');</script>";
		echo $script;
	}

	function SaveImage() {
		header('Content-Type: text/javascript');
		$ret = array(
			'result' => true,
			'error' => '',
			'message' => '',
			'imageurl' => '');

		do
		{
			$ret['imageurl'] = $this->in_param['image'];
			$image_data = file_get_contents($this->in_param['image']);
			if (FALSE === $image_data) {
				$ret['result'] = false;
				$ret['error'] = "Sorry, the image download failed.";
				break;
			}

			$image_filename = "/tmp/" . "exported_file" . time() . rand(10000,99999) . ".jpg";
			file_put_contents($image_filename, $image_data);

			if (!file_exists($image_filename)) {
				$ret['result'] = false;
				$ret['error'] = "Temp file cannot be created";
				break;
			}

			$path = base64_decode($this->in_param['path']);

			if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
				$ret['result'] = false;
				$ret['error'] = "Not in service dir";
				unlink($image_filename);
				break;
			}

			$path_info = pathinfo($path);
			
			$albumName = substr($path_info['dirname'], strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1);
			if (!$albumName) {
				$albumName = '/';
			}
			if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
				$ret['result'] = false;
				$ret['error'] = "Dir is not manageable";
				unlink($image_filename);
				break;
			}

			if (strtolower($path_info['extension']) == strtolower($this->in_param['type'])){
				$this->in_param['type'] = $path_info['extension'];
			}

			$title = (empty($this->in_param['mode'])? $path_info['filename'] : (empty($this->in_param['title'])? $path_info['filename'] : $this->in_param['title']));
			$filename = $title . "." . $this->in_param['type'];
			$ret['filename'] = $filename;
			$target_path = $path_info['dirname'] . "/" . $filename;
			$isSameFile = ($target_path == $path);

			if (file_exists($target_path) && !is_writable($target_path)) {
				$ret['result'] = false;
				$ret['error'] = "Target file is read-only";
				break;
			}

			$cwd = @getcwd();

			if (!@chdir($path_info['dirname'])) {
				@chdir($cwd);
				$ret['result'] = false;
				$ret['error'] = "No privilege in the dir";
				unlink($image_filename);
				break;
			}

			foreach(glob('*') as $file) {
				if (strtolower($file) !== strtolower($filename)) {
					continue;
				}

				$eaDir = $path_info['dirname'] . "/@eaDir/" . $file;
				$cmd = "/usr/syno/bin/synophotoio -D ".escapeshellarg($path_info['dirname'] . "/@eaDir/" . $file);
				@exec($cmd);
				$cmd = "/usr/syno/bin/synophotoio -d ".escapeshellarg($path_info['dirname'] . "/" . $file);
				@exec($cmd);
				$cmd = "/usr/syno/bin/synoindex -d ".escapeshellarg($path_info['dirname'] . "/" . $file);
				@exec($cmd);
			}

			@chdir($cwd);

			// move the temp photo to replace original one
			if (!rename($image_filename, $target_path)) {
				$ret['result'] = false;
				$ret['error'] = "Cannot move temp file to target path";
				unlink($image_filename);
				break;
			}

			chmod($target_path, 0777);

			// trigger photo indexing
			$cmd = "/usr/syno/bin/synoindex -a ".escapeshellarg($target_path);
			@exec($cmd);

		} while(false);

		echo json_encode($ret);
	}

	function RenderEditor() {		
		$smarty = $GLOBALS['smarty'];
		//echo "RenderEditor";
		// Prepare data
		$param = array(
			'mode'		=> $_GET['mode'], // !required
			'type'		=> $_GET['type'], // !required
			'image'		=> GetExternalAddr() . $_GET['image'], // !required
			'path'		=> SYNOPHOTO_ImageEditor_PathCheck($_GET['id']), // !required
			'loc'		=> $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'],  // !required
			'id'		=> $_GET['id'], // !required, photo object id
			'title'		=> $_GET['title'], // optional
			'target'	=> $_GET['target'], // optional
			'referrer'	=> $_GET['referrer'], // optional
			'hostname'	=> $_GET['hostname'] // optional
		);

		$path_info = pathinfo($param['path']);
		$param['extension'] = $path_info['extension'];
		$param['path'] = base64_encode($param['path']);
		if ($param['type'] == 'express') {
			$param['title'] = $path_info['filename'];
		}

		// Ready to render page
		$dsmVersion = csSYNOPhotoMisc::GetDsmVersion();
		$packageVersion = csSYNOPhotoMisc::GetPackageVersion();
		$smarty->assign('DSM_VERSION', '?v='.$dsmVersion);
		$smarty->assign('PACKAGE_VERSION', '?v='.$packageVersion);

		$lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
		$smarty->assign('LAN_PARAM', "ln=$lang");

		$external_ip = GetExternalIP();
		$pps = (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches))? (SYNOPHOTO_ADMIN_USER . "/") : "";
		$script .= "var external_ip = '$external_ip';";
		$script .= "var pps = '$pps';";

		$smarty->assign('JS_STRING', $script);
		$smarty->assign('settings', json_encode($param));
		$smarty->display('photo/PixlrEditor.tpl');
	}

	function Dispatch($action) {
		switch ($action) {
		case 'notify':
			$this->NotifyPS();
			break;
		case 'bridge':
			$this->BridgeService();
			break;
		case 'save':
			$this->SaveImage();
			break;
		case 'editor':
			$this->RenderEditor();
			break;
		default:
			$this->BridgeService();
			break;
		}
	}

	function ProcessRequest() {
		$this->in_param = array();
		$keys = $this->keys;
		foreach ($keys as $v) {
			$this->in_param[$v] = $_REQUEST[$v];
		}
		if (strlen($this->in_param['image']) <= 0) {
			$this->in_param['image'] = $this->in_param['file'];
		}
		if (strlen($this->in_param['type']) <= 0) {
			$this->in_param['type'] = 'jpg';
		}

		foreach($this->in_param as $value) {
			if (strlen($value) <= 0) {
				return false;
			}
		}

		return true;
	}

	static function delTree($dir) {
		$files = glob( $dir . '*', GLOB_MARK );
		foreach( $files as $file ){
			if( substr( $file, -1 ) == '/' )
				delTree( $file );
			else
				unlink( $file );
		}
		rmdir( $dir );
	}
}

function GetExternalIP($current = false)
{
	if ($current) {
		return $_SERVER['SERVER_ADDR'];
	}

	$server_ip = csSYNOPhotoMisc::GetExternalIP();
	if (empty($server_ip) || $server_ip == '0.0.0.0') {
		$server_ip = $_SERVER['SERVER_ADDR'];
	}
	return $server_ip;
}

function GetExternalAddr($current = false)
{
	$protocol = (strlen($_SERVER['HTTPS']) > 0)? "https:" : "http:";
	$server_ip = GetExternalIP($current);
	$server_port = $_SERVER['SERVER_PORT'];
	if ($server_port == "80") {
		$addr = "$protocol//$server_ip/";
	}else{
		$addr = "$protocol//$server_ip:$server_port/";
	}

	if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
		$addr .= SYNOPHOTO_ADMIN_USER . "/";
	}
	return $addr;
}

/**
 * return path if id is valid
 */
function SYNOPHOTO_ImageEditor_PathCheck($id)
{
	$id_arr = explode('_', $id);
	if (3 !== count($id_arr) || 'photo' !== $id_arr[0]) {
		SYNOPHOTO_ImageEditor_RedirectToLogin();
	}

	$albumName = @pack('H*', $id_arr[1]);
	$fileName = @pack('H*', $id_arr[2]);
	$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . ('/' === $albumName ? "" : "/" . $albumName) . "/" . $fileName);

	if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1) ||
		!csSYNOPhotoMisc::CheckAlbumManageable($albumName) || !@file_exists($path)) {
		SYNOPHOTO_ImageEditor_RedirectToLogin();
	}

	return $path;
}

function SYNOPHOTO_ImageEditor_RedirectToLogin()
{
	echo "<script>";
	echo "parent.location = \"".SYNOPHOTO_URL_PREFIX."/photo/login.php?url=".bin2hex($_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING'])."\";";
	echo "</script>";
	exit;
}

new ImageEditorHandler();

?>
