BEGIN;

CREATE TABLE video
(
  id serial NOT NULL,
  path text NOT NULL,
  title text NOT NULL,
  filesize int8 NOT NULL DEFAULT 0,
  album text,
  container_type text NOT NULL,
  video_codec text,
  frame_bitrate int4,
  frame_rate_num int4,
  frame_rate_den int4,
  video_bitrate int4,
  video_profile int4,
  video_level int4,
  resolutionX int4,
  resolutionY int4,
  audio_codec text,
  audio_bitrate int4,
  frequency int4,
  channel int4,
  duration int4,
  date timestamp,
  mdate timestamp,
  CONSTRAINT video_primary_key PRIMARY KEY (id)
)
WITHOUT OIDS;
CREATE INDEX video_title_idx ON video USING btree (title);
CREATE INDEX video_date_idx ON video USING btree (date);
CREATE INDEX video_mdate_idx ON video USING btree (mdate);
CREATE UNIQUE INDEX video_path_idx ON video USING btree (path);

CREATE TABLE video_convert (
 video_path text NOT NULL,
 convert_file_path text NOT NULL,
 resolutionx int4 DEFAULT NULL,
 resolutiony int4 DEFAULT NULL,
 container_type text NOT NULL,
 video_bitrate int4 DEFAULT NULL,
 vcodec text DEFAULT NULL,
 video_profile int4 DEFAULT NULL,
 video_level int4 DEFAULT NULL,
 acodec text DEFAULT NULL,
 audio_bitrate int4 DEFAULT NULL,
 audio_frequency int4 DEFAULT NULL,
 audio_channel int4 DEFAULT NULL,
 convert_type text NOT NULL,
 CONSTRAINT video_convert_pkey PRIMARY KEY (convert_file_path),
 CONSTRAINT video_convert_fk1 FOREIGN KEY (video_path) REFERENCES video (path) ON DELETE CASCADE ON UPDATE CASCADE
)
WITHOUT OIDS;
CREATE INDEX video_convert_convert_type_idx ON video_convert USING btree (convert_type);
CREATE INDEX video_convert_video_path_idx ON video_convert USING btree (video_path);

COMMIT;
