#!/bin/sh
# Copyright (c) 2003-2012 Synology Inc. All rights reserved.

SQLITE="/usr/syno/bin/sqlite3"
UPGRADE_DIR="/var/packages/PhotoStation/target/photo_scripts/sql/pps_upgrade"
UPGRADE_SCRIPT="012_pps_modify_label_constraint.sql"
NEW_CONSTRAINT_STR="id INTEGER PRIMARY KEY"

echo "Update photo_label table to test constraint correct"
SQL="select sql from sqlite_master where type='table' and name='photo_label'"
db=$1

$SQLITE "$db" "$SQL" | grep "$NEW_CONSTRAINT_STR" > /dev/null 2>&1
Ret=$?

if [ $Ret = 1 ]; then
	echo "Change primary key constraint to photo_label table"
	Script="$UPGRADE_DIR/$UPGRADE_SCRIPT"

	$SQLITE "$db" < $Script
	if [ $? != 0 ]; then
		echo "Failed to upgrade photo database"
		exit 2
	fi
fi
