#!/bin/sh
# Copyright (c) 2003-2011 Synology Inc. All rights reserved.

SQLITE="/usr/syno/bin/sqlite3"
UPGRADE_DIR="/var/packages/PhotoStation/target/photo_scripts/sql/pps_upgrade"
UPGRADE_SCRIPT="003_pps_alter_video_profile_type.sql"

echo "To test if video_profile exists in table video"
SQL="SELECT video_profile FROM video"
db=$1
$SQLITE "$db" "$SQL" >/dev/null 2>&1
Ret=$?
if [ $Ret = 1 ]; then
	echo "Create more video profile columns in $db"
	Script="$UPGRADE_DIR/$UPGRADE_SCRIPT"

	$SQLITE "$db" < $Script
	if [ $? != 0 ]; then
		echo "Failed to create more video profile columns in $db"
		exit 2 # error
	fi
        exit 1 # need reindex
fi

