
BEGIN;

create table blog_config
(
  config_id serial NOT NULL,
  module_name varchar(128) NOT NULL,
  config_key varchar(512) NOT NULL,
  config_value text,
  CONSTRAINT blog_config_pkey PRIMARY KEY (config_id)
);

INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'header_picture', 'Temple_of_Guangong_for_Official_Ritual,Tainan,Taiwan.jpg');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'blog_title', 'WELCOME TO BLOG');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'page_title', 'Synology Blog');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'article_num', '5');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'date_format', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'layout_type', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'layout_right', 'photo_slide,recent_article,recent_comment,article_collection');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'layout_left', 'search,personal_information,friend_link,label_cloud,statistical_data');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'view_today', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'view_total', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'view_last', '0');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'show_top_header_logo', '1');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('main', 'autosave_interval', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('recent_article', 'number', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('recent_comment', 'number', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('photo_slide', 'album_name', '');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('photo_slide', 'slide_interval', '3');
INSERT INTO blog_config (module_name, config_key, config_value) VALUES('google_ad', 'code', '');

create table blog_module
(
  module_name varchar(128) NOT NULL,
  provide_setting bool DEFAULT false,
  CONSTRAINT blog_module_pkey PRIMARY KEY (module_name)
);

INSERT INTO blog_module VALUES('personal_information', true);
INSERT INTO blog_module VALUES('friend_link', true);
INSERT INTO blog_module VALUES('label_cloud', false);
INSERT INTO blog_module VALUES('statistical_data', false);
INSERT INTO blog_module VALUES('photo_slide', true);
INSERT INTO blog_module VALUES('recent_article', true);
INSERT INTO blog_module VALUES('recent_comment', true);
INSERT INTO blog_module VALUES('article_collection', false);
INSERT INTO blog_module VALUES('search', false);
INSERT INTO blog_module VALUES('google_ad', true);

create table blog_label
(
  label_id serial NOT NULL,
  label_name text NOT NULL,
  article_count int4 DEFAULT 0,
  CONSTRAINT blog_label_pkey PRIMARY KEY (label_id),
  CONSTRAINT blog_label_label_name_key UNIQUE (label_name)
);

INSERT INTO blog_label (label_name, article_count) VALUES('no_label', 1);

create table blog_article
(
  article_id serial NOT NULL,
  author varchar(128) NOT NULL,
  date timestamp,
  title text NOT NULL,
  abstract text,
  content text NOT NULL,
  viewing_privilege int4 DEFAULT 0,
  access_key varchar(512),
  access_key_hint varchar(512),
  allow_comment bool DEFAULT true,
  hits int4 DEFAULT 0,
  draft int4 DEFAULT 0,
  show_abstract bool DEFAULT false,
  CONSTRAINT blog_article_pkey PRIMARY KEY (article_id),
  CHECK (draft IN (-1, 0, 1))
);

INSERT INTO blog_article (author, date, title, content) VALUES('Synology Blog', '2008-01-01 00:00:00', 'Synology Blog', '<font size="2" face="Arial"><p>Welcome! This is your first blog post on <a target="_blank" href="http://www.synology.com">Synology</a> <font color="#996600">Photo Station</font>. You can freely share wonderful living experiences here with all your friends.</p><p>Please sign in to add a new post or customize your Photo Station Blog.</p></font>');

create table blog_article_label
(
  article_label_id serial NOT NULL,
  label_id int4 NOT NULL,
  label_name text NOT NULL,
  article_id int4 NOT NULL,
  CONSTRAINT blog_article_label_pkey PRIMARY KEY (article_label_id)
);

INSERT INTO blog_article_label (label_id, label_name, article_id) VALUES(1, 'no_label', 1);

create table blog_article_autosave
(
  article_autosave_id serial NOT NULL,
  autosave_id int4 NOT NULL,
  article_id int4 NOT NULL,
  CONSTRAINT blog_article_autosave_pkey PRIMARY KEY (article_autosave_id)
);

create table blog_comment
(
  comment_id  serial NOT NULL,
  article_id int4 NOT NULL,
  username varchar(128) NOT NULL,
  email varchar(128),
  ip varchar(64) NOT NULL,
  date timestamp,
  comment text NOT NULL,
  CONSTRAINT blog_comment_pkey PRIMARY KEY (comment_id)
);

COMMIT;
