#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.

HOME_PHOTO_DIR="/var/services/photo/"
COVER_FILE="SYNOPHOTO:ALBUM.cover"
FIND="/usr/bin/find"
DB_FILE=".SYNOPPSDB"
COVER_EXT=".cover"
SQLITE="/usr/syno/bin/sqlite3"

db="$1"
flag=$1".convertflag"
if [ -e "$flag" ]; then
    echo "Need to do convert job"
else
    echo "Flag file not exist"
    exit # marked as nothing to do
fi

OLDIFS=$IFS # to handle the case with spaces in the filename
IFS="
"
########################################################################
# Process personal photo sqlite db
########################################################################
echo "Processing personal photo station database / .cover files"

Arg=$1
names=$($SQLITE "$Arg" "SELECT sharename from photo_share where cover !=''")
for name in $names;
do
    folder_path=$(echo $Arg | sed "s/$DB_FILE//g")
    eadir=$folder_path"@eaDir/"$name
    mkdir -p "$eadir"
    chmod 777 "$eadir"
    cover=$($SQLITE "$Arg" "SELECT cover from photo_share where sharename='$name'")
    folder_prefix=$(echo $folder_path | sed "s!\/!\\\\/!g")
    relative_path=$(echo $cover | sed "s/$folder_prefix//g" | sed "s/$name\///g" )
    newpath=$folder_path"@eaDir/"$name/$COVER_FILE
    echo $relative_path > "$newpath"
    chmod 777 "$newpath"
done

# do the personal .cover files searching here
folder_path=$(echo $Arg | sed "s/$DB_FILE//g")
files=`$FIND $folder_path -name "$COVER_EXT" | sort`
for ThisArg in $files;
do
    newpath=$(echo $ThisArg | sed "s/$COVER_EXT/$COVER_FILE/g")
    prefix_path=$(echo $ThisArg | sed "s/@eaDir\///g" | sed "s/$COVER_EXT//g" | sed "s!\/!\\\\/!g")
    relative_path=$(cat $ThisArg | sed "s/$prefix_path//g")
    touch "$newpath"
    echo $relative_path > "$newpath"
    chmod 777 "$newpath"
    rm "$ThisArg" # remove original .cover files
done

IFS=$OLDIFS # restore the field separator
rm "$flag" # remove the flag to mark as done


