#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.

HOME_PHOTO_DIR_PREFIX="\/var\/services\/photo\/" # for regular expression replacement
HOME_PHOTO_DIR="/var/services/photo/"
COVER_FILE="SYNOPHOTO:ALBUM.cover"
FIND="/usr/bin/find"
COVER_EXT=".cover"
FLAG_FILE=$HOME_PHOTO_DIR".convertflag"

if [ $1 = "restore" ]; then
    echo "Restore cover using skip mode"
    touch "/var/services/photo/.convertflag"
fi

if [ -e $FLAG_FILE ]; then
    echo "Need to do convert job"
else
    echo "Flag file not exist"
    exit # marked as nothing to do
fi

#######################################################################
# Pass 1 - Dump the cover info from pgsql as SNYOPHOTO:ALBUM.cover
#######################################################################
echo "Processing cover info from pgsql to SYNOPHOTO:ALBUM.cover"

OLDIFS=$IFS # to handle the case with spaces in the filename
IFS="
"

names=$(su admin -c "/usr/syno/pgsql/bin/psql photo -tc \"select sharename from photo_share where cover !=''\"")
for n in $names;
do
    n=$(echo $n | sed "s/^ //g")
    cover=$(su admin -c "/usr/syno/pgsql/bin/psql photo -tc \"select cover from photo_share where sharename = '$n'\"" | sed "s/$HOME_PHOTO_DIR_PREFIX//g" | sed "s/$n\///g")
    cover=$(echo $cover | sed "s/^ //g")
    eadir=$HOME_PHOTO_DIR"@eaDir/"$n
    mkdir -p "$eadir"
    chmod 777 "$eadir"
    newpath="$HOME_PHOTO_DIR""@eaDir/$n/$COVER_FILE"
    if [ $2 = "skip" -a -e $newpath ]; then
        echo "$newpath is exist"
    else
	echo $cover > "$newpath"
    fi
    chmod 777 "$newpath"
done

########################################################################
# Pass 2 - Transform all .cover files as SYNOPHOTO:ALBUM.cover
########################################################################
echo "Processing all .cover files as SYNOPHOTO:ALBUM.cover files"

files=`$FIND $HOME_PHOTO_DIR -name "$COVER_EXT" | sort`
for ThisArg in $files;
do
    newpath=$(echo $ThisArg | sed "s/$COVER_EXT/$COVER_FILE/g")
    prefix_path=$(echo $ThisArg | sed "s/@eaDir\///g" | sed "s/$COVER_EXT//g" | sed "s!\/!\\\\/!g")
    relative_path=$(cat $ThisArg | sed "s/$prefix_path//g")
    if [ $2 = "skip" -a -e $newpath ]; then
	echo "$newpath is exist"
    else
	touch "$newpath"
	echo $relative_path > "$newpath"
    fi

    chmod 777 "$newpath"
    rm $ThisArg # remove original .cover file
done

IFS=$OLDIFS # restore the field separator
rm $FLAG_FILE # remove the flag to mark as done
