<?
require_once('albumutil.php');
require_once('photoutil.php');

$id_str = $_GET['id'];
$id_arr = explode('_', $id_str);
if (3 !== count($id_arr) || ('photo' !== $id_arr[0] && 'video' !== $id_arr[0])) {
    $error = true;
}
$albumName = @pack('H*', $id_arr[1]);
$fileName = @pack('H*', $id_arr[2]);
$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . "/" . $fileName);

$item = checkVideoAvailable($albumName, $path, $id_arr[0]);

if ($item) {
    $quality_id = findQualityId($item['additional']['video_quality'], $_GET['quality']);
    $videoType = $item['additional']['video_quality'][0]['container'];
    $video = SYNOPHOTO_URL_PREFIX . "/photo/webapi/download.php/1.mp4?api=SYNO.PhotoStation.Download&method=getvideo&version=1&id=$id_str&quality_id=$quality_id";
    $image = SYNOPHOTO_URL_PREFIX . "/photo/webapi/thumb.php?api=SYNO.PhotoStation.Thumb&method=get&version=1&id=$id_str&size=large";
    $title = $item['info']['title'].' - '. __(photo_str_ap_name_6);
} else {
    $title = __(photo_str_ap_name_6);
}

function findQualityId ($videoQuality, $qualityProfileName)
{
    if (!$videoQuality) {
	return '';
    }
    foreach ($videoQuality as $i) {
	if ($qualityProfileName == $i['profile_name']) {
	    return $i['id'];
	}
    }
    usort($videoQuality, function($a, $b) {
	$profileOrder = Array('high'=>0, 'medium'=>1, 'low'=>2, 'orig_h264'=>3, 'mobile'=>4, 'flv'=>5);
	return $profileOrder[$a['profile_name']] > $profileOrder[$b['profile_name']] ? 1 : -1;
    });
    return $videoQuality[0]['id'];
}

function checkVideoAvailable ($albumName, $path, $type)
{
    if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
	return false;
    }

    csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
    if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName)) {
	return false;
    }

    if (@file_exists($path)) {
	if (!($item = PhotoAPIUtil::getItemByPath($path, 'video_quality', $type, false))) {
	    return false;
	}
    }
    return $item;
}

?>
<!DOCTYPE html>
<html><head><title><?= $title ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<script type="text/javascript" src="../jwplayer/jwplayer.js"></script>
	<script type="text/javascript" src="../photo_new/syno_embed.js"></script>
	<link rel="shortcut icon" href="../favicon.ico">
</head><body>
<? if ($error) {?>
<div style=text-align:center;margin-top:100px><?=__(photo_str_video_unavailable)?></div>
<? } else {?>
<div id='player'></div>
<script>
var video = "<?= $video?>",
    image = "<?= $image?>",
    videoType = "<?= $videoType?>";
</script>
<?}?>
</body></html>
