<?
require_once("include/syno_conf.php");

header('Content-Type: application/rss+xml');
csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

$is_for_dir = 0;
if(isset($_GET['dir']) && $_GET['dir'] != "") {
	if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName = @pack('H*', $_GET['dir']))) {
		header("Location: index.php");
		exit;
	}
	$is_for_dir = 1;
}

$is_for_smart_album = 0;
$is_for_virtual_album = 0;
$smartType = 0;
$virtualType = 0;
if(isset($_GET['smart_album']) && $_GET['smart_album'] != "") {
	$is_for_smart_album = 1;
	$smartType = intval($_GET['smart_album']);
} else if (isset($_GET['virtual_album']) && $_GET['virtual_album'] != "") {
	$is_for_virtual_album = 1;
	$virtualType = intval($_GET['virtual_album']);
}

$labelId = null;
$label = null;
if ($virtualType >=4 && $virtualType <= 6) {
	if (isSet($_GET['id'])) {
		$labelId = intval($_GET['id']);
		if ($labelId !== -1 && false !== ($res = SYNOPHOTO_LABEL_UTIL_GetLabelById($labelId))) {
			$labelId = null;
		}
	}
}


$is_for_cooliris = 0;
if(isset($_GET['for_cooliris']) && $_GET['for_cooliris'] != "") {
	$is_for_cooliris = 1;
}

$urlprefix = SYNOPHOTO_RSS_GetURLPrefix();

$allow_orig = 0;
if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'piclens_use_orig') == 'on' &&
	csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_orig') == 'on') {
	$allow_orig = 1;
}

$serverHost = csSYNOPhotoMisc::GetServerHost();

echo "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>\n";
echo "<rss version=\"2.0\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:atom=\"http://www.w3.org/2005/Atom\">\n";
echo "<channel>\n";

if($is_for_dir) {
	SYNOPHOTO_RSS_GetPicLensRSS();
} else if ($is_for_smart_album) {
	SYNOPHOTO_RSS_GetSmartAlbumRSS($smartType);
} else if($is_for_virtual_album) {
	SYNOPHOTO_RSS_GetVirtualAlbumRSS($virtualType, $labelId);
} else {
	SYNOPHOTO_RSS_GetVirtualAlbumRSS(0);
}

echo "</channel>\n";
echo "</rss>\n";

function SYNOPHOTO_RSS_GetPicLensRSS()
{

	$album = @pack('H*', $_GET['dir']);
	$album_link = $serverHost.SYNOPHOTO_URL_PREFIX. "/photo/photo_thumb.php?dir=" . $_GET['dir'];

	echo "<atom:icon>images/ps5_logo.png</atom:icon>\n";
	echo "<title>". htmlspecialchars($album) . "</title>\n";
	echo "<link>$album_link</link>";

	$title = csSYNOPhotoDB::GetDBInstance()->GetConfig("photo", "photo_page_title");
	if($title === false || $title == "") {
		$title = __(photo_str_ap_name);
	}
	echo "<description>".htmlspecialchars($title)."</description>\n\n";

	$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbListAll($album);

	foreach($photoList['items'] as $item) {
		if ($item['itemType'] == 1) {
			SYNOPHOTO_RSS_GetOneItem($item);
		} else if ($item['itemType'] == 2) {
			SYNOPHOTO_RSS_GetVideoItem($item);
		}

	}
}

function SYNOPHOTO_RSS_GetVirtualAlbumRSS($type, $labelId = null)
{
	$hostname = csSYNOPhotoMisc::GetConfigFile('/etc/sysconfig/network', 'HOSTNAME');
	$hostname = $hostname['HOSTNAME'];

	$album_link = $serverHost.SYNOPHOTO_URL_PREFIX."/photo/photo_thumb.php?virtual_album=".$type;

	echo "<atom:icon>images/ps5_logo.png</atom:icon>\n";
	echo "<title>".htmlspecialchars($hostname)."'s Photo</title>\n";
	echo "<link>$album_link</link>\n";

	$title = csSYNOPhotoDB::GetDBInstance()->GetConfig("photo", "photo_page_title");
	if($title === false || $title == "") {
		$title = __(photo_str_ap_name);
	}
	echo "<description>".htmlspecialchars($title)."</description>\n\n";

	switch($type) {
	case 0:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('photo');
		break;
	case 1:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('video');
		break;
	case 2:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('photo', true);
		break;
	case 3:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('video', true);
		break;
	case 4:
	case 5:
	case 6:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetLabelAlbumRSSList($type, $labelId);
		break;
	}

	$GLOBALS['printed_items_count'] = 0;
	foreach($photoList['items'] as $item) {
		if($item.itemType == 2) {
			SYNOPHOTO_RSS_GetVideoItem($item);
		} else {
			SYNOPHOTO_RSS_GetOneItem($item);
		}
		$GLOBALS['printed_items_count']++;
	}
}

function SYNOPHOTO_RSS_GetSmartAlbumRSS($smartType)
{
	$album = @pack('H*', $_GET['smart_album']);
	$album_link = $serverHost.SYNOPHOTO_URL_PREFIX. "/photo/photo_thumb.php?smart_album=".$_GET['smart_album'];

	echo "<atom:icon>images/ps5_logo.png</atom:icon>\n";
	echo "<title>".htmlspecialchars($album)."</title>\n";
	echo "<link>$album_link</link>";

	$title = csSYNOPhotoDB::GetDBInstance()->GetConfig("photo", "photo_page_title");
	if($title === false || $title == "") {
		$title = __(photo_str_ap_name);
	}
	echo "<description>".htmlspecialchars($title)."</description>\n\n";

	$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSmartAlbumItemList(@pack('H*', $_GET['smart_album']));

	foreach($photoList['items'] as $item) {
		if ($item['itemType'] == 1) {
			SYNOPHOTO_RSS_GetOneItem($item);
		} else if ($item['itemType'] == 2) {
			SYNOPHOTO_RSS_GetVideoItem($item);
		}
		$GLOBALS['printed_items_count']++;
	}
}

function SYNOPHOTO_RSS_GetURLPrefix() {
	if(!$_SERVER['HTTP_HOST']) {
		return "";
	}
	$ht = $_SERVER["HTTPS"] ? "https":"http";
	return $ht . '://' . $_SERVER['HTTP_HOST'];
}

function SYNOPHOTO_RSS_UrlEncode($url)
{
	return str_replace(
		array('%', '"', '#', '&', "'", '+', '/', '?'),
		array('%25', '%22', '%23', '%26', '%27', '%2B', '%2F', '%3F'), $url);
}

function SYNOPHOTO_RSS_GetOneItem($data, $isNewPhoto = false)
{
	global $allow_orig, $is_for_cooliris, $is_for_virtual_album;
	global $serverHost;

	$path = $data['path'];
	$dir = bin2hex(substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR."/"), strlen($path) - strlen(SYNOPHOTO_SERVICE_REAL_DIR."/") - strlen(basename($path)) - 1));
	$bname = basename($path);
	$name = bin2hex($bname);
	$have_thumb = csSYNOPhotoMisc::IsPhotoFileWithThumb($bname);

	$bname = SYNOPHOTO_RSS_UrlEncode($bname);
	$thumbnail = $serverHost.SYNOPHOTO_URL_PREFIX."/photo/convert.php/{$bname}?dir={$dir}&name={$name}&type=";
	$thumbnail .= $have_thumb ? '4' : '2';

	$thumbType = 'jpeg';
	if (!$have_thumb) {
		$path = strtolower($bname);
		$path_parts = pathinfo($path);
		$thumbType = $path_parts['extension'];
	}

	$content = $serverHost.SYNOPHOTO_URL_PREFIX."/photo/convert.php/{$bname}?dir={$dir}&name={$name}&type=";
	$content .= ($allow_orig || !$have_thumb) ? '2' : '1';

	$title = $data['title'];
	$link = $serverHost.SYNOPHOTO_URL_PREFIX."/photo/photo_one.php?name={$name}&dir={$dir}";
	if($is_for_virtual_album || $is_for_smart_album) {
		$link = $link."&current_key=".$GLOBALS['printed_items_count'];
	}
	$description = $is_for_cooliris ? '' : "<img src=\"{$thumbnail}\"/><br/>".$data['desc'];
	if ($isNewPhoto) {
		$description = $is_for_cooliris ? '' : "<img src=\"{$thumbnail}\"/><br/>".$data['description'];
	}

	echo "<item>\n";
	echo "<title>".htmlspecialchars($title)."</title>\n";
	echo "<link>".htmlspecialchars($link)."</link>\n";
	echo "<description>".htmlspecialchars($description)."</description>\n";
	echo "<media:thumbnail url=\"".htmlspecialchars($thumbnail)."\"/>\n";
	echo "<media:content url=\"".htmlspecialchars($content)."\"/>\n";
	echo "<enclosure url=\"".htmlspecialchars($content)."\" type=\"image/{$thumbType}\" />";
	echo "</item>\n";
}

function SYNOPHOTO_RSS_GetVideoItem($data)
{
	global $is_for_cooliris, $is_for_virtual_album;
	global $serverHost;

	$path = $data['path'];
	$dir = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR."/"), strlen($path) - strlen(SYNOPHOTO_SERVICE_REAL_DIR."/") - strlen(basename($path)) - 1);
	$bname = basename($path);

	if (empty($data['video']['flv_src'])) {
		return;
	}

	$name = bin2hex($bname);
	$dir = bin2hex($dir);

	$bname = SYNOPHOTO_RSS_UrlEncode($bname);
	if($is_for_cooliris) {
		// Bug #14000, to fix filename problem in Cooliris
		$bname = rawurlencode($bname);
	}

	$thumbnail = $serverHost.SYNOPHOTO_URL_PREFIX."/photo/convert.php/{$bname}_thumb.jpg?dir={$dir}&name={$name}&type=1";
	$content = $serverHost.SYNOPHOTO_URL_PREFIX."/photo/convert.php/{$bname}.flv?dir={$dir}&name={$name}&type=3";

	$link = $serverHost.SYNOPHOTO_URL_PREFIX."/photo/photo_one.php?name={$name}&dir={$dir}";
	if($is_for_virtual_album || $is_for_smart_album) {
		$link = $link."&current_key=".$GLOBALS['printed_items_count'];
	}
	$title = $data['title'];
	$description = $data['desc'];
	$description = $is_for_cooliris ? '' : "<img src='{$thumbnail}'/><br/>{$description}";
	echo "<item>\n";
	echo "<title>".htmlspecialchars($title)."</title>\n";
	echo "<link>".htmlspecialchars($link)."</link>\n";
	echo "<description>".htmlspecialchars($description)."</description>\n";
	echo "<media:thumbnail url=\"".htmlspecialchars($thumbnail)."\"/>\n";
	echo "<media:content url=\"".htmlspecialchars($content)."\" type=\"video/x-flv\"/>\n";
	echo "<enclosure url=\"".htmlspecialchars($content)."\" type=\"video/x-flv\" />";
	echo "</item>\n";
}
?>
