<?php
require_once("include/syno_conf.php");

if (isSet($_GET['sid']) && isSet($_GET['usr']) && 13 == strlen($_GET['sid'])) {
    $isDemoMode = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, 'enable_demomode');
	// need these params first
	if (('yes' !== $isDemoMode['enable_demomode']) && ('root' != SYNOPHOTO_ADMIN_USER || $_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] || strtoupper($_GET['usr']) == "ADMIN") &&
		// leave when not personal and not dsm account and not admin
		 (
			(isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] == $_GET['usr']) ||
			((strtoupper($_GET['usr']) == "ADMIN" || strtoupper($_GET['usr']) == strtoupper(SYNOPHOTO_ADMIN_NAME)) &&
				!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) &&
				$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] == SYNOPHOTO_ADMIN_PASS) ||
					loginFromDsm($_GET['usr'], $_GET['sid'], $_SERVER['REMOTE_ADDR'])
		// user alredy login or loginFromDsm() return true, we done.
		)) {
		header("HTTP/1.1 301 Moved Permanently");
		header('location: ' . SYNOPHOTO_URL_PREFIX . '/photo/');
	}
}

if (isSet($_GET['sid'])) {
	// not login from dsm.
	header("HTTP/1.1 301 Moved Permanently");
	header('location: ' . SYNOPHOTO_URL_PREFIX . '/photo/');
}

$dsmVersion = csSYNOPhotoMisc::GetDsmVersion();
$packageVersion = csSYNOPhotoMisc::GetPackageVersion();
$lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];

$dsmVersionAndLan = '?v='. $dsmVersion .'&ln='. $lang;
$packageVersionAndLan = '?v='. $packageVersion .'&ln='. $lang;
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<link rel="shortcut icon" href="images/ps_icon.png">
	<!-- GC -->
	<link rel="stylesheet" type="text/css" 	href="scripts/ext-3/resources/css/ext-all.css<?php echo $dsmVersionAndLan;?>" />
	<link rel="stylesheet" type="text/css" href="scripts/ext-3/resources/css/xtheme-gray-syno.css<?php echo $dsmVersionAndLan;?>" />
	<link rel="stylesheet" type="text/css" href="css/dsm_resources/css/desktop.css<?php echo $packageVersionAndLan;?>" />
	<link rel="stylesheet" type="text/css" href="css/common.css<?php echo $packageVersionAndLan;?>" />
	<!-- LIBS -->
	<script type="text/javascript" src="scripts/uistrings.php<?php echo $dsmVersionAndLan;?>"></script>
	<script type="text/javascript" src="scripts/ext-3/adapter/ext/ext-base.js<?php echo $dsmVersionAndLan;?>"></script>
	<script type="text/javascript" src="scripts/ext-3/ext-all.js<?php echo $dsmVersionAndLan;?>"></script>
	<script type="text/javascript" src="scripts/ext-3/ux/ux-all.js<?php echo $dsmVersionAndLan;?>"></script>

	<!-- String Script -->
	<script type="text/javascript" src="include/client_string.php<?php echo $packageVersionAndLan;?>"></script>
	<script type="text/javascript" src="javascripts/synophoto_common.js<?php echo $packageVersionAndLan;?>"></script>

	<link rel="stylesheet" href="css/photo_style.css<?php echo $packageVersionAndLan;?>">
	<style type="text/css">
		html, body {height: 100%}
	</style>
</head>
<body>
<div class="login-div" id="syno_login_dialog">
	<div class="header"> <span class="ap-name">Photo station</span> <span class="close-btn" id="syno_login_close"></span></div>
	<iframe name="login_iframe" width="0" height="0" frameborder="0"></iframe>
		<form id="login_form" class="login_form" method="GET" action="photo_login.php" target="login_iframe">
		<input type="hidden" id="login_action" name="action" value="login" />
		<input type="text" id="login_username" name="username" class="sbox-text login-input" />
		<input type="password" id="login_passwd" name="passwd" class="sbox-text login-input"/>
		<input type="submit" id="login_submit" name="submit" style="display: none;">
	</form>
	<div class="login-btn" id="syno_login_enter"></div>
	<div class="login-status login_error" id="login_status"></div>
</div>
<script  type="text/javascript">
<?php
if (isSet($_GET['password'])) {
?>

var dialog = new PhotoPasswordDialog({
	albumName: '<?php echo addslashes($_GET['albumName']); ?>',
	url: '<?php echo @pack('H*', $_GET['url']); ?>'
});
dialog.show();

<?php
} else {
?>

var login_dialog = new LoginDialog({url: '<?php echo @pack('H*', $_GET['url']); ?>'});
login_dialog.show();

<?php
}
?>
</script>
</body>
</html>
<?php
function loginFromDsm ($user, $session_id, $ip)
{
	$login_status = false;

	$enable_demomode = false;
	$conf = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, 'enable_demomode');
	if ('yes' == $conf['enable_demomode']) {
		$enable_demomode = true;
	}
	$commend = "/usr/syno/bin/synoautoblock --deny \"".$ip."\"";
	@system($commend, $retval);
	$commend = "";
	if ($retval == 1) {
		return $login_status;
	}

	// try to match ip
	$currentUser = array();
	$command = "/usr/syno/bin/synophoto_dsm_user --current";
	@exec($command, $currentUser, $retval);
	if (0 != $retval) {
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog("Failed to get current user");
		return $login_status;
	}
	foreach($currentUser as $currentUserLine) {
		$arr_user_info = split(",", $currentUserLine, 5);
		if ($ip  == $arr_user_info[0] && $user  == $arr_user_info[1] && $session_id  == $arr_user_info[2]) {
			$login_status = true;
			break;
		}
	}
	if (0 != preg_match('/[\\\]/', $user)) {
		$user = substr($user, strrpos($user, '\\') + 1);
	}
	if (0 != preg_match('/[@]/', $user)) {
		$user = substr($user, 0, strrpos($user, '@'));
	}

	if (false == $login_status) {
		if ($enable_demomode) {
			csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($user." failed to login from "."[xxx.xxx.xxx.xxx]", "f", $user);
		} else {
			csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($user." failed to login from "."[".$ip."]", "f", $user);
		}
		return $login_status;
	}

	// get user info
	$user_info = array();
	$command = "/usr/syno/bin/synophoto_dsm_user --getinfo ".escapeshellarg($user);
	@exec($command, $pUser, $retval);
	$user_info = SYNOPHOTO_LoginUserDataPaser($pUser);
	if (0 != $retval) {
		if ($enable_demomode) {
			csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($user." failed to login from "."[xxx.xxx.xxx.xxx]", "f", $user);
		} else {
			csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($user." failed to login from "."[".$ip."]", "f", $user);
		}
		return 0;
	}

	//login act
	unset($_SESSION[SYNOPHOTO_ADMIN_USER]);
	session_start();
	csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
	if (strtoupper($user) == "ADMIN" || strtoupper($user) == strtoupper(SYNOPHOTO_ADMIN_NAME)) {// admin
		$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
	} else {// user
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_userid'] = $user_info[2];
		$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] = $user_info[0];
		$_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] = true;
		if ($user_info[10]) {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] = SYNOPHOTO_ADMIN_PASS;
		}
	}

	$commend = "/usr/syno/bin/synoautoblock --reset \"".$ip."\"";
	@system($commend, $retval);
	if ($enable_demomode) {
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($user." logged in from "."[xxx.xxx.xxx.xxx]", "t", strtolower($user));
	} else {
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($user." logged in from "."[".$ip."]", "t", strtolower($user));
	}
	return $login_status;

}

function SYNOPHOTO_LoginUserDataPaser($pUser)
{
	global $SYNOPHOTO_DSM_USER_INFO;
	$result = array();
	if (!is_array($pUser)) {
		return null;
	}
	$i = 0;
	foreach ($pUser as $item) {
		if (!preg_match('/(^\w+\s?\w+)\s*\:/', $item, $match) || !preg_match('/\[(.*)\]/', $item, $match_val)) {
			continue;
		}

		if (false !== $index = array_search($match[1], $SYNOPHOTO_DSM_USER_INFO)) {
			$result[$index] = $match_val[1];
		}
	}
	return $result;
}
?>
