<?php
require_once(SYNOPHOTO_INCLUDE_DB);
require_once(SYNOPHOTO_FB_UTILS);
require_once(SYNOPHOTO_FB_SDK);
require_once SYNOPHOTO_INCLUDE_EA;

/*!
 * static misc function
 */
class csSYNOPhotoMisc {

	/*!
	 * check the prefix of files in eaDir is old or not
	 */
	static function IsOldEAFilePrefix() {
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['dsmCfg']['buildnumber'] >= SYNOPhotoEA::OLD_EADIR_PREFIX_DSM_VERSION) {
			return false;
		}
		return true;
	}

	static function showArray($input, $type = "console", $level = 0, $currentKey = "") {
		$output = "";
		$now_level = $level;
		$pre = "";

		$end = "\n";
		$preUnit = "   ";

		if ("web" === $type ) {
			$end = "<br>";
			$preUnit = "&nbsp;&nbsp;&nbsp;";
		}

		while ($now_level-- > 0)
			$pre = $preUnit.$pre;

		if ($level == 0)
			$output .= $end;

		if (is_array($input) || is_object($input)) {
			if (is_object($input)) {
				$input = get_object_vars($input);
				$output .= $pre."[$level:$currentKey(object)] {".$end;
			} else {
				$output .= $pre."[$level:$currentKey(array)] {".$end;
			}

			$res = array();
			//$output .= $pre."[$level:$currentKey(array)] {".$end;

			foreach($input as $key => $value)
				$res[] = csSYNOPhotoMisc::showArray($value, $type, $level + 1, $key);

			$output .= join($res, "");

			$output .= $pre."}".$end;

			return $output;
		} else {
			$output .= $pre."[$level:$currentKey] ".$input.$end;
			return $output;
		}
	}

	/**
	* Indents a flat JSON string to make it more human-readable
	*
	* @param string $json The original JSON string to process
	* @return string Indented version of the original JSON string
	*/
	function indentJson($json)
	{
		if (!json_decode($json)) {
			return $json;
		}

		$result = '';
		$pos = 0;
		$strLen = strlen($json);
		$indentStr = "\t";
		$newLine = "\n";
		$prevChar = '';
		$outOfQuotes = true;

		for($i = 0; $i <= $strLen; $i++) {
			// Grab the next character in the string
			$char = substr($json, $i, 1);

			// Are we inside a quoted string?
			if($char == '"' && $prevChar != '\\') {
				$outOfQuotes = !$outOfQuotes;
			}
			// If this character is the end of an element,
			// output a new line and indent the next line
			else if(($char == '}' || $char == ']') && $outOfQuotes) {
				$result .= $newLine;
				$pos --;
				for ($j=0; $j<$pos; $j++) {
					$result .= $indentStr;
				}
			}
			// Add the character to the result string
			$result .= $char;

			// If the last character was the beginning of an element,
			// output a new line and indent the next line
			if (($char == ',' || $char == '{' || $char == '[') && $outOfQuotes) {
				$result .= $newLine;
				if ($char == '{' || $char == '[') {
					$pos ++;
				}
				for ($j = 0; $j < $pos; $j++) {
					$result .= $indentStr;
				}
			}
			$prevChar = $char;
		}

		return $result;
	}

	static function CheckFbTokenValid($token=null)
	{
		if (empty($token)) {
			$token = self::GetConfigDB("photo", "fb_token", "photo_config");
		}
		if (null == $token || "" == $token) {
			return null;
		}
		$facebook = new Facebook(array('appId'  => SYNOPHOTO_FB_API_ID, 'secret' => SYNOPHOTO_FB_SECRET));
		$facebook->setAccessToken($token);
		$fb_utils = new FBPhotoUtils($facebook);
		$user = $fb_utils->getUser();
		if (empty($user)) {
			return null;
		}
		$fb_utils->user_name = $user['name'];
		$fb_utils->user_id = $user['id'];
		return $fb_utils;
	}

	static function UrlEncode($str)
	{
		if ($str == "") return NULL;
		$str = rawurlencode($str);
		$str = str_replace("%2F","/", $str);
		return $str;
	}

	/*!
	 * check the $path is a allowed photo file or not
	 *
	 * \param $path file path
	 * \return true or false
	 */
	static function IsPhotoFile($path)
	{
		global $SYNOPHOTO_ALLOW_PICT_NAMES_EXT;

		$path = strtolower($path);
		$ext = substr(strrchr($path, '.'), 1);
		if (in_array($ext, $SYNOPHOTO_ALLOW_PICT_NAMES_EXT)) {
			return true;
		}
		return false;
	}

	static function IsVideoFile($path)
	{
		global $SYNOPHOTO_ALLOW_FILM_NAMES_EXT;

		$path = strtolower($path);
		$ext = substr(strrchr($path, '.'), 1);
		if (in_array($ext, $SYNOPHOTO_ALLOW_FILM_NAMES_EXT)) {
			return true;
		}
		return false;
	}

	/*!
	 * check the photo file $path should have thumb file or not
	 *
	 * \param $path photo file path
	 * \return true or false
	 */
	static function IsPhotoFileWithThumb($path)
	{
		global $SYNOPHOTO_ALLOW_ORIG_NAMES_EXT;

		$path = strtolower($path);
		$ext = substr(strrchr($path, '.'), 1);
		if (!in_array($ext, $SYNOPHOTO_ALLOW_ORIG_NAMES_EXT)) {
			return true;
		}
		return false;
	}

	function GetSessionIdentifier()
	{
		$token = $_SERVER['REMOTE_ADDR'];
		if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
			$token .= $_SERVER["HTTP_X_FORWARDED_FOR"];
		}
		return $token;
	}

	function RestoreSession()
	{
		if (!isset($_REQUEST['session'])) {
			return -1;
		}

		$sessionDir = session_save_path();
		if (empty($sessionDir)) {
			$sessionDir = sys_get_temp_dir();
		}

		$sessionPath = $sessionDir."/sess_".$_REQUEST['session'];
		$serializedSession = @file_get_contents($sessionPath);

		if (empty($serializedSession)) {
			return false;
		}

		$currIdentifier = $_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'];
		$currSession = session_encode();
		session_unset();
		if (session_decode($serializedSession)
			&& isset($_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'])
			&& ($currIdentifier == $_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'])) {
			return true;
		}
		session_unset();
		session_decode($currSession);
		return false;
	}

	/*!
	 * check the if dsn user account exit
	 *
	 * \return true or false
	 */
	function CheckDsmUserValid ($username)
	{
		$command = "/usr/syno/bin/synophoto_dsm_user --getinfo " . escapeshellarg($username) . " > /dev/null";
		@system($command, $auth_retval);
		return (0 == $auth_retval) ? true : false;
	}

	/*!
	 * check the disk space is empty enough or not
	 *
	 * \return true or false
	 */
	static function DiskSpaceCheck()
	{
		static $cachedCheckValue = true;
		static $lastCheckTime = 0;
		$checkTime = time();

		// cache disk check result for 10 second
		if ($checkTime > $lastCheckTime + 10) {
			if (SYNOPHOTO_RSRV_DISK_SPACE < diskfreespace(SYNOPHOTO_SERVICE_DIR)) {
				$cachedCheckValue = true;
			} else {
				$cachedCheckValue = false;
			}
			$lastCheckTime = $checkTime;
		}

		return $cachedCheckValue;
	}

	/*!
	 * Get all accessible dir list
	 *
	 * \param $albumName - '/' means root shared folder
	 * \param $isNeedCtime returned list need include create time or not
	 * \return array with dir list
	 */
    static function GetDir($albumName, $isNeedCtime)
    {
        $result = array();
        if ('/' === $albumName) {
			$dirList = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']);
            if (false !== ($keyIndex = array_search('/', $dirList))) {
                unset($dirList[$keyIndex]);
            }
            /* make sure data type is string */
            foreach ($dirList as &$name) {
                settype($name, 'string');
            }
            unset($name);
            foreach ($dirList as $name) {
                // TODO: ctime
                $result[$name] = SYNOPHOTO_ITEM_TYPE_ALBUM;
            }
        } else {
            $result = self::GetSubDir($albumName, $isNeedCtime);
        }
        return $result;
    }

	/*!
	 * Get accessible sub-dir list
	 *
	 * \param $albumName album name
	 * \param $isNeedCtime returned list need include create time or not
	 * \return array with sub-dir list
	 */
	static function GetSubDir($albumName, $isNeedCtime)
	{
		$list = array();
		$currPath = getcwd();

		if (!@chdir(SYNOPHOTO_SERVICE_DIR . "/{$albumName}")) {
			@chdir($currPath);
			return $list;
		}

		foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $dir) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (self::isSkipPhotoDev(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumName.'/'.$dir, $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])
				|| !csSYNOPhotoMisc::IsUtf8($dir)) {
				continue;
			}

			if ($dir != SYNOPHOTO_EADIR && $dir != '.' && $dir != '..') {
				if (false === strpos($albumName, '/') &&
					!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir']["{$albumName}/{$dir}"])) {
					continue;
				}
				$list["{$albumName}/{$dir}"] = $isNeedCtime ? filectime($dir) : 0;
			}
		}

		@chdir($currPath);
		return $list;
	}

	static function GetSubDirFile($albumName)
	{
		$list = array();
		$currPath = getcwd();
		@chdir(SYNOPHOTO_SERVICE_DIR . "/{$albumName}");
		$latestFile = null;
		$data = null;
		
		$file = glob('{,.}*', GLOB_BRACE);
		usort($file, create_function('$a,$b', 'return filectime($b) - filectime($a);'));
		foreach ($file as $file) {
			if ($file != SYNOPHOTO_EADIR && $file != '.' && $file != '..') {
				if (csSYNOPhotoMisc::IsPhotoFile($file)) {
					$latestFile = $file;
					$type = 0;
					break;
				} else if (csSYNOPhotoMisc::IsVideoFile($file)) {
					$latestFile = $file;
					$type = 1;
					break;
				}
			}
		}
		if ($latestFile !== null) {
			$path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumName.'/'.$latestFile;
			if ($type == 0) {
				$data = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($path);
			} else {
				$data = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($path);
			}
		}
		return $data;
	}

	/*!
	 * check the album is thumbing or not
	 *
	 * \param $dir the album name
	 * \return true or false
	 */
	static function ThumbingCheck($dir='')
	{
		$isThumbing = false;
		$lockPath = "{$dir}/".SYNOPHOTO_EADIR;

		if (($fp = @fopen($lockPath, 'r'))>0) {
			if (flock($fp, LOCK_EX | LOCK_NB)) {
				flock($fp, LOCK_UN);
			} else {
				$isThumbing = true;
			}
			fclose($fp);
		}
		return $isThumbing;
	}
	/*!
	 * Get thumb file path by photo file path
	 *
	 * \param $path photo file path
	 * \param $isBigThumb return big thumb or not
	 * \param $isFail return thumb for failed thumb or not
	 * \return the thumb file path
	 */
	static function GetThumbPathFromFullPath($path, $thumbType, $isFail, $isVideo=false)
	{
		if ($isFail) {
			$thumbName = SYNOPHOTO_THUMBSMALL != $thumbType ? SYNOPhotoEA::FILE_THUMB_B_FAIL : SYNOPhotoEA::FILE_THUMB_S_FAIL;
			if (!csSYNOPhotoMisc::IsPhotoFile($path) && $isVideo) {
				$thumbName = SYNOPhotoEA::FILE_FILM_FAIL;
			}
		} else {
			switch ($thumbType) {
				case SYNOPHOTO_THUMBSMALL:
					$thumbName = SYNOPhotoEA::FILE_THUMB_S;
					break;
				case SYNOPHOTO_THUMBMEDIUM:
					$thumbName = SYNOPhotoEA::FILE_THUMB_M;
					break;
				case SYNOPHOTO_THUMBBIG:
					$thumbName = SYNOPhotoEA::FILE_THUMB_B;
					break;
				case SYNOPHOTO_THUMBLARGE:
					$thumbName = SYNOPhotoEA::FILE_THUMB_L;
					break;
				default:
					$thumbName = SYNOPhotoEA::FILE_THUMB_XL;
					break;
			}
		}
		SYNOPhotoEA::checkFilePath($path, $thumbName, $thumbPath);
		return $thumbPath;
	}
	/*!
	 * Get alternative thumb type during thumb generating
	 */
	static function GetAlternativeThumbType($thumbType)
	{
		$type = $thumbType;

		switch($thumbType) {
			case SYNOPHOTO_THUMBSMALL:
			case SYNOPHOTO_THUMBMEDIUM:
				$type = SYNOPHOTO_THUMBMEDIUM;
				break;
			case SYNOPHOTO_THUMBBIG:
			case SYNOPHOTO_THUMBLARGE:
			case SYNOPHOTO_THUMBXLARGE:
			default:
				$type = SYNOPHOTO_THUMBXLARGE;
		}

		return $type;
	}
	/*!
	 * Get thumb info by photo file path
	 *
	 * \param $path photo file path
	 * \param $thumbType return large thumb, big thumb or small thumb
	 * \param $width photo width
	 * \param $height photo height
	 * \param $version photo orientation
	 * \return array with thumb info
	 *	- src: link to the thumb file
	 *	- width: thumb width
	 *	- height: thumb height
	 */
	static function GetThumbInfoFromFullPath($path, $thumbType, $width, $height, $version, $createThumb=true)
	{
		if (!csSYNOPhotoMisc::IsPhotoFile($path)) {
			return array();
		}

		$isPhotoFileWithThumb = self::IsPhotoFileWithThumb($path);
		$fileName = basename($path);
		$dir = (false !== strpos($path, SYNOPHOTO_SERVICE_DIR)) ? SYNOPHOTO_SERVICE_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR.'/';
        $dir = dirname(str_replace($dir, "", $path));

		$thumbFile = '';
		$failFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, true);
		if ($isPhotoFileWithThumb) {
			$thumbFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, false);
			if (!@file_exists($thumbFile)) {
				$thumbType = csSYNOPhotoMisc::GetAlternativeThumbType($thumbType);
				$thumbFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, false);
			}
		}

		if (!empty($thumbFile) && @file_exists($thumbFile)) {
			if ($version == -1) {
				$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($path);
				$version = $photoInfo ? $photoInfo['version'] : -1;
			}
			if (($version % 2) == 1) {
				$tmp = $width;
				$width = $height;
				$height = $tmp;
			}
			$type = $thumbType;
			$result['src'] = SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type={$type}&v={$version}";
		} else if (@file_exists($failFile)) {
			$result['src'] = SYNOPHOTO_IMG_BROKEN;
			$thumbFile = SYNOPHOTO_IMG_BROKEN_FILE_PATH;
		} else {
			if (!csSYNOPhotoMisc::DiskSpaceCheck()) {
				if (SYNOPHOTO_THUMBSMALL != $thumbType) {
					$result['src'] = SYNOPHOTO_IMG_FULL_BIG;
					$thumbFile = SYNOPHOTO_IMG_FULL_BIG_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_FULL;
					$thumbFile = SYNOPHOTO_IMG_FULL_FILE_PATH;
				}
			} else if (!$isPhotoFileWithThumb) {
					$result['src'] = SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName).'&type=2';
					$thumbFile = $path;
			} else {
				$theme = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['theme']['template'];
				if (empty($theme) || 'White' == $theme) {
					$result['src'] = SYNOPHOTO_IMG_THUMB;
					$thumbFile = SYNOPHOTO_IMG_THUMB_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_THUMB_BLACK;
					$thumbFile = SYNOPHOTO_IMG_THUMB_BLACK_FILE_PATH;
				}
				$dirPath = substr($path, 0 , (strlen($path) - strlen($fileName) - 1));
				if ($createThumb && !csSYNOPhotoMisc::ThumbingCheck($dirPath)) {
					@system('/usr/syno/bin/synomkthumb -a '.escapeshellarg($dirPath).' > /dev/null 2>&1');
				}
			}
		}

		if (false !== strpos($result['src'], 'convert.php') && (0 != $width && 0 != $height)) {
			$imageInfo[0] = $width;
			$imageInfo[1] = $height;
		} else {
			$imageInfo = @getImageSize($thumbFile);
		}

		if	(SYNOPHOTO_THUMBSMALL == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBSMALL_WIDTH, SYNOPHOTO_THUMBSMALL_HEIGHT);
		} else if (SYNOPHOTO_THUMBMEDIUM == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBMEDIUM_WIDTH, SYNOPHOTO_THUMBMEDIUM_HEIGHT);
		} else if (SYNOPHOTO_THUMBBIG == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBBIG_WIDTH, SYNOPHOTO_THUMBBIG_HEIGHT);
		} else if (SYNOPHOTO_THUMBLARGE == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBLARGE_WIDTH, SYNOPHOTO_THUMBLARGE_HEIGHT);
		} else {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBXLARGE_WIDTH, SYNOPHOTO_THUMBXLARGE_HEIGHT);
		}

		$result['width'] = $imageInfo['width'];
		$result['height'] = $imageInfo['height'];
		return $result;
	}
	/*!
	 * Get video thumb info by video file path
	 *
	 * \param $path video file path
	 * \param $isBigThumb return big thumb or not
	 * \param $width video width
	 * \param $height video height
	 *
	 * \return array with thumb info
	 *	- src: link to the thumb file
	 *	- width: thumb width
	 *	- height: thumb height
	 */
	static function GetVideoThumbInfoFromFullPath($path, $thumbType, $width, $height, $createThumb=true)
	{
		$fileName = basename($path);
		$dir = (false !== strpos($path, SYNOPHOTO_SERVICE_DIR)) ? SYNOPHOTO_SERVICE_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR.'/';
		$dir = dirname(str_replace($dir, "", $path));

		$failThumbFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, true);
		$failVideoFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, true, true);

		$thumbFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, false);
		$readyVideoCount = count(csSYNOPhotoMisc::GetConvertedVideoFileInfoFromFullPath($path));

		if ($readyVideoCount > 0 && !empty($thumbFile) && @file_exists($thumbFile)) {
			$type = $thumbType;
			$result['src'] = SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type={$type}&v=0";
		} else if ($readyVideoCount > 0 && @file_exists($failThumbFile)) {
				$result['src'] = SYNOPHOTO_IMG_BROKEN;
				$thumbFile =  SYNOPHOTO_IMG_BROKEN_FILE_PATH;
		} else if ($readyVideoCount == 0 && @file_exists($failVideoFile)) {
				$result['src'] = SYNOPHOTO_IMG_MOVIE;
				$thumbFile = SYNOPHOTO_IMG_MOVIE_FILE_PATH;
		} else {
			if (!csSYNOPhotoMisc::DiskSpaceCheck()) {
				if (SYNOPHOTO_THUMBSMALL != $thumbType) {
					$result['src'] = SYNOPHOTO_IMG_FULL_BIG;
					$thumbFile = SYNOPHOTO_IMG_FULL_BIG_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_FULL;
					$thumbFile = SYNOPHOTO_IMG_FULL_FILE_PATH;
				}
			} else {
				$theme = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['theme']['template'];
				if (empty($theme) || 'White' == $theme) {
					$result['src'] = SYNOPHOTO_IMG_THUMB;
					$thumbFile = SYNOPHOTO_IMG_THUMB_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_THUMB_BLACK;
					$thumbFile = SYNOPHOTO_IMG_THUMB_BLACK_FILE_PATH;
				}
				if ($createThumb) {
					@system('/usr/syno/bin/synomkflv -a '.escapeshellarg($path).' > /dev/null 2>&1');
				}
			}
		}

		$imageInfo = @getImageSize($thumbFile);

		if	(SYNOPHOTO_THUMBSMALL == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBSMALL_WIDTH, SYNOPHOTO_THUMBSMALL_HEIGHT);
		} else if (SYNOPHOTO_THUMBMEDIUM == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBMEDIUM_WIDTH, SYNOPHOTO_THUMBMEDIUM_HEIGHT);
		} else if (SYNOPHOTO_THUMBBIG == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBBIG_WIDTH, SYNOPHOTO_THUMBBIG_HEIGHT);
		} else if (SYNOPHOTO_THUMBLARGE == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBLARGE_WIDTH, SYNOPHOTO_THUMBLARGE_HEIGHT);
		} else {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBXLARGE_WIDTH, SYNOPHOTO_THUMBXLARGE_HEIGHT);
		}

		$result['width'] = $imageInfo['width'];
		$result['height'] = $imageInfo['height'];
		return $result;
	}
	/*!
	 * Get converted video file info by video file path
	 *
	 * \param $path video file path
	 * \param $isBigThumb return big thumb or not
	 * \param $width video width
	 * \param $height video height
	 *
	 * \return array with thumb info
	 *	- src: link to the converted mobile video file
	 */
	static function GetConvertedVideoFileInfoFromFullPath($path)
	{
		$fileName = basename($path);
		$dir = (false !== strpos($path, SYNOPHOTO_SERVICE_DIR)) ? SYNOPHOTO_SERVICE_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR.'/';
		$dir = dirname(str_replace($dir, "", $path));

		$eaPath = '';

		if (SYNOPhotoEA::checkFilePath($path, SYNOPhotoEA::FILE_FILM_FLV, $eaPath)) {
			$result['flv_src'] = urlencode(SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type=3&v=0");
		}
		if (SYNOPhotoEA::checkFilePath($path, SYNOPhotoEA::FILE_FILM_H264_MP4, $eaPath)) {
			$result['mp4_orig_src'] = urlencode(SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type=13&v=0");
		}
		if (SYNOPhotoEA::checkFilePath($path, SYNOPhotoEA::FILE_FILM_H_MP4, $eaPath)) {
			$result['mp4_H_src'] = urlencode(SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type=6&v=0");
		}
		if (SYNOPhotoEA::checkFilePath($path, SYNOPhotoEA::FILE_FILM_M_MP4, $eaPath)) {
			$result['mp4_M_src'] = urlencode(SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type=7&v=0");
		}
		if (SYNOPhotoEA::checkFilePath($path, SYNOPhotoEA::FILE_FILM_L_MP4, $eaPath)) {
			$result['mp4_L_src'] = urlencode(SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type=8&v=0");
		}
		if (SYNOPhotoEA::checkFilePath($path, SYNOPhotoEA::FILE_FILM_MOBILE_MP4, $eaPath)) {
			$result['mp4_mobile_src'] = urlencode(SYNOPHOTO_URL_PREFIX.'/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type=9&v=0");
		}

		return $result;
	}
	/*!
	 * get the rounded float number
	 *
	 * \param $value the number to be round
	 * \return rounded number
	 */
	static function RoundFloat($value)
	{
		$round = 3;
		$tmp_value = $value * 10 % 10;
		if ($tmp_value < $round) {
			return floor($value);
		} else {
			return ceil($value);
		}
	}
	/*!
	 * Get the css style to just fit image
	 *
	 * \param $img array with image info
	 *	- width: image width
	 *	- height: image height
	 * \param $maxWidth
	 * \param $maxHeight
	 */
	static function GetJustFitCenterStyle($img, $maxWidth, $maxHeight, &$videoIconOffset = 0)
	{
		if ($img['width'] <= $maxWidth && $img['height'] <= $maxHeight) {
			return self::GetCenterStyle($img, $maxWidth, $maxHeight);
		}
		$scaledImg = self::GetJustFitWidthHeight($img['width'], $img['height'], $maxWidth, $maxHeight);
		if ($scaledImg['width'] > $scaledImg['height']) {
			$top = ($maxHeight - $scaledImg['height'])*4/5;
			$videoIconOffset = $top - ($maxHeight - $scaledImg['height']-1)/2;
			return "width: {$scaledImg['width']}px; margin-top: {$top}px;";
		}
		$left = ($maxWidth - $scaledImg['width'])/2;
		return "height: {$scaledImg['height']}px; margin-left: {$left}px;";
	}
	/*!
	 * Get the scaled size to just fit expected size
	 *
	 * \param $width photo width
	 * \param $height photo height
	 * \param $expectWidth expected width to scale
	 * \param $expectHeight expected height to scale
	 * \return array with scaled size
	 *	- width: scaled width
	 *	- height: scaled height
	 */
	static function GetJustFitWidthHeight($width, $height, $expectWidth, $expectHeight)
	{
		if ($width > $expectWidth && $height > $expectHeight) {
			if (($height / $expectHeight) < ($width / $expectWidth)) {
				$result['width'] = $expectWidth;
				$result['height'] = self::RoundFloat($height * ($expectWidth / $width));
			} else {
				$result['height'] = $expectHeight;
				$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
			}
		} else if ($height > $expectHeight) {
			$result['height'] = $expectHeight;
			$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
		} else if ($width > $expectWidth) {
			$result['width'] = $expectWidth;
			$result['height'] = self::RoundFloat($height*($expectWidth / $width));
		} else {
			$result['width'] = $width;
			$result['height'] = $height;
		}
		return $result;
	}
	/*!
	 * Get the scaled size to over fit expected size
	 * (ie. the shorter side will fit the expected size,
	 * and the longer side will overflow the expected size)
	 *
	 * \param $width photo width
	 * \param $height photo height
	 * \param $expectWidth expected width to scale
	 * \param $expectHeight expected height to scale
	 * \return array with scaled size
	 *	- width: scaled width
	 *	- height: scaled height
	 */
	static function GetOverFitWidthHeight($width, $height, $expectWidth, $expectHeight)
	{
		if ($width > $expectWidth && $height > $expectHeight) {
			if (($height / $expectHeight) > ($width / $expectWidth)) {
				$result['width'] = $expectWidth;
				$result['height'] = self::RoundFloat($height * ($expectWidth / $width));
			} else {
				$result['height'] = $expectHeight;
				$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
			}
		} else if ($height > $expectHeight) {
			$result['width'] = $expectWidth;
			$result['height'] = self::RoundFloat($height*($expectWidth / $width));
		} else if ($width > $expectWidth) {
			$result['height'] = $expectHeight;
			$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
		} else {
			$result['width'] = $width;
			$result['height'] = $height;
		}
		return $result;
	}
	/*!
	 * Get the css style to over fit image
	 * (ie. the shorter side will fit the expected size,
	 * and the longer side will overflow the expected size)
	 *
	 * \param $img array with image info
	 *	- width: image width
	 *	- height: image height
	 * \param $maxWidth
	 * \param $maxHeight
	 */
	static function GetOverFitCenterStyle($img, $maxWidth, $maxHeight)
	{
		if ($img['width'] <= $maxWidth && $img['height'] <= $maxHeight) {
			return self::GetCenterStyle($img, $maxWidth, $maxHeight);
		}
		$scaledImg = self::GetOverFitWidthHeight($img['width'], $img['height'], $maxWidth, $maxHeight);
		if ($scaledImg['width'] > $scaledImg['height']) {
			$left = ($scaledImg['width'] - $maxWidth)/2;
			return "height: {$scaledImg['height']}px; margin-left: -{$left}px;";
		}
		$top = ($scaledImg['height'] - $maxHeight)/2;
		return "width: {$scaledImg['width']}px; margin-top: -{$top}px;";
	}
	/*!
	 * Get the css style to center image in a block
	 * both image width/height should less then the block
	 *
	 * \param $img array with image info
	 *	- width: image width
	 *	- height: image height
	 * \param $maxWidth
	 * \param $maxHeight
	 */
	static function GetCenterStyle($img, $maxWidth, $maxHeight)
	{
		$style = "";
		if ($img['width'] < $maxWidth) {
			$left = ($maxWidth - $img['width'])/2;
			$style .= "margin-left: {$left}px; ";
		}
		if ($img['height'] < $maxHeight) {
			$top = ($maxHeight - $img['height'])/2;
			$style .= "margin-top: {$top}px; ";
		}
		$style .= 'width: '.$img['width'].'px';
		return $style;
	}
	/*!
	 * Get css styles for various purposes
	 *
	 * \param $imgInfo array with various css style
	 *	- listStyle: img style to over fit div in list mode
	 *	- blockStyle: img style to over fit div in block mode
	 *	- bgAlbumStyle: img style to just fit div in backgrounded album mode
	 *	- bgThumbStyle: img style to just fit div in backgrounded photo mode
	 */
	static function GetThumbStyle($imgInfo, $size=SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE, $isJustFit = false, &$videoIconOffset = 0)
	{
		if ($isJustFit) {
			return self::GetJustFitCenterStyle($imgInfo, $size, $size, $videoIconOffset);
		}
		return self::GetOverFitCenterStyle($imgInfo, $size, $size);
	}
	/*!
	 * check album accessible or not
	 *
	 * \param $albumName album name
	 * \return true or false
	 */
	static function CheckAlbumAccessible($albumName, $isNeedRedirect=false)
	{
		/* root album is always public */
		if ('/' === $albumName) {
			return true;
		}
		if (!file_exists(SYNOPHOTO_SERVICE_DIR."/".$albumName)) {
			if ($isNeedRedirect) {
				header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/index.php");
				exit;
			}
			return false;
		}
		$albumToken = explode('/', $albumName);
		if (2 < count($albumToken)) {
			$albumName = $albumToken[0] . '/' . $albumToken[1];
		}
		if (1 == count($albumToken)) {
			if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
				if ($isNeedRedirect) {
					self::RedirectToLoginPage($albumName);
				}
				return false;
			}
			if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName]['password'] &&
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName]['password'] !=
				$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
				if ($isNeedRedirect) {
					self::RedirectToLoginPage($albumName, 1);
				}
				return false;
			}
			return true;
		}
		/* album is not accessible */
		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
			if ($isNeedRedirect) {
				self::RedirectToLoginPage($albumName);
			}
			return false;
		}
		/* private album, can access */
		if ('f' == $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['public'] &&
			'' == $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password']) {
			return true;
		}
		/* pwd album, match pwd */
		if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] &&
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] ==
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
			return true;
		}
		/* pwd album, wrong pwd */
		if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] &&
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] !=
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
			if ($isNeedRedirect) {
				self::RedirectToLoginPage($albumName, 1);
			}
			return false;
		}
		if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']["{$albumToken[0]}"]['password'] &&
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']["{$albumToken[0]}"]['password'] !=
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album']["{$albumToken[0]}"]) {
			if ($isNeedRedirect) {
			    self::RedirectToLoginPage($albumToken[0], 1);
			}
			return false;
		}
		return true;
	}

	static function RedirectToLoginPage($albumName, $isForPassword=false)
	{
		$query = "Select sharename from photo_share where sharename = '".PHOTO_DB_EscapeParam($albumName)."'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		echo "<script>";
		if (PHOTO_DB_FetchRow($db_result)) {
			if ($isForPassword) {
				echo "parent.location = \"".SYNOPHOTO_URL_PREFIX."/photo/login.php?albumName=".bin2hex($albumName)."&password=true&".
				"&url=".bin2hex($_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING'])."\";";
			} else {
				echo "parent.location = \"".SYNOPHOTO_URL_PREFIX."/photo/login.php?url=".bin2hex($_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING'])."\";";
			}
		} else {
			echo "parent.location = \"".SYNOPHOTO_URL_PREFIX."/photo/index.php\";";
		}
		echo "</script>";
		exit;
	}

	static function CheckPathAccessible($path)
	{
		$file_name = basename($path);
		$dir = substr($path, 0, strlen($path) - strlen($file_name) - 1);
		$dir = substr($dir, strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1);
		return self::CheckAlbumAccessible($dir);
	}

	static function CheckAlbumUploadable($albumName)
	{
		// skip photo in remote mount (cifs) or read-only mount (iso9660)
		if (self::isSkipPhotoDev(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumName, $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])) {
			return false;
		}
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return true;
		}
		/* if album is under 3rd level, check uploadable in second level */
		$albumToken = explode('/', $albumName);
		if (count($albumToken) > 2) {
			$albumName = $albumToken[0] . '/' . $albumToken[1];
		}
		if (!self::CheckAlbumAccessible($albumName) ||
			!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album'][$albumName])) {
			return false;
		}
		return true;
	}

	static function CheckAlbumManageable($albumName)
	{
		// skip photo in remote mount (cifs) or read-only mount (iso9660)
		if (self::isSkipPhotoDev(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumName, $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])) {
			return false;
		}
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return true;
		}
		$albumToken = explode('/', $albumName);
		if (count($albumToken) > 2) {
			$albumName = $albumToken[0] . '/' . $albumToken[1];
		}
		if (!self::CheckAlbumUploadable($albumName) ||
			!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['manageable_album'][$albumName])) {
			return false;
		}
		return true;
	}
	/*!
	 * Get translated string from desktop edition language file by variable name
	 *
	 * \param $token variable name without '$photo_' prefix
	 * \return translated string
	 */
	static function GetPhotoText($token)
	{
		preg_match_all("/^\\\$photo_{$token}\\s*=\\s*'(.+)'/m",
		file_get_contents(SYNOPHOTO_LANGS_DIR."/{$_SESSION[SYNOPHOTO_ADMIN_USER]['lang']}.php"), $matches, PREG_SET_ORDER);
		return $matches[0][1];
	}
	/*!
	 * Get translated legal information from webman strings
	 *
	 * \return array with translated legal information
	 *	- copyright_mark_desc
	 *	- copyright_note_desc
	 */
	static function GetLegalText()
	{
		preg_match_all('/^(copyright_\w+)\s*=\s*"(.+)"/m',
		file_get_contents("../../../webman/texts/{$_SESSION[SYNOPHOTO_ADMIN_USER]['lang']}/strings"), $matches, PREG_SET_ORDER);
		$result = array();
		foreach ($matches as $item) {
			$result[$item[1]] = $item[2];
		}
		return $result;
	}
	/*!
	 * Get reduced datetime string
	 *
	 * \param $string the full datetime string: YYYY-mm-dd H:i:s
	 * \return only time if the string is in today, or otherwise only date.
	 */
	static function GetReducedDate($string)
	{
		$date = substr($string, 0, 10);
		if (date('Y-m-d') == $date) {
			return substr($string, 11);
		}
		return $date;
	}
	/*!
	 * Map ##-## language region to ###
	 *
	 * \param $lang language region
	 * \return mapped ### for supported language region, otherwise 'enu'
	 */
	static function GetMappedLanguage($lang)
	{
		if (2 == strlen($lang)) {
			$lang .= '-';
		}
		switch (true) {
			case !strcasecmp($lang, "zh-tw"):
			case !strcasecmp($lang, "zh-hk"):
			case !strcasecmp($lang, "zh-mo"):
			case !strncasecmp($lang, "zh-hant", 7): // ISO 639
				$lang = 'cht';
				break;
			case !strncasecmp($lang, "zh-", 3):
				$lang = 'chs';
				break;
			case !strncasecmp($lang, "en-", 3):
				$lang = 'enu';
				break;
			case !strncasecmp($lang, "de-", 3):
				$lang = 'ger';
				break;
			case !strncasecmp($lang, "ja-", 3):
				$lang = 'jpn';
				break;
			case !strncasecmp($lang, "ko-", 3):
				$lang = 'krn';
				break;
			case !strncasecmp($lang, "es-", 3):
				$lang = 'spn';
				break;
			case !strncasecmp($lang, "fr-", 3):
				$lang = 'fre';
				break;
			case !strncasecmp($lang, "it-", 3):
				$lang = 'ita';
				break;
			case !strncasecmp($lang, "ru-", 3):
				$lang = 'rus';
				break;
			case !strncasecmp($lang, "nl-", 3):
				$lang = 'nld';
				break;
			case !strncasecmp($lang, "no-", 3):
			case !strncasecmp($lang, "nb-", 3):
			case !strncasecmp($lang, "nn-", 3):
				$lang = 'nor';
				break;
			case !strncasecmp($lang, "sv-", 3):
				$lang = 'sve';
				break;
			case !strncasecmp($lang, "da-", 3):
				$lang = 'dan';
				break;
			case !strncasecmp($lang, "pl-", 3):
				$lang = 'plk';
				break;
			case !strncasecmp($lang, "pt-br", 5):
				$lang = 'ptb';
				break;
			case !strncasecmp($lang, "pt-", 3):
				$lang = 'ptg';
				break;
			case !strncasecmp($lang, "hu-", 3):
				$lang = 'hun';
				break;
			case !strncasecmp($lang, "tr-", 3):
				$lang = 'trk';
				break;
			case !strncasecmp($lang, "cs-", 3):
				$lang = 'csy';
				break;
			default:
				$lang = false;
		}
		return $lang;
	}
	/*!
	 * Get parsed config from file
	 *
	 * \param $cfgFile config file
	 * \param $confKeys config keys that values need to be returned
	 * \return array with parsed data
	 *	- key = 'value' will parse into $result['key'] = value
	 */
	static function GetConfigFile($cfgFile, $confKeys = '.+')
	{
		$trimmedCharSet = " \t\n\r\0\x0B\"'";
		preg_match_all('/^\s*('.$confKeys.')\s*=\s*(.*)/m', file_get_contents($cfgFile), $matches, PREG_SET_ORDER);
		$result = array();
		foreach ($matches as $item) {
			$result[$item[1]] = trim($item[2], $trimmedCharSet);
		}
		return $result;
	}
	static function SetConfigFile($cfgFile, $cfgKey, $value)
	{
		$cmd = '/usr/syno/bin/synosetkeyvalue '.escapeshellarg($cfgFile).' '.escapeshellarg($cfgKey).' '.escapeshellarg($value);
		@exec($cmd, $output, $retVal);

		if ($retVal == 0) {
			return true;
		}
		return false;
	}
	/*!
	 * Log message to a file
	 *
	 * \param $string message to be logged
	 */
	static function Synophoto_Log($string)
	{
		$handle = fopen("/tmp/synophoto_log", "a");
		fwrite($handle, date('ymd H:i:s')." => ".$string."\n");
		fclose($handle);
	}
	/*!
	 * Get syno user's email from /etc/synouser.conf
	 *
	 * \param $user username
	 */
	static function GetSynoUserEmail($user)
	{
		$mail = '';
		$file = fopen(SYNO_USER_FILE, 'r');
		while (!feof($file)) {
			$line = fgets($file, 4096);
			$line = trim($line);
			if('' == $line || 0 == strncmp($line, "#", 1)) {
				continue;
			}
			$info = explode(":", $line);
			if ($user == $info[0]) {
				return $info[2];
			}
		}
		return $mail;
	}
	/*!
	 * Get translated legal information from webman strings
	 *
	 * \return array with translated legal information
	 *	- copyright_mark_desc
	 *	- copyright_note_desc
	 */
	static function checkServiceEnabled()
	{
		$result =true;
		if (!preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			/* check whether photo service enabled */
			if (!file_exists(SYNO_PKG_DIR.'/enabled')) {
				$result = false;
			}
		} else{
			if (!file_exists(SYNO_PKG_DIR.'/enabled') ||
				!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation']) ||
				'yes' != $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation'] ||
				!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation']) ||
				'yes' != $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['runpersonalphotostation']) {
				$result = false;
			}
		}
		return $result;
	}

	/*!
	 * Check accont system if use dsm account
	 *
	 * \return true when use DSM account
	 */
	static function checkDsmAccountEnabled()
	{
		$result = true;
		if (null == ( $use_dsm_account = self::GetConfigDB("global", "account_system", "photo_config" ))) {
			if(self::GetUserType() == 2) {
				self::AddConfigDB("global", "account_system", "1", "photo_config");
			}
			$use_dsm_account = '1';
		}

		if ('0' == $use_dsm_account) {
			$result = false;
		}
		return $result;
	}

	static function IsBlogEnabled()
	{
		$result = self::GetConfigDB('main', 'enable_blog');
		if ($result == null || $result == '') {
			if (self::GetUserType() == 2) {
				self::AddConfigDB('main', 'enable_blog', '1');
			}
			return TRUE;
		}
		return ($result == '1');
	}

	static function CheckSessionTimeOut($userIsEnough = false)
	{
		$timeout = true;
		if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] === SYNOPHOTO_ADMIN_PASS) {
			$timeout = false;
		}
		if ($userIsEnough) {
			if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] !== "") {
				$timeout = false;
			}
		}
		if ($timeout) {
			header('x-request-error: error_timeout');
			exit;
		}
	}

	static function CheckAdminTimeOut()
	{
		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) || $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] != SYNOPHOTO_ADMIN_PASS) {
			header('x-request-error: error_timeout');
			exit;
		}
	}

	static function CheckUserTimeOut()
	{
		if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) || $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] == "") {
			header('x-request-error: error_timeout');
			exit;
		}
	}

	static function GetUserType()
	{
		if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'] == SYNOPHOTO_ADMIN_PASS) {
			$result = 2;
		} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
			$result = 1;
		} else {
			$result = 0;
		}
		return $result;
	}

	static function GetConfigDB($module_name, $config_key, $table="")
	{
		if($table == null || $table == "") {
			$table = 'blog_config';
		}

		$query = "Select config_value from $table where module_name = '".$module_name."' and config_key = '".$config_key."'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		if($row = PHOTO_DB_FetchRow($db_result)) {
			return $row[0];
		} else {
			return null;
		}
	}

	static function UpdateConfigDB($module_name, $config_key, $config_value, $table="", $blSkipTimeout=false)
	{
		if ($blSkeipTimeout) {
			self::CheckAdminTimeOut();
		}

		if($table == null || $table == "") {
			$table = 'blog_config';
		}

		$query = "Update $table set config_value = ? where module_name = ? and config_key = ?";
		$sqlParam = array($config_value, $module_name, $config_key);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		if(PHOTO_DB_AffectedRows($db_result) == 0) {
			self::AddConfigDB($module_name, $config_key, $config_value, $table);
		}

		$result['success'] = TRUE;
		return json_encode($result);
	}

	static function UpdateConfigDBDontCheckAdmin($module_name, $config_key, $config_value, $table="") {
		return csSYNOPhotoMisc::UpdateConfigDB($module_name, $config_key, $config_value, $table, true);
	}

	static function AddConfigDB($module_name, $config_key, $config_value, $table="")
	{
		self::CheckAdminTimeOut();

		if($table == null || $table == "") {
			$table = 'blog_config';
		}
		$query = "Insert Into $table (module_name, config_key, config_value) ";
		$query = $query."Values(?, ?, ?)";
		$sqlParam = array($module_name, $config_key, $config_value);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		$result['success'] = TRUE;
		return json_encode($result);
	}

	static function DeleteConfigByID($config_id, $table="")
	{
		self::CheckAdminTimeOut();
		if($table == null || $table == "") {
			$table = 'blog_config';
		}
		$query = "Delete from $table where config_id = ?";
		$sqlParam = array($config_id);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		$result['success'] = TRUE;
		return json_encode($result);
	}

	static function GetExternalIP()
	{
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['ddns_update'] == "yes") {
			$command = "/usr/syno/bin/synophoto_dsm_user --hostname";
			@exec($command, $hostname, $retval);
			if (0 == $retval && 0 < strlen($hostname[0])) {
				$host = $hostname[0];
			}
		}
		if (strlen($host) > 0) {
			return $host;
		}

		if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'])
			&& $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'] != '') {
			$host = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'];
		}
		if (strlen($host) > 0) {
			return $host;
		}

		$server_ip = exec("/usr/syno/bin/synophoto_sns_utils -e");
		return $server_ip;
	}

	static function GetServerHost()
	{
		$port = '';
		$host = $_SERVER['HTTP_HOST'];
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['ddns_update'] == "yes") {
			$command = "/usr/syno/bin/synophoto_dsm_user --hostname";
			@exec($command, $hostname, $retval);
			if (0 == $retval && 0 < strlen($hostname[0])) {
				$host = $hostname[0];
			}
			$port = ($_SERVER['SERVER_PORT'] == 80)? '' : ":{$_SERVER['SERVER_PORT']}";
		}

		if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'])
			&& $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'] != '') {
			$host = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'];
			$port = ($_SERVER['SERVER_PORT'] == 80)? '' : ":{$_SERVER['SERVER_PORT']}";
		}
		if ($_SERVER["HTTPS"] == 'on') {
			$protocol = "https";
			if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_https'])
				&& $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_https'] != '') {
				$port = ':'.$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_https'];
			}
		} else {
			$protocol = "http";
			if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_http'])
				&& $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_http'] != '') {
				$port = ':'.$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_http'];
			}
		}
		return $protocol.'://'.$host.$port;
	}

	static function formatTime($secs)
	{
		return str_pad(floor($secs/3600),2,"0",STR_PAD_LEFT).":".
			str_pad(floor(($secs%3600)/60),2,"0",STR_PAD_LEFT).":".
			str_pad($secs%60,2,"0",STR_PAD_LEFT);
	}

	static function getFbSyncConfPath($albumName)
	{
		$dirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_REAL_DIR, $albumName);
		SYNOPhotoEA::checkFilePath($dirPath, SYNOPhotoEA::FILE_ALBUM_FBSYNC, $confPath);

		return $confPath;
	}

	static function isSetToSyncWithFb($albumName)
	{
		if (null == $conf_path = self::getFbSyncConfPath($albumName)) {
			return FALSE;
		}
		$conf_path = $conf_path.".set";
		if (FALSE == @stat($conf_path)) {
			return FALSE;
		}
		return TRUE;
	}

	static function isSyncingWithFb($albumName)
	{
		$albumPath = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumName;
		$syncing_array = array();
		$handle = @fopen(SYNOPHOTO_FB_SYNCING_FILE, "r");
		if ($handle) {
			while (!feof($handle)) {
				$line = fgets($handle, 4096);
				$syncing_array[] = trim($line);
			}
			fclose($handle);
		}
		if (in_array($albumPath, $syncing_array)) {
			return TRUE;
		}
		return FALSE;
	}

	static function getVirtualAlbumText($type)
	{
		switch($type) {
			case 0:
				$virtual_album_text = __('photo_str_recent_photo');
				break;
			case 1:
				$virtual_album_text = __('photo_str_recent_video');
				break;
			case 2:
				$virtual_album_text = __('photo_str_recent_commented_photo');
				break;
			case 3:
				$virtual_album_text = __('photo_str_recent_commented_video');
				break;
			case 4:
				$virtual_album_text =__('photo_str_person_label');
				break;
			case 5:
				$virtual_album_text = __('photo_str_place_label');
				break;
			case 6:
				$virtual_album_text = __('photo_str_general_label');
				break;
		}
		return $virtual_album_text;
	}

	static function GetWelcomeText()
	{
		if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
			$welcome_text = __(photo_str_welcome).", ".$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
		} elseif (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			if ('root' == SYNOPHOTO_ADMIN_USER) {
				$welcome_text = __(photo_str_welcome).", admin";
			}else {
				$welcome_text = __(photo_str_welcome).', '.SYNOPHOTO_ADMIN_NAME;
			}
		} else {
			$welcome_text = "";
		}
		return $welcome_text;
	}

	static function GetTopHeaderLinkArray($isPhotoStation6 = false)
	{
		//TODO: for develepment process, use flag that indicates PhotoStation6 temporarily.

		$result = array();
		$item = array();

		if (!strstr($_SERVER['PHP_SELF'], "/photo/") || strstr($_SERVER['PHP_SELF'], "/photo/admin_index.php")
			|| strstr($_SERVER['PHP_SELF'], "/photo/timeline.php")) {
			$item['href'] = SYNOPHOTO_URL_PREFIX."/photo";
			$item['name'] = __(photo_str_photo);
			$result[] = $item;
		}

		if (self::GetConfigDB('main', 'enable_blog', 'blog_config') != "0") {
			if (!strstr($_SERVER['PHP_SELF'], "/blog/index.php")) {
				$item['href'] = SYNOPHOTO_URL_PREFIX."/blog";
				$item['name'] = __(photo_str_blog);
				$result[] = $item;
			}
		}

		$pkg_default_conf = csSYNOPhotoMisc::GetConfigFile(SYNO_PKG_DEFAULT_CONF, 'support_timeline');
		$enableTimeline = (csSYNOPhotoMisc::GetConfigDB("photo", "disable_timeline", "photo_config") !== "on");
		if (!$isPhotoStation6 && 'yes' == $pkg_default_conf['support_timeline'] && $enableTimeline && !strstr($_SERVER['PHP_SELF'], "/photo/timeline.php")) {
			$item['href'] = SYNOPHOTO_URL_PREFIX."/photo/timeline.php";
			$item['name'] = __(photo_str_timeline);
			$result[] = $item;
		}

		if (0 < self::GetUserType()) {
			$redirect = (!strstr($_SERVER['PHP_SELF'], "/blog/index.php")) ? "photo" : "blog";
			if (!strstr($_SERVER['PHP_SELF'], "/photo/admin_index.php") && 2 == self::GetUserType()) {
				$item['href'] = SYNOPHOTO_URL_PREFIX."/photo/admin_index.php";
				$item['name'] = __(photo_str_management);
				$result[] = $item;

				if (!$isPhotoStation6 && !strstr($_SERVER['PHP_SELF'], "/photo/timeline.php")) {
					$item['href'] = SYNOPHOTO_URL_PREFIX."/photo/theme.php?type=".$redirect;
					$item['name'] = __(photo_theme_btnTheme);
					$result[] = $item;
				}
			}

			if (!strstr($_SERVER['PHP_SELF'], "/photo/admin_index.php") && 1 == self::GetUserType() &&
					isset($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) && false == $_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
				$item['href'] = SYNOPHOTO_URL_PREFIX."/photo/admin_index.php";
				$item['name'] = __(photo_str_management);
				$result[] = $item;
			}

			$item['href'] = SYNOPHOTO_URL_PREFIX."/photo/photo_login.php?action=logout&redirect=".$redirect;
			$item['name'] = __(photo_logout);
			$result[] = $item;
		} else {
			$url = $_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING'];
			$item['href'] = "javascript:onLogin('".rawurlencode($url)."')";
			$item['name'] = __(photo_login);
			$result[] = $item;
		}

		return $result;
	}

	static function GetAccessibleAlbumQueryCondition($ref = '')
	{
		if ('' !== $ref) {
			$path = $ref . '.path';
			if (!empty($_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition_' . $ref])) {
				return $_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition_' . $ref];
			}
		} else {
			$path = 'path';
			if (!empty($_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition'])) {
				return $_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition'];
			}
		}

		$albumCond = array();
		$sqlParam = array();

		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'] as $item) {
			if (!self::CheckAlbumAccessible($item['sharename'])) {
				continue;
			}
            if ('/' === $item['sharename']) {
                $albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH);
                $sqlParam[] = "{$albumRealPath}%";
                $sqlParam[] = "{$albumRealPath}%/%";
            } else {
                $albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
                $sqlParam[] = "{$albumRealPath}/%";
                $sqlParam[] = "{$albumRealPath}/%/%";
            }
            $albumCond[] = "($path LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr." AND $path NOT LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr.") ";
		}
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
			if (!self::CheckAlbumAccessible($item['sharename'])) {
				continue;
			}
            // only first and second level can set permission
            $arr = explode('/', $item['sharename']);
            if (2 < count($arr)) {
                continue;
            }
			$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "$path LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr;
			$sqlParam[] = "{$albumRealPath}/%";
		}
		$result['albumCond'] = $albumCond;
		$result['sqlParam'] = $sqlParam;

		// due to Photo bug #1894, unlock session earlier.
		// need to call session_start() again to write to session here.
		session_start();
		if ('' !== $ref) {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition_' . $ref] = $result;
		} else {
			$_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition'] = $result;
		}

		return $result;
	}

	static function GetVideoNameList($videoList)
	{
		$i=0;
		$length = count($videoList);
		$list = array();
		while ($i < $length) {
			$list[] = basename($videoList[$i]);
			$i++;
		}
		return $list;
	}

	static function ResizePhoto($source, $dest, $width = '1920', $height = null)
	{
		$ret = false;
		if (!file_exists($source)) {
			return $ret;
		}
		$imageInfo = @getImageSize($source);
		if (strstr($imageInfo['mime'], 'gif')) {
			return $ret;
		}

		if ($height == null) {
			$command = "/usr/syno/bin/convert -resize ".$width.'x'.$width." ";
		} else {
			$command = "/usr/syno/bin/convert -resize ".$width.'x'.$height." ";
		}
		$command .= escapeshellarg($source) . " " . escapeshellarg($dest);
		@system($command, $retval);
		if (0 == $retval) {
			$ret = true;
		}
		return $ret;
	}

	/*!
	 * Check if album should be skipped on ui
	 *
	 * \param $path album's directory
	 * \return true or false
	 */
	static function IsSkipPhotoPath($path)
	{
		if (!file_exists($path) || !file_exists('/proc/mounts')) {
			return false;
		}
		if (!($stPath = stat($path))) {
			return false;
		}

		$handle = @fopen('/proc/mounts', 'r');
		$ret = false;

		while (($buf = fgets($handle, 4096)) != false) {
			list(, $dir, $type, ) = explode(" ", $buf);
			if (!($stMount = stat($dir))) {
				$ret = false;
				break;
			}
			if ($stMount['dev'] == $stPath['dev']) {
				if ($type == 'cifs' || $type == 'iso9660') {
					$ret = true;
					break;
				}
			}
		}
		fclose($handle);
		return $ret;
	}

	static function getSkipPhotoDev()
	{
		if (!file_exists('/proc/mounts')) {
			return null;
		}
		$handle = @fopen('/proc/mounts', 'r');
		$skipPathArr = array();
		while (($buf = fgets($handle, 4096)) != false) {
			list(, $dir, $type, ) = explode(" ", $buf);
			if ($type == 'cifs' || $type == 'iso9660' || $type == 'udf') {
				$dir = csSYNOPhotoMisc::decodeName($dir);
				$skipPathArr[] = $dir;
			}
		}
		fclose($handle);
		return $skipPathArr;
	}
	static function isSkipPhotoDev($path, $skipDevArr)
	{
		if (!file_exists($path) || empty($skipDevArr)) {
			return false;
		}
		if (false !== array_search($path, $skipDevArr)) {
			return true;
		}
		if (is_link($path)) {
			$real_path = realpath($path);
			foreach($skipDevArr as $skipPath){
				if (0 === strncmp($skipPath, $real_path, strlen($skipPath))) {
					return true;
				}
			}
		}
		return false;
	}

	function decodeName($path)
	{
		$i = 0;
		$count = strlen($path);
		$newPath = '';
		while($i < $count) {
			$four = substr($path, $i, 4);
			$two = substr($path, $i, 2);

			if ($four == '\040') {// space
				$newPath .= ' ';
				$i+=4;
			} else if ($four == '\011'){// \t
				$newPath .= "\t";
				$i+=4;
			} else if ($four == '\012') {// \n
				$newPath .= "\n";
				$i+=4;
			} else if ($two == '\\\\') {// \
				$newPath .= '\\';
				$i+=2;
			} else if ($four == '\134') {
				$newPath .= '\\';
				$i+=4;
			} else {
				$newPath .= substr($path, $i, 1);
				$i++;
			}
		}
		return $newPath;
	}

	static function GetDsmVersion()
	{
		$values = self::GetConfigFile(SYNO_DEF_VERSION_FILE, 'buildnumber');
		return $values['buildnumber'];
	}

	static function GetPackageVersion()
	{
		$values = self::GetConfigFile(SYNOPHOTO_PACKAGE_INFO, 'version');
		return $values['version'];
	}

	static function CheckPathValid($path)
	{
		$pathToken = explode('/', $path);
		foreach ($pathToken as $token) {
			if ('.' == $token || '..' == $token) {
				return false;
			}
		}
		return true;
	}

	static function IsUtf8($string)
	{
		return preg_match('%^(?:
			[\x09\x0A\x0D\x20-\x7E]            # ASCII
			| [\xC2-\xDF][\x80-\xBF]             # non-overlong 2-byte
			| \xE0[\xA0-\xBF][\x80-\xBF]         # excluding overlongs
			| [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
			| \xED[\x80-\x9F][\x80-\xBF]         # excluding surrogates
			| \xF0[\x90-\xBF][\x80-\xBF]{2}      # planes 1-3
			| [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
			| \xF4[\x80-\x8F][\x80-\xBF]{2}      # plane 16
		)*$%xs', $string);
	}
}
?>
