<?php

define('PROVIDER_LIST_DEFAULT',	'/var/packages/PhotoStation/target/etc/SocialNetworkList.json');
define('PHOTO_CONFIG_KEY', 'social_network_list');

class SocialNetwork {
	function ReadList()
	{
		$defaultList = SocialNetwork::ReadDefaultList();
		$customList = SocialNetwork::ReadCustomList();

		foreach ($defaultList as &$defaultProvider) {
			foreach ($customList as $customProvider) {
				if ($defaultProvider['name'] === $customProvider['name']) {
					$defaultProvider['enable'] = (bool)$customProvider['enable'];
					break;
				}
			}
		}

		return $defaultList;
	}

	function ReadDefaultList()
	{
		$returnData = array();

		if (false === (@file_exists(PROVIDER_LIST_DEFAULT)) || false === ($file = @file_get_contents(PROVIDER_LIST_DEFAULT))) {
			goto END;
		}

		if (false === ($providerList = json_decode($file, true))) {
			goto END;
		}

		if (!isset($providerList['data']) || !is_array($providerList['data'])) {
			goto END;
		}

		$providerList = $providerList['data'];

		foreach ($providerList as $provider) {
			if (!isset($provider['name']) ||
				!isset($provider['enable']) ||
				!isset($provider['allowShare']) ||
				!isset($provider['allowSingleUpload']) ||
				!isset($provider['allowMultiUpload'])) {
				continue;
			}

			$returnData[] = array(
				'name' => $provider['name'],
				'enable' => $provider['enable'],
				'allowShare' => $provider['allowShare'],
				'allowSingleUpload' => $provider['allowSingleUpload'],
				'allowMultiUpload' => $provider['allowMultiUpload']
			);
		}

	END:
		return $returnData;
	}

	function ReadCustomList()
	{
		$returnData = array();

		$socialNetworkListJson = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', PHOTO_CONFIG_KEY);

		if (null === $socialNetworkListJson) {
			goto END;
		}

		if (false === ($providerList = json_decode($socialNetworkListJson, true))) {
			goto END;
		}

		if (!isset($providerList['data']) || !is_array($providerList['data'])) {
			goto END;
		}

		$providerList = $providerList['data'];

		foreach ($providerList as $provider) {
			if (!isset($provider['name']) || !isset($provider['enable'])) {
				continue;
			}

			$returnData[] = array(
				'name' => $provider['name'],
				'enable' => $provider['enable']
			);
		}

	END:
		return $returnData;
	}

	function SaveList($providerList)
	{
		$returnValue = false;

		if (!is_array($providerList)) {
			goto END;
		}

		$data = array();

		foreach ($providerList as $providerName => $providerData) {
			$data[] = array(
				'name' => $providerData['name'],
				'enable' => $providerData['enable']
			);
		}

		$file = array(
			'data' => $data
		);

		csSYNOPhotoMisc::UpdateConfigDB('photo', PHOTO_CONFIG_KEY, json_encode($file), 'photo_config');

		$returnValue = true;
	END:
		return $returnValue;
	}
}

?>
