<?php
session_cache_limiter("must-revalidate");

require_once(dirname(__FILE__).'/syno_conf.php');

if(!isset($_GET['ln']) || $_GET['ln'] == "") {
    $_GET['ln'] = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
}

$file_path = realpath(SYNOPHOTO_LANGS_DIR)."/".$_GET['ln'].".php";

if (!file_exists($file_path) || !csSYNOPhotoMisc::CheckPathValid($file_path)) {
	$file_path = SYNOPHOTO_LANGS_DIR."/enu.php";
}

$signature = SYNOPHOTO_CLIENT_STRING_CreateSig($file_path);
if($signature) {
	SYNOPHOTO_CLIENT_STRING_CheckSigExit($signature);
	@header("ETag: ".$signature[0]);
	@header("Last-Modified: ".$signature[1]);
}

header('Content-type: application/javascript');

if (false === ($file = fopen($file_path, 'r'))) {
	exit(1);
}
while (!feof($file)){
    $line = fgets($file, 4096);
	if(strstr($line, "$")) {
        $line = trim($line, "$");
		$key_value = explode("=", $line, 2);
        $key_value[0] = trim($key_value[0], " \t\n");
        $key_value[1] = trim($key_value[1], " \"\t\n;'");
        echo $key_value[0]." = '".$key_value[1]."';\n";
    }
}
fclose($file);

function SYNOPHOTO_CLIENT_STRING_CreateSig($thumbpath) {
	$filest = @stat($thumbpath);
	$etag = "";
	if($filest != FALSE) {
		$etag = md5($thumbpath . $filest[1] . $filest[9] );
		$lastmod = gmdate('D, d M Y H:i:s', $filest[9]) . ' GMT';
		return array($etag, $lastmod);
	}
	else {
		return FALSE;
	}
}

function SYNOPHOTO_CLIENT_STRING_CheckSigExit($signature) {
	$etag = $signature[0];
	$lastmod = $signature[1];
	$headers = apache_request_headers();
	$token = $headers['If-None-Match'];
	if($token && $token == $etag) {
		@header("HTTP/1.1 304 Not Modified");
		exit;
	}
	if(isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
		$ims = preg_replace('/;.*$/', '', $_SERVER['HTTP_IF_MODIFIED_SINCE'] );
		if($ims == $lastmod) {
			@header("HTTP/1.1 304 Not Modified");
			exit;
		}
	}
}
?>
